/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.multi.qrcode.detector;

import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.detector.FinderPattern;
import com.dcloud.zxing2.qrcode.detector.FinderPatternFinder;
import com.dcloud.zxing2.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;

    MultiFinderPatternFinder(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    MultiFinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        super(bitMatrix, resultPointCallback);
    }

    private FinderPattern[][] selectMutipleBestPatterns() throws NotFoundException {
        int n5 = (object2 = ((FinderPatternFinder)object2).getPossibleCenters()).size();
        if (n5 >= 3) {
            ArrayList arrayList;
            ModuleSizeComparator moduleSizeComparator;
            if (n5 == 3) {
                Object object = object2;
                Object object2 = (FinderPattern)object.get(0);
                FinderPattern finderPattern = (FinderPattern)object.get(1);
                FinderPattern finderPattern2 = (FinderPattern)object.get(2);
                FinderPattern[] finderPatternArray = new FinderPattern[3];
                FinderPattern[] finderPatternArray2 = finderPatternArray;
                finderPatternArray[0] = object2;
                finderPatternArray[1] = finderPattern;
                finderPatternArray[2] = finderPattern2;
                return new FinderPattern[][]{finderPatternArray2};
            }
            Serializable serializable = moduleSizeComparator;
            moduleSizeComparator = new ModuleSizeComparator();
            Collections.sort(object2, serializable);
            serializable = arrayList;
            arrayList = new ArrayList();
            block0: for (int i5 = 0; i5 < n5 - 2; ++i5) {
                FinderPattern finderPattern = (FinderPattern)object2.get(i5);
                if (finderPattern == null) continue;
                block1: for (int i6 = i5 + 1; i6 < n5 - 1; ++i6) {
                    FinderPattern finderPattern3 = (FinderPattern)object2.get(i6);
                    if (finderPattern3 == null) continue;
                    FinderPattern finderPattern4 = finderPattern;
                    float f5 = (finderPattern4.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize()) / Math.min(finderPattern.getEstimatedModuleSize(), finderPattern3.getEstimatedModuleSize());
                    if (Math.abs(finderPattern4.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize()) > 0.5f && f5 >= 0.05f) continue block0;
                    for (int i7 = i6 + 1; i7 < n5; ++i7) {
                        float f6;
                        FinderPatternInfo finderPatternInfo;
                        Object object = (FinderPattern)object2.get(i7);
                        if (object == null) continue;
                        FinderPattern finderPattern5 = finderPattern3;
                        float f7 = (finderPattern5.getEstimatedModuleSize() - ((FinderPattern)object).getEstimatedModuleSize()) / Math.min(finderPattern3.getEstimatedModuleSize(), ((FinderPattern)object).getEstimatedModuleSize());
                        if (Math.abs(finderPattern5.getEstimatedModuleSize() - ((FinderPattern)object).getEstimatedModuleSize()) > 0.5f && f7 >= 0.05f) continue block1;
                        ResultPoint[] resultPointArray = new FinderPattern[3];
                        ResultPoint[] resultPointArray2 = resultPointArray;
                        resultPointArray[0] = finderPattern;
                        resultPointArray[1] = finderPattern3;
                        resultPointArray[2] = object;
                        ResultPoint.orderBestPatterns(resultPointArray);
                        object = finderPatternInfo;
                        float f8 = ResultPoint.distance(new FinderPatternInfo((FinderPattern[])resultPointArray2).getTopLeft(), ((FinderPatternInfo)object).getBottomLeft());
                        Object object3 = object;
                        float f9 = ResultPoint.distance(((FinderPatternInfo)object3).getTopRight(), ((FinderPatternInfo)object).getBottomLeft());
                        float f10 = ResultPoint.distance(((FinderPatternInfo)object3).getTopLeft(), ((FinderPatternInfo)object).getTopRight());
                        float f11 = (f8 + f10) / (finderPattern.getEstimatedModuleSize() * 2.0f);
                        if (f11 > 180.0f || f11 < 9.0f || Math.abs((f8 - f10) / Math.min(f8, f10)) >= 0.1f) continue;
                        float f12 = f8;
                        float f13 = f10;
                        f10 = (float)Math.sqrt(f12 * f12 + f13 * f13);
                        if (Math.abs((f9 - f6) / Math.min(f9, f10)) >= 0.1f) continue;
                        serializable.add(resultPointArray2);
                    }
                }
            }
            if (!serializable.isEmpty()) {
                Serializable serializable2 = serializable;
                return (FinderPattern[][])serializable2.toArray((T[])new FinderPattern[serializable2.size()][]);
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Map<DecodeHintType, ?> map) throws NotFoundException {
        ArrayList<FinderPatternInfo> arrayList;
        FinderPattern[][] finderPatternArray;
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE);
        BitMatrix bitMatrix = finderPatternArray.getImage();
        int n5 = bitMatrix.getHeight();
        int n6 = bitMatrix.getWidth();
        int n7 = (int)((float)n5 / 228.0f * 3.0f);
        if (n7 < 3 || bl) {
            n7 = 3;
        }
        int[] nArray = new int[5];
        for (int i5 = n7 - 1; i5 < n5; i5 += n7) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n8 = 0;
            for (int i6 = 0; i6 < n6; ++i6) {
                int n9;
                if (bitMatrix.get(i6, i5)) {
                    if (n8 & true) {
                        ++n8;
                    }
                    nArray[n8] = n9 = nArray[n8] + 1;
                    continue;
                }
                if (!(n8 & true)) {
                    if (n8 == 4) {
                        if (FinderPatternFinder.foundPatternCross(nArray) && finderPatternArray.handlePossibleCenter(nArray, i5, i6, bl2)) {
                            n8 = 0;
                            nArray[0] = 0;
                            nArray[1] = 0;
                            nArray[2] = 0;
                            nArray[3] = 0;
                            nArray[4] = 0;
                            continue;
                        }
                        nArray[0] = n8 = nArray[2];
                        nArray[1] = n8 = nArray[3];
                        nArray[2] = n8 = nArray[4];
                        nArray[3] = 1;
                        nArray[4] = 0;
                        n8 = 3;
                        continue;
                    }
                    nArray[++n8] = n9 = nArray[n8] + 1;
                    continue;
                }
                nArray[n8] = n9 = nArray[n8] + 1;
            }
            if (!FinderPatternFinder.foundPatternCross(nArray)) continue;
            finderPatternArray.handlePossibleCenter(nArray, i5, n6, bl2);
        }
        finderPatternArray = finderPatternArray.selectMutipleBestPatterns();
        ArrayList<FinderPatternInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<FinderPatternInfo>();
        for (ResultPoint[] resultPointArray : finderPatternArray) {
            FinderPatternInfo finderPatternInfo;
            ResultPoint.orderBestPatterns(resultPointArray);
            FinderPatternInfo finderPatternInfo2 = finderPatternInfo;
            finderPatternInfo = new FinderPatternInfo((FinderPattern[])resultPointArray);
            arrayList2.add(finderPatternInfo2);
        }
        if (arrayList2.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        ArrayList<FinderPatternInfo> arrayList3 = arrayList2;
        return arrayList3.toArray(new FinderPatternInfo[arrayList3.size()]);
    }

    private static final class ModuleSizeComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private ModuleSizeComparator() {
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            double d6;
            double d7 = finderPattern2.getEstimatedModuleSize() - finderPattern.getEstimatedModuleSize();
            return d6 < 0.0 ? -1 : (d7 > 0.0 ? 1 : 0);
        }
    }
}

