/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder.ec;

import com.dcloud.zxing2.pdf417.decoder.ec.ModulusGF;

final class ModulusPoly {
    private final ModulusGF field;
    private final int[] coefficients;

    ModulusPoly(ModulusGF modulusGF, int[] nArray) {
        if (nArray.length != 0) {
            ((ModulusPoly)object).field = modulusGF;
            int n5 = nArray.length;
            if (n5 > 1 && nArray[0] == 0) {
                int n6;
                for (n6 = 1; n6 < n5 && nArray[n6] == 0; ++n6) {
                }
                if (n6 == n5) {
                    ModulusPoly modulusPoly = object;
                    int[] nArray2 = new int[1];
                    Object object = nArray2;
                    nArray2[0] = 0;
                    modulusPoly.coefficients = (int[])object;
                } else {
                    int[] nArray3 = new int[n5 - n6];
                    ((ModulusPoly)object).coefficients = nArray3;
                    int n7 = nArray3.length;
                    System.arraycopy(nArray, n6, nArray3, 0, n7);
                }
            } else {
                ((ModulusPoly)object).coefficients = nArray;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n5) {
        return this.coefficients[this.coefficients.length - 1 - n5];
    }

    int evaluateAt(int n5) {
        if (n5 == 0) {
            return this.getCoefficient(0);
        }
        int[] nArray = this.coefficients;
        int n6 = this.coefficients.length;
        if (n5 == 1) {
            n5 = 0;
            for (int n7 : nArray) {
                n5 = this.field.add(n5, n7);
            }
            return n5;
        }
        int n8 = nArray[0];
        for (int i5 = 1; i5 < n6; ++i5) {
            ModulusGF modulusGF = this.field;
            n8 = modulusGF.add(modulusGF.multiply(n5, n8), this.coefficients[i5]);
        }
        return n8;
    }

    ModulusPoly add(ModulusPoly object) {
        if (this.field.equals(((ModulusPoly)object).field)) {
            if (this.isZero()) {
                return object;
            }
            if (((ModulusPoly)object).isZero()) {
                return this;
            }
            object = this.coefficients;
            Object object2 = ((ModulusPoly)object).coefficients;
            if (((Object)object).length <= ((int[])object2).length) {
                int[] nArray = object2;
                object2 = object;
                object = nArray;
            }
            Object object3 = object;
            int[] nArray = new int[((Object)object3).length];
            int n5 = ((Object)object3).length - ((int[])object2).length;
            System.arraycopy(object3, 0, nArray, 0, n5);
            for (int i5 = n5; i5 < ((Object)object).length; ++i5) {
                int n6 = object2[i5 - n5];
                nArray[i5] = this.field.add(n6, (int)object[i5]);
            }
            return new ModulusPoly(this.field, nArray);
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    ModulusPoly subtract(ModulusPoly modulusPoly) {
        if (this.field.equals(modulusPoly.field)) {
            if (modulusPoly.isZero()) {
                return this;
            }
            return this.add(modulusPoly.negative());
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    ModulusPoly multiply(ModulusPoly object) {
        if (this.field.equals(((ModulusPoly)object).field)) {
            if (!this.isZero() && !((ModulusPoly)object).isZero()) {
                int[] nArray = this.coefficients;
                int n5 = this.coefficients.length;
                object = ((ModulusPoly)object).coefficients;
                int n6 = ((ModulusPoly)object).coefficients.length;
                int[] nArray2 = new int[n5 + n6 - 1];
                for (int i5 = 0; i5 < n5; ++i5) {
                    int n7 = nArray[i5];
                    for (int i6 = 0; i6 < n6; ++i6) {
                        int n8 = i5 + i6;
                        ModulusGF modulusGF = this.field;
                        int n9 = nArray2[n8];
                        nArray2[n8] = modulusGF.add(n9, modulusGF.multiply(n7, (int)object[i6]));
                    }
                }
                return new ModulusPoly(this.field, nArray2);
            }
            return this.field.getZero();
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    ModulusPoly negative() {
        int n5 = this.coefficients.length;
        int[] nArray = new int[n5];
        for (int i5 = 0; i5 < n5; ++i5) {
            nArray[i5] = this.field.subtract(0, this.coefficients[i5]);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiply(int n5) {
        if (n5 == 0) {
            return this.field.getZero();
        }
        if (n5 == 1) {
            return this;
        }
        int n6 = this.coefficients.length;
        int[] nArray = new int[n6];
        for (int i5 = 0; i5 < n6; ++i5) {
            nArray[i5] = this.field.multiply(this.coefficients[i5], n5);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiplyByMonomial(int n5, int n6) {
        if (n5 >= 0) {
            if (n6 == 0) {
                return this.field.getZero();
            }
            int n7 = this.coefficients.length;
            int[] nArray = new int[n7 + n5];
            for (int i5 = 0; i5 < n7; ++i5) {
                nArray[i5] = this.field.multiply(this.coefficients[i5], n6);
            }
            return new ModulusPoly(this.field, nArray);
        }
        throw new IllegalArgumentException();
    }

    ModulusPoly[] divide(ModulusPoly modulusPoly) {
        if (this.field.equals(modulusPoly.field)) {
            if (!modulusPoly.isZero()) {
                ModulusPoly modulusPoly2 = modulusPoly;
                ModulusPoly modulusPoly3 = this.field.getZero();
                int n5 = modulusPoly2.getCoefficient(modulusPoly2.getDegree());
                n5 = this.field.inverse(n5);
                ModulusPoly modulusPoly4 = this;
                while (modulusPoly4.getDegree() >= modulusPoly.getDegree() && !modulusPoly4.isZero()) {
                    int n6 = modulusPoly4.getDegree() - modulusPoly.getDegree();
                    ModulusPoly modulusPoly5 = modulusPoly4;
                    int n7 = this.field.multiply(modulusPoly5.getCoefficient(modulusPoly5.getDegree()), n5);
                    ModulusPoly modulusPoly6 = modulusPoly.multiplyByMonomial(n6, n7);
                    modulusPoly3 = modulusPoly3.add(this.field.buildMonomial(n6, n7));
                    modulusPoly4 = modulusPoly4.subtract(modulusPoly6);
                }
                return new ModulusPoly[]{modulusPoly3, modulusPoly4};
            }
            throw new IllegalArgumentException("Divide by 0");
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.getDegree() * 8);
        for (int i5 = this.getDegree(); i5 >= 0; --i5) {
            int n5 = this.getCoefficient(i5);
            if (n5 == 0) continue;
            if (n5 < 0) {
                stringBuilder2.append(" - ");
                n5 = -n5;
            } else if (stringBuilder2.length() > 0) {
                stringBuilder2.append(" + ");
            }
            if (i5 == 0 || n5 != 1) {
                stringBuilder2.append(n5);
            }
            if (i5 == 0) continue;
            if (i5 == 1) {
                stringBuilder2.append('x');
                continue;
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append("x^");
            stringBuilder3.append(i5);
        }
        return stringBuilder2.toString();
    }
}

