/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.encoder;

final class BarcodeRow {
    private final byte[] row;
    private int currentLocation;

    BarcodeRow(int n5) {
        BarcodeRow barcodeRow = this;
        barcodeRow.row = new byte[n5];
        barcodeRow.currentLocation = 0;
    }

    void set(int n5, byte by) {
        this.row[n5] = by;
    }

    void set(int n5, boolean bl) {
        this.row[n5] = (byte)(bl ? 1 : 0);
    }

    void addBar(boolean bl, int n5) {
        for (int i5 = 0; i5 < n5; ++i5) {
            BarcodeRow barcodeRow = this;
            int n6 = barcodeRow.currentLocation;
            barcodeRow.currentLocation = n6 + 1;
            barcodeRow.set(n6, bl);
        }
    }

    byte[] getScaledRow(int n5) {
        int n6 = this.row.length * n5;
        byte[] byArray = new byte[n6];
        for (int i5 = 0; i5 < n6; ++i5) {
            byArray[i5] = this.row[i5 / n5];
        }
        return byArray;
    }
}

