/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitSource;
import com.dcloud.zxing2.common.CharacterSetECI;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.StringUtils;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.decoder.Mode;
import com.dcloud.zxing2.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

final class DecodedBitStreamParser {
    private static final char[] ALPHANUMERIC_CHARS;
    private static final int GB2312_SUBSET = 1;

    private DecodedBitStreamParser() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DecoderResult decode(byte[] var0, Version var1_1, ErrorCorrectionLevel var2_2, Map<DecodeHintType, ?> var3_3) throws FormatException {
        var4_4 = v0;
        v0 = new BitSource(var0);
        var5_5 = v1;
        v1 = new StringBuilder(50);
        var6_6 = v2;
        v2 = new ArrayList<byte[]>(1);
        var7_7 = -1;
        var8_8 = -1;
        var9_9 = "";
        var10_10 = null;
        var11_11 = false;
        do {
            block18: {
                try {
                    if (var4_4.available() < 4) {
                        v3 = Mode.TERMINATOR;
                    }
                    ** GOTO lbl-1000
                }
                catch (IllegalArgumentException v4) {
                    throw FormatException.getFormatInstance();
                }
lbl20:
                // 2 sources

                while (true) {
                    var12_12 = v3;
                    ** GOTO lbl25
                    break;
                }
lbl-1000:
                // 1 sources

                {
                    v3 = Mode.forBits(var4_4.readBits(4));
                    ** continue;
lbl25:
                    // 1 sources

                    var13_13 = Mode.TERMINATOR;
                    if (var12_12 == var13_13) continue;
                }
                {
                    if (var12_12 == Mode.FNC1_FIRST_POSITION || var12_12 == Mode.FNC1_SECOND_POSITION) break block18;
                }
                {
                    if (var12_12 != Mode.STRUCTURED_APPEND) ** GOTO lbl34
                }
                {
                    if (var4_4.available() < 16) throw FormatException.getFormatInstance();
                    v5 = var4_4;
                    var7_7 = v5.readBits(8);
                    var8_8 = v5.readBits(8);
                    continue;
lbl34:
                    // 1 sources

                    if (var12_12 != Mode.ECI) ** GOTO lbl38
                }
                {
                    var10_10 = CharacterSetECI.getCharacterSetECIByValue(DecodedBitStreamParser.parseECIValue(var4_4));
                    if (var10_10 != null) continue;
                }
                {
                    throw FormatException.getFormatInstance();
lbl38:
                    // 1 sources

                    if (var12_12 != Mode.HANZI) ** GOTO lbl43
                }
                {
                    var14_14 = var4_4.readBits(var12_12.getCharacterCountBits((Version)var1_1));
                    if (var4_4.readBits(4) != 1) continue;
                    DecodedBitStreamParser.decodeHanziSegment(var4_4, var5_5, var14_14);
                    continue;
lbl43:
                    // 1 sources

                    var14_14 = var4_4.readBits(var12_12.getCharacterCountBits((Version)var1_1));
                    if (var12_12 != Mode.NUMERIC) ** GOTO lbl47
                }
                {
                    DecodedBitStreamParser.decodeNumericSegment(var4_4, var5_5, var14_14);
                    continue;
lbl47:
                    // 1 sources

                    if (var12_12 != Mode.ALPHANUMERIC) ** GOTO lbl50
                }
                {
                    DecodedBitStreamParser.decodeAlphanumericSegment(var4_4, var5_5, var14_14, var11_11);
                    continue;
lbl50:
                    // 1 sources

                    if (var12_12 != Mode.BYTE) ** GOTO lbl53
                }
                {
                    var9_9 = DecodedBitStreamParser.decodeByteSegment(var4_4, var5_5, var14_14, var10_10, var6_6, var3_3);
                    continue;
lbl53:
                    // 1 sources

                    if (var12_12 != Mode.KANJI) throw FormatException.getFormatInstance();
                }
                {
                    DecodedBitStreamParser.decodeKanjiSegment(var4_4, var5_5, var14_14);
                    continue;
                }
            }
            var11_11 = true;
        } while (var12_12 != var13_13);
        var3_3 = var5_5.toString();
        if (var6_6.isEmpty()) {
            var6_6 = null;
        }
        var2_2 = var2_2 == null ? null : var2_2.toString();
        v6 = var1_1;
        v6(var0, (String)var3_3, var6_6, (String)var2_2, var7_7, var8_8);
        v6.textCharset = var9_9;
        return v6;
    }

    private static void decodeHanziSegment(BitSource object, StringBuilder stringBuilder, int n5) throws FormatException {
        if (n5 * 13 <= ((BitSource)object).available()) {
            String string2;
            StringBuilder stringBuilder2;
            byte[] byArray = new byte[n5 * 2];
            int n6 = 0;
            while (n5 > 0) {
                int n7 = ((BitSource)object).readBits(13);
                n7 = (n7 = n7 / 96 << 8 | n7 % 96) < 959 ? (n7 += 41377) : (n7 += 42657);
                int n8 = n7;
                byArray[n6] = (byte)(n7 >> 8 & 0xFF);
                n7 = n6 + 1;
                byArray[n7] = (byte)(n8 & 0xFF);
                n6 += 2;
                --n5;
            }
            try {
                stringBuilder2 = stringBuilder;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
            object = string2;
            string2 = new String(byArray, "GB2312");
            stringBuilder2.append((String)object);
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static void decodeKanjiSegment(BitSource object, StringBuilder stringBuilder, int n5) throws FormatException {
        if (n5 * 13 <= ((BitSource)object).available()) {
            String string2;
            StringBuilder stringBuilder2;
            byte[] byArray = new byte[n5 * 2];
            int n6 = 0;
            while (n5 > 0) {
                int n7 = ((BitSource)object).readBits(13);
                n7 = (n7 = n7 / 192 << 8 | n7 % 192) < 7936 ? (n7 += 33088) : (n7 += 49472);
                int n8 = n7;
                byArray[n6] = (byte)(n7 >> 8);
                n7 = n6 + 1;
                byArray[n7] = (byte)n8;
                n6 += 2;
                --n5;
            }
            try {
                stringBuilder2 = stringBuilder;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
            object = string2;
            string2 = new String(byArray, "UTF-8");
            stringBuilder2.append((String)object);
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static String decodeByteSegment(BitSource object, StringBuilder charSequence, int n5, CharacterSetECI characterSetECI, Collection<byte[]> collection, Map<DecodeHintType, ?> map) throws FormatException {
        if (n5 * 8 <= ((BitSource)object).available()) {
            String string2;
            StringBuilder stringBuilder;
            Collection<byte[]> collection2;
            Object object2;
            byte[] byArray = new byte[n5];
            for (int i5 = 0; i5 < n5; ++i5) {
                byArray[i5] = (byte)((BitSource)object).readBits(8);
            }
            object = characterSetECI == null ? StringUtils.guessEncoding(byArray, map) : characterSetECI.name();
            try {
                object2 = object;
                collection2 = collection;
                stringBuilder = charSequence;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
            charSequence = string2;
            string2 = new String(byArray, (String)object);
            stringBuilder.append((String)charSequence);
            collection2.add(byArray);
            return object2;
        }
        throw FormatException.getFormatInstance();
    }

    private static char toAlphaNumericChar(int n5) throws FormatException {
        char[] cArray = ALPHANUMERIC_CHARS;
        if (n5 < ALPHANUMERIC_CHARS.length) {
            return cArray[n5];
        }
        throw FormatException.getFormatInstance();
    }

    private static void decodeAlphanumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n5, boolean bl) throws FormatException {
        int n6 = stringBuilder.length();
        while (n5 > 1) {
            if (bitSource.available() >= 11) {
                int n7 = bitSource.readBits(11);
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n7 / 45));
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n7 % 45));
                n5 -= 2;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        if (n5 == 1) {
            if (bitSource.available() >= 6) {
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(bitSource.readBits(6)));
            } else {
                throw FormatException.getFormatInstance();
            }
        }
        if (bl) {
            while (n6 < stringBuilder.length()) {
                if (stringBuilder.charAt(n6) == '%') {
                    int n8;
                    if (n6 < stringBuilder.length() - 1 && stringBuilder.charAt(n8 = n6 + 1) == '%') {
                        stringBuilder.deleteCharAt(n8);
                    } else {
                        stringBuilder.setCharAt(n6, '\u001d');
                    }
                }
                ++n6;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void decodeNumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n5) throws FormatException {
        while (n5 >= 3) {
            if (bitSource.available() < 10) throw FormatException.getFormatInstance();
            int n6 = bitSource.readBits(10);
            if (n6 >= 1000) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n6 / 100));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n6 / 10 % 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n6 % 10));
            n5 -= 3;
        }
        if (n5 == 2) {
            if (bitSource.available() < 7) throw FormatException.getFormatInstance();
            int n7 = bitSource.readBits(7);
            if (n7 >= 100) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n7 / 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n7 % 10));
            return;
        } else {
            if (n5 != 1) return;
            if (bitSource.available() < 4) throw FormatException.getFormatInstance();
            int n8 = bitSource.readBits(4);
            if (n8 >= 10) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n8));
        }
    }

    private static int parseECIValue(BitSource bitSource) throws FormatException {
        int n5 = bitSource.readBits(8);
        if ((n5 & 0x80) == 0) {
            return n5 & 0x7F;
        }
        if ((n5 & 0xC0) == 128) {
            int n6 = bitSource.readBits(8);
            return (n5 & 0x3F) << 8 | n6;
        }
        if ((n5 & 0xE0) == 192) {
            int n7 = bitSource.readBits(16);
            return (n5 & 0x1F) << 16 | n7;
        }
        throw FormatException.getFormatInstance();
    }

    static {
        char[] cArray = new char[45];
        char[] cArray2 = cArray;
        cArray[0] = 48;
        cArray2[1] = 49;
        cArray2[2] = 50;
        cArray2[3] = 51;
        cArray2[4] = 52;
        cArray2[5] = 53;
        cArray2[6] = 54;
        cArray2[7] = 55;
        cArray2[8] = 56;
        cArray2[9] = 57;
        cArray2[10] = 65;
        cArray2[11] = 66;
        cArray2[12] = 67;
        cArray2[13] = 68;
        cArray2[14] = 69;
        cArray2[15] = 70;
        cArray2[16] = 71;
        cArray2[17] = 72;
        cArray2[18] = 73;
        cArray2[19] = 74;
        cArray2[20] = 75;
        cArray2[21] = 76;
        cArray2[22] = 77;
        cArray2[23] = 78;
        cArray2[24] = 79;
        cArray2[25] = 80;
        cArray2[26] = 81;
        cArray2[27] = 82;
        cArray2[28] = 83;
        cArray2[29] = 84;
        cArray2[30] = 85;
        cArray2[31] = 86;
        cArray2[32] = 87;
        cArray2[33] = 88;
        cArray2[34] = 89;
        cArray2[35] = 90;
        cArray2[36] = 32;
        cArray2[37] = 36;
        cArray2[38] = 37;
        cArray2[39] = 42;
        cArray2[40] = 43;
        cArray2[41] = 45;
        cArray2[42] = 46;
        cArray2[43] = 47;
        cArray2[44] = 58;
        ALPHANUMERIC_CHARS = cArray2;
    }
}

