/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.detector.AlignmentPattern;
import java.util.ArrayList;
import java.util.List;

final class AlignmentPatternFinder {
    private final BitMatrix image;
    private final List<AlignmentPattern> possibleCenters;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private final float moduleSize;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    AlignmentPatternFinder(BitMatrix bitMatrix, int n5, int n6, int n7, int n8, float f5, ResultPointCallback resultPointCallback) {
        AlignmentPatternFinder alignmentPatternFinder = this;
        AlignmentPatternFinder alignmentPatternFinder2 = this;
        alignmentPatternFinder2.image = bitMatrix;
        alignmentPatternFinder2.possibleCenters = new ArrayList<AlignmentPattern>(5);
        this.startX = n5;
        this.startY = n6;
        this.width = n7;
        this.height = n8;
        alignmentPatternFinder.moduleSize = f5;
        alignmentPatternFinder.crossCheckStateCount = new int[3];
        this.resultPointCallback = resultPointCallback;
    }

    private static float centerFromEnd(int[] nArray, int n5) {
        return (float)(n5 - nArray[2]) - (float)nArray[1] / 2.0f;
    }

    private boolean foundPatternCross(int[] nArray) {
        float f5 = this.moduleSize;
        float f6 = f5 / 2.0f;
        for (int i5 = 0; i5 < 3; ++i5) {
            if (!(Math.abs(f5 - (float)nArray[i5]) >= f6)) continue;
            return false;
        }
        return true;
    }

    private float crossCheckVertical(int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        AlignmentPatternFinder alignmentPatternFinder = this;
        BitMatrix bitMatrix = alignmentPatternFinder.image;
        int n11 = bitMatrix.getHeight();
        int[] nArray = alignmentPatternFinder.crossCheckStateCount;
        int[] nArray2 = alignmentPatternFinder.crossCheckStateCount;
        int[] nArray3 = nArray;
        nArray2[0] = 0;
        nArray[1] = 0;
        nArray2[2] = 0;
        for (n10 = n5; n10 >= 0 && bitMatrix.get(n6, n10) && (n9 = nArray3[1]) <= n7; --n10) {
            nArray3[1] = n9 + 1;
        }
        if (n10 >= 0 && nArray3[1] <= n7) {
            while (n10 >= 0 && !bitMatrix.get(n6, n10) && (n9 = nArray3[0]) <= n7) {
                nArray3[0] = n9 + 1;
                --n10;
            }
            if (nArray3[0] > n7) {
                return Float.NaN;
            }
            ++n5;
            while (n5 < n11 && bitMatrix.get(n6, n5) && (n10 = nArray3[1]) <= n7) {
                nArray3[1] = n10 + 1;
                ++n5;
            }
            if (n5 != n11 && nArray3[1] <= n7) {
                while (n5 < n11 && !bitMatrix.get(n6, n5) && (n10 = nArray3[2]) <= n7) {
                    nArray3[2] = n10 + 1;
                    ++n5;
                }
                n6 = nArray3[2];
                if (n6 > n7) {
                    return Float.NaN;
                }
                if (Math.abs(nArray3[0] + nArray3[1] + n6 - n8) * 5 >= n8 * 2) {
                    return Float.NaN;
                }
                return this.foundPatternCross(nArray3) ? AlignmentPatternFinder.centerFromEnd(nArray3, n5) : Float.NaN;
            }
            return Float.NaN;
        }
        return Float.NaN;
    }

    private AlignmentPattern handlePossibleCenter(int[] nArray, int n5, int n6) {
        int n7 = n5;
        n5 = nArray[0] + nArray[1] + nArray[2];
        float f5 = AlignmentPatternFinder.centerFromEnd(nArray, n6);
        int n8 = (int)f5;
        float f6 = ((AlignmentPatternFinder)((Object)alignmentPattern3)).crossCheckVertical(n7, n8, nArray[1] * 2, n5);
        if (!Float.isNaN(f6)) {
            AlignmentPattern alignmentPattern;
            float f7 = (float)(nArray[0] + nArray[1] + nArray[2]) / 3.0f;
            for (AlignmentPattern alignmentPattern2 : ((AlignmentPatternFinder)((Object)alignmentPattern3)).possibleCenters) {
                if (!alignmentPattern2.aboutEquals(f7, f6, f5)) continue;
                return alignmentPattern2.combineEstimate(f6, f5, f7);
            }
            AlignmentPatternFinder alignmentPatternFinder = alignmentPattern3;
            AlignmentPattern alignmentPattern3 = alignmentPattern;
            alignmentPattern = new AlignmentPattern(f5, f6, f7);
            alignmentPatternFinder.possibleCenters.add(alignmentPattern3);
            ResultPointCallback resultPointCallback = alignmentPatternFinder.resultPointCallback;
            if (resultPointCallback != null) {
                resultPointCallback.foundPossibleResultPoint(alignmentPattern3);
            }
        }
        return null;
    }

    AlignmentPattern find() throws NotFoundException {
        AlignmentPatternFinder alignmentPatternFinder = this;
        int n5 = alignmentPatternFinder.startX;
        AlignmentPatternFinder alignmentPatternFinder2 = this;
        int n6 = alignmentPatternFinder2.height;
        int n7 = n5 + alignmentPatternFinder2.width;
        int n8 = alignmentPatternFinder.startY + n6 / 2;
        int[] nArray = new int[3];
        for (int i5 = 0; i5 < n6; ++i5) {
            AlignmentPattern alignmentPattern;
            int n9;
            int n10 = (i5 & 1) == 0 ? (i5 + 1) / 2 : -((i5 + 1) / 2);
            int[] nArray2 = nArray;
            n10 = n8 + n10;
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray[2] = 0;
            for (n9 = n5; n9 < n7 && !this.image.get(n9, n10); ++n9) {
            }
            int n11 = 0;
            while (n9 < n7) {
                if (this.image.get(n9, n10)) {
                    if (n11 == 1) {
                        nArray[n11] = nArray[n11] + 1;
                    } else if (n11 == 2) {
                        AlignmentPattern alignmentPattern2;
                        if (this.foundPatternCross(nArray) && (alignmentPattern2 = this.handlePossibleCenter(nArray, n10, n9)) != null) {
                            return alignmentPattern2;
                        }
                        int[] nArray3 = nArray;
                        int[] nArray4 = nArray;
                        nArray4[0] = nArray3[2];
                        nArray3[1] = 1;
                        nArray4[2] = 0;
                        n11 = 1;
                    } else {
                        nArray[++n11] = nArray[n11] + 1;
                    }
                } else {
                    if (n11 == 1) {
                        ++n11;
                    }
                    nArray[n11] = nArray[n11] + 1;
                }
                ++n9;
            }
            if (!this.foundPatternCross(nArray) || (alignmentPattern = this.handlePossibleCenter(nArray, n10, n7)) == null) continue;
            return alignmentPattern;
        }
        if (!this.possibleCenters.isEmpty()) {
            return this.possibleCenters.get(0);
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

