/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.detector;

import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DetectorResult;
import com.dcloud.zxing2.common.GridSampler;
import com.dcloud.zxing2.common.PerspectiveTransform;
import com.dcloud.zxing2.common.detector.MathUtils;
import com.dcloud.zxing2.qrcode.decoder.Version;
import com.dcloud.zxing2.qrcode.detector.AlignmentPattern;
import com.dcloud.zxing2.qrcode.detector.AlignmentPatternFinder;
import com.dcloud.zxing2.qrcode.detector.FinderPattern;
import com.dcloud.zxing2.qrcode.detector.FinderPatternFinder;
import com.dcloud.zxing2.qrcode.detector.FinderPatternInfo;
import java.util.Map;

public class Detector {
    private final BitMatrix image;
    private ResultPointCallback resultPointCallback;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    private static PerspectiveTransform createTransform(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n5) {
        float f5;
        float f6;
        float f7;
        float f8 = (float)n5 - 3.5f;
        if (resultPoint4 != null) {
            ResultPoint resultPoint5 = resultPoint4;
            f7 = resultPoint5.getX();
            f6 = resultPoint5.getY();
            f5 = f8 - 3.0f;
        } else {
            ResultPoint resultPoint6 = resultPoint2;
            f7 = resultPoint6.getX() - resultPoint.getX() + resultPoint3.getX();
            f6 = resultPoint6.getY() - resultPoint.getY() + resultPoint3.getY();
            f5 = f8;
        }
        ResultPoint resultPoint7 = resultPoint3;
        ResultPoint resultPoint8 = resultPoint2;
        ResultPoint resultPoint9 = resultPoint;
        float f9 = resultPoint9.getX();
        float f10 = resultPoint9.getY();
        float f11 = resultPoint8.getX();
        float f12 = resultPoint8.getY();
        float f13 = resultPoint7.getX();
        float f14 = resultPoint7.getY();
        float f15 = f5;
        return PerspectiveTransform.quadrilateralToQuadrilateral(3.5f, 3.5f, f8, 3.5f, f15, f15, 3.5f, f8, f9, f10, f11, f12, f7, f6, f13, f14);
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, PerspectiveTransform perspectiveTransform, int n5) throws NotFoundException {
        int n6 = n5;
        return GridSampler.getInstance().sampleGrid(bitMatrix, n6, n6, perspectiveTransform);
    }

    private static int computeDimension(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, float f5) throws NotFoundException {
        int n5 = (MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2) / f5) + MathUtils.round(ResultPoint.distance(resultPoint, resultPoint3) / f5)) / 2;
        int n6 = n5 + 7;
        int n7 = n6 & 3;
        if (n7 != 0) {
            if (n7 != 2) {
                if (n7 == 3) {
                    throw NotFoundException.getNotFoundInstance();
                }
            } else {
                n6 = n5 + 6;
            }
        } else {
            n6 = n5 + 8;
        }
        return n6;
    }

    private float calculateModuleSizeOneWay(ResultPoint resultPoint, ResultPoint resultPoint2) {
        ResultPoint resultPoint3 = resultPoint2;
        int n5 = (int)resultPoint.getY();
        int n6 = (int)resultPoint3.getX();
        int n7 = (int)resultPoint3.getY();
        float f5 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint.getX(), n5, n6, n7);
        ResultPoint resultPoint4 = resultPoint;
        int n8 = (int)resultPoint2.getY();
        int n9 = (int)resultPoint4.getX();
        n6 = (int)resultPoint4.getY();
        float f6 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint2.getX(), n8, n9, n6);
        if (Float.isNaN(f5)) {
            return f6 / 7.0f;
        }
        if (Float.isNaN(f6)) {
            return f5 / 7.0f;
        }
        return (f5 + f6) / 14.0f;
    }

    private float sizeOfBlackWhiteBlackRunBothWays(int n5, int n6, int n7, int n8) {
        float f5 = this.sizeOfBlackWhiteBlackRun(n5, n6, n7, n8);
        float f6 = 1.0f;
        int n9 = n5 - (n7 - n5);
        if (n9 < 0) {
            f6 = (float)n5 / (float)(n5 - n9);
            n9 = 0;
        } else if (n9 >= this.image.getWidth()) {
            Detector detector = this;
            f6 = (float)(detector.image.getWidth() - 1 - n5) / (float)(n9 - n5);
            n9 = detector.image.getWidth() - 1;
        }
        float f7 = n6;
        n8 = (int)(f7 - (float)(n8 - n6) * f6);
        f6 = 1.0f;
        if (n8 < 0) {
            f6 = f7 / (float)(n6 - n8);
            n8 = 0;
        } else if (n8 >= this.image.getHeight()) {
            Detector detector = this;
            f6 = (float)(detector.image.getHeight() - 1 - n6) / (float)(n8 - n6);
            n8 = detector.image.getHeight() - 1;
        }
        int n10 = n5;
        return f5 + this.sizeOfBlackWhiteBlackRun(n10, n6, (int)((float)n10 + (float)(n9 - n5) * f6), n8) - 1.0f;
    }

    private float sizeOfBlackWhiteBlackRun(int n5, int n6, int n7, int n8) {
        boolean bl = Math.abs(n8 - n6) > Math.abs(n7 - n5);
        if (bl) {
            int n9 = n8;
            int n10 = n6;
            n6 = n5;
            n8 = n7;
            n5 = n10;
            n7 = n9;
        }
        int n11 = Math.abs(n7 - n5);
        int n12 = Math.abs(n8 - n6);
        int n13 = -n11 / 2;
        int n14 = n5 < n7 ? 1 : -1;
        int n15 = n6 < n8 ? 1 : -1;
        int n16 = n7;
        n7 = 0;
        int n17 = n16 + n14;
        int n18 = n6;
        for (int i5 = n5; i5 != n17; i5 += n14) {
            int n19;
            int n20;
            if (n7 == 1 == this.image.get(n20 = bl ? n18 : i5, n19 = bl ? i5 : n18)) {
                if (n7 == 2) {
                    return MathUtils.distance(i5, n18, n5, n6);
                }
                ++n7;
            }
            if ((n13 += n12) <= 0) continue;
            if (n18 == n8) break;
            n18 += n15;
            n13 -= n11;
        }
        if (n7 == 2) {
            return MathUtils.distance(n17, n8, n5, n6);
        }
        return Float.NaN;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final ResultPointCallback getResultPointCallback() {
        return this.resultPointCallback;
    }

    public DetectorResult detect() throws NotFoundException, FormatException {
        return this.detect(null);
    }

    public final DetectorResult detect(Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        ResultPointCallback resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        this.resultPointCallback = resultPointCallback;
        return this.processFinderPatternInfo(new FinderPatternFinder(this.image, resultPointCallback).find(map));
    }

    protected final DetectorResult processFinderPatternInfo(FinderPatternInfo object) throws NotFoundException, FormatException {
        FinderPattern finderPattern;
        FinderPattern finderPattern2;
        FinderPatternInfo finderPatternInfo = object;
        object = finderPatternInfo.getTopLeft();
        float f5 = ((Detector)object3).calculateModuleSize((ResultPoint)object, finderPattern2 = finderPatternInfo.getTopRight(), finderPattern = finderPatternInfo.getBottomLeft());
        if (!(f5 < 1.0f)) {
            ResultPoint[] resultPointArray;
            int n5 = Detector.computeDimension((ResultPoint)object, finderPattern2, finderPattern, f5);
            Version version = Version.getProvisionalVersionForDimension(n5);
            int n6 = version.getDimensionForVersion() - 7;
            AlignmentPattern alignmentPattern = null;
            if (version.getAlignmentPatternCenters().length > 0) {
                Object object2 = object;
                FinderPattern finderPattern3 = finderPattern2;
                float f6 = finderPattern3.getX() - ((ResultPoint)object).getX() + finderPattern.getX();
                float f7 = finderPattern3.getY() - ((ResultPoint)object).getY() + finderPattern.getY();
                float f8 = 1.0f - 3.0f / (float)n6;
                int n7 = (int)(((ResultPoint)object2).getX() + f8 * (f6 - ((ResultPoint)object).getX()));
                int n8 = (int)(((ResultPoint)object2).getY() + f8 * (f7 - ((ResultPoint)object).getY()));
                for (int i5 = 4; i5 <= 16; i5 <<= 1) {
                    float f9 = i5;
                    try {
                        alignmentPattern = ((Detector)object3).findAlignmentInRegion(f5, n7, n8, f9);
                        break;
                    }
                    catch (NotFoundException notFoundException) {
                        continue;
                    }
                }
            }
            Detector detector = object3;
            Object object3 = Detector.createTransform((ResultPoint)object, finderPattern2, finderPattern, alignmentPattern, n5);
            object3 = Detector.sampleGrid(detector.image, (PerspectiveTransform)object3, n5);
            if (alignmentPattern == null) {
                ResultPoint[] resultPointArray2 = new ResultPoint[3];
                resultPointArray = resultPointArray2;
                resultPointArray2[0] = finderPattern;
                resultPointArray2[1] = object;
                resultPointArray2[2] = finderPattern2;
            } else {
                ResultPoint[] resultPointArray3 = new ResultPoint[4];
                resultPointArray = resultPointArray3;
                resultPointArray3[0] = finderPattern;
                resultPointArray3[1] = object;
                resultPointArray3[2] = finderPattern2;
                resultPointArray3[3] = alignmentPattern;
            }
            new DetectorResult((BitMatrix)object3, resultPointArray).moduleSize = f5;
            return new DetectorResult((BitMatrix)object3, resultPointArray);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final float calculateModuleSize(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3) {
        return (this.calculateModuleSizeOneWay(resultPoint, resultPoint2) + this.calculateModuleSizeOneWay(resultPoint, resultPoint3)) / 2.0f;
    }

    protected final AlignmentPattern findAlignmentInRegion(float f5, int n5, int n6, float f6) throws NotFoundException {
        float f7;
        int n7 = (int)(f6 * f5);
        int n8 = Math.max(0, n5 - n7);
        n5 = Math.min(((Detector)((Object)bitMatrix)).image.getWidth() - 1, n5 + n7) - n8;
        if (!((float)n5 < (f7 = f5 * 3.0f))) {
            int n9 = Math.max(0, n6 - n7);
            n6 = Math.min(((Detector)((Object)bitMatrix)).image.getHeight() - 1, n6 + n7) - n9;
            if (!((float)n6 < f7)) {
                Detector detector = bitMatrix;
                BitMatrix bitMatrix = detector.image;
                ResultPointCallback resultPointCallback = detector.resultPointCallback;
                return new AlignmentPatternFinder(bitMatrix, n8, n9, n5, n6, f5, resultPointCallback).find();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

