/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.dmcbig.mediapicker.MediaPickerR;
import com.dmcbig.mediapicker.entity.Media;
import com.dmcbig.mediapicker.view.PreviewFragment;
import io.dcloud.base.R;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import java.util.ArrayList;
import java.util.List;

public class PreviewActivity
extends FragmentActivity
implements View.OnClickListener,
ViewPager.OnPageChangeListener {
    Button done;
    LinearLayout check_layout;
    ImageView check_image;
    ImageView fullImage;
    ViewPager viewpager;
    TextView bar_title;
    TextView imageEdit;
    View top;
    View bottom;
    ArrayList<Media> preRawList;
    ArrayList<Media> selects;
    boolean isSingle = false;
    ArrayList<Fragment> fragmentArrayList;
    private Class editActivityClass;
    private boolean editable = true;
    String doneBtnText = "";
    private int max;

    private void setTopAndBottomBarColor() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)"#21282C"));
            window.setNavigationBarColor(Color.parseColor((String)"#21282C"));
        }
    }

    protected void onCreate(@Nullable Bundle object) {
        ArrayList arrayList;
        super.onCreate((Bundle)object);
        this.requestWindowFeature(1);
        this.setContentView(MediaPickerR.MP_LAYOUT_PREVIEW_MAIN);
        this.setTopAndBottomBarColor();
        this.findViewById(MediaPickerR.MP_ID_BTN_BACK).setOnClickListener((View.OnClickListener)this);
        this.isSingle = this.getIntent().getBooleanExtra("single_select", false);
        this.check_image = (ImageView)this.findViewById(MediaPickerR.MP_ID_CHECK_IMAGE);
        this.check_layout = (LinearLayout)this.findViewById(MediaPickerR.MP_ID_CHECK_LAYOUT);
        this.check_layout.setOnClickListener((View.OnClickListener)this);
        this.bar_title = (TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE);
        this.done = (Button)this.findViewById(MediaPickerR.MP_ID_DONE);
        this.done.setOnClickListener((View.OnClickListener)this);
        this.top = this.findViewById(MediaPickerR.MP_ID_TOP);
        this.bottom = this.findViewById(MediaPickerR.MP_ID_BOTTOM);
        this.imageEdit = (TextView)this.findViewById(R.id.gallery_preview_edit);
        this.imageEdit.setOnClickListener((View.OnClickListener)this);
        this.fullImage = (ImageView)this.findViewById(R.id.check_origin_image);
        this.fullImage.setSelected(this.getIntent().getBooleanExtra("FULL_IMAGE", false));
        object = this.getIntent().getStringExtra("size_type");
        if (object != null) {
            if (((String)object).contains("original") && ((String)object).contains("compressed")) {
                this.findViewById(R.id.check_origin_image_layout).setOnClickListener((View.OnClickListener)this);
            } else if (!((String)object).contains("original")) {
                this.findViewById(R.id.check_origin_image_layout).setVisibility(8);
            }
        } else {
            this.findViewById(R.id.check_origin_image_layout).setOnClickListener((View.OnClickListener)this);
        }
        if (this.getIntent().getIntExtra("select_mode", 101) == 102) {
            this.findViewById(R.id.check_origin_image_layout).setVisibility(8);
        }
        this.editable = this.getIntent().getBooleanExtra("image_editable", true);
        this.doneBtnText = this.getIntent().getStringExtra("done_button_text");
        if (!PdrUtil.isEmpty(this.doneBtnText)) {
            this.done.setText((CharSequence)this.doneBtnText);
        }
        this.max = this.getIntent().getIntExtra("max_select_count", Integer.MAX_VALUE);
        try {
            this.editActivityClass = Class.forName("io.dcloud.feature.gallery.imageedit.IMGEditActivity");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (this.isSingle) {
            this.bottom.setVisibility(8);
        }
        this.viewpager = (ViewPager)this.findViewById(MediaPickerR.MP_ID_VIEWPAGER);
        this.preRawList = this.getIntent().getParcelableArrayListExtra("pre_raw_List");
        object = arrayList;
        arrayList = new ArrayList();
        this.selects = object;
        object = this.preRawList;
        if (object != null && ((ArrayList)object).size() != 0) {
            this.selects.addAll(this.preRawList);
            if (BaseInfo.sGlobalFullScreen) {
                PreviewActivity previewActivity = this;
                previewActivity.setFullScreen((Activity)previewActivity, true);
            }
            this.setView(this.preRawList);
            return;
        }
        this.onBackPressed();
    }

    void setView(ArrayList<Media> object) {
        AdapterFragment adapterFragment;
        ArrayList arrayList;
        PreviewActivity previewActivity = this;
        previewActivity.setDoneView(((ArrayList)object).size());
        previewActivity.bar_title.setText((CharSequence)("1/" + this.preRawList.size()));
        Media media2 = previewActivity.preRawList.get(0);
        if (".gif".equalsIgnoreCase(media2.extension) || this.editActivityClass == null || media2.mediaType == 3 || !this.editable) {
            this.imageEdit.setVisibility(4);
        }
        ArrayList arrayList2 = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.fragmentArrayList = object;
        for (Media media2 : arrayList2) {
            this.fragmentArrayList.add(PreviewFragment.newInstance(media2, ""));
        }
        PreviewActivity previewActivity2 = this;
        object = adapterFragment;
        PreviewActivity previewActivity3 = this;
        media2 = previewActivity3.getSupportFragmentManager();
        adapterFragment = previewActivity3.new AdapterFragment((FragmentManager)media2, previewActivity3.fragmentArrayList);
        previewActivity2.viewpager.setAdapter((PagerAdapter)object);
        previewActivity2.viewpager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    void setDoneView(int n5) {
        if (PdrUtil.isEmpty(this.doneBtnText)) {
            this.doneBtnText = this.getString(MediaPickerR.MP_STRING_DONE);
        }
        if (this.max == Integer.MAX_VALUE) {
            this.done.setText((CharSequence)(this.doneBtnText + "(" + n5 + ")"));
        } else {
            this.done.setText((CharSequence)(this.doneBtnText + "(" + n5 + "/" + this.max + ")"));
        }
    }

    public void onClick(View view) {
        int n5 = view.getId();
        if (n5 == MediaPickerR.MP_ID_BTN_BACK) {
            this.done(this.selects, 1990);
        } else if (n5 == MediaPickerR.MP_ID_DONE) {
            this.done(this.selects, 19901026);
        } else if (n5 == MediaPickerR.MP_ID_CHECK_LAYOUT) {
            ArrayList<Media> arrayList;
            Media media = this.preRawList.get(this.viewpager.getCurrentItem());
            int n6 = this.isSelect(media, arrayList = this.selects);
            if (n6 < 0) {
                this.check_image.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)MediaPickerR.MP_DRAWABLE_BNT_SELECTED));
                this.selects.add(media);
            } else {
                this.check_image.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)MediaPickerR.MP_DRAWABLE_BNT_UNSELECTED));
                this.selects.remove(n6);
            }
            this.setDoneView(this.selects.size());
        } else if (n5 == R.id.gallery_preview_edit) {
            Intent intent;
            Intent intent2;
            n5 = this.viewpager.getCurrentItem();
            Media media = this.preRawList.get(n5);
            Intent intent3 = intent2 = intent;
            intent3((Context)this, this.editActivityClass);
            intent3.putExtra("IMAGE_URI", (Parcelable)Uri.parse((String)("file://" + media.path)));
            intent.putExtra("IMAGE_MEDIA_ID", media.id);
            intent.putExtra("IMAGE_INDEX", n5);
            this.startActivityForResult(intent2, 0);
        } else if (n5 == R.id.check_origin_image_layout) {
            ImageView imageView = this.fullImage;
            imageView.setSelected(imageView.isSelected() ^ true);
        }
    }

    public int isSelect(Media media, ArrayList<Media> arrayList) {
        int n5 = -1;
        if (arrayList.size() <= 0) {
            return n5;
        }
        for (int i5 = 0; i5 < arrayList.size(); ++i5) {
            if (!arrayList.get((int)i5).path.equals(media.path)) continue;
            n5 = i5;
            break;
        }
        return n5;
    }

    public void done(ArrayList<Media> arrayList, int n5) {
        Intent intent;
        Intent intent2;
        PreviewActivity previewActivity = this;
        Intent intent3 = intent2 = intent;
        intent3();
        intent3.putParcelableArrayListExtra("select_result", arrayList);
        intent2.putIntegerArrayListExtra("original_preview_index", this.getIntent().getIntegerArrayListExtra("original_preview_index"));
        intent2.putParcelableArrayListExtra("edited_preview_data", this.preRawList);
        intent.putExtra("FULL_IMAGE", this.fullImage.isSelected());
        previewActivity.setResult(n5, intent2);
        previewActivity.finish();
    }

    public void setBarStatus() {
        Log.e((String)"setBarStatus", (String)"setBarStatus");
        if (this.top.getVisibility() == 0) {
            PreviewActivity previewActivity = this;
            previewActivity.top.setVisibility(8);
            if (!previewActivity.isSingle) {
                this.bottom.setVisibility(8);
            }
        } else {
            PreviewActivity previewActivity = this;
            previewActivity.top.setVisibility(0);
            if (!previewActivity.isSingle) {
                this.bottom.setVisibility(0);
            }
        }
    }

    public void onBackPressed() {
        PreviewActivity previewActivity = this;
        previewActivity.done(previewActivity.selects, 1990);
        super.onBackPressed();
    }

    public void onPageScrolled(int n5, float f5, int n6) {
    }

    public void onPageSelected(int n5) {
        PreviewActivity previewActivity = previewActivity3;
        previewActivity.bar_title.setText((CharSequence)(n5 + 1 + "/" + previewActivity3.preRawList.size()));
        Media media = previewActivity.preRawList.get(n5);
        if (!".gif".equalsIgnoreCase(media.extension) && previewActivity3.editActivityClass != null && media.mediaType != 3 && previewActivity3.editable) {
            previewActivity3.imageEdit.setVisibility(0);
        } else {
            previewActivity3.imageEdit.setVisibility(4);
        }
        Media media2 = media;
        PreviewActivity previewActivity2 = previewActivity3;
        media = previewActivity2.check_image;
        PreviewActivity previewActivity3 = previewActivity3.isSelect(media2, previewActivity2.selects) < 0 ? ContextCompat.getDrawable((Context)previewActivity3, (int)MediaPickerR.MP_DRAWABLE_BNT_UNSELECTED) : ContextCompat.getDrawable((Context)previewActivity3, (int)MediaPickerR.MP_DRAWABLE_BNT_SELECTED);
        media.setImageDrawable((Drawable)previewActivity3);
    }

    public void onPageScrollStateChanged(int n5) {
    }

    public void setFullScreen(Activity activity, boolean bl) {
        PreviewActivity previewActivity = activity.getWindow();
        if (bl) {
            PreviewActivity previewActivity2 = previewActivity;
            WindowManager.LayoutParams layoutParams = previewActivity2.getAttributes();
            layoutParams.flags |= 0x400;
            previewActivity2.setAttributes(layoutParams);
        } else {
            PreviewActivity previewActivity3 = previewActivity;
            WindowManager.LayoutParams layoutParams = previewActivity3.getAttributes();
            layoutParams.flags &= 0xFFFFFBFF;
            previewActivity3.setAttributes(layoutParams);
        }
    }

    protected void onActivityResult(int n5, int n6, @Nullable Intent object) {
        super.onActivityResult(n5, n6, object);
        if (n6 == -1 && n5 == 0 && object != null) {
            Intent intent = object;
            n5 = intent.getIntExtra("IMAGE_INDEX", -1);
            n6 = intent.getIntExtra("_id", -1);
            if (n6 != -1 && n5 != -1) {
                Media media;
                PreviewActivity previewActivity = this;
                Intent intent2 = object;
                object = intent2.getStringExtra("PATH");
                String string2 = intent2.getStringExtra("_display_name");
                long l5 = System.currentTimeMillis();
                l5 = intent2.getLongExtra("date_added", l5);
                int n7 = intent2.getIntExtra("mime_type", 0);
                long l6 = intent2.getLongExtra("_size", 0L);
                String string3 = intent2.getStringExtra("PARENTPATH");
                Media media2 = media;
                media = new Media((String)object, string2, l5, n7, l6, n6, string3);
                Media media3 = previewActivity.preRawList.get(n5);
                int n8 = previewActivity.isSelect(media3, previewActivity.selects);
                if (n8 >= 0) {
                    this.selects.set(n8, media2);
                }
                PreviewActivity previewActivity2 = this;
                previewActivity2.preRawList.set(n5, media2);
                previewActivity2.fragmentArrayList.set(n5, PreviewFragment.newInstance(media2, ""));
                previewActivity2.viewpager.getAdapter().notifyDataSetChanged();
            } else {
                return;
            }
        }
    }

    public class AdapterFragment
    extends FragmentStatePagerAdapter {
        private List<Fragment> mFragments;

        public AdapterFragment(FragmentManager fragmentManager, List<Fragment> list) {
            super(fragmentManager);
            this.mFragments = list;
        }

        public Fragment getItem(int n5) {
            return this.mFragments.get(n5);
        }

        public int getCount() {
            return this.mFragments.size();
        }

        public int getItemPosition(@NonNull Object object) {
            return -2;
        }
    }
}

