/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker.utils;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;

public class ScreenUtils {
    private ScreenUtils() {
        throw new UnsupportedOperationException("\u672c\u5c4f\u5e55\u5de5\u5177\u7c7b\u4e0d\u80fd\u88ab\u5b9e\u4f8b\u5316,\u76f4\u63a5\u8c03\u7528\u9759\u6001\u65b9\u6cd5\u5c31\u597d");
    }

    public static boolean isScreenOriatationPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public static int getDpi(Context context) {
        DisplayMetrics displayMetrics;
        int n5 = 0;
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        Class.forName("android.view.Display").getMethod("getRealMetrics", DisplayMetrics.class).invoke((Object)display, displayMetrics2);
        try {
            n5 = displayMetrics.heightPixels;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n5;
    }

    public static int getBottomStatusHeight(Context context) {
        return ScreenUtils.getDpi(context) - ScreenUtils.getScreenHeight(context);
    }

    public static int getTitleHeight(Activity activity) {
        return activity.getWindow().findViewById(0x1020002).getTop();
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics displayMetrics;
        context = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics2();
        context.getDefaultDisplay().getMetrics(displayMetrics2);
        return displayMetrics.heightPixels;
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics displayMetrics;
        context = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics2();
        context.getDefaultDisplay().getMetrics(displayMetrics2);
        return displayMetrics.widthPixels;
    }

    public static int dp2px(Context context, float f5) {
        context = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)f5, (DisplayMetrics)context);
    }

    public static int sp2px(Context context, float f5) {
        context = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)2, (float)f5, (DisplayMetrics)context);
    }

    public static float px2dp(Context context, float f5) {
        return f5 / context.getResources().getDisplayMetrics().density;
    }

    public static float px2sp(Context context, float f5) {
        return f5 / context.getResources().getDisplayMetrics().scaledDensity;
    }
}

