/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.CipherSuite;
import dc.squareup.okhttp3.TlsVersion;
import dc.squareup.okhttp3.internal.Util;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class Handshake {
    private final TlsVersion tlsVersion;
    private final CipherSuite cipherSuite;
    private final List<Certificate> peerCertificates;
    private final List<Certificate> localCertificates;

    private Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.peerCertificates = list;
        this.localCertificates = list2;
    }

    public static Handshake get(SSLSession object) throws IOException {
        Object object2 = object.getCipherSuite();
        if (object2 != null) {
            if (!"SSL_NULL_WITH_NULL_NULL".equals(object2)) {
                object2 = CipherSuite.forJavaName((String)object2);
                Object object3 = object.getProtocol();
                if (object3 != null) {
                    if (!"NONE".equals(object3)) {
                        Object object4;
                        object3 = TlsVersion.forJavaName(object3);
                        try {
                            object4 = object.getPeerCertificates();
                        }
                        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                            object4 = null;
                        }
                        object4 = object4 != null ? Util.immutableList(object4) : Collections.emptyList();
                        object = object.getLocalCertificates();
                        object = object != null ? Util.immutableList(object) : Collections.emptyList();
                        return new Handshake((TlsVersion)((Object)object3), (CipherSuite)object2, (List<Certificate>)object4, (List<Certificate>)object);
                    }
                    throw new IOException("tlsVersion == NONE");
                }
                throw new IllegalStateException("tlsVersion == null");
            }
            throw new IOException("cipherSuite == SSL_NULL_WITH_NULL_NULL");
        }
        throw new IllegalStateException("cipherSuite == null");
    }

    public static Handshake get(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        if (tlsVersion != null) {
            if (cipherSuite != null) {
                list = Util.immutableList(list);
                list2 = Util.immutableList(list2);
                return new Handshake(tlsVersion, cipherSuite, list, list2);
            }
            throw new NullPointerException("cipherSuite == null");
        }
        throw new NullPointerException("tlsVersion == null");
    }

    public TlsVersion tlsVersion() {
        return this.tlsVersion;
    }

    public CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    public List<Certificate> peerCertificates() {
        return this.peerCertificates;
    }

    @Nullable
    public Principal peerPrincipal() {
        return !this.peerCertificates.isEmpty() ? ((X509Certificate)this.peerCertificates.get(0)).getSubjectX500Principal() : null;
    }

    public List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    @Nullable
    public Principal localPrincipal() {
        return !this.localCertificates.isEmpty() ? ((X509Certificate)this.localCertificates.get(0)).getSubjectX500Principal() : null;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Handshake)) {
            return false;
        }
        object = (Handshake)object;
        return ((Object)((Object)this.tlsVersion)).equals((Object)((Handshake)object).tlsVersion) && this.cipherSuite.equals(((Handshake)object).cipherSuite) && this.peerCertificates.equals(((Handshake)object).peerCertificates) && this.localCertificates.equals(((Handshake)object).localCertificates);
    }

    public int hashCode() {
        return (((527 + ((Object)((Object)this.tlsVersion)).hashCode()) * 31 + this.cipherSuite.hashCode()) * 31 + this.peerCertificates.hashCode()) * 31 + this.localCertificates.hashCode();
    }
}

