/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.cache;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.CacheControl;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.http.HttpDate;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class CacheStrategy {
    @Nullable
    public final Request networkRequest;
    @Nullable
    public final Response cacheResponse;

    CacheStrategy(Request request, Response response) {
        this.networkRequest = request;
        this.cacheResponse = response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCacheable(Response response, Request request) {
        switch (response.code()) {
            default: {
                return false;
            }
            case 302: 
            case 307: {
                if (response.header("Expires") != null || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic()) break;
                if (!response.cacheControl().isPrivate()) return false;
                break;
            }
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 308: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: 
        }
        if (response.cacheControl().noStore()) return false;
        if (request.cacheControl().noStore()) return false;
        return true;
    }

    public static class Factory {
        final long nowMillis;
        final Request request;
        final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds = -1;

        public Factory(long l5, Request request, Response object) {
            this.nowMillis = l5;
            this.request = request;
            this.cacheResponse = object;
            if (object != null) {
                this.sentRequestMillis = ((Response)object).sentRequestAtMillis();
                this.receivedResponseMillis = ((Response)object).receivedResponseAtMillis();
                Headers headers = ((Response)object).headers();
                int n5 = headers.size();
                for (int i5 = 0; i5 < n5; ++i5) {
                    object = headers.name(i5);
                    String string2 = headers.value(i5);
                    if ("Date".equalsIgnoreCase((String)object)) {
                        this.servedDate = HttpDate.parse(string2);
                        this.servedDateString = string2;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase((String)object)) {
                        this.expires = HttpDate.parse(string2);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase((String)object)) {
                        this.lastModified = HttpDate.parse(string2);
                        this.lastModifiedString = string2;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase((String)object)) {
                        this.etag = string2;
                        continue;
                    }
                    if (!"Age".equalsIgnoreCase((String)object)) continue;
                    this.ageSeconds = HttpHeaders.parseSeconds(string2, -1);
                }
            }
        }

        private CacheStrategy getCandidate() {
            block12: {
                block16: {
                    Object object;
                    Object object2;
                    block14: {
                        block15: {
                            block13: {
                                long l5;
                                if (this.cacheResponse == null) {
                                    return new CacheStrategy(this.request, null);
                                }
                                if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                                    return new CacheStrategy(this.request, null);
                                }
                                if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                                    return new CacheStrategy(this.request, null);
                                }
                                object2 = this.request.cacheControl();
                                if (((CacheControl)object2).noCache() || Factory.hasConditions(this.request)) break block12;
                                object = this.cacheResponse.cacheControl();
                                long l6 = this.cacheResponseAge();
                                long l7 = this.computeFreshnessLifetime();
                                if (((CacheControl)object2).maxAgeSeconds() != -1) {
                                    l7 = Math.min(l7, TimeUnit.SECONDS.toMillis(((CacheControl)object2).maxAgeSeconds()));
                                }
                                long l8 = 0L;
                                if (((CacheControl)object2).minFreshSeconds() != -1) {
                                    l8 = TimeUnit.SECONDS.toMillis(((CacheControl)object2).minFreshSeconds());
                                }
                                long l9 = 0L;
                                if (!((CacheControl)object).mustRevalidate() && ((CacheControl)object2).maxStaleSeconds() != -1) {
                                    l9 = TimeUnit.SECONDS.toMillis(((CacheControl)object2).maxStaleSeconds());
                                }
                                if (!((CacheControl)object).noCache() && (l5 = l6 + l8) < l7 + l9) {
                                    Response.Builder builder = this.cacheResponse.newBuilder();
                                    if (l5 >= l7) {
                                        builder.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                                    }
                                    if (l6 > 86400000L && this.isFreshnessLifetimeHeuristic()) {
                                        builder.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                                    }
                                    return new CacheStrategy(null, builder.build());
                                }
                                object2 = this.etag;
                                if (object2 == null) break block13;
                                object = "If-None-Match";
                                break block14;
                            }
                            if (this.lastModified == null) break block15;
                            object = "If-Modified-Since";
                            object2 = this.lastModifiedString;
                            break block14;
                        }
                        if (this.servedDate == null) break block16;
                        object = "If-Modified-Since";
                        object2 = this.servedDateString;
                    }
                    Headers.Builder builder = this.request.headers().newBuilder();
                    Internal.instance.addLenient(builder, (String)object, (String)object2);
                    object2 = this.request.newBuilder().headers(builder.build()).build();
                    return new CacheStrategy((Request)object2, this.cacheResponse);
                }
                return new CacheStrategy(this.request, null);
            }
            return new CacheStrategy(this.request, null);
        }

        private long computeFreshnessLifetime() {
            Object object = this.cacheResponse.cacheControl();
            if (((CacheControl)object).maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(((CacheControl)object).maxAgeSeconds());
            }
            if (this.expires != null) {
                object = this.servedDate;
                long l5 = object != null ? ((Date)object).getTime() : this.receivedResponseMillis;
                l5 = this.expires.getTime() - l5;
                if (l5 <= 0L) {
                    l5 = 0L;
                }
                return l5;
            }
            if (this.lastModified != null && this.cacheResponse.request().url().query() == null) {
                object = this.servedDate;
                long l6 = (object != null ? ((Date)object).getTime() : this.sentRequestMillis) - this.lastModified.getTime();
                return l6 > 0L ? l6 / 10L : 0L;
            }
            return 0L;
        }

        private long cacheResponseAge() {
            long l5;
            Date date = this.servedDate;
            if (date != null) {
                l5 = this.receivedResponseMillis - date.getTime();
                l5 = Math.max(0L, l5);
            } else {
                l5 = 0L;
            }
            int n5 = this.ageSeconds;
            if (n5 != -1) {
                l5 = Math.max(l5, TimeUnit.SECONDS.toMillis(n5));
            }
            long l6 = l5;
            long l7 = this.receivedResponseMillis;
            l5 = l7;
            l5 = this.nowMillis - l5;
            return l6 + (l7 - this.sentRequestMillis) + l5;
        }

        private boolean isFreshnessLifetimeHeuristic() {
            return this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
        }

        private static boolean hasConditions(Request request) {
            return request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
        }

        public CacheStrategy get() {
            CacheStrategy cacheStrategy = this.getCandidate();
            if (cacheStrategy.networkRequest != null && this.request.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return cacheStrategy;
        }
    }
}

