/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http;

import dc.squareup.okhttp3.Cookie;
import dc.squareup.okhttp3.CookieJar;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.RequestBody;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.Version;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okhttp3.internal.http.RealResponseBody;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.GzipSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Source;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class BridgeInterceptor
implements Interceptor {
    private static final Comparator<String> FIELD_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string2, String string3) {
            if (string2 == string3) {
                return 0;
            }
            if (string2 == null) {
                return -1;
            }
            return string3 == null ? 1 : String.CASE_INSENSITIVE_ORDER.compare(string2, string3);
        }
    };
    private final CookieJar cookieJar;

    public BridgeInterceptor(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
    }

    public static Map<String, List<String>> toMultimap(Headers headers, String string2) {
        TreeMap treeMap;
        TreeMap treeMap2 = treeMap;
        treeMap = new TreeMap(FIELD_NAME_COMPARATOR);
        int n5 = headers.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            ArrayList<String> arrayList;
            String string3 = headers.name(i5);
            String string4 = headers.value(i5);
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>();
            List list = (List)treeMap2.get(string3);
            if (list != null) {
                arrayList2.addAll(list);
            }
            ArrayList<String> arrayList3 = arrayList2;
            arrayList3.add(string4);
            treeMap2.put(string3, Collections.unmodifiableList(arrayList3));
        }
        if (string2 != null) {
            treeMap2.put(null, Collections.unmodifiableList(Collections.singletonList(string2)));
        }
        return Collections.unmodifiableMap(treeMap2);
    }

    public static void addCookies(Request.Builder builder, Map<String, List<String>> object) {
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String string2 = (String)entry.getKey();
            if (!"Cookie".equalsIgnoreCase(string2) && !"Cookie2".equalsIgnoreCase(string2) || ((List)entry.getValue()).isEmpty()) continue;
            builder.addHeader(string2, BridgeInterceptor.buildCookieHeader((List)entry.getValue()));
        }
        return;
    }

    public static String buildCookieHeader(List<String> list) {
        StringBuilder stringBuilder;
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n5 = list.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            if (i5 > 0) {
                stringBuilder2.append("; ");
            }
            stringBuilder2.append(list.get(i5));
        }
        return stringBuilder2.toString();
    }

    private String cookieHeader(List<Cookie> list) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n5 = list.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            if (i5 > 0) {
                stringBuilder2.append("; ");
            }
            Cookie cookie = list.get(i5);
            stringBuilder2.append(cookie.name()).append('=').append(cookie.value());
        }
        return stringBuilder2.toString();
    }

    @Override
    public Response intercept(Interceptor.Chain object) throws IOException {
        boolean bl;
        Object object2;
        block20: {
            Object object3;
            object2 = object.request();
            Object object4 = ((Request)object2).newBuilder();
            RequestBody requestBody = ((Request)object2).body();
            if (requestBody != null) {
                long l5;
                object3 = requestBody.contentType();
                if (object3 != null) {
                    ((Request.Builder)object4).header("Content-Type", ((MediaType)object3).toString());
                }
                if ((l5 = requestBody.contentLength()) != -1L) {
                    Request.Builder builder = object4;
                    builder.header("Content-Length", Long.toString(l5));
                    builder.removeHeader("Transfer-Encoding");
                } else {
                    Request.Builder builder = object4;
                    builder.header("Transfer-Encoding", "chunked");
                    builder.removeHeader("Content-Length");
                }
            }
            if (((Request)object2).header("Host") == null) {
                ((Request.Builder)object4).header("Host", Util.hostHeader(((Request)object2).url(), false));
            }
            if (((Request)object2).header("Connection") == null) {
                ((Request.Builder)object4).header("Connection", "Keep-Alive");
            }
            bl = false;
            if (((Request)object2).header("Accept-Encoding") == null && ((Request)object2).header("Range") == null) {
                bl = true;
                ((Request.Builder)object4).header("Accept-Encoding", "gzip");
            }
            if ((object3 = ((Request)object2).header("cookie")) == null) {
                object3 = CookieHandler.getDefault();
                if (object3 != null) {
                    Headers headers;
                    Request request;
                    Map<String, List<String>> map;
                    Request.Builder builder;
                    try {
                        builder = object4;
                        map = object3;
                        Request request2 = object2;
                        request = request2;
                        headers = request2.headers();
                    }
                    catch (Exception exception) {}
                    object3 = BridgeInterceptor.toMultimap(headers, null);
                    BridgeInterceptor.addCookies(builder, ((CookieHandler)((Object)map)).get(request.url().uri(), (Map<String, List<String>>)object3));
                }
            } else {
                ((Request.Builder)object4).header("Cookie", (String)object3);
            }
            if (((Request)object2).header("User-Agent") == null) {
                ((Request.Builder)object4).header("User-Agent", Version.userAgent());
            }
            object = object.proceed(((Request.Builder)object4).build());
            try {
                object4 = CookieHandler.getDefault();
                if (object4 == null) break block20;
            }
            catch (Exception exception) {}
            Object object5 = object4;
            URI uRI = ((Request)object2).url().uri();
            Headers headers = ((Response)object).headers();
            ((CookieHandler)object5).put(uRI, BridgeInterceptor.toMultimap(headers, null));
        }
        Object object6 = ((Request)object2).url();
        HttpHeaders.receiveHeaders(((BridgeInterceptor)object6).cookieJar, (HttpUrl)object6, ((Response)object).headers());
        object6 = ((Response)object).newBuilder().request((Request)object2);
        if (bl && "gzip".equalsIgnoreCase(((Response)object).header("Content-Encoding")) && HttpHeaders.hasBody((Response)object)) {
            GzipSource gzipSource;
            object2 = gzipSource;
            gzipSource = new GzipSource(((Response)object).body().source());
            ((Response.Builder)object6).headers(((Response)object).headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build());
            Object object7 = object = ((Response)object).header("Content-Type");
            object = Okio.buffer((Source)object2);
            ((Response.Builder)object6).body(new RealResponseBody((String)object7, -1L, (BufferedSource)object));
        }
        return ((Response.Builder)object6).build();
    }
}

