/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http;

import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.Connection;
import dc.squareup.okhttp3.EventListener;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.RealConnection;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.http.HttpCodec;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RealInterceptorChain
implements Interceptor.Chain {
    private final List<Interceptor> interceptors;
    private final StreamAllocation streamAllocation;
    private final HttpCodec httpCodec;
    private final RealConnection connection;
    private final int index;
    private final Request request;
    private final Call call;
    private final EventListener eventListener;
    private final int connectTimeout;
    private final int readTimeout;
    private final int writeTimeout;
    private int calls;

    public RealInterceptorChain(List<Interceptor> list, StreamAllocation streamAllocation, HttpCodec httpCodec, RealConnection realConnection, int n5, Request request, Call call, EventListener eventListener, int n6, int n7, int n8) {
        this.interceptors = list;
        this.connection = realConnection;
        this.streamAllocation = streamAllocation;
        this.httpCodec = httpCodec;
        this.index = n5;
        this.request = request;
        this.call = call;
        this.eventListener = eventListener;
        this.connectTimeout = n6;
        this.readTimeout = n7;
        this.writeTimeout = n8;
    }

    @Override
    public Connection connection() {
        return this.connection;
    }

    @Override
    public int connectTimeoutMillis() {
        return this.connectTimeout;
    }

    @Override
    public Interceptor.Chain withConnectTimeout(int n5, TimeUnit object) {
        long l5 = n5;
        n5 = Util.checkDuration("timeout", l5, object);
        RealInterceptorChain realInterceptorChain = list;
        List<Interceptor> list = realInterceptorChain.interceptors;
        object = realInterceptorChain.streamAllocation;
        HttpCodec httpCodec = realInterceptorChain.httpCodec;
        RealConnection realConnection = realInterceptorChain.connection;
        int n6 = realInterceptorChain.index;
        Request request = realInterceptorChain.request;
        Call call = realInterceptorChain.call;
        EventListener eventListener = realInterceptorChain.eventListener;
        int n7 = realInterceptorChain.readTimeout;
        int n8 = realInterceptorChain.writeTimeout;
        return new RealInterceptorChain(list, (StreamAllocation)object, httpCodec, realConnection, n6, request, call, eventListener, n5, n7, n8);
    }

    @Override
    public int readTimeoutMillis() {
        return this.readTimeout;
    }

    @Override
    public Interceptor.Chain withReadTimeout(int n5, TimeUnit object) {
        long l5 = n5;
        n5 = Util.checkDuration("timeout", l5, object);
        RealInterceptorChain realInterceptorChain = list;
        List<Interceptor> list = realInterceptorChain.interceptors;
        object = realInterceptorChain.streamAllocation;
        HttpCodec httpCodec = realInterceptorChain.httpCodec;
        RealConnection realConnection = realInterceptorChain.connection;
        int n6 = realInterceptorChain.index;
        Request request = realInterceptorChain.request;
        Call call = realInterceptorChain.call;
        EventListener eventListener = realInterceptorChain.eventListener;
        int n7 = realInterceptorChain.connectTimeout;
        int n8 = realInterceptorChain.writeTimeout;
        return new RealInterceptorChain(list, (StreamAllocation)object, httpCodec, realConnection, n6, request, call, eventListener, n7, n5, n8);
    }

    @Override
    public int writeTimeoutMillis() {
        return this.writeTimeout;
    }

    @Override
    public Interceptor.Chain withWriteTimeout(int n5, TimeUnit object) {
        long l5 = n5;
        n5 = Util.checkDuration("timeout", l5, object);
        RealInterceptorChain realInterceptorChain = list;
        List<Interceptor> list = realInterceptorChain.interceptors;
        object = realInterceptorChain.streamAllocation;
        HttpCodec httpCodec = realInterceptorChain.httpCodec;
        RealConnection realConnection = realInterceptorChain.connection;
        int n6 = realInterceptorChain.index;
        Request request = realInterceptorChain.request;
        Call call = realInterceptorChain.call;
        EventListener eventListener = realInterceptorChain.eventListener;
        int n7 = realInterceptorChain.connectTimeout;
        int n8 = realInterceptorChain.readTimeout;
        return new RealInterceptorChain(list, (StreamAllocation)object, httpCodec, realConnection, n6, request, call, eventListener, n7, n8, n5);
    }

    public StreamAllocation streamAllocation() {
        return this.streamAllocation;
    }

    public HttpCodec httpStream() {
        return this.httpCodec;
    }

    @Override
    public Call call() {
        return this.call;
    }

    public EventListener eventListener() {
        return this.eventListener;
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public Response proceed(Request object) throws IOException {
        RealInterceptorChain realInterceptorChain = streamAllocation;
        Request request = object;
        RealInterceptorChain realInterceptorChain2 = streamAllocation;
        StreamAllocation streamAllocation = realInterceptorChain2.streamAllocation;
        object = realInterceptorChain2.httpCodec;
        RealConnection realConnection = realInterceptorChain2.connection;
        return realInterceptorChain.proceed(request, streamAllocation, (HttpCodec)object, realConnection);
    }

    public Response proceed(Request object, StreamAllocation streamAllocation, HttpCodec httpCodec, RealConnection realConnection) throws IOException {
        if (this.index < this.interceptors.size()) {
            RealInterceptorChain realInterceptorChain;
            ++this.calls;
            if (this.httpCodec != null && !this.connection.supportsUrl(((Request)object).url())) {
                throw new IllegalStateException("network interceptor " + this.interceptors.get(this.index - 1) + " must retain the same host and port");
            }
            if (this.httpCodec != null && this.calls > 1) {
                throw new IllegalStateException("network interceptor " + this.interceptors.get(this.index - 1) + " must call proceed() exactly once");
            }
            RealInterceptorChain realInterceptorChain2 = realInterceptorChain;
            int n5 = this.index + 1;
            Call call = this.call;
            EventListener eventListener = this.eventListener;
            int n6 = this.connectTimeout;
            int n7 = this.readTimeout;
            int n8 = this.writeTimeout;
            realInterceptorChain = new RealInterceptorChain(this.interceptors, streamAllocation, httpCodec, realConnection, n5, (Request)object, call, eventListener, n6, n7, n8);
            object = this.interceptors.get(this.index);
            Response response = object.intercept(realInterceptorChain2);
            if (httpCodec != null && this.index + 1 < this.interceptors.size() && realInterceptorChain2.calls != 1) {
                throw new IllegalStateException("network interceptor " + object + " must call proceed() exactly once");
            }
            if (response != null) {
                if (response.body() != null) {
                    return response;
                }
                throw new IllegalStateException("interceptor " + object + " returned a response with no body");
            }
            throw new NullPointerException("interceptor " + object + " returned null");
        }
        throw new AssertionError();
    }
}

