/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Hpack;
import dc.squareup.okhttp3.internal.http2.Http2;
import dc.squareup.okhttp3.internal.http2.Settings;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Writer
implements Closeable {
    private static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    final Hpack.Writer hpackWriter;

    Http2Writer(BufferedSink object, boolean bl) {
        Hpack.Writer writer;
        Buffer buffer;
        closeable.sink = object;
        closeable.client = bl;
        Closeable closeable = buffer;
        buffer = new Buffer();
        v1.hpackBuffer = closeable;
        object = writer;
        writer = new Hpack.Writer((Buffer)closeable);
        v1.hpackWriter = object;
        v1.maxFrameSize = 16384;
    }

    private static void writeMedium(BufferedSink bufferedSink, int n5) throws IOException {
        bufferedSink.writeByte(n5 >>> 16 & 0xFF);
        bufferedSink.writeByte(n5 >>> 8 & 0xFF);
        bufferedSink.writeByte(n5 & 0xFF);
    }

    private void writeContinuationFrames(int n5, long l5) throws IOException {
        while (l5 > 0L) {
            int n6 = (int)Math.min((long)this.maxFrameSize, l5);
            long l6 = n6;
            long l7 = l5 - l6;
            byte by = 9;
            byte by2 = l7 == 0L ? (byte)4 : 0;
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(n5, n6, by, by2);
            http2Writer.sink.write(this.hpackBuffer, l6);
            l5 = l7;
        }
    }

    public synchronized void connectionPreface() throws IOException {
        if (!this.closed) {
            if (!this.client) {
                return;
            }
            Object object = logger;
            if (((Logger)object).isLoggable(Level.FINE)) {
                Logger logger = object;
                object = Http2.CONNECTION_PREFACE.hex();
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = object;
                logger.fine(Util.format(">> CONNECTION %s", objectArray2));
            }
            Http2Writer http2Writer = this;
            http2Writer.sink.write(Http2.CONNECTION_PREFACE.toByteArray());
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void applyAndAckSettings(Settings settings) throws IOException {
        if (!this.closed) {
            this.maxFrameSize = settings.getMaxFrameSize(this.maxFrameSize);
            if (settings.getHeaderTableSize() != -1) {
                this.hpackWriter.setHeaderTableSizeSetting(settings.getHeaderTableSize());
            }
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(0, 0, (byte)4, (byte)1);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void pushPromise(int n5, int n6, List<Header> list) throws IOException {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.hpackWriter.writeHeaders(list);
            long l5 = http2Writer.hpackBuffer.size();
            int n7 = (int)Math.min((long)(this.maxFrameSize - 4), l5);
            byte by = 5;
            long l6 = n7;
            byte by2 = l5 == l6 ? (byte)4 : 0;
            Http2Writer http2Writer2 = this;
            http2Writer2.frameHeader(n5, n7 + 4, by, by2);
            http2Writer2.sink.writeInt(n6 & Integer.MAX_VALUE);
            http2Writer2.sink.write(this.hpackBuffer, l6);
            if (l5 > l6) {
                long l7 = l5 - l6;
                this.writeContinuationFrames(n5, l7);
            }
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void flush() throws IOException {
        if (!this.closed) {
            this.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void synStream(boolean bl, int n5, int n6, List<Header> list) throws IOException {
        if (!this.closed) {
            this.headers(bl, n5, list);
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void synReply(boolean bl, int n5, List<Header> list) throws IOException {
        if (!this.closed) {
            this.headers(bl, n5, list);
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void headers(int n5, List<Header> list) throws IOException {
        if (!this.closed) {
            this.headers(false, n5, list);
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void rstStream(int n5, ErrorCode errorCode) throws IOException {
        if (!this.closed) {
            if (errorCode.httpCode != -1) {
                Http2Writer http2Writer = this;
                http2Writer.frameHeader(n5, 4, (byte)3, (byte)0);
                http2Writer.sink.writeInt(errorCode.httpCode);
                http2Writer.sink.flush();
                return;
            }
            throw new IllegalArgumentException();
        }
        throw new IOException("closed");
    }

    public int maxDataLength() {
        return this.maxFrameSize;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void data(boolean bl, int n5, Buffer buffer, int n6) throws IOException {
        if (!this.closed) {
            void var4_6;
            void var3_5;
            void var2_4;
            byte by;
            boolean bl2 = false;
            if (bl) {
                by = (byte)1;
            }
            this.dataFrame((int)var2_4, by, (Buffer)var3_5, (int)var4_6);
            return;
        }
        throw new IOException("closed");
    }

    void dataFrame(int n5, byte by, Buffer buffer, int n6) throws IOException {
        this.frameHeader(n5, n6, (byte)0, by);
        if (n6 > 0) {
            this.sink.write(buffer, (long)n6);
        }
    }

    public synchronized void settings(Settings settings) throws IOException {
        if (!this.closed) {
            this.frameHeader(0, settings.size() * 6, (byte)4, (byte)0);
            for (int i5 = 0; i5 < 10; ++i5) {
                if (!settings.isSet(i5)) continue;
                int n5 = i5 == 4 ? 3 : (i5 == 7 ? 4 : i5);
                Http2Writer http2Writer = this;
                http2Writer.sink.writeShort(n5);
                http2Writer.sink.writeInt(settings.get(i5));
            }
            this.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void ping(boolean bl, int n5, int n6) throws IOException {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            byte by = 6;
            http2Writer.frameHeader(0, 8, by, bl ? 1 : 0);
            http2Writer.sink.writeInt(n5);
            http2Writer.sink.writeInt(n6);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void goAway(int n5, ErrorCode errorCode, byte[] byArray) throws IOException {
        if (!this.closed) {
            if (errorCode.httpCode != -1) {
                Http2Writer http2Writer = this;
                http2Writer.frameHeader(0, byArray.length + 8, (byte)7, (byte)0);
                http2Writer.sink.writeInt(n5);
                http2Writer.sink.writeInt(errorCode.httpCode);
                if (byArray.length > 0) {
                    this.sink.write(byArray);
                }
                this.sink.flush();
                return;
            }
            throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
        }
        throw new IOException("closed");
    }

    public synchronized void windowUpdate(int n5, long l5) throws IOException {
        if (!((Http2Writer)((Object)l7)).closed) {
            if (l5 != 0L && l5 <= Integer.MAX_VALUE) {
                Long l6 = l7;
                ((Http2Writer)((Object)l6)).frameHeader(n5, 4, (byte)8, (byte)0);
                ((Http2Writer)((Object)l6)).sink.writeInt((int)l5);
                ((Http2Writer)((Object)l6)).sink.flush();
                return;
            }
            Long l7 = l5;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = l7;
            throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", objectArray2);
        }
        throw new IOException("closed");
    }

    public void frameHeader(int n5, int n6, byte by, byte by2) throws IOException {
        Object object;
        int n7;
        Logger logger = Http2Writer.logger;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(false, n5, n6, by, by2));
        }
        if (n6 <= (n7 = ((Http2Writer)object).maxFrameSize)) {
            if ((n5 & Integer.MIN_VALUE) == 0) {
                Object object2 = object;
                Http2Writer.writeMedium(((Http2Writer)object2).sink, n6);
                ((Http2Writer)object2).sink.writeByte(by & 0xFF);
                ((Http2Writer)object2).sink.writeByte(by2 & 0xFF);
                ((Http2Writer)object2).sink.writeInt(n5 & Integer.MAX_VALUE);
                return;
            }
            object = n5;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            throw Http2.illegalArgument("reserved bit set: %s", objectArray2);
        }
        object = n7;
        Integer n8 = n6;
        Object[] objectArray = new Object[2];
        Object[] objectArray3 = objectArray;
        objectArray[0] = object;
        objectArray[1] = n8;
        throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", objectArray3);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    void headers(boolean bl, int n5, List<Header> list) throws IOException {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.hpackWriter.writeHeaders(list);
            long l5 = http2Writer.hpackBuffer.size();
            int n6 = (int)Math.min((long)this.maxFrameSize, l5);
            byte by = 1;
            long l6 = n6;
            byte by2 = l5 == l6 ? (byte)4 : 0;
            if (bl) {
                by2 = (byte)(by2 | 1);
            }
            Http2Writer http2Writer2 = this;
            http2Writer2.frameHeader(n5, n6, by, by2);
            http2Writer2.sink.write(this.hpackBuffer, l6);
            if (l5 > l6) {
                long l7 = l5 - l6;
                this.writeContinuationFrames(n5, l7);
            }
            return;
        }
        throw new IOException("closed");
    }
}

