/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.platform.OptionalMethod;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okhttp3.internal.tls.CertificateChainCleaner;
import dc.squareup.okhttp3.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();

    AndroidPlatform(Class<?> clazz, OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
        this.sslParametersClass = clazz;
        this.setUseSessionTickets = optionalMethod;
        this.setHostname = optionalMethod2;
        this.getAlpnSelectedProtocol = optionalMethod3;
        this.setAlpnProtocols = optionalMethod4;
    }

    private boolean api24IsCleartextTrafficPermitted(String string2, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            return (Boolean)clazz.getMethod("isCleartextTrafficPermitted", String.class).invoke(object, string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.api23IsCleartextTrafficPermitted(string2, clazz, object);
        }
    }

    private boolean api23IsCleartextTrafficPermitted(String string2, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            return (Boolean)clazz.getMethod("isCleartextTrafficPermitted", null).invoke(object, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string2);
        }
    }

    private static boolean supportsAlpn() {
        if (Security.getProvider("GMSCore_OpenSSL") != null) {
            return true;
        }
        try {
            Class.forName("android.net.Network");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Platform buildIfSupported() {
        Class[] classArray;
        String string2;
        OptionalMethod optionalMethod;
        Class[] classArray2;
        OptionalMethod optionalMethod2;
        Object object;
        OptionalMethod optionalMethod3;
        OptionalMethod<Socket> optionalMethod4;
        OptionalMethod<Socket> optionalMethod5;
        Class<?> clazz;
        if (AndroidPlatform.getSdkInt() == 0) {
            return null;
        }
        try {
            clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
        Class<?> clazz2 = clazz;
        OptionalMethod<Socket> optionalMethod6 = optionalMethod5;
        {
            optionalMethod5 = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
        }
        OptionalMethod<Socket> optionalMethod7 = optionalMethod4;
        {
            optionalMethod4 = new OptionalMethod<Socket>(null, "setHostname", String.class);
            optionalMethod3 = null;
            object = null;
            if (!AndroidPlatform.supportsAlpn()) return new AndroidPlatform(clazz2, optionalMethod6, optionalMethod7, optionalMethod3, (OptionalMethod<Socket>)object);
        }
        optionalMethod3 = optionalMethod2;
        {
            object = byte[].class;
            classArray2 = new Class[]{};
            optionalMethod2 = new OptionalMethod((Class<?>)object, "getAlpnSelectedProtocol", classArray2);
        }
        object = optionalMethod;
        classArray2 = null;
        {
            string2 = "setAlpnProtocols";
            classArray = new Class[1];
        }
        Class[] classArray3 = classArray;
        {
            classArray[0] = byte[].class;
            optionalMethod = new OptionalMethod((Class<?>)classArray2, string2, classArray3);
            return new AndroidPlatform(clazz2, optionalMethod6, optionalMethod7, optionalMethod3, (OptionalMethod<Socket>)object);
        }
    }

    static int getSdkInt() {
        try {
            return Build.VERSION.SDK_INT;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return 0;
        }
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n5) throws IOException {
        try {
            socket.connect(inetSocketAddress, n5);
            return;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                IOException iOException = new IOException("Exception in connect");
                iOException.initCause(classCastException);
                throw iOException;
            }
            throw classCastException;
        }
        catch (SecurityException securityException) {
            IOException iOException = new IOException("Exception in connect");
            iOException.initCause(securityException);
            throw iOException;
        }
        catch (AssertionError assertionError) {
            AssertionError assertionError2 = assertionError;
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)((Object)assertionError2));
            }
            throw assertionError2;
        }
    }

    @Override
    @Nullable
    protected X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        Object obj = Platform.readFieldOrNull(sSLSocketFactory, ((AndroidPlatform)this).sslParametersClass, "sslParameters");
        if (obj == null) {
            String string2;
            SSLSocketFactory sSLSocketFactory2;
            try {
                sSLSocketFactory2 = sSLSocketFactory;
                string2 = "com.google.android.gms.org.conscrypt.SSLParametersImpl";
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager(sSLSocketFactory);
            }
            obj = Platform.readFieldOrNull(sSLSocketFactory2, Class.forName(string2, false, sSLSocketFactory.getClass().getClassLoader()), "sslParameters");
        }
        if ((this = Platform.readFieldOrNull(obj, X509TrustManager.class, "x509TrustManager")) != null) {
            return this;
        }
        return Platform.readFieldOrNull(obj, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String objectArray, List<Protocol> list) throws IOException {
        if (objectArray != null) {
            AndroidPlatform androidPlatform = object;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = Boolean.TRUE;
            androidPlatform.setUseSessionTickets.invokeOptionalWithoutCheckedException(sSLSocket, objectArray3);
            Object[] objectArray4 = new Object[1];
            objectArray3 = objectArray4;
            objectArray4[0] = objectArray;
            androidPlatform.setHostname.invokeOptionalWithoutCheckedException(sSLSocket, objectArray3);
        }
        if ((objectArray = ((AndroidPlatform)object).setAlpnProtocols) != null && objectArray.isSupported(sSLSocket)) {
            AndroidPlatform androidPlatform = object;
            Object object = Platform.concatLengthPrefixed(list);
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = object;
            androidPlatform.setAlpnProtocols.invokeWithoutCheckedException(sSLSocket, objectArray);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket object) {
        OptionalMethod<Socket> optionalMethod = ((AndroidPlatform)object2).getAlpnSelectedProtocol;
        if (optionalMethod == null) {
            return null;
        }
        if (!optionalMethod.isSupported((Socket)object)) {
            return null;
        }
        byte[] byArray = (byte[])((AndroidPlatform)object2).getAlpnSelectedProtocol.invokeWithoutCheckedException((Socket)object, new Object[0]);
        Object object2 = byArray;
        if (byArray != null) {
            String string2;
            object = string2;
            string2 = new String((byte[])object2, Util.UTF_8);
        } else {
            object = null;
        }
        return object;
    }

    @Override
    public void log(int n5, String string2, @Nullable Throwable throwable) {
        int n6 = n5 == 5 ? 5 : 3;
        if (throwable != null) {
            string2 = string2 + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        n5 = 0;
        int n7 = string2.length();
        block0: while (n5 < n7) {
            int n8 = string2.indexOf(10, n5);
            if (n8 == -1) {
                n8 = n7;
            }
            while (true) {
                int n9 = Math.min(n8, n5 + 4000);
                Log.println((int)n6, (String)"OkHttp", (String)string2.substring(n5, n9));
                if (n9 >= n8) {
                    n5 = n9 + 1;
                    continue block0;
                }
                n5 = n9;
            }
        }
    }

    @Override
    public Object getStackTraceForCloseable(String string2) {
        return this.closeGuard.createAndOpen(string2);
    }

    @Override
    public void logCloseableLeak(String string2, Object object) {
        if (!this.closeGuard.warnIfOpen(object)) {
            this.log(5, string2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isCleartextTrafficPermitted(String string2) {
        block10: {
            void var0_4;
            if (Build.VERSION.SDK_INT < 23) {
                return super.isCleartextTrafficPermitted(string2);
            }
            AndroidPlatform androidPlatform = this;
            String string3 = string2;
            Class<?> clazz = Class.forName("android.security.NetworkSecurityPolicy");
            Method method = clazz.getMethod("getInstance", null);
            try {
                return androidPlatform.api24IsCleartextTrafficPermitted(string3, clazz, method.invoke(null, null));
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                break block10;
            }
            catch (ClassNotFoundException classNotFoundException) {
                break block10;
            }
            throw Util.assertionError("unable to determine cleartext support", (Exception)var0_4);
        }
        return super.isCleartextTrafficPermitted(string2);
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        Object obj;
        Class<?> clazz;
        try {
            Class<?> clazz2 = Class.forName("android.net.http.X509TrustManagerExtensions");
            clazz = clazz2;
            obj = clazz2.getConstructor(X509TrustManager.class).newInstance(x509TrustManager);
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(x509TrustManager);
        }
        String string2 = "checkServerTrusted";
        Class[] classArray = new Class[3];
        Class[] classArray2 = classArray;
        Class[] classArray3 = classArray;
        Class[] classArray4 = classArray;
        classArray[0] = X509Certificate[].class;
        Object object = String.class;
        classArray2[1] = object;
        classArray3[2] = object;
        object = clazz.getMethod(string2, classArray4);
        return new AndroidCertificateChainCleaner(obj, (Method)object);
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        Method method;
        try {
            method = x509TrustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
        method.setAccessible(true);
        return new AndroidTrustRootIndex(x509TrustManager, method);
    }

    @Override
    public SSLContext getSSLContext() {
        block6: {
            try {
                int n5 = Build.VERSION.SDK_INT;
                if (n5 < 16 || n5 >= 22) break block6;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            try {
                return SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method method, Method method2, Method method3) {
            this.getMethod = method;
            this.openMethod = method2;
            this.warnIfOpenMethod = method3;
        }

        static CloseGuard get() {
            Method method;
            Class<?> clazz = Class.forName("dalvik.system.CloseGuard");
            Class<?> clazz2 = clazz;
            Class<?> clazz3 = clazz;
            Method method2 = clazz.getMethod("get", null);
            Method method3 = clazz3.getMethod("open", String.class);
            try {
                method = clazz2.getMethod("warnIfOpen", null);
            }
            catch (Exception exception) {
                method2 = null;
                method3 = null;
                method = null;
            }
            return new CloseGuard(method2, method3, method);
        }

        Object createAndOpen(String string2) {
            Method method = objectArray2.getMethod;
            if (method != null) {
                Object object;
                try {
                    object = method.invoke(null, null);
                }
                catch (Exception exception) {}
                Object object2 = object;
                Method method2 = objectArray2.openMethod;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string2;
                method2.invoke(object2, objectArray2);
                return object;
            }
            return null;
        }

        boolean warnIfOpen(Object object) {
            boolean bl = false;
            if (object != null) {
                try {
                    this.warnIfOpenMethod.invoke(object, null);
                }
                catch (Exception exception) {}
                bl = true;
            }
            return bl;
        }
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        AndroidCertificateChainCleaner(Object object, Method method) {
            this.x509TrustManagerExtensions = object;
            this.checkServerTrusted = method;
        }

        @Override
        public List<Certificate> clean(List<Certificate> x509CertificateArray, String string2) throws SSLPeerUnverifiedException {
            InvocationTargetException invocationTargetException2;
            block5: {
                AndroidCertificateChainCleaner androidCertificateChainCleaner = this;
                x509CertificateArray = x509CertificateArray.toArray(new X509Certificate[x509CertificateArray.size()]);
                try {
                    return (List)androidCertificateChainCleaner.checkServerTrusted.invoke(this.x509TrustManagerExtensions, x509CertificateArray, "RSA", string2);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException2) {
                    break block5;
                }
                throw new AssertionError((Object)illegalAccessException);
            }
            SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(invocationTargetException2.getMessage());
            sSLPeerUnverifiedException.initCause(invocationTargetException2);
            throw sSLPeerUnverifiedException;
        }

        public boolean equals(Object object) {
            return object instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }

    static final class AndroidTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        AndroidTrustRootIndex(X509TrustManager x509TrustManager, Method method) {
            this.findByIssuerAndSignatureMethod = method;
            this.trustManager = x509TrustManager;
        }

        @Override
        public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
            IllegalAccessException illegalAccessException2;
            block7: {
                block6: {
                    block5: {
                        Object object;
                        block4: {
                            object = (TrustAnchor)((AndroidTrustRootIndex)object).findByIssuerAndSignatureMethod.invoke((Object)((AndroidTrustRootIndex)object).trustManager, x509Certificate);
                            if (object == null) break block4;
                            try {
                                object = ((TrustAnchor)object).getTrustedCert();
                                break block5;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                break block6;
                            }
                            catch (IllegalAccessException illegalAccessException2) {
                                break block7;
                            }
                        }
                        object = null;
                    }
                    return object;
                }
                return null;
            }
            throw Util.assertionError("unable to get issues and signature", illegalAccessException2);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AndroidTrustRootIndex)) {
                return false;
            }
            object = (AndroidTrustRootIndex)object;
            return this.trustManager.equals(((AndroidTrustRootIndex)object).trustManager) && this.findByIssuerAndSignatureMethod.equals(((AndroidTrustRootIndex)object).findByIssuerAndSignatureMethod);
        }

        public int hashCode() {
            return this.trustManager.hashCode() + this.findByIssuerAndSignatureMethod.hashCode() * 31;
        }
    }
}

