/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.publicsuffix;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.GzipSource;
import dc.squareup.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.net.IDN;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PublicSuffixDatabase {
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    private static final byte[] WILDCARD_LABEL = new byte[]{42};
    private static final String[] EMPTY_RULE = new String[0];
    private static final String[] PREVAILING_RULE = new String[]{"*"};
    private static final byte EXCEPTION_MARKER = 33;
    private static final PublicSuffixDatabase instance = new PublicSuffixDatabase();
    private final AtomicBoolean listRead;
    private final CountDownLatch readCompleteLatch;
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;

    public PublicSuffixDatabase() {
        CountDownLatch countDownLatch;
        AtomicBoolean atomicBoolean;
        Object object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.listRead = object;
        object = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        v1.readCompleteLatch = object;
    }

    public static PublicSuffixDatabase get() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String[] findMatchingRule(String[] object) {
        String string2;
        int n5;
        Object object2;
        int n6;
        byte[][] byArrayArray;
        int n7;
        block17: {
            block16: {
                if (!object3.listRead.get() && object3.listRead.compareAndSet(false, true)) {
                    object3.readTheListUninterruptibly();
                } else {
                    try {
                        object3.readCompleteLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                // MONITORENTER : object3
                if (object3.publicSuffixListBytes == null) break block16;
                // MONITOREXIT : object3
                n7 = ((Object)object).length;
                byArrayArray = new byte[n7][];
                for (n6 = 0; n6 < ((Object)object).length; ++n6) {
                    byArrayArray[n6] = ((String)object[n6]).getBytes(Util.UTF_8);
                }
                object = null;
                break block17;
            }
            throw new IllegalStateException("Unable to load publicsuffixes.gz resource from the classpath.");
        }
        for (n6 = 0; n6 < n7; ++n6) {
            object2 = PublicSuffixDatabase.binarySearchBytes(object3.publicSuffixListBytes, byArrayArray, n6);
            if (object2 == null) continue;
            object = object2;
            break;
        }
        String string3 = null;
        if (n7 > 1) {
            object2 = (byte[][])byArrayArray.clone();
            for (n5 = 0; n5 < ((Object)object2).length - 1; ++n5) {
                object2[n5] = WILDCARD_LABEL;
                string2 = PublicSuffixDatabase.binarySearchBytes(object3.publicSuffixListBytes, (byte[][])object2, n5);
                if (string2 == null) continue;
                string3 = string2;
                break;
            }
        }
        object2 = null;
        if (string3 != null) {
            for (n5 = 0; n5 < n7 - 1; ++n5) {
                string2 = PublicSuffixDatabase.binarySearchBytes(object3.publicSuffixExceptionListBytes, byArrayArray, n5);
                if (string2 == null) continue;
                object2 = string2;
                break;
            }
        }
        if (object2 != null) {
            return ("!" + (String)object2).split("\\.");
        }
        if (object == null && string3 == null) {
            return PREVAILING_RULE;
        }
        Object object3 = object != null ? ((String)object).split("\\.") : EMPTY_RULE;
        object = string3 != null ? string3.split("\\.") : EMPTY_RULE;
        if (((String[])object3).length <= ((Object)object).length) return object;
        return object3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static String binarySearchBytes(byte[] byArray, byte[][] object, int n5) {
        int n6 = 0;
        int n7 = byArray.length;
        String string2 = null;
        block0: while (n6 < n7) {
            void var2_3;
            int n8;
            int n9;
            for (n9 = (n6 + n7) / 2; n9 > -1 && byArray[n9] != 10; --n9) {
            }
            int n10 = n9 + 1;
            int n11 = 1;
            while (byArray[n8 = n10 + n11] != 10) {
                ++n11;
            }
            n11 = n8 - n10;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            void var13_14 = var2_3;
            while (true) {
                int n15;
                block12: {
                    block13: {
                        block15: {
                            block16: {
                                block14: {
                                    block11: {
                                        if (n14 != 0) {
                                            n14 = 46;
                                            n15 = 0;
                                        } else {
                                            int n16 = n15 = object[var13_14][n12] & 0xFF;
                                            n15 = n14;
                                            n14 = n16;
                                        }
                                        if ((n14 -= byArray[n10 + n13] & 0xFF) != 0) break block11;
                                        ++n12;
                                        if (++n13 == n11) break block11;
                                        if (object[var13_14].length != n12) break block12;
                                        if (var13_14 != ((byte[][])object).length - 1) break block13;
                                    }
                                    if (n14 < 0) break block14;
                                    if (n14 > 0) break block15;
                                    n13 = n11 - n13;
                                    n12 = object[var13_14].length - n12;
                                    for (n14 = var13_14 + true; n14 < ((byte[][])object).length; n12 += object[n14].length, ++n14) {
                                    }
                                    if (n12 >= n13) break block16;
                                }
                                n7 = n9;
                                continue block0;
                            }
                            if (n12 <= n13) {
                                String string3;
                                string2 = string3;
                                Charset charset = Util.UTF_8;
                                string3 = new String(byArray, n10, n11, charset);
                                return string2;
                            }
                        }
                        n6 = n8 + 1;
                        continue block0;
                    }
                    ++var13_14;
                    n12 = -1;
                    n14 = 1;
                    continue;
                }
                n14 = n15;
            }
            break;
        }
        return string2;
    }

    /*
     * Exception decompiling
     */
    private void readTheListUninterruptibly() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 22->26)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTheList() throws IOException {
        byte[] byArray;
        Closeable closeable = PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
        if (closeable == null) {
            return;
        }
        PublicSuffixDatabase publicSuffixDatabase = this;
        closeable = Okio.buffer(new GzipSource(Okio.source(closeable)));
        try {
            byArray = new byte[closeable.readInt()];
        }
        catch (Throwable throwable) {
            Util.closeQuietly(closeable);
            throw throwable;
        }
        closeable.readFully(byArray);
        byte[] byArray2 = new byte[closeable.readInt()];
        closeable.readFully(byArray2);
        Util.closeQuietly(closeable);
        synchronized (publicSuffixDatabase) {
            publicSuffixDatabase.publicSuffixListBytes = byArray;
            publicSuffixDatabase.publicSuffixExceptionListBytes = byArray2;
            // MONITOREXIT @DISABLED, blocks:[3, 4] lbl18 : MonitorExitStatement: MONITOREXIT : v231541
            publicSuffixDatabase.readCompleteLatch.countDown();
            return;
        }
    }

    public String getEffectiveTldPlusOne(String charSequence) {
        if (charSequence != null) {
            StringBuilder stringBuilder;
            String[] stringArray;
            String[] stringArray2 = IDN.toUnicode((String)charSequence).split("\\.");
            if (stringArray2.length == (stringArray = super.findMatchingRule(stringArray2)).length && stringArray[0].charAt(0) != '!') {
                return null;
            }
            int n5 = stringArray[0].charAt(0) == '!' ? stringArray2.length - stringArray.length : stringArray2.length - (stringArray.length + 1);
            String string2 = charSequence;
            charSequence = stringBuilder;
            stringBuilder = new StringBuilder();
            stringArray = string2.split("\\.");
            while (n5 < stringArray.length) {
                ((StringBuilder)charSequence).append(stringArray[n5]).append('.');
                ++n5;
            }
            CharSequence charSequence2 = charSequence;
            ((StringBuilder)charSequence2).deleteCharAt(((StringBuilder)charSequence2).length() - 1);
            return ((StringBuilder)charSequence2).toString();
        }
        throw new NullPointerException("domain == null");
    }

    void setListBytes(byte[] byArray, byte[] byArray2) {
        PublicSuffixDatabase publicSuffixDatabase = this;
        this.publicSuffixListBytes = byArray;
        publicSuffixDatabase.publicSuffixExceptionListBytes = byArray2;
        publicSuffixDatabase.listRead.set(true);
        publicSuffixDatabase.readCompleteLatch.countDown();
    }
}

