/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.tls;

import dc.squareup.okhttp3.internal.tls.CertificateChainCleaner;
import dc.squareup.okhttp3.internal.tls.TrustRootIndex;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    private static final int MAX_SIGNERS = 9;
    private final TrustRootIndex trustRootIndex;

    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        this.trustRootIndex = trustRootIndex;
    }

    private boolean verifySignature(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (!x509Certificate.getIssuerDN().equals(x509Certificate2.getSubjectDN())) {
            return false;
        }
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    @Override
    public List<Certificate> clean(List<Certificate> arrayList, String object) throws SSLPeerUnverifiedException {
        ArrayList<Certificate> arrayList2;
        ArrayDeque<Certificate> arrayDeque;
        object = arrayDeque;
        arrayDeque = new ArrayDeque<Certificate>(arrayList);
        arrayList = arrayList2;
        arrayList();
        arrayList2.add((Certificate)object.removeFirst());
        boolean bl = false;
        block0: for (int i5 = 0; i5 < 9; ++i5) {
            ArrayList<Certificate> arrayList3 = arrayList;
            X509Certificate x509Certificate = (X509Certificate)arrayList3.get(arrayList3.size() - 1);
            Object object2 = this.trustRootIndex.findByIssuerAndSignature(x509Certificate);
            if (object2 != null) {
                if (arrayList.size() > 1 || !((Object)x509Certificate).equals(object2)) {
                    arrayList.add((Certificate)object2);
                }
                Object object3 = object2;
                if (this.verifySignature((X509Certificate)object3, (X509Certificate)object3)) {
                    return arrayList;
                }
                bl = true;
                continue;
            }
            object2 = object.iterator();
            while (object2.hasNext()) {
                X509Certificate x509Certificate2 = (X509Certificate)object2.next();
                if (!this.verifySignature(x509Certificate, x509Certificate2)) continue;
                object2.remove();
                arrayList.add(x509Certificate2);
                continue block0;
            }
            if (bl) {
                return arrayList;
            }
            throw new SSLPeerUnverifiedException("Failed to find a trusted cert that signed " + x509Certificate);
        }
        throw new SSLPeerUnverifiedException("Certificate chain too long: " + arrayList);
    }

    public int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof BasicCertificateChainCleaner && ((BasicCertificateChainCleaner)object).trustRootIndex.equals(this.trustRootIndex);
    }
}

