/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.ws;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.Callback;
import dc.squareup.okhttp3.EventListener;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.WebSocket;
import dc.squareup.okhttp3.WebSocketListener;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.ws.WebSocketProtocol;
import dc.squareup.okhttp3.internal.ws.WebSocketReader;
import dc.squareup.okhttp3.internal.ws.WebSocketWriter;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    private static final List<Protocol> ONLY_HTTP1;
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Request originalRequest;
    final WebSocketListener listener;
    private final Random random;
    private final long pingIntervalMillis;
    private final String key;
    private Call call;
    private final Runnable writerRunnable;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private ScheduledExecutorService executor;
    private Streams streams;
    private final ArrayDeque<ByteString> pongQueue = new ArrayDeque();
    private final ArrayDeque<Object> messageAndCloseQueue = new ArrayDeque();
    private long queueSize;
    private boolean enqueuedClose;
    private ScheduledFuture<?> cancelFuture;
    private int receivedCloseCode = -1;
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;

    public RealWebSocket(Request object, WebSocketListener webSocketListener, Random random, long l5) {
        if ("GET".equals(((Request)object).method())) {
            RealWebSocket realWebSocket = this;
            this.originalRequest = object;
            this.listener = webSocketListener;
            this.random = random;
            this.pingIntervalMillis = l5;
            byte[] byArray = new byte[16];
            object = byArray;
            random.nextBytes(byArray);
            realWebSocket.key = ByteString.of((byte[])object).base64();
            realWebSocket.writerRunnable = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            if (!RealWebSocket.this.writeOneFrame()) break;
                        }
                        catch (IOException iOException) {
                            RealWebSocket.this.failWebSocket(iOException, null);
                            break;
                        }
                    }
                }
            };
            return;
        }
        throw new IllegalArgumentException("Request must be GET: " + ((Request)object).method());
    }

    private synchronized boolean send(ByteString byteString, int n5) {
        if (!this.failed && !this.enqueuedClose) {
            if (this.queueSize + (long)byteString.size() > 0x1000000L) {
                this.close(1001, null);
                return false;
            }
            RealWebSocket realWebSocket = this;
            realWebSocket.queueSize += (long)byteString.size();
            realWebSocket.messageAndCloseQueue.add(new Message(n5, byteString));
            realWebSocket.runWriter();
            return true;
        }
        return false;
    }

    private void runWriter() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        ScheduledExecutorService scheduledExecutorService = this.executor;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.execute(this.writerRunnable);
        }
    }

    static {
        $assertionsDisabled = RealWebSocket.class.desiredAssertionStatus() ^ true;
        ONLY_HTTP1 = Collections.singletonList(Protocol.HTTP_1_1);
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    public void connect(OkHttpClient cloneable) {
        RealWebSocket realWebSocket = this;
        cloneable = ((OkHttpClient)cloneable).newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        final Request request = realWebSocket.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        cloneable = Internal.instance.newWebSocketCall((OkHttpClient)cloneable, request);
        realWebSocket.call = cloneable;
        cloneable.timeout().clearTimeout();
        realWebSocket.call.enqueue(new Callback(){

            @Override
            public void onResponse(Call object, Response response) {
                Streams streams;
                2 v22;
                2 v12;
                try {
                    2 v02 = this;
                    v12 = v02;
                    v22 = v02;
                    v02.RealWebSocket.this.checkResponse(response);
                    object = Internal.instance.streamAllocation((Call)object);
                    ((StreamAllocation)object).noNewStreams();
                    streams = ((StreamAllocation)object).connection().newWebSocketStreams((StreamAllocation)object);
                }
                catch (ProtocolException protocolException) {
                    RealWebSocket.this.failWebSocket(protocolException, response);
                    Util.closeQuietly(response);
                    return;
                }
                RealWebSocket realWebSocket = v22.RealWebSocket.this;
                Object object2 = object;
                2 v42 = this;
                realWebSocket.listener.onOpen(realWebSocket, response);
                object = "OkHttp WebSocket " + request.url().redact();
                try {
                    v42.RealWebSocket.this.initReaderAndWriter((String)object, streams);
                    ((StreamAllocation)object2).connection().socket().setSoTimeout(0);
                    v12.RealWebSocket.this.loopReader();
                }
                catch (Exception exception) {
                    RealWebSocket.this.failWebSocket(exception, null);
                }
            }

            @Override
            public void onFailure(Call call, IOException iOException) {
                RealWebSocket.this.failWebSocket(iOException, null);
            }
        });
    }

    void checkResponse(Response object) throws ProtocolException {
        if (((Response)object).code() == 101) {
            String string2 = ((Response)object).header("Connection");
            if ("Upgrade".equalsIgnoreCase(string2)) {
                string2 = ((Response)object).header("Upgrade");
                if ("websocket".equalsIgnoreCase(string2)) {
                    object = ((Response)object).header("Sec-WebSocket-Accept");
                    String string3 = ByteString.encodeUtf8(((RealWebSocket)((Object)string3)).key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
                    if (string3.equals(object)) {
                        return;
                    }
                    throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + (String)string3 + "' but was '" + (String)object + "'");
                }
                throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + string2 + "'");
            }
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + string2 + "'");
        }
        throw new ProtocolException("Expected HTTP 101 response but was '" + ((Response)object).code() + " " + ((Response)object).message() + "'");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initReaderAndWriter(String string2, Streams streams) throws IOException {
        synchronized (this) {
            WebSocketReader webSocketReader;
            Throwable throwable2;
            block8: {
                PingRunnable pingRunnable;
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                try {
                    this.streams = streams;
                    Streams streams2 = streams;
                    boolean bl = streams2.client;
                    BufferedSink bufferedSink = streams2.sink;
                    Random random = this.random;
                    this.writer = new WebSocketWriter(bl, bufferedSink, random);
                }
                catch (Throwable throwable2) {}
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor2 = scheduledThreadPoolExecutor;
                int n5 = 1;
                this.executor = new ScheduledThreadPoolExecutor(n5, Util.threadFactory(string2, false));
                if (this.pingIntervalMillis == 0L) break block8;
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor3 = scheduledThreadPoolExecutor2;
                RealWebSocket realWebSocket = this;
                Object object = pingRunnable;
                pingRunnable = new PingRunnable();
                long l5 = realWebSocket.pingIntervalMillis;
                PingRunnable pingRunnable2 = object;
                object = TimeUnit.MILLISECONDS;
                long l6 = l5;
                scheduledThreadPoolExecutor3.scheduleAtFixedRate(pingRunnable2, l6, l6, (TimeUnit)((Object)object));
            }
            if (!this.messageAndCloseQueue.isEmpty()) {
                this.runWriter();
            }
            RealWebSocket realWebSocket = this;
            RealWebSocket realWebSocket2 = realWebSocket;
            // ** MonitorExit[v8] (shouldn't be in output)
            WebSocketReader webSocketReader2 = webSocketReader;
            Streams streams3 = streams;
            boolean bl = streams3.client;
            webSocketReader = new WebSocketReader(bl, streams3.source, this);
            realWebSocket2.reader = webSocketReader2;
            return;
            throw throwable2;
        }
    }

    public void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            this.reader.processNextFrame();
        }
    }

    boolean processNextFrame() throws IOException {
        try {
            RealWebSocket realWebSocket = this;
            realWebSocket.reader.processNextFrame();
            return realWebSocket.receivedCloseCode == -1;
        }
        catch (Exception exception) {
            this.failWebSocket(exception, null);
            return false;
        }
    }

    void awaitTermination(int n5, TimeUnit timeUnit) throws InterruptedException {
        this.executor.awaitTermination(n5, timeUnit);
    }

    void tearDown() throws InterruptedException {
        ScheduledFuture<?> scheduledFuture = object.cancelFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        RealWebSocket realWebSocket = object;
        realWebSocket.executor.shutdown();
        Object object = TimeUnit.SECONDS;
        realWebSocket.executor.awaitTermination(10L, (TimeUnit)((Object)object));
    }

    synchronized int sentPingCount() {
        return this.sentPingCount;
    }

    synchronized int receivedPingCount() {
        return this.receivedPingCount;
    }

    synchronized int receivedPongCount() {
        return this.receivedPongCount;
    }

    @Override
    public void onReadMessage(String string2) throws IOException {
        this.listener.onMessage((WebSocket)this, string2);
    }

    @Override
    public void onReadMessage(ByteString byteString) throws IOException {
        this.listener.onMessage((WebSocket)this, byteString);
    }

    @Override
    public synchronized void onReadPing(ByteString byteString) {
        if (!(this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty())) {
            RealWebSocket realWebSocket = this;
            realWebSocket.pongQueue.add(byteString);
            realWebSocket.runWriter();
            ++realWebSocket.receivedPingCount;
            return;
        }
    }

    @Override
    public synchronized void onReadPong(ByteString byteString) {
        ++this.receivedPongCount;
        this.awaitingPong = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onReadClose(int var1_1, String var2_2) {
        if (var1_1 == -1) {
            throw new IllegalArgumentException();
        }
        v0 = this;
        var3_3 = null;
        synchronized (v0) {
            block11: {
                block10: {
                    try {
                        if (v0.receivedCloseCode != -1) ** GOTO lbl-1000
                        this.receivedCloseCode = var1_1;
                        this.receivedCloseReason = var2_2;
                        if (!this.enqueuedClose || !this.messageAndCloseQueue.isEmpty()) ** GOTO lbl23
                        v1 = this;
                        var3_3 = v1.streams;
                        v1.streams = null;
                        var4_4 = v1.cancelFuture;
                        if (var4_4 != null) {
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable v2) {
                        ** GOTO lbl41
                    }
                    {
                        var4_4.cancel(false);
                    }
lbl-1000:
                    // 2 sources

                    {
                        this.executor.shutdown();
lbl23:
                        // 2 sources

                        v3 = var3_3;
                        v4 = this;
                        v5 = v4;
                        // ** MonitorExit[v4] (shouldn't be in output)
                    }
                    try {
                        v5.listener.onClosing(this, var1_1, var2_2);
                        if (v3 == null) break block10;
                        this.listener.onClosed(this, var1_1, var2_2);
                    }
                    catch (Throwable v6) {
                        break block11;
                    }
                }
                Util.closeQuietly(var3_3);
                return;
            }
            Util.closeQuietly(var3_3);
            throw v6;
lbl-1000:
            // 1 sources

            {
                throw new IllegalStateException("already closed");
lbl41:
                // 1 sources

                // ** MonitorExit[this] (shouldn't be in output)
            }
            throw v2;
        }
    }

    @Override
    public boolean send(String string2) {
        if (string2 != null) {
            return this.send(ByteString.encodeUtf8(string2), 1);
        }
        throw new NullPointerException("text == null");
    }

    @Override
    public boolean send(ByteString byteString) {
        if (byteString != null) {
            return this.send(byteString, 2);
        }
        throw new NullPointerException("bytes == null");
    }

    synchronized boolean pong(ByteString byteString) {
        if (!(this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty())) {
            RealWebSocket realWebSocket = this;
            realWebSocket.pongQueue.add(byteString);
            realWebSocket.runWriter();
            return true;
        }
        return false;
    }

    @Override
    public boolean close(int n5, String string2) {
        return this.close(n5, string2, 60000L);
    }

    synchronized boolean close(int n5, String string2, long l5) {
        WebSocketProtocol.validateCloseCode(n5);
        ByteString byteString = null;
        if (string2 != null && (long)(byteString = ByteString.encodeUtf8(string2)).size() > 123L) {
            throw new IllegalArgumentException("reason.size() > 123: " + string2);
        }
        if (!this.failed && !this.enqueuedClose) {
            RealWebSocket realWebSocket = this;
            realWebSocket.enqueuedClose = true;
            realWebSocket.messageAndCloseQueue.add(new Close(n5, byteString, l5));
            realWebSocket.runWriter();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean writeOneFrame() throws IOException {
        block20: {
            block21: {
                var1_1 = null;
                var2_4 = -1;
                var3_5 = null;
                var4_6 = null;
                // MONITORENTER : this
                if (this.failed) {
                    // MONITOREXIT : this
                    return false;
                }
                var5_7 = this.writer;
                var6_8 = this.pongQueue.poll();
                if (var6_8 != null) break block20;
                var1_1 = this.messageAndCloseQueue.poll();
                if (!(var1_1 instanceof Close)) break block21;
                var2_4 = this.receivedCloseCode;
                var3_5 = this.receivedCloseReason;
                if (var2_4 != -1) {
                    var4_6 = this.streams;
                    this.streams = null;
                    this.executor.shutdown();
                    break block20;
                }
                v1 = this.executor;
                this.cancelFuture = v1.schedule(new CancelRunnable(), ((Close)var1_1).cancelAfterCloseMillis, TimeUnit.MILLISECONDS);
            }
            if (var1_1 == null) {
                // MONITOREXIT : this
                return false;
            }
        }
        // MONITOREXIT : this
        if (var6_8 == null) ** GOTO lbl39
        var5_7.writePong(var6_8);
        ** GOTO lbl65
lbl39:
        // 1 sources

        if (!(var1_1 instanceof Message)) ** GOTO lbl59
        v2 = var1_1;
        var1_1 = ((Message)v2).data;
        v3 = Okio.buffer(var5_7.newMessageSink(((Message)v2).formatOpcode, var1_1.size()));
        v4 = v3;
        v3.write((ByteString)var1_1);
        v4.close();
        // MONITORENTER : this
        {
            catch (Throwable v5) {}
        }
        try {
            var1_2 = this.queueSize - (long)var1_1.size();
            this.queueSize = var1_2;
            // MONITOREXIT : this
            ** GOTO lbl65
        }
        catch (Throwable v6) {
            block22: {
                block23: {
                    // MONITOREXIT : this
                    throw v6;
lbl59:
                    // 1 sources

                    if (!(var1_1 instanceof Close)) break block22;
                    v7 = (Close)var1_1;
                    var1_3 = v7.code;
                    var5_7.writeClose(var1_3, v7.reason);
                    if (var4_6 == null) break block23;
                    this.listener.onClosed(this, var2_4, var3_5);
                }
                Util.closeQuietly(var4_6);
                return true;
            }
            throw new AssertionError();
        }
        Util.closeQuietly(var4_6);
        throw v5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writePingFrame() {
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            Throwable throwable2;
            WebSocketWriter webSocketWriter;
            block7: {
                try {
                    if (realWebSocket.failed) {
                        // ** MonitorExit[this] (shouldn't be in output)
                        return;
                    }
                    RealWebSocket realWebSocket2 = this;
                    webSocketWriter = realWebSocket2.writer;
                    int n5 = realWebSocket2.awaitingPong ? this.sentPingCount : -1;
                    RealWebSocket realWebSocket3 = this;
                    ++realWebSocket3.sentPingCount;
                    realWebSocket3.awaitingPong = true;
                    // ** MonitorExit[v2] (shouldn't be in output)
                    if (n5 == -1) break block7;
                    this.failWebSocket(new SocketTimeoutException("sent ping but didn't receive pong within " + this.pingIntervalMillis + "ms (after " + (n5 - 1) + " successful ping/pongs)"), null);
                    return;
                }
                catch (Throwable throwable2) {}
            }
            try {
                webSocketWriter.writePing(ByteString.EMPTY);
                return;
            }
            catch (IOException iOException) {
                this.failWebSocket(iOException, null);
            }
            return;
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void failWebSocket(Exception exception, @Nullable Response response) {
        Streams streams;
        block11: {
            ScheduledFuture<?> scheduledFuture;
            block10: {
                RealWebSocket realWebSocket = this;
                // MONITORENTER : realWebSocket
                if (realWebSocket.failed) {
                    // MONITOREXIT : this
                    return;
                }
                RealWebSocket realWebSocket2 = this;
                realWebSocket2.failed = true;
                streams = realWebSocket2.streams;
                realWebSocket2.streams = null;
                scheduledFuture = realWebSocket2.cancelFuture;
                if (scheduledFuture == null) break block10;
                scheduledFuture.cancel(false);
            }
            scheduledFuture = this.executor;
            if (scheduledFuture == null) break block11;
            scheduledFuture.shutdown();
        }
        RealWebSocket realWebSocket = this;
        // MONITOREXIT : realWebSocket
        try {
            realWebSocket.listener.onFailure(this, exception, response);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(streams);
            throw throwable;
        }
        Util.closeQuietly(streams);
    }

    public static abstract class Streams
    implements Closeable {
        public final boolean client;
        public final BufferedSource source;
        public final BufferedSink sink;

        public Streams(boolean bl, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.client = bl;
            this.source = bufferedSource;
            this.sink = bufferedSink;
        }
    }

    private final class PingRunnable
    implements Runnable {
        PingRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.writePingFrame();
        }
    }

    static final class Message {
        final int formatOpcode;
        final ByteString data;

        Message(int n5, ByteString byteString) {
            this.formatOpcode = n5;
            this.data = byteString;
        }
    }

    static final class Close {
        final int code;
        final ByteString reason;
        final long cancelAfterCloseMillis;

        Close(int n5, ByteString byteString, long l5) {
            this.code = n5;
            this.reason = byteString;
            this.cancelAfterCloseMillis = l5;
        }
    }

    final class CancelRunnable
    implements Runnable {
        CancelRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.cancel();
        }
    }
}

