/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.ws;

import dc.squareup.okhttp3.internal.ws.WebSocketProtocol;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Timeout;
import java.io.IOException;
import java.util.Random;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    final Buffer sinkBuffer;
    boolean writerClosed;
    final Buffer buffer;
    final FrameSink frameSink;
    boolean activeWriter;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    WebSocketWriter(boolean bl, BufferedSink object, Random random) {
        FrameSink frameSink;
        Buffer buffer;
        Sink sink = buffer;
        buffer = new Buffer();
        this.buffer = sink;
        sink = frameSink;
        frameSink = new FrameSink();
        this.frameSink = sink;
        if (object != null) {
            if (random != null) {
                Buffer.UnsafeCursor unsafeCursor;
                this.isClient = bl;
                this.sink = object;
                this.sinkBuffer = object.buffer();
                this.random = random;
                object = bl ? (Object)new byte[4] : null;
                this.maskKey = (byte[])object;
                if (bl) {
                    Buffer.UnsafeCursor unsafeCursor2;
                    unsafeCursor = unsafeCursor2;
                    unsafeCursor2 = new Buffer.UnsafeCursor();
                } else {
                    unsafeCursor = null;
                }
                this.maskCursor = unsafeCursor;
                return;
            }
            throw new NullPointerException("random == null");
        }
        throw new NullPointerException("sink == null");
    }

    private void writeControlFrame(int n5, ByteString byteString) throws IOException {
        if (!this.writerClosed) {
            int n6 = byteString.size();
            if ((long)n6 <= 125L) {
                WebSocketWriter webSocketWriter = this;
                webSocketWriter.sinkBuffer.writeByte(n5 |= 0x80);
                if (webSocketWriter.isClient) {
                    WebSocketWriter webSocketWriter2 = this;
                    n5 = n6 | 0x80;
                    webSocketWriter2.sinkBuffer.writeByte(n5);
                    webSocketWriter2.random.nextBytes(this.maskKey);
                    webSocketWriter2.sinkBuffer.write(this.maskKey);
                    if (n6 > 0) {
                        WebSocketWriter webSocketWriter3 = this;
                        long l5 = webSocketWriter3.sinkBuffer.size();
                        webSocketWriter3.sinkBuffer.write(byteString);
                        webSocketWriter3.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                        webSocketWriter3.maskCursor.seek(l5);
                        WebSocketProtocol.toggleMask(webSocketWriter3.maskCursor, this.maskKey);
                        webSocketWriter3.maskCursor.close();
                    }
                } else {
                    WebSocketWriter webSocketWriter4 = this;
                    webSocketWriter4.sinkBuffer.writeByte(n6);
                    webSocketWriter4.sinkBuffer.write(byteString);
                }
                this.sink.flush();
                return;
            }
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        throw new IOException("closed");
    }

    void writePing(ByteString byteString) throws IOException {
        this.writeControlFrame(9, byteString);
    }

    void writePong(ByteString byteString) throws IOException {
        this.writeControlFrame(10, byteString);
    }

    void writeClose(int n5, ByteString byteString) throws IOException {
        Object object = ByteString.EMPTY;
        if (n5 != 0 || byteString != null) {
            Buffer buffer;
            if (n5 != 0) {
                WebSocketProtocol.validateCloseCode(n5);
            }
            object = buffer;
            new Buffer().writeShort(n5);
            if (byteString != null) {
                ((Buffer)object).write(byteString);
            }
            object = ((Buffer)object).readByteString();
        }
        try {
            this.writeControlFrame(8, (ByteString)object);
            this.writerClosed = true;
            return;
        }
        catch (Throwable throwable) {
            this.writerClosed = true;
            throw throwable;
        }
    }

    Sink newMessageSink(int n5, long l5) {
        if (!this.activeWriter) {
            this.activeWriter = true;
            this.frameSink.formatOpcode = n5;
            this.frameSink.contentLength = l5;
            this.frameSink.isFirstFrame = true;
            this.frameSink.closed = false;
            return this.frameSink;
        }
        throw new IllegalStateException("Another message writer is active. Did you call close()?");
    }

    void writeMessageFrame(int n5, long l5, boolean bl, boolean bl2) throws IOException {
        if (!this.writerClosed) {
            if (!bl) {
                n5 = 0;
            }
            if (bl2) {
                n5 |= 0x80;
            }
            this.sinkBuffer.writeByte(n5);
            n5 = 0;
            if (this.isClient) {
                n5 = 128;
            }
            if (l5 <= 125L) {
                this.sinkBuffer.writeByte(n5 | (int)l5);
            } else if (l5 <= 65535L) {
                this.sinkBuffer.writeByte(n5 | 0x7E);
                this.sinkBuffer.writeShort((int)l5);
            } else {
                this.sinkBuffer.writeByte(n5 | 0x7F);
                this.sinkBuffer.writeLong(l5);
            }
            if (this.isClient) {
                this.random.nextBytes(this.maskKey);
                this.sinkBuffer.write(this.maskKey);
                if (l5 > 0L) {
                    long l6 = this.sinkBuffer.size();
                    this.sinkBuffer.write(this.buffer, l5);
                    this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                    this.maskCursor.seek(l6);
                    WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                    this.maskCursor.close();
                }
            } else {
                this.sinkBuffer.write(this.buffer, l5);
            }
            this.sink.emit();
            return;
        }
        throw new IOException("closed");
    }

    final class FrameSink
    implements Sink {
        int formatOpcode;
        long contentLength;
        boolean isFirstFrame;
        boolean closed;

        FrameSink() {
        }

        @Override
        public void write(Buffer buffer, long l5) throws IOException {
            if (!this.closed) {
                FrameSink frameSink = this;
                frameSink.WebSocketWriter.this.buffer.write(buffer, l5);
                boolean bl = frameSink.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
                l5 = WebSocketWriter.this.buffer.completeSegmentByteCount();
                if (l5 > 0L && !bl) {
                    FrameSink frameSink2 = this;
                    int n5 = frameSink2.formatOpcode;
                    bl = frameSink2.isFirstFrame;
                    WebSocketWriter.this.writeMessageFrame(n5, l5, bl, false);
                    this.isFirstFrame = false;
                }
                return;
            }
            throw new IOException("closed");
        }

        @Override
        public void flush() throws IOException {
            if (!this.closed) {
                WebSocketWriter webSocketWriter = WebSocketWriter.this;
                int n5 = this.formatOpcode;
                long l5 = webSocketWriter.buffer.size();
                boolean bl = this.isFirstFrame;
                webSocketWriter.writeMessageFrame(n5, l5, bl, false);
                this.isFirstFrame = false;
                return;
            }
            throw new IOException("closed");
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                WebSocketWriter webSocketWriter = WebSocketWriter.this;
                int n5 = this.formatOpcode;
                long l5 = webSocketWriter.buffer.size();
                boolean bl = this.isFirstFrame;
                webSocketWriter.writeMessageFrame(n5, l5, bl, true);
                this.closed = true;
                WebSocketWriter.this.activeWriter = false;
                return;
            }
            throw new IOException("closed");
        }
    }
}

