/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.DeflaterSink;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public final class GzipSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private final DeflaterSink deflaterSink;
    private boolean closed;
    private final CRC32 crc;

    public GzipSink(Sink sink) {
        CRC32 cRC32;
        Object object = cRC32;
        cRC32 = new CRC32();
        ((GzipSink)((Object)deflater2)).crc = object;
        if (sink != null) {
            DeflaterSink deflaterSink;
            Deflater deflater;
            GzipSink gzipSink = deflater2;
            GzipSink gzipSink2 = deflater2;
            Deflater deflater2 = deflater;
            deflater = new Deflater(-1, true);
            gzipSink2.deflater = deflater2;
            sink = Okio.buffer(sink);
            gzipSink.sink = sink;
            object = deflaterSink;
            deflaterSink = new DeflaterSink((BufferedSink)sink, deflater2);
            gzipSink.deflaterSink = object;
            gzipSink.writeHeader();
            return;
        }
        throw new IllegalArgumentException("sink == null");
    }

    private void writeHeader() {
        Buffer buffer = this.sink.buffer();
        buffer.writeShort(8075);
        buffer.writeByte(8);
        buffer.writeByte(0);
        buffer.writeInt(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
    }

    private void writeFooter() throws IOException {
        GzipSink gzipSink = this;
        gzipSink.sink.writeIntLe((int)this.crc.getValue());
        gzipSink.sink.writeIntLe((int)this.deflater.getBytesRead());
    }

    private void updateCrc(Buffer object, long l5) {
        object = ((Buffer)object).head;
        while (l5 > 0L) {
            Object object2 = object;
            long l6 = l5;
            int n5 = (int)Math.min(l6, (long)(((Segment)object).limit - ((Segment)object).pos));
            Object object3 = object;
            object = ((Segment)object3).data;
            this.crc.update((byte[])object, ((Segment)object3).pos, n5);
            l5 = l6 - (long)n5;
            object = ((Segment)object2).next;
        }
    }

    @Override
    public void write(Buffer buffer, long l5) throws IOException {
        if (l5 >= 0L) {
            if (l5 == 0L) {
                return;
            }
            GzipSink gzipSink = this;
            gzipSink.updateCrc(buffer, l5);
            gzipSink.deflaterSink.write(buffer, l5);
            return;
        }
        throw new IllegalArgumentException("byteCount < 0: " + l5);
    }

    @Override
    public void flush() throws IOException {
        this.deflaterSink.flush();
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    @Override
    public void close() throws IOException {
        Throwable throwable;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                GzipSink gzipSink = this;
                throwable = null;
                try {
                    gzipSink.deflaterSink.finishDeflate();
                    gzipSink.writeFooter();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block8;
                    throwable = throwable3;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block9;
                throwable = throwable4;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    public final Deflater deflater() {
        return this.deflater;
    }
}

