/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Options;
import dc.squareup.okio.PeekSource;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer;
    public final Source source;
    boolean closed;

    RealBufferedSource(Source source) {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        this.buffer = buffer2;
        if (source != null) {
            this.source = source;
            return;
        }
        throw new NullPointerException("source == null");
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public long read(Buffer buffer, long l5) throws IOException {
        if (buffer != null) {
            if (l5 >= 0L) {
                if (!this.closed) {
                    Buffer buffer2 = this.buffer;
                    if (buffer2.size == 0L && this.source.read(buffer2, 8192L) == -1L) {
                        return -1L;
                    }
                    l5 = Math.min(l5, this.buffer.size);
                    return this.buffer.read(buffer, l5);
                }
                throw new IllegalStateException("closed");
            }
            throw new IllegalArgumentException("byteCount < 0: " + l5);
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public boolean exhausted() throws IOException {
        if (!this.closed) {
            return this.buffer.exhausted() && this.source.read(this.buffer, 8192L) == -1L;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public void require(long l5) throws IOException {
        if (this.request(l5)) {
            return;
        }
        throw new EOFException();
    }

    @Override
    public boolean request(long l5) throws IOException {
        if (l5 >= 0L) {
            if (!this.closed) {
                block3: {
                    Buffer buffer;
                    do {
                        buffer = this.buffer;
                        if (buffer.size >= l5) break block3;
                    } while (this.source.read(buffer, 8192L) != -1L);
                    return false;
                }
                return true;
            }
            throw new IllegalStateException("closed");
        }
        throw new IllegalArgumentException("byteCount < 0: " + l5);
    }

    @Override
    public byte readByte() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(1L);
        return realBufferedSource.buffer.readByte();
    }

    @Override
    public ByteString readByteString() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.buffer.writeAll(this.source);
        return realBufferedSource.buffer.readByteString();
    }

    @Override
    public ByteString readByteString(long l5) throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(l5);
        return realBufferedSource.buffer.readByteString(l5);
    }

    @Override
    public int select(Options options) throws IOException {
        if (!this.closed) {
            int n5;
            block3: {
                do {
                    if ((n5 = this.buffer.selectPrefix(options, true)) == -1) {
                        return -1;
                    }
                    if (n5 != -2) break block3;
                } while (this.source.read(this.buffer, 8192L) != -1L);
                return -1;
            }
            int n6 = options.byteStrings[n5].size();
            this.buffer.skip(n6);
            return n5;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public byte[] readByteArray() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.buffer.writeAll(this.source);
        return realBufferedSource.buffer.readByteArray();
    }

    @Override
    public byte[] readByteArray(long l5) throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(l5);
        return realBufferedSource.buffer.readByteArray(l5);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        long l5;
        RealBufferedSource realBufferedSource;
        RealBufferedSource realBufferedSource2;
        try {
            RealBufferedSource realBufferedSource3 = this;
            realBufferedSource2 = realBufferedSource3;
            realBufferedSource = realBufferedSource3;
            l5 = byArray.length;
        }
        catch (EOFException eOFException) {
            block4: {
                int n5 = 0;
                while (true) {
                    Buffer buffer = this.buffer;
                    long l6 = buffer.size;
                    if (l6 <= 0L) break block4;
                    int n6 = (int)l6;
                    if ((n6 = buffer.read(byArray, n5, n6)) == -1) break;
                    n5 += n6;
                }
                throw new AssertionError();
            }
            throw eOFException;
        }
        realBufferedSource2.require(l5);
        realBufferedSource.buffer.readFully(byArray);
    }

    @Override
    public int read(byte[] byArray, int n5, int n6) throws IOException {
        long l5 = n5;
        long l6 = n6;
        Util.checkOffsetAndCount(byArray.length, l5, l6);
        Buffer buffer = this.buffer;
        if (buffer.size == 0L && this.source.read(buffer, 8192L) == -1L) {
            return -1;
        }
        int n7 = (int)Math.min(l6, this.buffer.size);
        return this.buffer.read(byArray, n5, n7);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Buffer buffer = this.buffer;
        if (buffer.size == 0L && this.source.read(buffer, 8192L) == -1L) {
            return -1;
        }
        return this.buffer.read(byteBuffer);
    }

    @Override
    public void readFully(Buffer buffer, long l5) throws IOException {
        try {
            RealBufferedSource realBufferedSource = this;
            realBufferedSource.require(l5);
            realBufferedSource.buffer.readFully(buffer, l5);
            return;
        }
        catch (EOFException eOFException) {
            buffer.writeAll(this.buffer);
            throw eOFException;
        }
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        if (sink != null) {
            long l5 = 0L;
            while (this.source.read(this.buffer, 8192L) != -1L) {
                long l6 = this.buffer.completeSegmentByteCount();
                if (l6 <= 0L) continue;
                l5 += l6;
                sink.write(this.buffer, l6);
            }
            if (this.buffer.size() > 0L) {
                l5 += this.buffer.size();
                Buffer buffer = this.buffer;
                sink.write(buffer, buffer.size());
            }
            return l5;
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public String readUtf8() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.buffer.writeAll(this.source);
        return realBufferedSource.buffer.readUtf8();
    }

    @Override
    public String readUtf8(long l5) throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(l5);
        return realBufferedSource.buffer.readUtf8(l5);
    }

    @Override
    public String readString(Charset charset) throws IOException {
        if (charset != null) {
            RealBufferedSource realBufferedSource = this;
            realBufferedSource.buffer.writeAll(this.source);
            return realBufferedSource.buffer.readString(charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    public String readString(long l5, Charset charset) throws IOException {
        this.require(l5);
        if (charset != null) {
            return this.buffer.readString(l5, charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    @Nullable
    public String readUtf8Line() throws IOException {
        long l5 = this.indexOf((byte)10);
        if (l5 == -1L) {
            l5 = this.buffer.size;
            return l5 != 0L ? this.readUtf8(l5) : null;
        }
        return this.buffer.readUtf8Line(l5);
    }

    @Override
    public String readUtf8LineStrict() throws IOException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l5) throws IOException {
        if (l5 >= 0L) {
            Buffer buffer;
            long l6 = l5 == Long.MAX_VALUE ? Long.MAX_VALUE : l5 + 1L;
            long l7 = this.indexOf((byte)10, 0L, l6);
            if (l7 != -1L) {
                return this.buffer.readUtf8Line(l7);
            }
            if (l6 < Long.MAX_VALUE && this.request(l6) && this.buffer.getByte(l6 - 1L) == 13 && this.request(l6 + 1L) && this.buffer.getByte(l6) == 10) {
                return this.buffer.readUtf8Line(l6);
            }
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            Buffer buffer3 = this.buffer;
            long l8 = buffer3.size();
            l8 = Math.min(32L, l8);
            buffer3.copyTo(buffer2, 0L, l8);
            throw new EOFException("\\n not found: limit=" + Math.min(this.buffer.size(), l5) + " content=" + buffer2.readByteString().hex() + '\u2026');
        }
        throw new IllegalArgumentException("limit < 0: " + l5);
    }

    @Override
    public int readUtf8CodePoint() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(1L);
        byte by = realBufferedSource.buffer.getByte(0L);
        if ((by & 0xE0) == 192) {
            this.require(2L);
        } else if ((by & 0xF0) == 224) {
            this.require(3L);
        } else if ((by & 0xF8) == 240) {
            this.require(4L);
        }
        return this.buffer.readUtf8CodePoint();
    }

    @Override
    public short readShort() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(2L);
        return realBufferedSource.buffer.readShort();
    }

    @Override
    public short readShortLe() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(2L);
        return realBufferedSource.buffer.readShortLe();
    }

    @Override
    public int readInt() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(4L);
        return realBufferedSource.buffer.readInt();
    }

    @Override
    public int readIntLe() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(4L);
        return realBufferedSource.buffer.readIntLe();
    }

    @Override
    public long readLong() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(8L);
        return realBufferedSource.buffer.readLong();
    }

    @Override
    public long readLongLe() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(8L);
        return realBufferedSource.buffer.readLongLe();
    }

    @Override
    public long readDecimalLong() throws IOException {
        int n5;
        ((RealBufferedSource)((Object)by2)).require(1L);
        int n6 = 0;
        while (((RealBufferedSource)((Object)by2)).request(n5 = n6 + 1)) {
            byte by = ((RealBufferedSource)((Object)by2)).buffer.getByte(n6);
            if (by >= 48 && by <= 57 || n6 == 0 && by == 45) {
                n6 = n5;
                continue;
            }
            if (n6 != 0) break;
            Byte by2 = by;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by2;
            throw new NumberFormatException(String.format("Expected leading [0-9] or '-' character but was %#x", objectArray2));
        }
        return ((RealBufferedSource)((Object)by2)).buffer.readDecimalLong();
    }

    @Override
    public long readHexadecimalUnsignedLong() throws IOException {
        int n5;
        ((RealBufferedSource)((Object)by2)).require(1L);
        int n6 = 0;
        while (((RealBufferedSource)((Object)by2)).request(n5 = n6 + 1)) {
            byte by = ((RealBufferedSource)((Object)by2)).buffer.getByte(n6);
            if (by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70) {
                n6 = n5;
                continue;
            }
            if (n6 != 0) break;
            Byte by2 = by;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by2;
            throw new NumberFormatException(String.format("Expected leading [0-9a-fA-F] character but was %#x", objectArray2));
        }
        return ((RealBufferedSource)((Object)by2)).buffer.readHexadecimalUnsignedLong();
    }

    @Override
    public void skip(long l5) throws IOException {
        if (!this.closed) {
            while (l5 > 0L) {
                Buffer buffer = this.buffer;
                if (buffer.size == 0L && this.source.read(buffer, 8192L) == -1L) {
                    throw new EOFException();
                }
                long l6 = l5;
                l5 = Math.min(l6, this.buffer.size());
                this.buffer.skip(l5);
                l5 = l6 - l5;
            }
            return;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long indexOf(byte by) throws IOException {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l5) throws IOException {
        return this.indexOf(by, l5, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l5, long l6) throws IOException {
        if (!((RealBufferedSource)((Object)l9)).closed) {
            if (l5 >= 0L && l6 >= l5) {
                while (l5 < l6) {
                    long l7 = ((RealBufferedSource)((Object)l9)).buffer.indexOf(by, l5, l6);
                    if (l7 != -1L) {
                        return l7;
                    }
                    Buffer buffer = ((RealBufferedSource)((Object)l9)).buffer;
                    long l8 = buffer.size;
                    if (l8 < l6 && ((RealBufferedSource)((Object)l9)).source.read(buffer, 8192L) != -1L) {
                        l5 = Math.max(l5, l8);
                        continue;
                    }
                    return -1L;
                }
                return -1L;
            }
            Long l9 = l5;
            Long l10 = l6;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = l9;
            objectArray[1] = l10;
            throw new IllegalArgumentException(String.format("fromIndex=%s toIndex=%s", objectArray2));
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l5) throws IOException {
        if (!this.closed) {
            while (true) {
                long l6;
                if ((l6 = this.buffer.indexOf(byteString, l5)) != -1L) {
                    return l6;
                }
                RealBufferedSource realBufferedSource = this;
                Buffer buffer = realBufferedSource.buffer;
                long l7 = buffer.size;
                if (realBufferedSource.source.read(buffer, 8192L) == -1L) {
                    return -1L;
                }
                l5 = Math.max(l5, l7 - (long)byteString.size() + 1L);
            }
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long indexOfElement(ByteString byteString) throws IOException {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public long indexOfElement(ByteString byteString, long l5) throws IOException {
        if (!this.closed) {
            while (true) {
                long l6;
                if ((l6 = this.buffer.indexOfElement(byteString, l5)) != -1L) {
                    return l6;
                }
                RealBufferedSource realBufferedSource = this;
                Buffer buffer = realBufferedSource.buffer;
                long l7 = buffer.size;
                if (realBufferedSource.source.read(buffer, 8192L) == -1L) {
                    return -1L;
                }
                l5 = Math.max(l5, l7);
            }
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public boolean rangeEquals(long l5, ByteString byteString) throws IOException {
        int n5 = byteString.size();
        return this.rangeEquals(l5, byteString, 0, n5);
    }

    @Override
    public boolean rangeEquals(long l5, ByteString byteString, int n5, int n6) throws IOException {
        if (!this.closed) {
            if (l5 >= 0L && n5 >= 0 && n6 >= 0 && byteString.size() - n5 >= n6) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    long l6 = l5 + (long)i5;
                    if (!this.request(l6 + 1L)) {
                        return false;
                    }
                    if (this.buffer.getByte(l6) == byteString.getByte(n5 + i5)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSource peek() {
        return Okio.buffer(new PeekSource(this));
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                RealBufferedSource realBufferedSource = RealBufferedSource.this;
                if (!realBufferedSource.closed) {
                    Buffer buffer = realBufferedSource.buffer;
                    if (buffer.size == 0L && realBufferedSource.source.read(buffer, 8192L) == -1L) {
                        return -1;
                    }
                    return RealBufferedSource.this.buffer.readByte() & 0xFF;
                }
                throw new IOException("closed");
            }

            @Override
            public int read(byte[] byArray, int n5, int n6) throws IOException {
                if (!RealBufferedSource.this.closed) {
                    long l5 = n5;
                    long l6 = n6;
                    Util.checkOffsetAndCount(byArray.length, l5, l6);
                    RealBufferedSource realBufferedSource = RealBufferedSource.this;
                    Buffer buffer = realBufferedSource.buffer;
                    if (buffer.size == 0L && realBufferedSource.source.read(buffer, 8192L) == -1L) {
                        return -1;
                    }
                    return RealBufferedSource.this.buffer.read(byArray, n5, n6);
                }
                throw new IOException("closed");
            }

            @Override
            public int available() throws IOException {
                Closeable closeable = closeable.RealBufferedSource.this;
                if (!((RealBufferedSource)closeable).closed) {
                    return (int)Math.min(((RealBufferedSource)closeable).buffer.size, Integer.MAX_VALUE);
                }
                throw new IOException("closed");
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + ".inputStream()";
            }
        };
    }

    @Override
    public boolean isOpen() {
        return this.closed ^ true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.closed = true;
        realBufferedSource.source.close();
        realBufferedSource.buffer.clear();
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    public String toString() {
        return "buffer(" + this.source + ")";
    }
}

