/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview.subscaleview.decoder;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.dcloud.feature.nativeObj.photoview.subscaleview.SubsamplingScaleImageView;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.ImageDecoder;
import java.io.InputStream;
import java.util.List;

public class SkiaImageDecoder
implements ImageDecoder {
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";
    private final Bitmap.Config bitmapConfig;

    @Keep
    public SkiaImageDecoder() {
        this(null);
    }

    public SkiaImageDecoder(@Nullable Bitmap.Config config) {
        Bitmap.Config config2 = SubsamplingScaleImageView.getPreferredBitmapConfig();
        this.bitmapConfig = config != null ? config : (config2 != null ? config2 : Bitmap.Config.RGB_565);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public Bitmap decode(Context context, @NonNull Uri uri) throws Exception {
        Object object;
        BitmapFactory.Options options;
        String string2 = uri.toString();
        BitmapFactory.Options options2 = options;
        options2();
        options.inPreferredConfig = ((SkiaImageDecoder)object).bitmapConfig;
        if (string2.startsWith(RESOURCE_PREFIX)) {
            object = uri.getAuthority();
            string2 = context.getPackageName().equals(object) ? context.getResources() : context.getPackageManager().getResourcesForApplication((String)object);
            int n5 = 0;
            List list = uri.getPathSegments();
            int n6 = list.size();
            if (n6 == 2 && ((String)list.get(0)).equals("drawable")) {
                n5 = string2.getIdentifier((String)list.get(1), "drawable", (String)object);
            } else if (n6 == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)list.get(0)))) {
                try {
                    n5 = Integer.parseInt((String)list.get(0));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            object = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n5, (BitmapFactory.Options)options2);
        } else if (string2.startsWith(ASSET_PREFIX)) {
            object = string2.substring(22);
            object = BitmapFactory.decodeStream((InputStream)context.getAssets().open((String)object), null, (BitmapFactory.Options)options2);
        } else if (string2.startsWith(FILE_PREFIX)) {
            object = BitmapFactory.decodeFile((String)string2.substring(7), (BitmapFactory.Options)options2);
        } else {
            block18: {
                object = null;
                try {
                    object = context.getContentResolver().openInputStream(uri);
                }
                catch (Throwable throwable) {
                    if (object == null) throw throwable;
                    try {
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                {
                    context = BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)options2);
                    if (object == null) break block18;
                }
                try {
                    ((InputStream)object).close();
                }
                catch (Exception exception) {}
            }
            object = context;
        }
        if (object == null) throw new RuntimeException("Skia image region decoder returned null bitmap - image format may not be supported");
        return object;
    }
}

