/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.sequence.SequenceModel;

public class SingleByteCharsetProber
extends CharsetProber {
    public static final int SAMPLE_SIZE = 64;
    public static final int SB_ENOUGH_REL_THRESHOLD = 1024;
    public static final float POSITIVE_SHORTCUT_THRESHOLD = 0.95f;
    public static final float NEGATIVE_SHORTCUT_THRESHOLD = 0.05f;
    public static final int SYMBOL_CAT_ORDER = 250;
    public static final int NUMBER_OF_SEQ_CAT = 4;
    public static final int POSITIVE_CAT = 3;
    public static final int NEGATIVE_CAT = 0;
    private CharsetProber.ProbingState state;
    private SequenceModel model;
    private boolean reversed;
    private short lastOrder;
    private int totalSeqs;
    private int[] seqCounters;
    private int totalChar;
    private int freqChar;
    private CharsetProber nameProber;

    public SingleByteCharsetProber(SequenceModel sequenceModel) {
        this.model = sequenceModel;
        this.reversed = false;
        this.nameProber = null;
        this.seqCounters = new int[4];
        this.reset();
    }

    public SingleByteCharsetProber(SequenceModel sequenceModel, boolean bl, CharsetProber charsetProber) {
        this.model = sequenceModel;
        this.reversed = bl;
        this.nameProber = charsetProber;
        this.seqCounters = new int[4];
        this.reset();
    }

    boolean keepEnglishLetters() {
        return this.model.getKeepEnglishLetter();
    }

    @Override
    public String getCharSetName() {
        CharsetProber charsetProber = this.nameProber;
        if (charsetProber == null) {
            return this.model.getCharsetName();
        }
        return charsetProber.getCharSetName();
    }

    @Override
    public float getConfidence() {
        int n5 = this.totalSeqs;
        if (n5 > 0) {
            float f5;
            float f6 = (float)this.seqCounters[3] * 1.0f / (float)n5 / this.model.getTypicalPositiveRatio() * (float)this.freqChar / (float)this.totalChar;
            if (f5 >= 1.0f) {
                f6 = 0.99f;
            }
            return f6;
        }
        return 0.01f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n5, int n6) {
        n6 = n5 + n6;
        while (n5 < n6) {
            short s5 = this.model.getOrder(byArray[n5]);
            if (s5 < 250) {
                ++this.totalChar;
            }
            if (s5 < 64) {
                SingleByteCharsetProber singleByteCharsetProber = this;
                ++singleByteCharsetProber.freqChar;
                short s6 = singleByteCharsetProber.lastOrder;
                if (s6 < 64) {
                    SingleByteCharsetProber singleByteCharsetProber2 = this;
                    ++singleByteCharsetProber2.totalSeqs;
                    if (!singleByteCharsetProber2.reversed) {
                        byte by = this.model.getPrecedence(s6 * 64 + s5);
                        s6 = by;
                        this.seqCounters[s6] = this.seqCounters[by] + 1;
                    } else {
                        byte by = this.model.getPrecedence(s5 * 64 + s6);
                        s6 = by;
                        this.seqCounters[s6] = this.seqCounters[by] + 1;
                    }
                }
            }
            this.lastOrder = s5;
            ++n5;
        }
        if (this.state == CharsetProber.ProbingState.DETECTING && this.totalSeqs > 1024) {
            float f5;
            float f6 = this.getConfidence();
            if (f5 > 0.95f) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
            } else if (f6 < 0.05f) {
                this.state = CharsetProber.ProbingState.NOT_ME;
            }
        }
        return this.state;
    }

    @Override
    public void reset() {
        SingleByteCharsetProber singleByteCharsetProber = this;
        singleByteCharsetProber.state = CharsetProber.ProbingState.DETECTING;
        singleByteCharsetProber.lastOrder = (short)255;
        for (int i5 = 0; i5 < 4; ++i5) {
            this.seqCounters[i5] = 0;
        }
        SingleByteCharsetProber singleByteCharsetProber2 = this;
        singleByteCharsetProber2.totalSeqs = 0;
        singleByteCharsetProber2.totalChar = 0;
        singleByteCharsetProber2.freqChar = 0;
    }

    @Override
    public void setOption() {
    }
}

