/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.adapter;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DefaultWXHttpAdapter
implements IWXHttpAdapter {
    private static final IEventReporterDelegate DEFAULT_DELEGATE = new NOPEventReportDelegate();
    private ExecutorService mExecutorService;

    private void execute(Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newFixedThreadPool(3);
        }
        this.mExecutorService.execute(runnable);
    }

    private HttpURLConnection openConnection(WXRequest wXRequest, IWXHttpAdapter.OnHttpListener onHttpListener) {
        HttpURLConnection httpURLConnection = ((DefaultWXHttpAdapter)((Object)httpURLConnection)).createConnection(new URL(wXRequest.url));
        httpURLConnection.setConnectTimeout(wXRequest.timeoutMs);
        httpURLConnection.setReadTimeout(wXRequest.timeoutMs);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        Map<String, String> map = wXRequest.paramMap;
        if (map != null) {
            for (String string : map.keySet()) {
                httpURLConnection.addRequestProperty(string, wXRequest.paramMap.get(string));
            }
        }
        if (!("POST".equals(wXRequest.method) || "PUT".equals(wXRequest.method) || "PATCH".equals(wXRequest.method))) {
            if (!TextUtils.isEmpty((CharSequence)wXRequest.method)) {
                httpURLConnection.setRequestMethod(wXRequest.method);
            } else {
                httpURLConnection.setRequestMethod("GET");
            }
        } else {
            httpURLConnection.setRequestMethod(wXRequest.method);
            if (wXRequest.body != null) {
                if (onHttpListener != null) {
                    onHttpListener.onHttpUploadProgress(0);
                }
                httpURLConnection.setDoOutput(true);
                DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                ((OutputStream)dataOutputStream).write(wXRequest.body.getBytes());
                ((OutputStream)dataOutputStream).close();
                if (onHttpListener != null) {
                    onHttpListener.onHttpUploadProgress(100);
                }
            }
        }
        return httpURLConnection;
    }

    private byte[] readInputStreamAsBytes(InputStream inputStream, IWXHttpAdapter.OnHttpListener onHttpListener) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        int n3 = 2048;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray, 0, n3)) != -1) {
            byteArrayOutputStream2.write(byArray, 0, n);
            n2 += n;
            if (onHttpListener == null) continue;
            onHttpListener.onHttpResponseProgress(n2);
        }
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
        byteArrayOutputStream3.flush();
        return byteArrayOutputStream3.toByteArray();
    }

    private String readInputStream(InputStream object, IWXHttpAdapter.OnHttpListener onHttpListener) {
        int n;
        InputStreamReader inputStreamReader;
        BufferedReader bufferedReader;
        StringBuilder stringBuilder;
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        BufferedReader bufferedReader2 = bufferedReader;
        InputStreamReader inputStreamReader2 = inputStreamReader;
        inputStreamReader = new InputStreamReader((InputStream)object);
        bufferedReader = new BufferedReader(inputStreamReader2);
        object = new char[2048];
        while ((n = bufferedReader2.read((char[])object)) != -1) {
            stringBuilder2.append((char[])object, 0, n);
            if (onHttpListener == null) continue;
            onHttpListener.onHttpResponseProgress(stringBuilder2.length());
        }
        bufferedReader2.close();
        return stringBuilder2.toString();
    }

    @Override
    public void sendRequest(final WXRequest wXRequest, final IWXHttpAdapter.OnHttpListener onHttpListener) {
        Runnable runnable;
        if (onHttpListener != null) {
            onHttpListener.onHttpStart();
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                boolean bl;
                WXSDKInstance wXSDKInstance;
                block15: {
                    void var2_7;
                    WXResponse wXResponse;
                    wXSDKInstance = WXSDKManager.getInstance().getAllInstanceMap().get(wXRequest.instanceId);
                    if (wXSDKInstance != null && !wXSDKInstance.isDestroy()) {
                        wXSDKInstance.getApmForInstance().actionNetRequest();
                    }
                    1 v0 = this;
                    bl = true;
                    WXResponse wXResponse2 = wXResponse;
                    wXResponse = new WXResponse();
                    IEventReporterDelegate iEventReporterDelegate = v0.DefaultWXHttpAdapter.this.getEventReporterDelegate();
                    1 v2 = this;
                    Object object = v2.wXRequest;
                    object = v0.DefaultWXHttpAdapter.this.openConnection((WXRequest)object, v2.onHttpListener);
                    iEventReporterDelegate.preConnect((HttpURLConnection)object, wXRequest.body);
                    Map<String, List<String>> map = ((URLConnection)object).getHeaderFields();
                    int n = ((HttpURLConnection)object).getResponseCode();
                    IWXHttpAdapter.OnHttpListener onHttpListener2 = v0.onHttpListener;
                    if (onHttpListener2 != null) {
                        onHttpListener2.onHeadersReceived(n, map);
                    }
                    iEventReporterDelegate.postConnect();
                    wXResponse2.statusCode = String.valueOf(n);
                    if (n >= 200 && n <= 299) {
                        object = iEventReporterDelegate.interpretResponseStream(((URLConnection)object).getInputStream());
                        wXResponse2.originalData = DefaultWXHttpAdapter.this.readInputStreamAsBytes((InputStream)object, onHttpListener);
                    } else {
                        InputStream inputStream = ((HttpURLConnection)object).getErrorStream();
                        wXResponse2.errorMsg = DefaultWXHttpAdapter.this.readInputStream(inputStream, onHttpListener);
                        bl = false;
                    }
                    object = onHttpListener;
                    if (object == null) break block15;
                    try {
                        object.onHttpFinish(wXResponse2);
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IOException iOException) {}
                    WXResponse wXResponse3 = wXResponse2;
                    boolean bl2 = false;
                    var2_7.printStackTrace();
                    wXResponse3.statusCode = "-1";
                    wXResponse3.errorCode = "-1";
                    wXResponse2.errorMsg = var2_7.getMessage();
                    object = onHttpListener;
                    if (object != null) {
                        object.onHttpFinish(wXResponse2);
                    }
                    if (var2_7 instanceof IOException) {
                        try {
                            iEventReporterDelegate.httpExchangeFailed((IOException)var2_7);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    bl = bl2;
                }
                if (wXSDKInstance != null && !wXSDKInstance.isDestroy()) {
                    wXSDKInstance.getApmForInstance().actionNetResult(bl, null);
                }
            }
        };
        this.execute(runnable2);
    }

    protected HttpURLConnection createConnection(URL uRL) {
        return (HttpURLConnection)uRL.openConnection();
    }

    @NonNull
    public IEventReporterDelegate getEventReporterDelegate() {
        return DEFAULT_DELEGATE;
    }

    public static interface IEventReporterDelegate {
        public void preConnect(HttpURLConnection var1, @Nullable String var2);

        public void postConnect();

        public InputStream interpretResponseStream(@Nullable InputStream var1);

        public void httpExchangeFailed(IOException var1);
    }

    private static class NOPEventReportDelegate
    implements IEventReporterDelegate {
        private NOPEventReportDelegate() {
        }

        @Override
        public void preConnect(HttpURLConnection httpURLConnection, @Nullable String string) {
        }

        @Override
        public void postConnect() {
        }

        @Override
        public InputStream interpretResponseStream(@Nullable InputStream inputStream) {
            return inputStream;
        }

        @Override
        public void httpExchangeFailed(IOException iOException) {
        }
    }
}

