/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.content.Intent;
import android.text.TextUtils;
import android.view.Menu;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.bridge.ModuleFactoryImpl;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.ui.config.ConfigModuleFactory;
import com.taobao.weex.ui.module.WXDomModule;
import com.taobao.weex.ui.module.WXTimerModule;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.cache.RegisterCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WXModuleManager {
    private static volatile ConcurrentMap<String, ModuleFactoryImpl> sModuleFactoryMap = new ConcurrentHashMap<String, ModuleFactoryImpl>();
    private static Map<String, WXModule> sGlobalModuleMap = new HashMap<String, WXModule>();
    private static Map<String, WXDomModule> sDomModuleMap = new HashMap<String, WXDomModule>();
    private static Map<String, Map<String, WXModule>> sInstanceModuleMap = new ConcurrentHashMap<String, Map<String, WXModule>>();
    private static ArrayList<String> mBlackModuleList;

    public static boolean registerModule(Map<String, RegisterCache.ModuleCache> object) {
        if (object.isEmpty()) {
            return true;
        }
        object = object.entrySet().iterator();
        WXBridgeManager.getInstance().post(new Runnable((Iterator)object){
            final /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            @Override
            public void run() {
                HashMap<String, Object> hashMap;
                HashMap<String, Object> hashMap2 = hashMap;
                hashMap = new HashMap<String, Object>();
                while (this.val$iterator.hasNext()) {
                    ModuleFactoryImpl moduleFactoryImpl;
                    String string2;
                    ConcurrentMap concurrentMap;
                    Object object = (RegisterCache.ModuleCache)((Map.Entry)this.val$iterator.next()).getValue();
                    String string3 = ((RegisterCache.ModuleCache)object).name;
                    if (TextUtils.equals((CharSequence)string3, (CharSequence)"dom")) {
                        WXLogUtils.e("Cannot registered module with name 'dom'.");
                        continue;
                    }
                    if (sModuleFactoryMap != null && sModuleFactoryMap.containsKey(string3)) {
                        WXLogUtils.w("WXComponentRegistry Duplicate the Module name: " + string3);
                    }
                    ModuleFactory moduleFactory = ((RegisterCache.ModuleCache)object).factory;
                    try {
                        WXModuleManager.registerNativeModule(string3, moduleFactory);
                    }
                    catch (WXException wXException) {
                        WXLogUtils.e("registerNativeModule" + wXException);
                    }
                    if (((RegisterCache.ModuleCache)object).global) {
                        object = moduleFactory.buildInstance();
                        try {
                            ((WXModule)object).setModuleName(string3);
                            sGlobalModuleMap.put(string3, object);
                        }
                        catch (Exception exception) {
                            WXLogUtils.e(string3 + " class must have a default constructor without params. ", exception);
                        }
                    }
                    try {
                        concurrentMap = sModuleFactoryMap;
                        string2 = string3;
                    }
                    catch (Throwable throwable) {}
                    object = moduleFactoryImpl;
                    moduleFactoryImpl = new ModuleFactoryImpl(moduleFactory);
                    concurrentMap.put(string2, object);
                    hashMap2.put(string3, moduleFactory.getMethods());
                }
                WXSDKManager.getInstance().registerModules(hashMap2);
            }
        });
        return true;
    }

    public static boolean registerModule(final String string2, final ModuleFactory moduleFactory, final boolean bl) {
        if (string2 != null && moduleFactory != null) {
            if (TextUtils.equals((CharSequence)string2, (CharSequence)"dom")) {
                WXLogUtils.e("Cannot registered module with name 'dom'.");
                return false;
            }
            if (RegisterCache.getInstance().cacheModule(string2, moduleFactory, bl)) {
                return true;
            }
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    if (sModuleFactoryMap != null && sModuleFactoryMap.containsKey(string2)) {
                        WXLogUtils.w("WXComponentRegistry Duplicate the Module name: " + string2);
                    }
                    try {
                        WXModuleManager.registerNativeModule(string2, moduleFactory);
                    }
                    catch (WXException wXException) {
                        WXLogUtils.e("registerNativeModule" + wXException);
                    }
                    if (bl) {
                        Object t = moduleFactory.buildInstance();
                        try {
                            ((WXModule)t).setModuleName(string2);
                            sGlobalModuleMap.put(string2, t);
                        }
                        catch (Exception exception) {
                            WXLogUtils.e(string2 + " class must have a default constructor without params. ", exception);
                        }
                    }
                    WXModuleManager.registerJSModule(string2, moduleFactory);
                    try {
                        sModuleFactoryMap.put(string2, new ModuleFactoryImpl(moduleFactory));
                    }
                    catch (Throwable throwable) {}
                }
            });
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean registerNativeModule(String string2, ModuleFactory moduleFactory) {
        ModuleFactoryImpl moduleFactoryImpl;
        if (moduleFactory == null) {
            return false;
        }
        if (sModuleFactoryMap.containsKey(string2)) return true;
        ConcurrentMap<String, ModuleFactoryImpl> concurrentMap = sModuleFactoryMap;
        String string3 = string2;
        ModuleFactoryImpl moduleFactoryImpl2 = moduleFactoryImpl;
        try {
            moduleFactoryImpl = new ModuleFactoryImpl(moduleFactory);
            concurrentMap.put(string3, moduleFactoryImpl2);
        }
        catch (ArrayStoreException arrayStoreException) {
            arrayStoreException.printStackTrace();
            WXLogUtils.e("[WXModuleManager] registerNativeModule Error moduleName:" + string2 + " Error:" + ((Object)arrayStoreException).toString());
        }
        return true;
    }

    static boolean registerJSModule(String string2, ModuleFactory moduleFactory) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap2();
        hashMap.put(string2, moduleFactory.getMethods());
        WXSDKManager.getInstance().registerModules(hashMap2);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object callModuleMethod(String var0, String var1_4, String var2_5, JSONArray var3_6) {
        block17: {
            block18: {
                var4_7 = ((ModuleFactoryImpl)WXModuleManager.sModuleFactoryMap.get((Object)var1_4)).mFactory;
                if (var4_7 == null) {
                    WXLogUtils.e("[WXModuleManager] module factory not found.");
                    return null;
                }
                var5_8 = WXModuleManager.findModule((String)var0, var1_4, (ModuleFactory)var4_7);
                if (var5_8 == null) {
                    return null;
                }
                var5_8.mWXSDKInstance = var0 = WXSDKManager.getInstance().getSDKInstance((String)var0);
                var5_8.mUniSDKInstance = var0;
                var4_7 = var4_7.getMethodInvoker(var2_5);
                if (var0 == null) break block18;
                var6_9 = WXSDKManager.getInstance().getIWXUserTrackAdapter();
                if (var6_9 == null) ** GOTO lbl36
                v0 = var6_9;
                v1 = var0;
                var6_9 = v2;
                v3 = var0;
                v4 = var6_9;
                v5 = v4;
                v4();
                v4.put("errCode", (Serializable)"101");
                v6 = "arg";
                v5.put(v6, (Serializable)(var1_4 + "." + var2_5));
                var7_10 = "errMsg";
                v2.put(var7_10, v3.getBundleUrl());
                v0.commit(v1.getContext(), null, "invokeModule", null, var6_9);
lbl36:
                // 2 sources

                var0 = WXModuleManager.dispatchCallModuleMethod((WXSDKInstance)var0, var5_8, var3_6, (Invoker)var4_7);
                if (var5_8 instanceof WXDomModule || var5_8 instanceof WXTimerModule) {
                    v7 = var5_8;
                    v7.mWXSDKInstance = null;
                    v7.mUniSDKInstance = null;
                }
                return var0;
            }
            try {
                WXLogUtils.e("callModuleMethod >>> instance is null");
                var0 = null;
            }
            catch (Throwable var0_1) {
                break block17;
            }
            catch (Exception var0_2) {}
            if (var5_8 instanceof WXDomModule || var5_8 instanceof WXTimerModule) {
                v8 = var5_8;
                v8.mWXSDKInstance = null;
                v8.mUniSDKInstance = null;
            }
            return var0;
            {
                WXLogUtils.e("callModuleMethod >>> invoke module:" + var1_4 + ", method:" + var2_5 + " failed. ", var0_2);
                var0_3 = null;
            }
            if (var5_8 instanceof WXDomModule || var5_8 instanceof WXTimerModule) {
                v9 = var5_8;
                v9.mWXSDKInstance = null;
                v9.mUniSDKInstance = null;
            }
            return var0_3;
        }
        if (var5_8 instanceof WXDomModule || var5_8 instanceof WXTimerModule) {
            v10 = var5_8;
            v10.mWXSDKInstance = null;
            v10.mUniSDKInstance = null;
        }
        throw var0_1;
    }

    private static Object dispatchCallModuleMethod(@NonNull WXSDKInstance wXSDKInstance, @NonNull WXModule wXModule, @NonNull JSONArray jSONArray, @NonNull Invoker invoker) {
        if (!wXSDKInstance.isPreRenderMode()) {
            return wXSDKInstance.getNativeInvokeHelper().invoke(wXModule, invoker, jSONArray);
        }
        if (invoker.isRunOnUIThread()) {
            return null;
        }
        return wXSDKInstance.getNativeInvokeHelper().invoke(wXModule, invoker, jSONArray);
    }

    public static boolean hasModule(String string2) {
        return sGlobalModuleMap.containsKey(string2) || sModuleFactoryMap.containsKey(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static WXModule findModule(String object, String string2, ModuleFactory moduleFactory) {
        WXModule wXModule;
        Map<String, WXModule> map = sGlobalModuleMap.get(string2);
        if (map != null) return map;
        map = sInstanceModuleMap.get(object);
        if (map == null) {
            ConcurrentHashMap concurrentHashMap;
            map = concurrentHashMap;
            concurrentHashMap = new ConcurrentHashMap();
            sInstanceModuleMap.put((String)object, map);
        }
        if ((wXModule = (WXModule)map.get(string2)) != null) {
            return wXModule;
        }
        try {
            Object t;
            if (moduleFactory instanceof ConfigModuleFactory) {
                object = WXSDKManager.getInstance().getSDKInstance((String)object);
                t = ((ConfigModuleFactory)moduleFactory).buildInstance((WXSDKInstance)object);
            } else {
                t = moduleFactory.buildInstance();
            }
            object = t;
            ((WXModule)object).setModuleName(string2);
            map.put(string2, (WXModule)object);
            return object;
        }
        catch (Exception exception) {}
        WXLogUtils.e(string2 + " module build instace failed.", exception);
        return null;
    }

    public static void onActivityCreate(String object) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onActivityCreate();
                    continue;
                }
                WXLogUtils.w("onActivityCreate can not find the " + string2 + " module");
            }
        }
    }

    public static void onActivityStart(String object) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onActivityStart();
                    continue;
                }
                WXLogUtils.w("onActivityStart can not find the " + string2 + " module");
            }
        }
    }

    public static void onActivityPause(String object) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onActivityPause();
                    continue;
                }
                WXLogUtils.w("onActivityPause can not find the " + string2 + " module");
            }
        }
    }

    public static void onActivityResume(String object) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onActivityResume();
                    continue;
                }
                WXLogUtils.w("onActivityResume can not find the " + string2 + " module");
            }
        }
    }

    public static void onActivityStop(String object) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onActivityStop();
                    continue;
                }
                WXLogUtils.w("onActivityStop can not find the " + string2 + " module");
            }
        }
    }

    public static void onActivityDestroy(String object) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onActivityDestroy();
                    continue;
                }
                WXLogUtils.w("onActivityDestroy can not find the " + string2 + " module");
            }
        }
    }

    public static boolean onActivityBack(String object) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    return wXModule.onActivityBack();
                }
                WXLogUtils.w("onActivityCreate can not find the " + string2 + " module");
            }
        }
        return false;
    }

    public static void onActivityResult(String object, int n, int n2, Intent intent) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onActivityResult(n, n2, intent);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + string2 + " module");
            }
        }
    }

    public static boolean onCreateOptionsMenu(String object, Menu menu) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onCreateOptionsMenu(menu);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + string2 + " module");
            }
        }
        return false;
    }

    public static void onRequestPermissionsResult(String object, int n, String[] stringArray, int[] nArray) {
        if ((object = sInstanceModuleMap.get(object)) != null) {
            for (String string2 : object.keySet()) {
                WXModule wXModule = (WXModule)object.get(string2);
                if (wXModule != null) {
                    wXModule.onRequestPermissionsResult(n, stringArray, nArray);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + string2 + " module");
            }
        }
    }

    public static void destroyInstanceModules(String iterator) {
        sDomModuleMap.remove(iterator);
        iterator = sInstanceModuleMap.remove(iterator);
        if (iterator != null && iterator.size() >= 1) {
            iterator = iterator.entrySet().iterator();
            while (iterator.hasNext()) {
                WXModule wXModule = (WXModule)iterator.next().getValue();
                if (!(wXModule instanceof Destroyable)) continue;
                ((Destroyable)((Object)wXModule)).destroy();
            }
            return;
        }
    }

    public static void createDomModule(WXSDKInstance wXSDKInstance) {
        if (wXSDKInstance != null) {
            sDomModuleMap.put(wXSDKInstance.getInstanceId(), new WXDomModule(wXSDKInstance));
        }
    }

    public static void destoryDomModule(String string2) {
        sDomModuleMap.remove(string2);
    }

    public static WXDomModule getDomModule(String string2) {
        return sDomModuleMap.get(string2);
    }

    public static void reload() {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
                try {
                    WXModuleManager.registerJSModule((String)entry.getKey(), ((ModuleFactoryImpl)entry.getValue()).mFactory);
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    public static void registerWhenCreateInstance() {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
                try {
                    if (((ModuleFactoryImpl)entry.getValue()).hasRigster) continue;
                }
                catch (Throwable throwable) {
                    continue;
                }
                WXModuleManager.registerJSModule((String)entry.getKey(), ((ModuleFactoryImpl)entry.getValue()).mFactory);
            }
        }
    }

    public static void resetAllModuleState() {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            Iterator iterator = sModuleFactoryMap.entrySet().iterator();
            while (iterator.hasNext()) {
                ((ModuleFactoryImpl)iterator.next().getValue()).hasRigster = false;
            }
        }
    }

    public static void resetModuleState(String string2, boolean bl) {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
                try {
                    if (entry.getKey() == null) continue;
                }
                catch (Throwable throwable) {}
                if (!((String)entry.getKey()).equals(string2)) continue;
                ((ModuleFactoryImpl)entry.getValue()).hasRigster = bl;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject getRegisterJsModules() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = null;
        if (sModuleFactoryMap == null || sModuleFactoryMap.size() <= 0) return jSONObject2;
        jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
            try {
                if (WXModuleManager.getBlackList().contains(entry.getKey())) continue;
            }
            catch (Throwable throwable) {}
            if (((ModuleFactoryImpl)entry.getValue()).mFactory == null) continue;
            JSONObject jSONObject3 = jSONObject2;
            Map.Entry entry2 = entry;
            Map.Entry entry3 = entry2;
            JSONArray jSONArray = WXModuleManager.modulesToJSONArray(((ModuleFactoryImpl)entry2.getValue()).mFactory.getMethods(), ((ModuleFactoryImpl)entry.getValue()).mFactory);
            jSONObject3.put((String)entry3.getKey(), (Object)jSONArray);
        }
        return jSONObject2;
    }

    private static ArrayList<String> getBlackList() {
        if (mBlackModuleList == null) {
            mBlackModuleList = new ArrayList<String>();
            mBlackModuleList.add("webview");
            mBlackModuleList.add("animation");
            mBlackModuleList.add("binding");
            mBlackModuleList.add("bindingx");
            mBlackModuleList.add("instanceWrap");
            mBlackModuleList.add("meta");
            mBlackModuleList.add("navigator");
            mBlackModuleList.add("expressionBinding");
        }
        return mBlackModuleList;
    }

    public static JSONArray modulesToJSONArray(String[] stringArray, ModuleFactory moduleFactory) {
        JSONArray jSONArray = null;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                StringBuilder stringBuilder;
                if (jSONArray == null) {
                    JSONArray jSONArray2;
                    jSONArray = jSONArray2;
                    jSONArray2 = new JSONArray();
                }
                String string2 = ":sync";
                String string3 = ":async";
                if (stringArray[i].equals("addEventListener") || stringArray[i].equals("removeAllEventListeners")) continue;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2();
                stringBuilder2 = stringBuilder.append(stringArray[i]);
                if (moduleFactory.getMethodInvoker(stringArray[i]).isRunOnUIThread()) {
                    string2 = string3;
                }
                jSONArray.add((Object)stringBuilder2.append(string2).toString());
            }
        }
        return jSONArray;
    }
}

