/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.http;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.http.CertDTO;
import com.taobao.weex.http.CertJSResponse;
import com.taobao.weex.http.Options;
import com.taobao.weex.http.Status;
import com.taobao.weex.http.WXHttpUtil;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.common.constant.DOMException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WXStreamModule
extends WXModule {
    public static final String STATUS_TEXT = "statusText";
    public static final String STATUS = "status";
    static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([a-z0-9-]+)");
    public static HashMap<String, CertDTO> certMap = new HashMap();
    final IWXHttpAdapter mAdapter;

    public WXStreamModule() {
        this(null);
    }

    public WXStreamModule(IWXHttpAdapter iWXHttpAdapter) {
        this.mAdapter = iWXHttpAdapter;
    }

    static String getHeader(Map<String, String> map, String string2) {
        if (map != null && string2 != null) {
            if (map.containsKey(string2)) {
                return map.get(string2);
            }
            return map.get(string2.toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readAsString(byte[] byArray, String object, Options.Type type) {
        String string2 = "utf-8";
        if (object != null && ((Matcher)(object = CHARSET_PATTERN.matcher(((String)object).toLowerCase(Locale.ENGLISH)))).find()) {
            string2 = ((Matcher)object).group(1);
        }
        try {
            if (type != Options.Type.base64) return new String(byArray, string2);
            return Base64.encodeToString((byte[])byArray, (int)2);
        }
        catch (Exception exception) {}
        WXLogUtils.e("", exception);
        return new String(byArray);
    }

    private void extractHeaders(JSONObject jSONObject, Options.Builder builder) {
        Object object = WXHttpUtil.assembleUserAgent((Context)WXEnvironment.getApplication(), WXEnvironment.getConfig());
        if (jSONObject != null) {
            for (String string2 : jSONObject.keySet()) {
                if (string2.equals("user-agent")) {
                    object = jSONObject.getString(string2);
                    continue;
                }
                builder.putHeader(string2, jSONObject.getString(string2));
            }
        }
        builder.putHeader("user-agent", (String)object);
    }

    private void sendRequest(Options options, ResponseCallback responseCallback, JSCallback jSCallback, String map, String string2) {
        Object object;
        WXRequest wXRequest;
        WXRequest wXRequest2;
        WXRequest wXRequest3 = wXRequest2 = wXRequest;
        wXRequest2();
        wXRequest3.method = options.getMethod();
        wXRequest3.url = WXSDKManager.getInstance().getURIAdapter().rewrite(string2, "request", Uri.parse((String)options.getUrl())).toString();
        wXRequest2.body = options.getBody();
        wXRequest2.timeoutMs = options.getTimeout();
        wXRequest2.instanceId = map;
        wXRequest2.sslVerify = options.getSslVerify();
        wXRequest2.isFirstIpv4 = options.isFirstIpv4();
        wXRequest.tls = options.getTlsConfig();
        wXRequest2.inputType = "BASE64".equalsIgnoreCase(options.getInputType()) ? "BASE64" : "";
        if (options.getHeaders() != null) {
            map = wXRequest2.paramMap;
            if (map == null) {
                wXRequest2.paramMap = options.getHeaders();
            } else {
                map.putAll(options.getHeaders());
            }
        }
        if ((object = ((WXStreamModule)object).mAdapter) == null) {
            object = WXSDKManager.getInstance().getIWXHttpAdapter();
        }
        if (object != null) {
            StreamHttpListener streamHttpListener;
            Object object2 = object;
            object = streamHttpListener;
            streamHttpListener = new StreamHttpListener(responseCallback, jSCallback);
            object2.sendRequest(wXRequest2, (IWXHttpAdapter.OnHttpListener)object);
        } else {
            WXLogUtils.e("WXStreamModule", "No HttpAdapter found,request failed.");
        }
    }

    @Deprecated
    @JSMethod(uiThread=false)
    public void sendHttp(JSONObject object, final String string2) {
        ResponseCallback responseCallback;
        Options.Builder builder;
        Object object2 = object.getString("method");
        JSONObject jSONObject = object;
        object = jSONObject.getString("url");
        JSONObject jSONObject2 = jSONObject.getJSONObject("header");
        String string3 = jSONObject.getString("body");
        int n = jSONObject.getIntValue("timeout");
        boolean bl = jSONObject.getBooleanValue("sslVerify");
        boolean bl2 = jSONObject.getBooleanValue("firstIpv4");
        JSONObject jSONObject3 = jSONObject.getJSONObject("tls");
        if (object2 != null) {
            object2 = ((String)object2).toUpperCase();
        }
        Options.Builder builder2 = builder;
        builder = new Options.Builder();
        if (!("GET".equals(object2) || "POST".equals(object2) || "PUT".equals(object2) || "DELETE".equals(object2) || "HEAD".equals(object2) || "PATCH".equals(object2))) {
            object2 = "GET";
        }
        WXStreamModule wXStreamModule = string4;
        Options.Builder builder3 = builder2.setMethod((String)object2).setUrl((String)object).setBody(string3).setTimeout(n).setSslVerify(bl).setAndroidTlsConfig(jSONObject3).setFirstIpv4(bl2);
        object = builder3;
        ((WXStreamModule)((Object)string4)).extractHeaders(jSONObject2, (Options.Builder)object);
        object = builder3.createOptions();
        WXStreamModule wXStreamModule2 = string4;
        object2 = responseCallback;
        responseCallback = new ResponseCallback(){
            final /* synthetic */ Options val$options;
            {
                this.val$options = options;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void onResponse(WXResponse var1_1, Map<String, String> var2_2) {
                block2: {
                    if (string2 == null || WXStreamModule.this.mWXSDKInstance == null) break block2;
                    v0 = this;
                    var3_3 = WXBridgeManager.getInstance();
                    var4_4 = v0.WXStreamModule.this.mWXSDKInstance.getInstanceId();
                    var5_5 = v0.string2;
                    if (var1_1 == null) ** GOTO lbl-1000
                    var1_1 = var1_1.originalData;
                    if (var1_1.originalData != null) {
                        var2_2 = var2_2 != null ? WXStreamModule.getHeader(var2_2, "Content-Type") : "";
                        this = WXStreamModule.readAsString((byte[])var1_1, (String)var2_2, this.val$options.getType());
                    } else lbl-1000:
                    // 2 sources

                    {
                        this = "{}";
                    }
                    var3_3.callback(var4_4, var5_5, (String)this);
                }
            }
        };
        String string4 = wXStreamModule2.mWXSDKInstance.getInstanceId();
        object = wXStreamModule2.mWXSDKInstance.getBundleUrl();
        wXStreamModule.sendRequest(builder3.createOptions(), (ResponseCallback)object2, null, string4, (String)object);
    }

    @JSMethod(uiThread=false)
    public void fetch(JSONObject object, JSCallback jSCallback, JSCallback jSCallback2) {
        WXStreamModule wXStreamModule = string2;
        JSONObject jSONObject = object;
        WXStreamModule wXStreamModule2 = string2;
        String string2 = wXStreamModule2.mWXSDKInstance.getInstanceId();
        object = wXStreamModule2.mWXSDKInstance.getBundleUrl();
        wXStreamModule.fetch(jSONObject, jSCallback, jSCallback2, string2, (String)object);
    }

    @JSMethod(uiThread=false)
    public void fetchWithArrayBuffer(JSONObject object, JSONObject jSONObject, JSCallback jSCallback, JSCallback jSCallback2) {
        Object object2;
        if (object == null) {
            if (jSCallback != null) {
                HashMap<String, Object> hashMap;
                object2 = hashMap;
                new HashMap<String, Object>().put("ok", Boolean.FALSE);
                object2.put(STATUS_TEXT, "ERR_INVALID_REQUEST");
                jSCallback.invoke(object2);
            }
            return;
        }
        String string2 = object.getString("@type");
        if (!TextUtils.isEmpty((CharSequence)string2) && "binary".equalsIgnoreCase(string2)) {
            if (TextUtils.isEmpty((CharSequence)(object = object.getString("base64")))) {
                if (jSCallback != null) {
                    HashMap<String, Object> hashMap;
                    object2 = hashMap;
                    new HashMap<String, Object>().put("ok", Boolean.FALSE);
                    object2.put(STATUS_TEXT, "ERR_INVALID_REQUEST");
                    jSCallback.invoke(object2);
                }
                return;
            }
            Object object3 = object2;
            Object object4 = object2;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2.put("inputType", (Object)"base64");
            jSONObject2.put("body", object);
            object2 = ((WXModule)object4).mWXSDKInstance.getInstanceId();
            object = ((WXModule)object4).mWXSDKInstance.getBundleUrl();
            ((WXStreamModule)object3).fetch(jSONObject, jSCallback, jSCallback2, (String)object2, (String)object);
            return;
        }
        if (jSCallback != null) {
            HashMap<String, Object> hashMap;
            object2 = hashMap;
            new HashMap<String, Object>().put("ok", Boolean.FALSE);
            object2.put(STATUS_TEXT, "ERR_INVALID_REQUEST");
            jSCallback.invoke(object2);
        }
    }

    @JSMethod(uiThread=false)
    public void configMTLS(JSONArray jSONArray, JSCallback jSCallback) {
        if (jSCallback == null) {
            return;
        }
        if (jSONArray != null && !jSONArray.isEmpty()) {
            certMap.clear();
            for (int i = 0; i < jSONArray.size(); ++i) {
                CertDTO certDTO;
                Object object = jSONArray.getJSONObject(i);
                if (!object.containsKey((Object)"host")) continue;
                CertDTO certDTO2 = certDTO;
                JSONObject jSONObject = object;
                JSONObject jSONObject2 = object;
                JSONObject jSONObject3 = object;
                certDTO2();
                object = object.getString("host");
                certDTO2.host = object;
                certDTO2.client = jSONObject3.getString("client");
                certDTO2.clientPassword = jSONObject2.getString("clientPassword");
                certDTO.server = (String[])jSONObject.getJSONArray("server").toArray((Object[])new String[0]);
                certMap.put((String)object, certDTO2);
            }
            jSCallback.invoke(CertJSResponse.obtainSuccess());
            return;
        }
        jSCallback.invoke(CertJSResponse.obtainFail(-1, DOMException.MSG_PARAMETER_ERROR));
    }

    public void fetch(JSONObject object, final JSCallback jSCallback, JSCallback jSCallback2, String string2, String string3) {
        if (object != null && object.getString("url") != null) {
            ResponseCallback responseCallback;
            Options.Builder builder;
            JSONObject jSONObject = object;
            object = jSONObject.getString("method");
            Object object2 = jSONObject.getString("url");
            JSONObject jSONObject2 = jSONObject.getJSONObject("headers");
            String string4 = jSONObject.getString("body");
            String string5 = jSONObject.getString("type");
            String string6 = jSONObject.getString("inputType");
            int n = jSONObject.getIntValue("timeout");
            JSONObject jSONObject3 = jSONObject.getJSONObject("tls");
            boolean bl = jSONObject.getBooleanValue("sslVerify");
            boolean bl2 = jSONObject.getBooleanValue("firstIpv4");
            Object object3 = WXSDKManager.getInstance().getSDKInstance(string2);
            if (object3 != null && ((WXSDKInstance)object3).getStreamNetworkHandler() != null && !TextUtils.isEmpty((CharSequence)(object3 = ((WXSDKInstance)object3).getStreamNetworkHandler().fetchLocal((String)object2)))) {
                object2 = object3;
            }
            if (object != null) {
                object = ((String)object).toUpperCase();
            }
            object3 = builder;
            builder = new Options.Builder();
            if (!("GET".equals(object) || "POST".equals(object) || "PUT".equals(object) || "DELETE".equals(object) || "HEAD".equals(object) || "PATCH".equals(object))) {
                object = "GET";
            }
            object = ((Options.Builder)object3).setMethod((String)object).setUrl((String)object2).setBody(string4).setType(string5).setInputTypes(string6).setTimeout(n).setSslVerify(bl).setAndroidTlsConfig(jSONObject3).setFirstIpv4(bl2);
            super.extractHeaders(jSONObject2, (Options.Builder)object);
            object = ((Options.Builder)object).createOptions();
            object2 = responseCallback;
            responseCallback = new ResponseCallback(){
                final /* synthetic */ Options val$options;
                {
                    this.val$options = options;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onResponse(WXResponse wXResponse, Map<String, String> map) {
                    if (jSCallback != null) {
                        HashMap<String, Object> hashMap;
                        HashMap<String, Object> hashMap2 = hashMap;
                        hashMap = new HashMap<String, Object>();
                        if (wXResponse != null && !"-1".equals(wXResponse.statusCode)) {
                            int n = Integer.parseInt(wXResponse.statusCode);
                            hashMap2.put(WXStreamModule.STATUS, n);
                            String string2 = "ok";
                            Object object = n >= 200 && n <= 299;
                            hashMap2.put(string2, object);
                            object = wXResponse.originalData;
                            if (wXResponse.originalData == null) {
                                hashMap2.put("data", wXResponse.errorMsg);
                            } else {
                                string2 = map != null ? WXStreamModule.getHeader(map, "Content-Type") : "";
                                object = WXStreamModule.readAsString((byte[])object, string2, this.val$options.getType());
                                try {
                                    hashMap2.put("data", WXStreamModule.this.parseData((String)object, this.val$options.getType()));
                                }
                                catch (JSONException jSONException) {
                                    HashMap<String, Object> hashMap3 = hashMap2;
                                    WXLogUtils.e("", jSONException);
                                    hashMap3.put("ok", Boolean.FALSE);
                                    hashMap3.put("data", "{'err':'Data parse failed!'}");
                                }
                            }
                            hashMap2.put(WXStreamModule.STATUS_TEXT, Status.getStatusText(wXResponse.statusCode));
                        } else {
                            HashMap<String, Object> hashMap4 = hashMap2;
                            hashMap4.put(WXStreamModule.STATUS, -1);
                            hashMap4.put(WXStreamModule.STATUS_TEXT, "ERR_CONNECT_FAILED");
                            if (wXResponse != null) {
                                hashMap2.put("errorMsg", wXResponse.errorMsg);
                            } else {
                                hashMap2.put("errorMsg", "response \u4e3a\u7a7a");
                            }
                        }
                        hashMap2.put("headers", map);
                        jSCallback.invoke(hashMap2);
                    }
                }
            };
            super.sendRequest((Options)object, (ResponseCallback)object2, jSCallback2, string2, string3);
            return;
        }
        if (jSCallback != null) {
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2 = hashMap;
            new HashMap<String, Object>().put("ok", Boolean.FALSE);
            hashMap2.put(STATUS_TEXT, "ERR_INVALID_REQUEST");
            jSCallback.invoke(hashMap2);
        }
    }

    Object parseData(String string2, Options.Type type) {
        if (type == Options.Type.json) {
            return JSONObject.parse((String)string2);
        }
        if (type == Options.Type.jsonp) {
            if (string2 != null && !string2.isEmpty()) {
                int n = string2.indexOf("(") + 1;
                int n2 = string2.lastIndexOf(")");
                if (n != 0 && n < n2 && n2 > 0) {
                    return JSONObject.parse((String)string2.substring(n, n2));
                }
                return new JSONObject();
            }
            return new JSONObject();
        }
        return string2;
    }

    private static interface ResponseCallback {
        public void onResponse(WXResponse var1, Map<String, String> var2);
    }

    private static class StreamHttpListener
    implements IWXHttpAdapter.OnHttpListener {
        private ResponseCallback mCallback;
        private JSCallback mProgressCallback;
        private Map<String, Object> mResponse;
        private Map<String, String> mRespHeaders;

        private StreamHttpListener(ResponseCallback responseCallback, JSCallback jSCallback) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            v1.mResponse = hashMap2;
            v1.mCallback = responseCallback;
            v1.mProgressCallback = jSCallback;
        }

        @Override
        public void onHttpStart() {
            if (this.mProgressCallback != null) {
                StreamHttpListener streamHttpListener = this;
                streamHttpListener.mResponse.put("readyState", 1);
                streamHttpListener.mResponse.put("length", 0);
                streamHttpListener.mProgressCallback.invokeAndKeepAlive(new HashMap<String, Object>(this.mResponse));
            }
        }

        @Override
        public void onHttpUploadProgress(int n) {
        }

        @Override
        public void onHeadersReceived(int n, Map<String, List<String>> object) {
            HashMap<String, String> hashMap;
            StreamHttpListener streamHttpListener = this;
            streamHttpListener.mResponse.put("readyState", 2);
            streamHttpListener.mResponse.put(WXStreamModule.STATUS, n);
            Object object2 = hashMap;
            hashMap = new HashMap<String, String>();
            if (object != null) {
                for (Map.Entry entry : object.entrySet()) {
                    String string2;
                    if (((List)entry.getValue()).size() == 0) continue;
                    if (((List)entry.getValue()).size() == 1) {
                        string2 = entry.getKey() == null ? "_" : (String)entry.getKey();
                        object2.put(string2, (String)((List)entry.getValue()).get(0));
                        continue;
                    }
                    string2 = entry.getKey() == null ? "_" : (String)entry.getKey();
                    object2.put(string2, ((List)entry.getValue()).toString());
                }
            }
            this.mResponse.put("headers", object2);
            this.mRespHeaders = object2;
            object2 = this.mProgressCallback;
            if (object2 != null) {
                object2.invokeAndKeepAlive(new HashMap<String, Object>(this.mResponse));
            }
        }

        @Override
        public void onHttpResponseProgress(int n) {
            StreamHttpListener streamHttpListener = this;
            streamHttpListener.mResponse.put("length", n);
            JSCallback jSCallback = streamHttpListener.mProgressCallback;
            if (jSCallback != null) {
                jSCallback.invokeAndKeepAlive(new HashMap<String, Object>(this.mResponse));
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onHttpFinish(WXResponse var1_1) {
            block3: {
                var2_2 = this.mCallback;
                if (var2_2 != null) {
                    var2_2.onResponse((WXResponse)var1_1, this.mRespHeaders);
                }
                if (!WXEnvironment.isApkDebugable()) break block3;
                this = "WXStreamModule";
                if (var1_1 == null) ** GOTO lbl-1000
                var1_1 = var1_1.originalData;
                if (var1_1.originalData != null) {
                    var2_2 = v0;
                    v0 = new String((byte[])var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    var2_2 = "response data is NUll!";
                }
                WXLogUtils.d(this, (String)var2_2);
            }
        }
    }
}

