/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.layout.measurefunc;

import android.graphics.Canvas;
import android.os.Build;
import android.os.Looper;
import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AlignmentSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.TextDecorationSpan;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.dom.WXLineHeightSpan;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.layout.MeasureMode;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import io.dcloud.feature.uniapp.dom.AbsAttr;
import io.dcloud.feature.uniapp.dom.AbsStyle;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class TextContentBoxMeasurement
extends ContentBoxMeasurement {
    private static final Canvas DUMMY_CANVAS = new Canvas();
    private static final String ELLIPSIS = "\u2026";
    protected boolean mIsColorSet = false;
    private boolean hasBeenMeasured = false;
    protected int mColor;
    protected int mFontStyle = -1;
    protected int mFontWeight = -1;
    private int mNumberOfLines = -1;
    protected int mFontSize = -1;
    protected int mLineHeight = -1;
    private float previousWidth = Float.NaN;
    protected String mFontFamily = null;
    private String mText = null;
    private TextUtils.TruncateAt textOverflow;
    protected Layout.Alignment mAlignment;
    protected WXTextDecoration mTextDecoration = WXTextDecoration.NONE;
    protected TextPaint mTextPaint;
    @Nullable
    private Spanned spanned;
    @Nullable
    private Layout layout;
    private AtomicReference<Layout> atomicReference = new AtomicReference();

    public TextContentBoxMeasurement(WXComponent wXComponent) {
        super(wXComponent);
    }

    private void updateStyleAndText() {
        TextContentBoxMeasurement textContentBoxMeasurement = this;
        textContentBoxMeasurement.updateStyleImp(textContentBoxMeasurement.mComponent.getStyles());
        textContentBoxMeasurement.mText = AbsAttr.getValue(textContentBoxMeasurement.mComponent.getAttrs());
    }

    private void updateStyleImp(Map<String, Object> map) {
        if (map != null) {
            int n;
            if (map.containsKey("lines")) {
                n = AbsStyle.getLines(map);
                if (n <= 0) {
                    n = -1;
                }
                this.mNumberOfLines = n;
            }
            if (map.containsKey("fontSize")) {
                this.mFontSize = AbsStyle.getFontSize(map, this.mComponent.getInstance().getDefaultFontSize(), this.mComponent.getViewPortWidthForFloat());
            }
            if (map.containsKey("fontWeight")) {
                this.mFontWeight = AbsStyle.getFontWeight(map);
            }
            if (map.containsKey("fontStyle")) {
                this.mFontStyle = AbsStyle.getFontStyle(map);
            }
            if (map.containsKey("color")) {
                this.mColor = WXResourceUtils.getColor(AbsStyle.getTextColor(map));
                n = this.mColor != Integer.MIN_VALUE ? 1 : 0;
                this.mIsColorSet = n;
            }
            if (map.containsKey("textDecoration")) {
                this.mTextDecoration = AbsStyle.getTextDecoration(map);
            }
            if (map.containsKey("fontFamily")) {
                this.mFontFamily = AbsStyle.getFontFamily(map);
            }
            this.mAlignment = AbsStyle.getTextAlignment(map, this.mComponent.isLayoutRTL());
            this.textOverflow = AbsStyle.getTextOverflow(map);
            int n2 = AbsStyle.getLineHeight(map, this.mComponent.getViewPortWidthForFloat());
            if (n2 != -1) {
                this.mLineHeight = n2;
            }
        }
    }

    private float getTextWidth(TextPaint textPaint, float f, boolean bl) {
        if (this.mText == null) {
            if (bl) {
                return f;
            }
            return 0.0f;
        }
        if (!bl) {
            float f2 = Layout.getDesiredWidth((CharSequence)this.spanned, (TextPaint)textPaint);
            if (WXUtils.isUndefined(f) || f2 < f) {
                f = f2;
            }
        }
        return f;
    }

    @NonNull
    private Layout createLayout(float f, @Nullable Layout layout2) {
        int n;
        if (textContentBoxMeasurement4.previousWidth != f || layout2 == null) {
            StaticLayout staticLayout;
            layout2 = staticLayout;
            TextContentBoxMeasurement textContentBoxMeasurement = textContentBoxMeasurement4;
            Spanned spanned = textContentBoxMeasurement.spanned;
            TextPaint textPaint = textContentBoxMeasurement.mTextPaint;
            Spanned spanned2 = spanned;
            spanned = Layout.Alignment.ALIGN_NORMAL;
            staticLayout = new StaticLayout((CharSequence)spanned2, textPaint, (int)Math.ceil(f), (Layout.Alignment)spanned, 1.0f, 0.0f, false);
        }
        if ((n = textContentBoxMeasurement4.mNumberOfLines) != -1 && n > 0 && n < layout2.getLineCount()) {
            n = textContentBoxMeasurement4.mNumberOfLines;
            if (n > 1) {
                int n2;
                if ((n = layout2.getLineStart(n - 1)) < (n2 = layout2.getLineEnd(textContentBoxMeasurement4.mNumberOfLines - 1))) {
                    SpannableStringBuilder spannableStringBuilder;
                    if (n > 0) {
                        SpannableStringBuilder spannableStringBuilder2;
                        layout2 = spannableStringBuilder2;
                        spannableStringBuilder2 = new SpannableStringBuilder(textContentBoxMeasurement4.spanned.subSequence(0, n));
                    } else {
                        SpannableStringBuilder spannableStringBuilder3;
                        layout2 = spannableStringBuilder3;
                        spannableStringBuilder3 = new SpannableStringBuilder();
                    }
                    TextContentBoxMeasurement textContentBoxMeasurement = textContentBoxMeasurement4;
                    TextContentBoxMeasurement textContentBoxMeasurement2 = textContentBoxMeasurement4;
                    SpannableStringBuilder spannableStringBuilder4 = spannableStringBuilder;
                    spannableStringBuilder = new SpannableStringBuilder(textContentBoxMeasurement4.spanned.subSequence(n, n2));
                    TextPaint textPaint = textContentBoxMeasurement4.mTextPaint;
                    double d = f;
                    int n3 = (int)Math.ceil(d);
                    TextUtils.TruncateAt truncateAt = textContentBoxMeasurement2.textOverflow;
                    layout2.append((CharSequence)textContentBoxMeasurement2.truncate((Editable)spannableStringBuilder4, textPaint, n3, truncateAt));
                    textContentBoxMeasurement.adjustSpansRange(textContentBoxMeasurement.spanned, (Spannable)layout2);
                    textContentBoxMeasurement4.spanned = layout2;
                    TextContentBoxMeasurement textContentBoxMeasurement3 = textContentBoxMeasurement4;
                    TextContentBoxMeasurement textContentBoxMeasurement4 = textContentBoxMeasurement3.spanned;
                    spannableStringBuilder4 = textContentBoxMeasurement3.mTextPaint;
                    TextContentBoxMeasurement textContentBoxMeasurement5 = textContentBoxMeasurement4;
                    textContentBoxMeasurement4 = Layout.Alignment.ALIGN_NORMAL;
                    return new StaticLayout((CharSequence)((Object)textContentBoxMeasurement5), (TextPaint)spannableStringBuilder4, (int)Math.ceil(d), (Layout.Alignment)textContentBoxMeasurement4, 1.0f, 0.0f, false);
                }
            } else {
                int n4 = (int)Math.ceil(f);
                Spanned spanned = textContentBoxMeasurement4.spanned;
                int n5 = spanned.length();
                layout2 = textContentBoxMeasurement4.mTextPaint;
                return StaticLayout.Builder.obtain((CharSequence)spanned, (int)0, (int)n5, (TextPaint)layout2, (int)n4).setMaxLines(1).setEllipsize(TextUtils.TruncateAt.END).setEllipsizedWidth(n4).build();
            }
        }
        return layout2;
    }

    @NonNull
    private Spanned truncate(@Nullable Editable object, @NonNull TextPaint textPaint, int n, @Nullable TextUtils.TruncateAt truncateAt) {
        SpannedString spannedString;
        TextContentBoxMeasurement textContentBoxMeasurement = spannedString;
        spannedString = new SpannedString((CharSequence)"");
        if (!TextUtils.isEmpty((CharSequence)object) && object.length() > 0) {
            if (truncateAt != null) {
                Object object2 = object;
                object2.append((CharSequence)ELLIPSIS);
                for (Object object3 : object2.getSpans(0, object2.length(), Object.class)) {
                    int n2 = object.getSpanEnd(object3);
                    if (object.getSpanStart(object3) != 0 || n2 != object.length() - 1) continue;
                    Object object4 = object;
                    object4.removeSpan(object3);
                    n2 = object4.length();
                    int n3 = object4.getSpanFlags(object3);
                    object4.setSpan(object3, 0, n2, n3);
                }
            }
            while (object.length() > 1) {
                int n4 = object.length();
                int n5 = n4 - 1;
                if (truncateAt != null) {
                    n5 = n4 - 2;
                }
                int n6 = n5;
                object.delete(n6, n6 + 1);
                if (new StaticLayout((CharSequence)object, textPaint, n, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false).getLineCount() > 1) continue;
                break;
            }
        } else {
            object = textContentBoxMeasurement;
        }
        return object;
    }

    private void adjustSpansRange(@NonNull Spanned spanned, @NonNull Spannable spannable) {
        Spanned spanned2 = spanned;
        for (Object object : spanned2.getSpans(0, spanned2.length(), Object.class)) {
            int n = spanned.getSpanEnd(object);
            if (spanned.getSpanStart(object) != 0 || n != spanned.length()) continue;
            Spannable spannable2 = spannable;
            spannable2.removeSpan(object);
            n = spannable2.length();
            int n2 = spanned.getSpanFlags(object);
            spannable.setSpan(object, 0, n, n2);
        }
    }

    private void recalculateLayout(float f) {
        float f2;
        f = WXDomUtils.getContentWidth(textContentBoxMeasurement2.mComponent.getPadding(), textContentBoxMeasurement2.mComponent.getBorder(), f);
        if (f2 > 0.0f) {
            TextContentBoxMeasurement textContentBoxMeasurement = textContentBoxMeasurement2;
            textContentBoxMeasurement2.spanned = textContentBoxMeasurement.createSpanned(textContentBoxMeasurement.mText);
            if (textContentBoxMeasurement2.spanned != null) {
                TextContentBoxMeasurement textContentBoxMeasurement2 = textContentBoxMeasurement2.createLayout(f, textContentBoxMeasurement2.layout);
                v2.layout = textContentBoxMeasurement2;
                v2.previousWidth = textContentBoxMeasurement2.getWidth();
            } else {
                textContentBoxMeasurement2.previousWidth = 0.0f;
            }
        }
    }

    private boolean warmUpTextLayoutCache(Layout layout2) {
        boolean bl;
        try {
            layout2.draw(DUMMY_CANVAS);
            bl = true;
        }
        catch (Exception exception) {
            WXLogUtils.eTag("TextWarmUp", exception);
            bl = false;
        }
        return bl;
    }

    private void swap() {
        Layout layout2 = this.layout;
        if (layout2 != null) {
            this.atomicReference.set(layout2);
            this.layout = null;
        }
        this.hasBeenMeasured = false;
    }

    @Override
    public void layoutBefore() {
        TextContentBoxMeasurement textContentBoxMeasurement = this;
        textContentBoxMeasurement.mTextPaint = new TextPaint(1);
        textContentBoxMeasurement.hasBeenMeasured = false;
        textContentBoxMeasurement.updateStyleAndText();
        textContentBoxMeasurement.spanned = textContentBoxMeasurement.createSpanned(textContentBoxMeasurement.mText);
    }

    @Override
    public void measureInternal(float f, float f2, int n, int n2) {
        float f3;
        this.hasBeenMeasured = true;
        TextPaint textPaint = this.mTextPaint;
        boolean bl = n == MeasureMode.EXACTLY;
        float f4 = this.getTextWidth(textPaint, f, bl);
        if (f3 > 0.0f && this.spanned != null) {
            Layout layout2;
            this.layout = layout2 = this.createLayout(f4, null);
            this.previousWidth = layout2.getWidth();
            f = Float.isNaN(f) ? (float)this.layout.getWidth() : Math.min((float)this.layout.getWidth(), f);
            if (Float.isNaN(f2)) {
                f2 = this.layout.getHeight();
            }
        } else {
            if (n == (n = MeasureMode.UNSPECIFIED)) {
                f = 0.0f;
            }
            if (n2 == n) {
                f2 = 0.0f;
            }
        }
        TextContentBoxMeasurement textContentBoxMeasurement = this;
        textContentBoxMeasurement.mMeasureWidth = f;
        textContentBoxMeasurement.mMeasureHeight = f2;
    }

    @Override
    public void layoutAfter(float f, float f2) {
        WXComponent wXComponent = this.mComponent;
        if (wXComponent != null) {
            if (this.hasBeenMeasured) {
                if (this.layout != null && WXDomUtils.getContentWidth(wXComponent.getPadding(), this.mComponent.getBorder(), f) != this.previousWidth) {
                    this.recalculateLayout(f);
                }
            } else {
                TextContentBoxMeasurement textContentBoxMeasurement = this;
                textContentBoxMeasurement.updateStyleAndText();
                textContentBoxMeasurement.recalculateLayout(f);
            }
            this.hasBeenMeasured = false;
            Layout layout2 = this.layout;
            if (layout2 != null && !layout2.equals(this.atomicReference.get()) && Build.VERSION.SDK_INT >= 19 && Thread.currentThread() != Looper.getMainLooper().getThread()) {
                TextContentBoxMeasurement textContentBoxMeasurement = this;
                textContentBoxMeasurement.warmUpTextLayoutCache(textContentBoxMeasurement.layout);
            }
            this.swap();
            WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (TextContentBoxMeasurement.this.mComponent != null) {
                        TextContentBoxMeasurement.this.mComponent.updateExtra(TextContentBoxMeasurement.this.atomicReference.get());
                    }
                }
            }, this.mComponent.getInstanceId());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void forceRelayout() {
        TextContentBoxMeasurement textContentBoxMeasurement = this;
        textContentBoxMeasurement.layoutBefore();
        int n = MeasureMode.UNSPECIFIED;
        textContentBoxMeasurement.measure(textContentBoxMeasurement.previousWidth, Float.NaN, MeasureMode.EXACTLY, n);
        textContentBoxMeasurement.layoutAfter(textContentBoxMeasurement.previousWidth, Float.NaN);
    }

    @NonNull
    protected Spanned createSpanned(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            SpannableString spannableString;
            SpannableString spannableString2 = spannableString;
            spannableString2((CharSequence)string2);
            this.updateSpannable((Spannable)spannableString2, 17);
            return spannableString;
        }
        return new SpannableString((CharSequence)"");
    }

    protected void updateSpannable(Spannable spannable, int n) {
        AlignmentSpan.Standard standard;
        int n2 = spannable.length();
        int n3 = this.mFontSize;
        if (n3 == -1) {
            this.mTextPaint.setTextSize((float)this.mComponent.getInstance().getDefaultFontSize());
        } else {
            this.mTextPaint.setTextSize((float)n3);
        }
        n3 = this.mLineHeight;
        if (n3 != -1) {
            WXLineHeightSpan wXLineHeightSpan;
            WXLineHeightSpan wXLineHeightSpan2 = wXLineHeightSpan;
            wXLineHeightSpan = new WXLineHeightSpan(n3);
            this.setSpan(spannable, wXLineHeightSpan2, 0, n2, n);
        }
        Object object = standard;
        standard = new AlignmentSpan.Standard(this.mAlignment);
        this.setSpan(spannable, object, 0, n2, n);
        if (this.mFontStyle != -1 || this.mFontWeight != -1 || this.mFontFamily != null) {
            WXCustomStyleSpan wXCustomStyleSpan;
            object = wXCustomStyleSpan;
            int n4 = this.mFontStyle;
            String string2 = this.mFontFamily;
            wXCustomStyleSpan = new WXCustomStyleSpan(n4, this.mFontWeight, string2);
            this.setSpan(spannable, object, 0, n2, n);
        }
        if (this.mIsColorSet) {
            this.mTextPaint.setColor(this.mColor);
        }
        if ((object = this.mTextDecoration) == WXTextDecoration.UNDERLINE || object == WXTextDecoration.LINETHROUGH) {
            TextDecorationSpan textDecorationSpan;
            object = textDecorationSpan;
            textDecorationSpan = new TextDecorationSpan(this.mTextDecoration);
            this.setSpan(spannable, object, 0, n2, n);
        }
    }

    protected void setSpan(Spannable spannable, Object object, int n, int n2, int n3) {
        spannable.setSpan(object, n, n2, n3);
    }

    class SetSpanOperation {
        protected final int start;
        protected final int end;
        protected final int flag;
        protected final Object what;

        SetSpanOperation(int n, int n2, Object object) {
            this(n, n2, object, 17);
        }

        SetSpanOperation(int n, int n2, Object object, int n3) {
            this.start = n;
            this.end = n2;
            this.what = object;
            this.flag = n3;
        }

        public void execute(Spannable spannable) {
            SetSpanOperation setSpanOperation = object;
            Object object = setSpanOperation.what;
            int n = setSpanOperation.start;
            int n2 = setSpanOperation.end;
            int n3 = setSpanOperation.flag;
            spannable.setSpan(object, n, n2, n3);
        }
    }
}

