/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.app.Activity;
import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.CSSConstants;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.layout.MeasureMode;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.SoftKeyboardDetector;
import com.taobao.weex.ui.component.helper.WXTimeInputHelper;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.uniapp.dom.AbsStyle;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class AbstractEditComponent
extends WXComponent<WXEditText> {
    private static final int MAX_TEXT_FORMAT_REPEAT = 3;
    private final InputMethodManager mInputMethodManager;
    private String mBeforeText = "";
    private boolean mAutoFocus;
    private String mType = "text";
    private String mMax = null;
    private String mMin = null;
    private String mLastValue = "";
    private int mEditorAction = 6;
    private String mReturnKeyType = null;
    private List<TextView.OnEditorActionListener> mEditorActionListeners;
    private boolean mListeningKeyboard = false;
    private SoftKeyboardDetector.Unregister mUnregister;
    private boolean mIgnoreNextOnInputEvent = false;
    private boolean mKeepSelectionIndex = false;
    private TextFormatter mFormatter = null;
    private List<TextWatcher> mTextChangedListeners;
    private TextWatcher mTextChangedEventDispatcher;
    private int mFormatRepeatCount = 0;
    private TextPaint mPaint;
    private int mLineHeight;
    private WXComponent.OnClickListener mOnClickListener;

    public AbstractEditComponent(WXSDKInstance object, WXVContainer wXVContainer, boolean bl, BasicComponentData basicComponentData) {
        super((WXSDKInstance)object, wXVContainer, bl, basicComponentData);
        ContentBoxMeasurement contentBoxMeasurement;
        WXComponent.OnClickListener onClickListener;
        TextPaint textPaint;
        object = textPaint;
        textPaint = new TextPaint();
        this.mPaint = object;
        this.mLineHeight = -1;
        object = onClickListener;
        onClickListener = new WXComponent.OnClickListener(){

            @Override
            public void onHostViewClick() {
                String string2 = string3.AbstractEditComponent.this.mType;
                string2.hashCode();
                if (!string2.equals("date")) {
                    if (string2.equals("time")) {
                        3 v0 = string3;
                        v0.AbstractEditComponent.this.hideSoftKeyboard();
                        if (v0.AbstractEditComponent.this.getParent() != null) {
                            string3.AbstractEditComponent.this.getParent().interceptFocus();
                        }
                        WXTimeInputHelper.pickTime(string3.AbstractEditComponent.this);
                    }
                } else {
                    3 v1 = string3;
                    v1.AbstractEditComponent.this.hideSoftKeyboard();
                    if (v1.AbstractEditComponent.this.getParent() != null) {
                        string3.AbstractEditComponent.this.getParent().interceptFocus();
                    }
                    3 v2 = string3;
                    String string3 = v2.AbstractEditComponent.this.mMin;
                    WXTimeInputHelper.pickDate(string3.AbstractEditComponent.this.mMax, string3, v2.AbstractEditComponent.this);
                }
            }
        };
        this.mOnClickListener = object;
        this.mInputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        object = contentBoxMeasurement;
        contentBoxMeasurement = new ContentBoxMeasurement(){

            @Override
            public void measureInternal(float f, float f2, int n, int n2) {
                if (CSSConstants.isUndefined(f) || n == MeasureMode.UNSPECIFIED) {
                    f = 0.0f;
                }
                this.mMeasureWidth = f;
                this.mMeasureHeight = AbstractEditComponent.this.getMeasureHeight();
            }

            @Override
            public void layoutBefore() {
                AbstractEditComponent.this.updateStyleAndAttrs();
            }

            @Override
            public void layoutAfter(float f, float f2) {
            }
        };
        this.setContentBoxMeasurement((ContentBoxMeasurement)object);
    }

    private void applyOnClickListener() {
        AbstractEditComponent abstractEditComponent = this;
        abstractEditComponent.addClickListener(abstractEditComponent.mOnClickListener);
    }

    private void fireEvent(String string2, String string3) {
        if (string2 != null) {
            HashMap<String, String> hashMap;
            HashMap<String, Object> hashMap2;
            HashMap<String, Object> hashMap3;
            HashMap<String, Object> hashMap4 = hashMap3;
            new HashMap<String, Object>(2).put("value", string3);
            hashMap4.put("timeStamp", System.currentTimeMillis());
            HashMap<String, Object> hashMap5 = hashMap2;
            hashMap2 = new HashMap<String, Object>();
            HashMap<String, String> hashMap6 = hashMap;
            new HashMap<String, String>().put("value", string3);
            hashMap2.put("attrs", hashMap6);
            AbstractEditComponent abstractEditComponent = string4;
            String string4 = abstractEditComponent.getInstanceId();
            WXSDKManager.getInstance().fireEvent(string4, abstractEditComponent.getRef(), string2, hashMap4, hashMap5);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getInputType(String string2) {
        String string3 = string2;
        string3.hashCode();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 1793702779: {
                if (!string2.equals("datetime")) break;
                n = 8;
                break;
            }
            case 1216985755: {
                if (!string2.equals("password")) break;
                n = 7;
                break;
            }
            case 96619420: {
                if (!string2.equals("email")) break;
                n = 6;
                break;
            }
            case 3560141: {
                if (!string2.equals("time")) break;
                n = 5;
                break;
            }
            case 3556653: {
                if (!string2.equals("text")) break;
                n = 4;
                break;
            }
            case 3076014: {
                if (!string2.equals("date")) break;
                n = 3;
                break;
            }
            case 116079: {
                if (!string2.equals("url")) break;
                n = 2;
                break;
            }
            case 114715: {
                if (!string2.equals("tel")) break;
                n = 1;
                break;
            }
            case -1034364087: {
                if (!string2.equals("number")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return 1;
            }
            case 8: {
                return 4;
            }
            case 7: {
                int n2 = 129;
                if (this.getHostView() == null) return n2;
                ((WXEditText)this.getHostView()).setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                return n2;
            }
            case 6: {
                return 33;
            }
            case 5: {
                int n2 = 0;
                if (this.getHostView() == null) return n2;
                ((WXEditText)this.getHostView()).setFocusable(false);
                return n2;
            }
            case 3: {
                int n3 = 0;
                ((WXEditText)this.getHostView()).setFocusable(false);
                return n3;
            }
            case 2: {
                return 17;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 8194;
            }
        }
    }

    private boolean showSoftKeyboard() {
        if (this.getHostView() == null) {
            return false;
        }
        ((WXEditText)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                AbstractEditComponent.this.mInputMethodManager.showSoftInput(AbstractEditComponent.this.getHostView(), 1);
            }
        }), 100L);
        return true;
    }

    private void hideSoftKeyboard() {
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    AbstractEditComponent.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)AbstractEditComponent.this.getHostView()).getWindowToken(), 0);
                }
            }), 16L);
        }
    }

    private int getTextAlign(String string2) {
        int n = this.isLayoutRTL() ? 0x800005 : 0x800003;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return n;
        }
        if (string2.equals("left")) {
            n = 0x800003;
        } else if (string2.equals("center")) {
            n = 17;
        } else if (string2.equals("right")) {
            n = 0x800005;
        }
        return n;
    }

    private void decideSoftKeyboard() {
        Context context;
        Object t = this.getHostView();
        if (t != null && (context = this.getContext()) != null && context instanceof Activity) {
            t.postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    View view = ((Activity)context).getCurrentFocus();
                    if (view != null && !(view instanceof EditText) && !view.isFocused()) {
                        AbstractEditComponent.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)AbstractEditComponent.this.getHostView()).getWindowToken(), 0);
                    }
                }
            }), 16L);
        }
    }

    private void addKeyboardListener(WXEditText wXEditText) {
        if (wXEditText == null) {
            return;
        }
        if ((wXEditText = wXEditText.getContext()) != null && wXEditText instanceof Activity) {
            this.mUnregister = SoftKeyboardDetector.registerKeyboardEventListener((Activity)wXEditText, new SoftKeyboardDetector.OnKeyboardEventListener(){
                final /* synthetic */ Context val$context;
                {
                    this.val$context = context;
                }

                @Override
                public void onKeyboardEvent(boolean bl) {
                    if (AbstractEditComponent.this.mListeningKeyboard) {
                        if (AbstractEditComponent.this.getInstance() != null && !AbstractEditComponent.this.getInstance().isDestroy()) {
                            HashMap<String, Object> hashMap;
                            HashMap<String, Object> hashMap2 = hashMap;
                            hashMap2(1);
                            hashMap.put("isShow", bl);
                            if (bl) {
                                Rect rect;
                                13 v1 = this;
                                Rect rect2 = rect;
                                rect = new Rect();
                                ((Activity)v1.val$context).getWindow().getDecorView().getWindowVisibleDisplayFrame(rect2);
                                hashMap2.put("keyboardSize", Float.valueOf(WXViewUtils.getWebPxByWidth((float)(WXViewUtils.getScreenHeight(v1.val$context) - (rect2.bottom - rect2.top)), AbstractEditComponent.this.getInstance().getInstanceViewPortWidthWithFloat())));
                            }
                            AbstractEditComponent.this.fireEvent("keyboard", hashMap2);
                        } else {
                            return;
                        }
                    }
                    if (!bl) {
                        AbstractEditComponent.this.blur();
                    }
                }
            });
        }
    }

    private PatternWrapper parseToPattern(String string2, String string3) {
        if (string2 != null && string3 != null) {
            if (!Pattern.compile("/[\\S]+/[i]?[m]?[g]?").matcher(string2).matches()) {
                WXLogUtils.w("WXInput", "Illegal js pattern syntax: " + string2);
                return null;
            }
            String string4 = string2;
            int n = 0;
            String string5 = string4.substring(string4.lastIndexOf("/") + 1);
            String string6 = string2;
            int n2 = string6.indexOf("/") + 1;
            String string7 = string6.substring(n2, string6.lastIndexOf("/"));
            if (string5.contains("i")) {
                n = 2;
            }
            if (string5.contains("m")) {
                n |= 0x20;
            }
            boolean bl = string5.contains("g");
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(string7, n);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                WXLogUtils.w("WXInput", "Pattern syntax error: " + string7);
            }
            if (pattern == null) {
                return null;
            }
            PatternWrapper patternWrapper = new PatternWrapper();
            PatternWrapper.access$2102(patternWrapper, bl);
            PatternWrapper.access$2202(patternWrapper, pattern);
            PatternWrapper.access$2302(patternWrapper, string3);
            return patternWrapper;
        }
        return null;
    }

    static /* synthetic */ int access$902(AbstractEditComponent abstractEditComponent, int n) {
        abstractEditComponent.mFormatRepeatCount = n;
        return n;
    }

    static /* synthetic */ String access$1002(AbstractEditComponent abstractEditComponent, String string2) {
        abstractEditComponent.mLastValue = string2;
        return string2;
    }

    static /* synthetic */ boolean access$1302(AbstractEditComponent abstractEditComponent, boolean bl) {
        abstractEditComponent.mIgnoreNextOnInputEvent = bl;
        return bl;
    }

    static /* synthetic */ String access$1402(AbstractEditComponent abstractEditComponent, String string2) {
        abstractEditComponent.mBeforeText = string2;
        return string2;
    }

    @Override
    protected void layoutDirectionDidChanged(boolean n) {
        AbstractEditComponent abstractEditComponent = this;
        n = abstractEditComponent.getTextAlign((String)abstractEditComponent.getStyles().get("textAlign"));
        if (n <= 0) {
            n = 0x800003;
        }
        if (this.getHostView() instanceof WXEditText) {
            ((WXEditText)this.getHostView()).setGravity(n | this.getVerticalGravity());
        }
    }

    protected final float getMeasuredLineHeight() {
        int n = this.mLineHeight;
        return n != -1 && n > 0 ? (float)n : this.mPaint.getFontMetrics(null);
    }

    protected float getMeasureHeight() {
        return this.getMeasuredLineHeight();
    }

    protected void updateStyleAndAttrs() {
        if (this.getStyles().size() > 0) {
            int n;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            String string2 = null;
            if (this.getStyles().containsKey("fontSize")) {
                AbstractEditComponent abstractEditComponent = this;
                n2 = abstractEditComponent.getInstance().getDefaultFontSize();
                n2 = AbsStyle.getFontSize(this.getStyles(), n2, abstractEditComponent.getViewPortWidthForFloat());
            }
            if (this.getStyles().containsKey("fontFamily")) {
                string2 = AbsStyle.getFontFamily(this.getStyles());
            }
            if (this.getStyles().containsKey("fontStyle")) {
                n3 = AbsStyle.getFontStyle(this.getStyles());
            }
            if (this.getStyles().containsKey("fontWeight")) {
                n4 = AbsStyle.getFontWeight(this.getStyles());
            }
            if ((n = AbsStyle.getLineHeight(this.getStyles(), this.getViewPortWidthForFloat())) != -1) {
                this.mLineHeight = n;
            }
            if (n2 != -1) {
                this.mPaint.setTextSize((float)n2);
            }
            if (string2 != null) {
                TypefaceUtil.applyFontStyle((Paint)this.mPaint, n3, n4, string2);
            }
        }
    }

    @Override
    protected WXEditText initComponentHostView(@NonNull Context context) {
        WXEditText wXEditText;
        WXEditText wXEditText2 = wXEditText;
        wXEditText2(context, this.getInstanceId());
        this.appleStyleAfterCreated(wXEditText2);
        return wXEditText;
    }

    @Override
    protected void onHostViewInitialized(WXEditText wXEditText) {
        WXComponent.OnFocusChangeListener onFocusChangeListener;
        AbstractEditComponent abstractEditComponent = this;
        super.onHostViewInitialized(wXEditText);
        WXComponent.OnFocusChangeListener onFocusChangeListener2 = onFocusChangeListener;
        onFocusChangeListener = new WXComponent.OnFocusChangeListener(){

            @Override
            public void onFocusChange(boolean bl) {
                if (!bl) {
                    AbstractEditComponent.this.decideSoftKeyboard();
                }
                AbstractEditComponent.this.setPseudoClassStatus(":focus", bl);
            }
        };
        abstractEditComponent.addFocusChangeListener(onFocusChangeListener2);
        abstractEditComponent.addKeyboardListener(wXEditText);
    }

    @Override
    protected boolean isConsumeTouch() {
        return this.isDisabled() ^ true;
    }

    protected int getVerticalGravity() {
        return 16;
    }

    protected void appleStyleAfterCreated(final WXEditText wXEditText) {
        TextWatcher textWatcher;
        AbstractEditComponent abstractEditComponent = this;
        int n = abstractEditComponent.getTextAlign((String)abstractEditComponent.getStyles().get("textAlign"));
        if (n <= 0) {
            n = 0x800003;
        }
        wXEditText.setGravity(n | this.getVerticalGravity());
        n = WXResourceUtils.getColor("#999999");
        if (n != Integer.MIN_VALUE) {
            wXEditText.setHintTextColor(n);
        }
        TextWatcher textWatcher2 = textWatcher;
        this.mTextChangedEventDispatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                if (iterator.AbstractEditComponent.this.mTextChangedListeners != null) {
                    Iterator iterator = iterator.AbstractEditComponent.this.mTextChangedListeners.iterator();
                    while (iterator.hasNext()) {
                        ((TextWatcher)iterator.next()).beforeTextChanged(charSequence, n, n2, n3);
                    }
                }
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                if (iterator.AbstractEditComponent.this.mFormatter != null) {
                    4 v0 = iterator;
                    String string2 = v0.AbstractEditComponent.this.mFormatter.recover(charSequence.toString());
                    string2 = v0.AbstractEditComponent.this.mFormatter.format(string2);
                    if (!string2.equals(charSequence.toString()) && iterator.AbstractEditComponent.this.mFormatRepeatCount < 3) {
                        Iterator iterator = iterator;
                        AbstractEditComponent abstractEditComponent = iterator.AbstractEditComponent.this;
                        AbstractEditComponent.access$902(abstractEditComponent, abstractEditComponent.mFormatRepeatCount + 1);
                        n = iterator.wXEditText.getSelectionStart();
                        int n4 = iterator.AbstractEditComponent.this.mFormatter.format(iterator.AbstractEditComponent.this.mFormatter.recover(charSequence.subSequence(0, n).toString())).length();
                        iterator.wXEditText.setText(string2);
                        iterator.wXEditText.setSelection(n4);
                        return;
                    }
                    AbstractEditComponent.access$902(iterator.AbstractEditComponent.this, 0);
                }
                if (iterator.AbstractEditComponent.this.mTextChangedListeners != null) {
                    Iterator iterator = iterator.AbstractEditComponent.this.mTextChangedListeners.iterator();
                    while (iterator.hasNext()) {
                        ((TextWatcher)iterator.next()).onTextChanged(charSequence, n, n2, n3);
                    }
                }
            }

            public void afterTextChanged(Editable editable) {
                if (iterator.AbstractEditComponent.this.mTextChangedListeners != null) {
                    Iterator iterator = iterator.AbstractEditComponent.this.mTextChangedListeners.iterator();
                    while (iterator.hasNext()) {
                        ((TextWatcher)iterator.next()).afterTextChanged(editable);
                    }
                }
            }
        };
        wXEditText.addTextChangedListener(textWatcher2);
        wXEditText.setTextSize(0, AbsStyle.getFontSize(this.getStyles(), this.getInstance().getDefaultFontSize(), this.getInstance().getInstanceViewPortWidthWithFloat()));
    }

    @Override
    public void addEvent(String string2) {
        AbstractEditComponent abstractEditComponent = this;
        super.addEvent(string2);
        if (abstractEditComponent.getHostView() != null && !TextUtils.isEmpty((CharSequence)string2)) {
            Object object = (TextView)this.getHostView();
            if (string2.equals("change")) {
                TextView.OnEditorActionListener onEditorActionListener;
                WXComponent.OnFocusChangeListener onFocusChangeListener;
                AbstractEditComponent abstractEditComponent2 = this;
                Object object2 = onFocusChangeListener;
                onFocusChangeListener = new WXComponent.OnFocusChangeListener(){
                    final /* synthetic */ TextView val$text;
                    {
                        this.val$text = textView;
                    }

                    @Override
                    public void onFocusChange(boolean bl) {
                        if (bl) {
                            AbstractEditComponent.access$1002(AbstractEditComponent.this, this.val$text.getText().toString());
                        } else {
                            CharSequence charSequence = this.val$text.getText();
                            if (charSequence == null) {
                                charSequence = "";
                            }
                            if (!charSequence.toString().equals(AbstractEditComponent.this.mLastValue)) {
                                5 v0 = this;
                                v0.AbstractEditComponent.this.fireEvent("change", charSequence.toString());
                                AbstractEditComponent.access$1002(v0.AbstractEditComponent.this, this.val$text.getText().toString());
                            }
                        }
                    }
                };
                abstractEditComponent2.addFocusChangeListener((WXComponent.OnFocusChangeListener)object2);
                object2 = onEditorActionListener;
                onEditorActionListener = new TextView.OnEditorActionListener(){
                    final /* synthetic */ TextView val$text;
                    {
                        this.val$text = textView;
                    }

                    public boolean onEditorAction(TextView object, int n, KeyEvent keyEvent) {
                        if (n == AbstractEditComponent.this.mEditorAction) {
                            object = this.val$text.getText();
                            if (object == null) {
                                object = "";
                            }
                            if (!object.toString().equals(AbstractEditComponent.this.mLastValue)) {
                                6 v0 = this;
                                v0.AbstractEditComponent.this.fireEvent("change", object.toString());
                                AbstractEditComponent.access$1002(v0.AbstractEditComponent.this, this.val$text.getText().toString());
                            }
                            if (AbstractEditComponent.this.getParent() != null) {
                                AbstractEditComponent.this.getParent().interceptFocus();
                            }
                            AbstractEditComponent.this.hideSoftKeyboard();
                            return true;
                        }
                        return false;
                    }
                };
                abstractEditComponent2.addEditorActionListener((TextView.OnEditorActionListener)object2);
            } else if (string2.equals("input")) {
                TextWatcher textWatcher;
                object = textWatcher;
                textWatcher = new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }

                    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                        if (AbstractEditComponent.this.mIgnoreNextOnInputEvent) {
                            7 v0 = this;
                            AbstractEditComponent.access$1302(v0.AbstractEditComponent.this, false);
                            AbstractEditComponent.access$1402(v0.AbstractEditComponent.this, charSequence.toString());
                            return;
                        }
                        if (AbstractEditComponent.this.mBeforeText.equals(charSequence.toString())) {
                            return;
                        }
                        7 v1 = this;
                        AbstractEditComponent.access$1402(v1.AbstractEditComponent.this, charSequence.toString());
                        v1.AbstractEditComponent.this.fireEvent("input", charSequence.toString());
                    }

                    public void afterTextChanged(Editable editable) {
                    }
                };
                this.addTextChangedListener((TextWatcher)object);
            }
            if ("return".equals(string2)) {
                TextView.OnEditorActionListener onEditorActionListener;
                object = onEditorActionListener;
                onEditorActionListener = new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                        if (n == AbstractEditComponent.this.mEditorAction) {
                            HashMap<String, Object> hashMap;
                            HashMap<String, Object> hashMap2 = hashMap;
                            hashMap2(2);
                            hashMap2.put("returnKeyType", AbstractEditComponent.this.mReturnKeyType);
                            hashMap.put("value", textView.getText().toString());
                            AbstractEditComponent.this.fireEvent("return", hashMap2);
                            return true;
                        }
                        return false;
                    }
                };
                this.addEditorActionListener((TextView.OnEditorActionListener)object);
            }
            if ("keyboard".equals(string2)) {
                this.mListeningKeyboard = true;
            }
            return;
        }
    }

    public void performOnChange(String string2) {
        if (this.getEvents() != null) {
            String string3 = ((AbstractCollection)this.getEvents()).contains("change") ? "change" : null;
            this.fireEvent(string3, string2);
        }
    }

    @Override
    protected boolean setProperty(String object, Object object2) {
        int n;
        block69: {
            int n2;
            String string2 = object;
            string2.hashCode();
            n = -1;
            switch (string2.hashCode()) {
                default: {
                    break block69;
                }
                case 1667607689: {
                    if (((String)object).equals("autofocus")) {
                        n2 = 16;
                        break;
                    }
                    break block69;
                }
                case 1625554645: {
                    if (((String)object).equals("allowCopyPaste")) {
                        n2 = 15;
                        break;
                    }
                    break block69;
                }
                case 947486441: {
                    if (((String)object).equals("returnKeyType")) {
                        n2 = 14;
                        break;
                    }
                    break block69;
                }
                case 914346044: {
                    if (((String)object).equals("singleline")) {
                        n2 = 13;
                        break;
                    }
                    break block69;
                }
                case 598246771: {
                    if (((String)object).equals("placeholder")) {
                        n2 = 12;
                        break;
                    }
                    break block69;
                }
                case 365601008: {
                    if (((String)object).equals("fontSize")) {
                        n2 = 11;
                        break;
                    }
                    break block69;
                }
                case 270940796: {
                    if (((String)object).equals("disabled")) {
                        n2 = 10;
                        break;
                    }
                    break block69;
                }
                case 124732746: {
                    if (((String)object).equals("maxlength")) {
                        n2 = 9;
                        break;
                    }
                    break block69;
                }
                case 102977279: {
                    if (((String)object).equals("lines")) {
                        n2 = 8;
                        break;
                    }
                    break block69;
                }
                case 94842723: {
                    if (((String)object).equals("color")) {
                        n2 = 7;
                        break;
                    }
                    break block69;
                }
                case 3575610: {
                    if (((String)object).equals("type")) {
                        n2 = 6;
                        break;
                    }
                    break block69;
                }
                case 108114: {
                    if (((String)object).equals("min")) {
                        n2 = 5;
                        break;
                    }
                    break block69;
                }
                case 107876: {
                    if (((String)object).equals("max")) {
                        n2 = 4;
                        break;
                    }
                    break block69;
                }
                case -791400086: {
                    if (((String)object).equals("maxLength")) {
                        n2 = 3;
                        break;
                    }
                    break block69;
                }
                case -1065511464: {
                    if (((String)object).equals("textAlign")) {
                        n2 = 2;
                        break;
                    }
                    break block69;
                }
                case -1576785488: {
                    if (((String)object).equals("placeholderColor")) {
                        n2 = 1;
                        break;
                    }
                    break block69;
                }
                case -1898657397: {
                    if (!((String)object).equals("keepSelectionIndex")) break block69;
                    n2 = 0;
                }
            }
            n = n2;
        }
        switch (n) {
            default: {
                return super.setProperty((String)object, object2);
            }
            case 16: {
                object = WXUtils.getBoolean(object2, null);
                if (object != null) {
                    this.setAutofocus((Boolean)object);
                }
                return true;
            }
            case 15: {
                boolean bl = WXUtils.getBoolean(object2, Boolean.TRUE);
                if (this.getHostView() != null) {
                    ((WXEditText)this.getHostView()).setAllowCopyPaste(bl);
                }
                return true;
            }
            case 14: {
                this.setReturnKeyType(String.valueOf(object2));
                return true;
            }
            case 13: {
                object = WXUtils.getBoolean(object2, null);
                if (object != null) {
                    this.setSingleLine((Boolean)object);
                }
                return true;
            }
            case 12: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setPlaceholder((String)object);
                }
                return true;
            }
            case 11: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setFontSize((String)object);
                }
                return true;
            }
            case 10: {
                object = WXUtils.getBoolean(object2, null);
                if (object != null && this.mHost != null) {
                    if (((Boolean)object).booleanValue()) {
                        ((WXEditText)this.mHost).setFocusable(false);
                        ((WXEditText)this.mHost).setFocusableInTouchMode(false);
                    } else {
                        ((WXEditText)this.mHost).setFocusableInTouchMode(true);
                        ((WXEditText)this.mHost).setFocusable(true);
                    }
                }
                return true;
            }
            case 9: {
                object = WXUtils.getInteger(object2, null);
                if (object != null) {
                    this.setMaxLength((Integer)object);
                }
                return true;
            }
            case 8: {
                object = WXUtils.getInteger(object2, null);
                if (object != null) {
                    this.setLines((Integer)object);
                }
                return true;
            }
            case 7: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setColor((String)object);
                }
                return true;
            }
            case 6: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setType((String)object);
                }
                return true;
            }
            case 5: {
                this.setMin(String.valueOf(object2));
                return true;
            }
            case 4: {
                this.setMax(String.valueOf(object2));
                return true;
            }
            case 3: {
                object = WXUtils.getInteger(object2, null);
                if (object != null) {
                    this.setMaxLength((Integer)object);
                }
                return true;
            }
            case 2: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setTextAlign((String)object);
                }
                return true;
            }
            case 1: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setPlaceholderColor((String)object);
                }
                return true;
            }
            case 0: 
        }
        this.mKeepSelectionIndex = WXUtils.getBoolean(object2, Boolean.FALSE);
        return true;
    }

    @WXComponentProp(name="returnKeyType")
    public void setReturnKeyType(String string2) {
        if (this.getHostView() != null && !string2.equals(this.mReturnKeyType)) {
            this.mReturnKeyType = string2;
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1544803905: {
                    if (!string2.equals("default")) break;
                    n = 5;
                    break;
                }
                case 3526536: {
                    if (!string2.equals("send")) break;
                    n = 4;
                    break;
                }
                case 3377907: {
                    if (!string2.equals("next")) break;
                    n = 3;
                    break;
                }
                case 3089282: {
                    if (!string2.equals("done")) break;
                    n = 2;
                    break;
                }
                case 3304: {
                    if (!string2.equals("go")) break;
                    n = 1;
                    break;
                }
                case -906336856: {
                    if (!string2.equals("search")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 5: {
                    this.mEditorAction = 0;
                    break;
                }
                case 4: {
                    this.mEditorAction = 4;
                    break;
                }
                case 3: {
                    this.mEditorAction = 5;
                    break;
                }
                case 2: {
                    this.mEditorAction = 6;
                    break;
                }
                case 1: {
                    this.mEditorAction = 2;
                    break;
                }
                case 0: {
                    this.mEditorAction = 3;
                }
            }
            AbstractEditComponent abstractEditComponent = this;
            abstractEditComponent.blur();
            ((WXEditText)abstractEditComponent.getHostView()).setImeOptions(this.mEditorAction);
            return;
        }
    }

    @WXComponentProp(name="placeholder")
    public void setPlaceholder(String string2) {
        if (string2 != null && this.getHostView() != null) {
            ((WXEditText)this.getHostView()).setHint(string2);
            return;
        }
    }

    @WXComponentProp(name="placeholderColor")
    public void setPlaceholderColor(String string2) {
        int n;
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)string2) && (n = WXResourceUtils.getColor(string2)) != Integer.MIN_VALUE) {
            ((WXEditText)this.getHostView()).setHintTextColor(n);
        }
    }

    @WXComponentProp(name="type")
    public void setType(String string2) {
        Log.e((String)"weex", (String)("setType=" + string2));
        if (string2 != null && this.getHostView() != null && !this.mType.equals(string2)) {
            AbstractEditComponent abstractEditComponent = this;
            abstractEditComponent.mType = string2;
            AbstractEditComponent abstractEditComponent2 = this;
            ((EditText)abstractEditComponent.getHostView()).setInputType(abstractEditComponent2.getInputType(abstractEditComponent2.mType));
            string2 = abstractEditComponent.mType;
            string2.hashCode();
            if (string2.equals("date") || string2.equals("time")) {
                this.applyOnClickListener();
            }
            return;
        }
    }

    @WXComponentProp(name="autofocus")
    public void setAutofocus(boolean bl) {
        if (this.getHostView() == null) {
            return;
        }
        AbstractEditComponent abstractEditComponent = this;
        abstractEditComponent.mAutoFocus = bl;
        EditText editText = (EditText)abstractEditComponent.getHostView();
        if (abstractEditComponent.mAutoFocus) {
            EditText editText2 = editText;
            editText2.setFocusable(true);
            editText2.requestFocus();
            editText2.setFocusableInTouchMode(true);
            this.showSoftKeyboard();
        } else {
            this.hideSoftKeyboard();
        }
    }

    @WXComponentProp(name="value")
    public void setValue(String string2) {
        WXEditText wXEditText = (WXEditText)this.getHostView();
        if (wXEditText == null) {
            return;
        }
        if (TextUtils.equals((CharSequence)wXEditText.getText(), (CharSequence)string2)) {
            return;
        }
        this.mIgnoreNextOnInputEvent = true;
        int n = wXEditText.getSelectionStart();
        wXEditText.setText(string2);
        if (!this.mKeepSelectionIndex) {
            n = string2.length();
        }
        if (string2 == null) {
            n = 0;
        }
        wXEditText.setSelection(n);
    }

    @WXComponentProp(name="color")
    public void setColor(String string2) {
        int n;
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)string2) && (n = WXResourceUtils.getColor(string2)) != Integer.MIN_VALUE) {
            ((WXEditText)this.getHostView()).setTextColor(n);
        }
    }

    @WXComponentProp(name="fontSize")
    public void setFontSize(String string2) {
        if (this.getHostView() != null && string2 != null) {
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2 = hashMap;
            new HashMap<String, Object>(1).put("fontSize", string2);
            ((WXEditText)this.getHostView()).setTextSize(0, AbsStyle.getFontSize(hashMap2, this.getInstance().getDefaultFontSize(), this.getInstance().getInstanceViewPortWidthWithFloat()));
        }
    }

    @WXComponentProp(name="textAlign")
    public void setTextAlign(String string2) {
        int n = this.getTextAlign(string2);
        if (n > 0) {
            ((WXEditText)this.getHostView()).setGravity(n | this.getVerticalGravity());
        }
    }

    @WXComponentProp(name="singleline")
    public void setSingleLine(boolean bl) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setSingleLine(bl);
    }

    @WXComponentProp(name="lines")
    public void setLines(int n) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setLines(n);
    }

    @WXComponentProp(name="maxLength")
    public void setMaxLength(int n) {
        InputFilter.LengthFilter lengthFilter;
        if (abstractEditComponent.getHostView() == null) {
            return;
        }
        WXEditText wXEditText = (WXEditText)abstractEditComponent.getHostView();
        AbstractEditComponent abstractEditComponent = lengthFilter;
        lengthFilter = new InputFilter.LengthFilter(n);
        wXEditText.setFilters(new InputFilter[]{abstractEditComponent});
    }

    @WXComponentProp(name="maxlength")
    @Deprecated
    public void setMaxlength(int n) {
        this.setMaxLength(n);
    }

    @WXComponentProp(name="max")
    public void setMax(String string2) {
        this.mMax = string2;
    }

    @WXComponentProp(name="min")
    public void setMin(String string2) {
        this.mMin = string2;
    }

    @JSMethod
    public void blur() {
        WXEditText wXEditText = (WXEditText)this.getHostView();
        if (wXEditText != null && wXEditText.hasFocus()) {
            if (this.getParent() != null) {
                this.getParent().interceptFocus();
            }
            wXEditText.clearFocus();
            this.hideSoftKeyboard();
        }
    }

    @JSMethod
    public void focus() {
        WXEditText wXEditText = (WXEditText)this.getHostView();
        if (wXEditText != null && !wXEditText.hasFocus()) {
            if (this.getParent() != null) {
                this.getParent().ignoreFocus();
            }
            WXEditText wXEditText2 = wXEditText;
            wXEditText2.requestFocus();
            wXEditText2.setFocusable(true);
            wXEditText2.setFocusableInTouchMode(true);
            this.showSoftKeyboard();
        }
    }

    @Override
    protected Object convertEmptyProperty(String string2, Object object) {
        String string3 = string2;
        string3.hashCode();
        if (!string3.equals("color")) {
            if (!string2.equals("fontSize")) {
                return super.convertEmptyProperty(string2, object);
            }
            return this.getInstance().getDefaultFontSize();
        }
        return "black";
    }

    @JSMethod
    public void setSelectionRange(int n, int n2) {
        EditText editText = (EditText)this.getHostView();
        if (editText != null) {
            int n3 = ((WXEditText)this.getHostView()).length();
            if (n <= n3 && n2 <= n3) {
                this.focus();
                editText.setSelection(n, n2);
            } else {
                return;
            }
        }
    }

    @JSMethod
    public void getSelectionRange(String string2) {
        HashMap<String, Integer> hashMap;
        HashMap<String, Integer> hashMap2 = hashMap;
        hashMap = new HashMap<String, Integer>(2);
        EditText editText = (EditText)this.getHostView();
        if (editText != null) {
            EditText editText2 = editText;
            int n = editText2.getSelectionStart();
            int n2 = editText2.getSelectionEnd();
            if (!editText2.hasFocus()) {
                n = 0;
                n2 = 0;
            }
            hashMap2.put("selectionStart", n);
            hashMap2.put("selectionEnd", n2);
        }
        WXBridgeManager.getInstance().callback(this.getInstanceId(), string2, hashMap2, false);
    }

    @JSMethod
    public void setTextFormatter(JSONObject object) {
        block9: {
            TextFormatter textFormatter;
            AbstractEditComponent abstractEditComponent = textFormatter2;
            JSONObject jSONObject = object;
            JSONObject jSONObject2 = jSONObject;
            JSONObject jSONObject3 = jSONObject;
            JSONObject jSONObject4 = jSONObject;
            object = jSONObject.getString("formatRule");
            Object object2 = jSONObject2.getString("formatReplace");
            String string2 = jSONObject3.getString("recoverRule");
            String string3 = jSONObject4.getString("recoverReplace");
            object = abstractEditComponent.parseToPattern((String)object, (String)object2);
            object2 = ((AbstractEditComponent)((Object)textFormatter2)).parseToPattern(string2, string3);
            if (object == null || object2 == null) break block9;
            AbstractEditComponent abstractEditComponent2 = textFormatter2;
            TextFormatter textFormatter2 = textFormatter;
            try {
                textFormatter = new TextFormatter((PatternWrapper)object, (PatternWrapper)object2);
                abstractEditComponent2.mFormatter = textFormatter2;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected final void addEditorActionListener(TextView.OnEditorActionListener onEditorActionListener) {
        Object object;
        if (onEditorActionListener != null && (object = (TextView)this.getHostView()) != null) {
            if (this.mEditorActionListeners == null) {
                TextView.OnEditorActionListener onEditorActionListener2;
                ArrayList arrayList;
                TextView textView = object;
                object = arrayList;
                arrayList = new ArrayList();
                this.mEditorActionListeners = object;
                object = onEditorActionListener2;
                onEditorActionListener2 = new TextView.OnEditorActionListener(){
                    private boolean handled = true;

                    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                        for (TextView.OnEditorActionListener onEditorActionListener : AbstractEditComponent.this.mEditorActionListeners) {
                            if (onEditorActionListener == null) continue;
                            this.handled &= onEditorActionListener.onEditorAction(textView, n, keyEvent);
                        }
                        return this.handled;
                    }
                };
                textView.setOnEditorActionListener((TextView.OnEditorActionListener)object);
            }
            this.mEditorActionListeners.add(onEditorActionListener);
        }
    }

    public final void addTextChangedListener(TextWatcher textWatcher) {
        if (this.mTextChangedListeners == null) {
            ArrayList<TextWatcher> arrayList;
            ArrayList<TextWatcher> arrayList2 = arrayList;
            arrayList = new ArrayList<TextWatcher>();
            this.mTextChangedListeners = arrayList2;
        }
        this.mTextChangedListeners.add(textWatcher);
    }

    @Override
    public void destroy() {
        SoftKeyboardDetector.Unregister unregister;
        AbstractEditComponent abstractEditComponent = this;
        super.destroy();
        if (abstractEditComponent.getHostView() != null) {
            ((WXEditText)this.getHostView()).destroy();
        }
        if ((unregister = this.mUnregister) != null) {
            try {
                unregister.execute();
                this.mUnregister = null;
            }
            catch (Throwable throwable) {
                WXLogUtils.w("Unregister throw ", throwable);
            }
        }
    }

    private static class TextFormatter {
        private PatternWrapper format;
        private PatternWrapper recover;

        private TextFormatter(PatternWrapper patternWrapper, PatternWrapper patternWrapper2) {
            this.format = patternWrapper;
            this.recover = patternWrapper2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String format(String string2) {
            block4: {
                Throwable throwable2;
                block5: {
                    PatternWrapper patternWrapper;
                    try {
                        patternWrapper = this.format;
                        if (patternWrapper == null) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    if (patternWrapper.global) {
                        return this.format.matcher.matcher(string2).replaceAll(this.format.replace);
                    }
                    return this.format.matcher.matcher(string2).replaceFirst(this.format.replace);
                }
                WXLogUtils.w("WXInput", "[format] " + throwable2.getMessage());
            }
            return string2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String recover(String string2) {
            block4: {
                Throwable throwable2;
                block5: {
                    PatternWrapper patternWrapper;
                    try {
                        patternWrapper = this.recover;
                        if (patternWrapper == null) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    if (patternWrapper.global) {
                        return this.recover.matcher.matcher(string2).replaceAll(this.recover.replace);
                    }
                    return this.recover.matcher.matcher(string2).replaceFirst(this.recover.replace);
                }
                WXLogUtils.w("WXInput", "[formatted] " + throwable2.getMessage());
            }
            return string2;
        }
    }

    private static class PatternWrapper {
        private boolean global = false;
        private Pattern matcher;
        private String replace;

        private PatternWrapper() {
        }

        static /* synthetic */ boolean access$2102(PatternWrapper patternWrapper, boolean bl) {
            patternWrapper.global = bl;
            return bl;
        }

        static /* synthetic */ Pattern access$2202(PatternWrapper patternWrapper, Pattern pattern) {
            patternWrapper.matcher = pattern;
            return pattern;
        }

        static /* synthetic */ String access$2302(PatternWrapper patternWrapper, String string2) {
            patternWrapper.replace = string2;
            return string2;
        }
    }

    private static interface ReturnTypes {
        public static final String DEFAULT = "default";
        public static final String GO = "go";
        public static final String NEXT = "next";
        public static final String SEARCH = "search";
        public static final String SEND = "send";
        public static final String DONE = "done";
    }
}

