/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.app.Activity;
import android.content.Context;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXImageQuality;
import com.taobao.weex.performance.WXAnalyzerDataTransfer;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXImageView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.ImageDrawable;
import com.taobao.weex.utils.ImgURIUtil;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewToImageUtil;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(lazyload=false)
public class WXImage
extends WXComponent<ImageView> {
    public static final String SUCCEED = "success";
    public static final String ERRORDESC = "errorDesc";
    private static final int WRITE_EXTERNAL_STORAGE_PERMISSION_REQUEST_CODE = 2;
    private static SingleFunctionParser.FlatMapper<Integer> BLUR_RADIUS_MAPPER = new SingleFunctionParser.FlatMapper<Integer>(){

        @Override
        public Integer map(String string2) {
            return WXUtils.getInteger(string2, 0);
        }
    };
    private String mSrc;
    private int mBlurRadius;
    private boolean mAutoRecycle = true;
    protected boolean mIsUni = false;
    private WXSDKInstance.FrameViewEventListener mFrameViewEventListener;
    private String preImgUrlStr = "";

    @Deprecated
    public WXImage(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, String string2, boolean bl, BasicComponentData basicComponentData) {
        this(wXSDKInstance, wXVContainer, basicComponentData);
    }

    public WXImage(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
    }

    private void setLocalSrc(Uri uri) {
        uri = ImgURIUtil.getDrawableFromLoaclSrc(this.getContext(), uri);
        if (uri != null && (this = (ImageView)this.getHostView()) != null) {
            this.setImageDrawable((Drawable)uri);
        }
    }

    private void runSrc(String string2) {
        if (this.getHostView() != null && this.getInstance() != null) {
            String string3;
            if (this.getInstance().getImageNetworkHandler() != null && !TextUtils.isEmpty((CharSequence)(string3 = this.getInstance().getImageNetworkHandler().fetchLocal(string2)))) {
                string2 = string3;
            }
            if (PdrUtil.isEmpty((Object)string2)) {
                return;
            }
            string3 = (ImageView)this.getHostView();
            if (string3 != null && string3.getDrawable() != null && !TextUtils.equals((CharSequence)this.mSrc, (CharSequence)string2)) {
                string3.setImageDrawable(null);
            }
            this.mSrc = string2;
            string2 = this.getInstance().rewriteUri(Uri.parse((String)string2), "image");
            if ("local".equals(string2.getScheme())) {
                this.setLocalSrc((Uri)string2);
            } else {
                WXImage wXImage = this;
                this.setRemoteSrc((Uri)string2, wXImage.parseBlurRadius(wXImage.getStyles().getBlur()));
            }
            return;
        }
    }

    private void setBlurRadius(@NonNull String string2, int n) {
        if (this.getInstance() != null && n != this.mBlurRadius && !"local".equals((string2 = this.getInstance().rewriteUri(Uri.parse((String)string2), "image")).getScheme())) {
            this.setRemoteSrc((Uri)string2, n);
        }
    }

    private int parseBlurRadius(@Nullable String string2) {
        if (string2 == null) {
            return 0;
        }
        try {
            List<Integer> list = new SingleFunctionParser<Integer>(string2, BLUR_RADIUS_MAPPER).parse("blur");
            if (list != null && !list.isEmpty()) {
                return (Integer)list.get(0);
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void setRemoteSrc(Uri object, int n) {
        WXImageStrategy wXImageStrategy;
        WXImageStrategy wXImageStrategy2 = wXImageStrategy;
        new WXImageStrategy((String)this.getInstanceId()).isClipping = true;
        boolean bl = this.getAttrs().getImageSharpen() == WXImageSharpen.SHARPEN;
        WXImageStrategy wXImageStrategy3 = wXImageStrategy2;
        wXImageStrategy3.isSharpen = bl;
        wXImageStrategy3.blurRadius = Math.max(0, n);
        this.mBlurRadius = n;
        object = object.toString();
        WXImage wXImage = this;
        wXImageStrategy2.setImageListener(wXImage.new MyImageListener(wXImage, (String)object));
        if (this.getAttrs().containsKey("autoCompression")) {
            wXImageStrategy2.setAutoCompression(WXUtils.getBoolean(this.getAttrs().get("autoCompression"), Boolean.TRUE));
        }
        String string2 = null;
        if (this.getAttrs().containsKey("placeholder")) {
            string2 = (String)this.getAttrs().get("placeholder");
        } else if (this.getAttrs().containsKey("placeHolder")) {
            string2 = (String)this.getAttrs().get("placeHolder");
        }
        if (string2 != null) {
            wXImageStrategy2.placeHolder = this.getInstance().rewriteUri(Uri.parse((String)string2), "image").toString();
        }
        wXImageStrategy2.instanceId = this.getInstanceId();
        this.setImage((String)object, wXImageStrategy2);
    }

    private void updateBorderRadius() {
        if (((WXComponent)object).getHostView() instanceof WXImageView) {
            Object object;
            WXImage wXImage = object;
            Object object2 = (WXImageView)wXImage.getHostView();
            BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(wXImage.getHostView());
            if (borderDrawable != null) {
                RectF rectF;
                BorderDrawable borderDrawable2 = borderDrawable;
                borderDrawable = rectF;
                WXImage wXImage2 = object;
                float f = WXDomUtils.getContentWidth(wXImage2);
                float f2 = WXDomUtils.getContentHeight(wXImage2);
                rectF = new RectF(0.0f, 0.0f, f, f2);
                object = borderDrawable2.getBorderInnerRadius((RectF)borderDrawable);
            } else {
                float[] fArray = new float[8];
                object = fArray;
                fArray[0] = 0.0f;
                fArray[1] = 0.0f;
                fArray[2] = 0.0f;
                fArray[3] = 0.0f;
                fArray[4] = 0.0f;
                fArray[5] = 0.0f;
                fArray[6] = 0.0f;
                fArray[7] = 0.0f;
            }
            WXImageView wXImageView = object2;
            wXImageView.setBorderRadius((float[])object);
            if (wXImageView.getDrawable() instanceof ImageDrawable && !Arrays.equals(((ImageDrawable)((Object)(object2 = (ImageDrawable)object2.getDrawable()))).getCornerRadii(), (float[])object)) {
                ((ImageDrawable)((Object)object2)).setCornerRadii((float[])object);
            }
        }
    }

    private void monitorImgSize(ImageView object, String string2) {
        if (object == null) {
            return;
        }
        Object object2 = ((WXComponent)object3).getInstance();
        if (object2 == null) {
            return;
        }
        Drawable drawable2 = object.getDrawable();
        if (object.getLayoutParams() != null && drawable2 != null) {
            Drawable drawable3 = drawable2;
            int n = drawable3.getIntrinsicHeight();
            int n2 = drawable3.getIntrinsicWidth();
            if (!((WXImage)object3).preImgUrlStr.equals(string2)) {
                ((WXImage)object3).preImgUrlStr = string2;
                if (n > 1081 && n2 > 721) {
                    ((WXSDKInstance)object2).getApmForInstance().updateDiffStats("wxLargeImgMaxCount", 1.0);
                    if (WXAnalyzerDataTransfer.isOpenPerformance) {
                        String string3 = n2 + "*" + n + "," + string2;
                        WXAnalyzerDataTransfer.transferPerformance(((WXComponent)object3).getInstanceId(), "details", "wxLargeImgMaxCount", string3);
                    }
                }
                long l = n * n2;
                long l2 = object.getMeasuredHeight() * object.getMeasuredWidth();
                if (l2 == 0L) {
                    return;
                }
                if ((double)l / (double)l2 > 1.2 && l - l2 > 1600L) {
                    WXSDKInstance wXSDKInstance = object2;
                    wXSDKInstance.getWXPerformance().wrongImgSizeCount += 1.0;
                    wXSDKInstance.getApmForInstance().updateDiffStats("wxWrongImgSizeCount", 1.0);
                    if (WXAnalyzerDataTransfer.isOpenPerformance) {
                        String string4 = ((WXComponent)object3).getInstanceId();
                        ImageView imageView = object;
                        Object object3 = n2;
                        object = n;
                        object2 = imageView.getMeasuredWidth();
                        Integer n3 = imageView.getMeasuredHeight();
                        Object[] objectArray = new Object[5];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = object3;
                        objectArray[1] = object;
                        objectArray[2] = object2;
                        objectArray[3] = n3;
                        objectArray[4] = string2;
                        object3 = StringUtil.format((String)"imgSize:[%d,%d],viewSize:[%d,%d],urL:%s", (Object[])objectArray2);
                        WXAnalyzerDataTransfer.transferPerformance(string4, "details", "wxWrongImgSizeCount", object3);
                    }
                }
            }
            return;
        }
    }

    @Override
    protected ImageView initComponentHostView(@NonNull Context context) {
        WXImageView wXImageView;
        WXImageView wXImageView2 = wXImageView;
        new WXImageView(context).setScaleType(ImageView.ScaleType.FIT_XY);
        if (Build.VERSION.SDK_INT >= 16) {
            wXImageView2.setCropToPadding(true);
        }
        WXImageView wXImageView3 = wXImageView2;
        wXImageView3.holdComponent(this);
        return wXImageView3;
    }

    @Override
    protected boolean setProperty(String string2, Object object) {
        String string3 = string2;
        string3.hashCode();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 2049757303: {
                if (!string2.equals("resizeMode")) break;
                n = 5;
                break;
            }
            case 1249477412: {
                if (!string2.equals("imageQuality")) break;
                n = 4;
                break;
            }
            case 114148: {
                if (!string2.equals("src")) break;
                n = 3;
                break;
            }
            case -934437708: {
                if (!string2.equals("resize")) break;
                n = 2;
                break;
            }
            case -1274492040: {
                if (!string2.equals("filter")) break;
                n = 1;
                break;
            }
            case -1285653259: {
                if (!string2.equals("autoBitmapRecycle")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return super.setProperty(string2, object);
            }
            case 5: {
                string2 = WXUtils.getString(object, null);
                if (string2 != null) {
                    this.setResizeMode(string2);
                }
                return true;
            }
            case 4: {
                return true;
            }
            case 3: {
                string2 = WXUtils.getString(object, null);
                if (string2 != null) {
                    this.setSrc(string2);
                }
                return true;
            }
            case 2: {
                string2 = WXUtils.getString(object, null);
                if (string2 != null) {
                    this.setResize(string2);
                }
                return true;
            }
            case 1: {
                int n2 = 0;
                if (object != null && object instanceof String) {
                    n2 = this.parseBlurRadius((String)object);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mSrc)) {
                    WXImage wXImage = this;
                    wXImage.setBlurRadius(wXImage.mSrc, n2);
                }
                return true;
            }
            case 0: 
        }
        this.mAutoRecycle = WXUtils.getBoolean(object, this.mAutoRecycle);
        if (!this.mAutoRecycle && this.getInstance() != null) {
            this.getInstance().getApmForInstance().updateDiffStats("wxImgUnRecycleCount", 1.0);
        }
        return true;
    }

    @Override
    public void refreshData(WXComponent wXComponent) {
        super.refreshData(wXComponent);
        if (wXComponent instanceof WXImage) {
            this.setSrc(wXComponent.getAttrs().getImageSrc());
        }
    }

    @WXComponentProp(name="resizeMode")
    public void setResizeMode(String string2) {
        WXImage wXImage = this;
        ((ImageView)wXImage.getHostView()).setScaleType(this.getResizeMode(string2));
        ((ImageView)wXImage.getHostView()).setImageDrawable(((ImageView)this.getHostView()).getDrawable());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected ImageView.ScaleType getResizeMode(String string2) {
        WXImage wXImage = ImageView.ScaleType.FIT_XY;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return wXImage;
        }
        String string3 = string2;
        string3.hashCode();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 951526612: {
                if (!string2.equals("contain")) break;
                n = 2;
                break;
            }
            case 94852023: {
                if (!string2.equals("cover")) break;
                n = 1;
                break;
            }
            case -1881872635: {
                if (!string2.equals("stretch")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                wXImage = ImageView.ScaleType.FIT_CENTER;
                break;
            }
            case 1: {
                wXImage = ImageView.ScaleType.CENTER_CROP;
            }
            case 0: 
        }
        return wXImage;
    }

    @WXComponentProp(name="resize")
    public void setResize(String string2) {
        this.setResizeMode(string2);
    }

    @WXComponentProp(name="src")
    public void setSrc(String string2) {
        this.runSrc(string2);
    }

    @Override
    public void recycled() {
        block4: {
            block3: {
                block2: {
                    WXImage wXImage = this;
                    super.recycled();
                    if (wXImage.getHostView() == null || this.getInstance() == null || this.getInstance().getImgLoaderAdapter() == null) break block2;
                    this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
                    break block3;
                }
                if (WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e("Error getImgLoaderAdapter() == null");
            }
            return;
        }
        throw new WXRuntimeException("getImgLoaderAdapter() == null");
    }

    public void autoReleaseImage() {
        if (this.mAutoRecycle && this.getHostView() != null && this.getInstance() != null && this.getInstance().getImgLoaderAdapter() != null) {
            this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
        }
    }

    public void autoRecoverImage() {
        if (this.mAutoRecycle) {
            WXImage wXImage = this;
            wXImage.setSrc(wXImage.mSrc);
        }
    }

    protected void setImage(String string2, WXImageStrategy wXImageStrategy) {
        IWXImgLoaderAdapter iWXImgLoaderAdapter = wXImage2.getInstance().getImgLoaderAdapter();
        if (iWXImgLoaderAdapter != null) {
            WXImage wXImage = wXImage2;
            WXImage wXImage2 = (ImageView)wXImage.getHostView();
            iWXImgLoaderAdapter.setImage(string2, (ImageView)wXImage2, wXImage.getImageQuality(), wXImageStrategy);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected WXImageQuality getImageQuality() {
        return this.getAttrs().getImageQuality();
    }

    @Override
    protected void onFinishLayout() {
        WXImage wXImage = this;
        super.onFinishLayout();
        wXImage.updateBorderRadius();
    }

    @Override
    public void updateProperties(Map<String, Object> map) {
        WXImage wXImage = this;
        super.updateProperties(map);
        wXImage.updateBorderRadius();
    }

    @JSMethod(uiThread=false)
    public void save(final JSCallback jSCallback) {
        Object object;
        if (ContextCompat.checkSelfPermission((Context)((WXComponent)object).getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0 && ((WXComponent)object).getContext() instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)((WXComponent)object).getContext()), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)2);
        }
        if (ContextCompat.checkSelfPermission((Context)((WXComponent)object).getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            if (jSCallback != null) {
                HashMap<String, Object> hashMap;
                object = hashMap;
                new HashMap<String, Object>().put(SUCCEED, Boolean.FALSE);
                object.put(ERRORDESC, "Permission denied: android.permission.WRITE_EXTERNAL_STORAGE");
                jSCallback.invoke(object);
            }
            return;
        }
        if (((WXComponent)object).mHost == null) {
            if (jSCallback != null) {
                HashMap<String, Object> hashMap;
                object = hashMap;
                new HashMap<String, Object>().put(SUCCEED, Boolean.FALSE);
                object.put(ERRORDESC, "Image component not initialized");
                jSCallback.invoke(object);
            }
            return;
        }
        Object object2 = ((WXImage)object).mSrc;
        if (object2 != null && !((String)object2).equals("")) {
            WXViewToImageUtil.OnImageSavedCallback onImageSavedCallback;
            object2 = onImageSavedCallback;
            onImageSavedCallback = new WXViewToImageUtil.OnImageSavedCallback(){

                @Override
                public void onSaveSucceed(String string2) {
                    if (hashMap2.jSCallback != null) {
                        HashMap<String, Boolean> hashMap;
                        2 v0 = hashMap2;
                        HashMap<String, Boolean> hashMap2 = hashMap;
                        new HashMap<String, Boolean>().put(WXImage.SUCCEED, Boolean.TRUE);
                        v0.jSCallback.invoke(hashMap2);
                    }
                }

                @Override
                public void onSaveFailed(String string2) {
                    if (hashMap2.jSCallback != null) {
                        HashMap<String, Object> hashMap;
                        2 v0 = hashMap2;
                        HashMap<String, Object> hashMap2 = hashMap;
                        new HashMap<String, Object>().put(WXImage.SUCCEED, Boolean.FALSE);
                        hashMap2.put(WXImage.ERRORDESC, string2);
                        v0.jSCallback.invoke(hashMap2);
                    }
                }
            };
            WXViewToImageUtil.generateImage(((WXComponent)object).mHost, 0, -460552, (WXViewToImageUtil.OnImageSavedCallback)object2);
            return;
        }
        if (jSCallback != null) {
            HashMap<String, Object> hashMap;
            object = hashMap;
            new HashMap<String, Object>().put(SUCCEED, Boolean.FALSE);
            object.put(ERRORDESC, "Image does not have the correct src");
            jSCallback.invoke(object);
        }
    }

    @Override
    public void destroy() {
        if (this.getHostView() != null && this.getInstance() != null && this.getHostView() instanceof WXImageView && this.getInstance().getImgLoaderAdapter() != null) {
            this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
        }
        super.destroy();
    }

    public void onImageFinish(boolean bl, Map map) {
    }

    public class MyImageListener
    implements WXImageStrategy.ImageListener {
        private WeakReference<WXImage> wxImageWeakReference;
        private String rewritedStr;

        MyImageListener(WXImage wXImage2, String string2) {
            WeakReference<WXImage> weakReference;
            WeakReference<WXImage> weakReference2 = weakReference;
            weakReference = new WeakReference<WXImage>(wXImage2);
            v1.wxImageWeakReference = weakReference2;
            v1.rewritedStr = string2;
        }

        @Override
        public void onImageFinish(String object, ImageView imageView, boolean bl, Map map) {
            HashMap hashMap;
            HashMap<String, Object> hashMap2;
            object = (WXImage)((MyImageListener)((Object)hashMap4)).wxImageWeakReference.get();
            if (object == null) {
                return;
            }
            if (map == null) {
                HashMap<String, Boolean> hashMap3;
                HashMap<String, Boolean> hashMap4 = hashMap3;
                new HashMap<String, Boolean>().put(WXImage.SUCCEED, Boolean.FALSE);
                ((WXComponent)object).fireEvent("error", (Map<String, Object>)hashMap4);
                return;
            }
            ((WXImage)object).onImageFinish(bl, map);
            HashMap<String, Object> hashMap5 = hashMap2;
            hashMap2 = new HashMap<String, Object>();
            HashMap hashMap6 = hashMap;
            hashMap6(2);
            hashMap6.put("width", map.get("width"));
            hashMap.put("height", map.get("height"));
            if (((MyImageListener)((Object)hashMap4)).WXImage.this.mIsUni) {
                if (!bl && ((WXComponent)object).containsEvent("error")) {
                    HashMap<String, Object> hashMap7 = hashMap5;
                    hashMap7.put(WXImage.SUCCEED, bl);
                    hashMap7.put("detail", hashMap6);
                    ((WXComponent)object).fireEvent("error", hashMap5);
                }
                if (bl && ((WXComponent)object).containsEvent("load")) {
                    HashMap<String, Object> hashMap8 = hashMap5;
                    hashMap8.put(WXImage.SUCCEED, bl);
                    hashMap8.put("detail", hashMap6);
                    ((WXComponent)object).fireEvent("load", hashMap5);
                }
            } else if (((WXComponent)object).containsEvent("load")) {
                HashMap<String, Object> hashMap9 = hashMap5;
                hashMap9.put(WXImage.SUCCEED, bl);
                hashMap9.put("detail", hashMap6);
                ((WXComponent)object).fireEvent("load", hashMap5);
            }
            ((WXImage)object).monitorImgSize(imageView, ((MyImageListener)((Object)hashMap4)).rewritedStr);
        }
    }

    public static interface Measurable {
        public int getNaturalWidth();

        public int getNaturalHeight();
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
            return new WXImage(wXSDKInstance, wXVContainer, basicComponentData);
        }
    }
}

