/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.BaseFrameLayout;
import com.taobao.weex.ui.view.WXBaseCircleIndicator;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class WXSlider
extends WXVContainer<FrameLayout> {
    public static final String INDEX = "index";
    public static final String INFINITE = "infinite";
    private boolean isInfinite = true;
    Map<String, Object> params;
    private float offsetXAccuracy;
    private int initIndex;
    private boolean keepIndex;
    private Runnable initRunnable;
    WXCircleViewPager mViewPager;
    protected WXIndicator mIndicator;
    protected WXCirclePageAdapter mAdapter;
    protected boolean mShowIndicators;
    protected ViewPager.OnPageChangeListener mPageChangeListener;

    @Deprecated
    public WXSlider(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, String string2, boolean bl, BasicComponentData basicComponentData) {
        this(wXSDKInstance, wXVContainer, basicComponentData);
    }

    public WXSlider(WXSDKInstance object, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super((WXSDKInstance)object, wXVContainer, basicComponentData);
        SliderPageChangeListener sliderPageChangeListener;
        HashMap hashMap;
        object = hashMap;
        hashMap = new HashMap();
        this.params = object;
        this.offsetXAccuracy = 0.1f;
        this.initIndex = -1;
        this.keepIndex = false;
        object = sliderPageChangeListener;
        sliderPageChangeListener = new SliderPageChangeListener();
        this.mPageChangeListener = object;
    }

    private int getInitIndex() {
        WXSlider wXSlider = this;
        int n = WXUtils.getInteger(wXSlider.getAttrs().get(INDEX), this.initIndex);
        WXCirclePageAdapter wXCirclePageAdapter = wXSlider.mAdapter;
        if (wXCirclePageAdapter != null && wXCirclePageAdapter.getCount() != 0) {
            if (n >= this.mAdapter.getRealCount()) {
                n %= this.mAdapter.getRealCount();
            }
            return n;
        }
        return 0;
    }

    private int getRealIndex(int n) {
        if (this.mAdapter.getRealCount() > 0) {
            if (n >= this.mAdapter.getRealCount()) {
                n = this.mAdapter.getRealCount() - 1;
            }
            if (this.isLayoutRTL()) {
                n = this.mAdapter.getRealCount() - 1 - n;
            }
        }
        return n;
    }

    private void hackTwoItemsInfiniteScroll() {
        WXCirclePageAdapter wXCirclePageAdapter;
        if (this.mViewPager != null && (wXCirclePageAdapter = this.mAdapter) != null) {
            if (this.isInfinite) {
                if (wXCirclePageAdapter.getRealCount() == 2) {
                    GestureDetector gestureDetector;
                    wXCirclePageAdapter = gestureDetector;
                    gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new FlingGestureListener(this.mViewPager));
                    this.mViewPager.setOnTouchListener(new View.OnTouchListener(){
                        final /* synthetic */ GestureDetector val$gestureDetector;
                        {
                            this.val$gestureDetector = gestureDetector;
                        }

                        public boolean onTouch(View view, MotionEvent motionEvent) {
                            return this.val$gestureDetector.onTouchEvent(motionEvent);
                        }
                    });
                } else {
                    this.mViewPager.setOnTouchListener(null);
                }
            }
            return;
        }
    }

    static /* synthetic */ int access$002(WXSlider wXSlider, int n) {
        wXSlider.initIndex = n;
        return n;
    }

    static /* synthetic */ Runnable access$302(WXSlider wXSlider, Runnable runnable) {
        wXSlider.initRunnable = runnable;
        return runnable;
    }

    @Override
    protected BaseFrameLayout initComponentHostView(@NonNull Context object) {
        WXCirclePageAdapter wXCirclePageAdapter;
        WXCircleViewPager wXCircleViewPager;
        WXCircleViewPager wXCircleViewPager2;
        FrameLayout.LayoutParams layoutParams;
        BaseFrameLayout baseFrameLayout;
        BaseFrameLayout baseFrameLayout2 = baseFrameLayout;
        baseFrameLayout = new BaseFrameLayout((Context)object);
        if (this.getAttrs() != null) {
            this.isInfinite = WXUtils.getBoolean(this.getAttrs().get(INFINITE), Boolean.TRUE);
        }
        BaseFrameLayout baseFrameLayout3 = baseFrameLayout2;
        WXSlider wXSlider = this;
        BaseFrameLayout baseFrameLayout4 = baseFrameLayout2;
        WXSlider wXSlider2 = this;
        baseFrameLayout2 = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        WXCircleViewPager wXCircleViewPager3 = wXCircleViewPager2 = wXCircleViewPager;
        wXCircleViewPager3((Context)object);
        this.mViewPager = wXCircleViewPager3;
        wXCircleViewPager.setCircle(this.isInfinite);
        wXSlider2.mViewPager.setLayoutParams((ViewGroup.LayoutParams)baseFrameLayout2);
        object = wXCirclePageAdapter;
        wXSlider2.mAdapter = new WXCirclePageAdapter(this.isInfinite);
        wXSlider2.mViewPager.setAdapter((PagerAdapter)object);
        baseFrameLayout4.addView((View)wXSlider2.mViewPager);
        wXSlider.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        wXSlider.registerActivityStateListener();
        return baseFrameLayout3;
    }

    @Override
    public ViewGroup.LayoutParams getChildLayoutParams(WXComponent wXComponent, View view, int n, int n2, int n3, int n4, int n5, int n6) {
        if ((view = view.getLayoutParams()) == null) {
            FrameLayout.LayoutParams layoutParams;
            view = layoutParams;
            layoutParams = new FrameLayout.LayoutParams(n, n2);
        } else {
            View view2 = view;
            view2.width = n;
            view2.height = n2;
        }
        if (view instanceof ViewGroup.MarginLayoutParams) {
            if (wXComponent instanceof WXIndicator) {
                this.setMarginsSupportRTL((ViewGroup.MarginLayoutParams)view, n3, n5, n4, n6);
            } else {
                this.setMarginsSupportRTL((ViewGroup.MarginLayoutParams)view, 0, 0, 0, 0);
            }
        }
        return view;
    }

    @Override
    public void addEvent(String object) {
        super.addEvent((String)object);
        if ("scroll".equals(object)) {
            SliderOnScrollListener sliderOnScrollListener;
            object = this.mViewPager;
            if (object == null) {
                return;
            }
            Object object2 = object;
            object = sliderOnScrollListener;
            sliderOnScrollListener = new SliderOnScrollListener(this);
            object2.addOnPageChangeListener((ViewPager.OnPageChangeListener)object);
        }
    }

    @Override
    public boolean containsGesture(WXGestureType wXGestureType) {
        return super.containsGesture(wXGestureType);
    }

    @Override
    public ViewGroup getRealView() {
        return this.mViewPager;
    }

    @Override
    public void addSubView(View object, int n) {
        WXCirclePageAdapter wXCirclePageAdapter;
        if (object != null && (wXCirclePageAdapter = this.mAdapter) != null) {
            if (object instanceof WXCircleIndicator) {
                return;
            }
            WXSlider wXSlider = this;
            wXCirclePageAdapter.addPageView((View)object);
            wXSlider.hackTwoItemsInfiniteScroll();
            if (wXSlider.initIndex != -1 && this.mAdapter.getRealCount() > this.initIndex) {
                if (this.initRunnable == null) {
                    Runnable runnable;
                    object = runnable;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            1 v0 = this;
                            WXSlider wXSlider = v0.WXSlider.this;
                            WXSlider.access$002(wXSlider, wXSlider.getInitIndex());
                            Object object = this = v0.WXSlider.this;
                            ((WXSlider)this).mViewPager.setCurrentItem(((WXSlider)object).getRealIndex(((WXSlider)object).initIndex));
                            WXSlider.access$002(v0.WXSlider.this, -1);
                            WXSlider.access$302(v0.WXSlider.this, null);
                        }
                    };
                    this.initRunnable = object;
                }
                WXSlider wXSlider2 = this;
                wXSlider2.mViewPager.removeCallbacks(this.initRunnable);
                wXSlider2.mViewPager.postDelayed(this.initRunnable, 50L);
            } else if (!this.keepIndex) {
                this.mViewPager.setCurrentItem(this.getRealIndex(0));
            }
            object = this.mIndicator;
            if (object != null) {
                ((WXCircleIndicator)((WXComponent)object).getHostView()).forceLayout();
                ((WXCircleIndicator)this.mIndicator.getHostView()).requestLayout();
            }
            return;
        }
    }

    @Override
    public void setLayout(WXComponent wXComponent) {
        WXCirclePageAdapter wXCirclePageAdapter = this.mAdapter;
        if (wXCirclePageAdapter != null) {
            wXCirclePageAdapter.setLayoutDirectionRTL(this.isLayoutRTL());
        }
        super.setLayout(wXComponent);
    }

    @Override
    public void remove(WXComponent wXComponent, boolean bl) {
        WXCirclePageAdapter wXCirclePageAdapter;
        if (wXComponent != null && wXComponent.getHostView() != null && (wXCirclePageAdapter = this.mAdapter) != null) {
            wXCirclePageAdapter.removePageView((View)wXComponent.getHostView());
            this.hackTwoItemsInfiniteScroll();
            super.remove(wXComponent, bl);
            return;
        }
    }

    @Override
    public void destroy() {
        WXSlider wXSlider = this;
        super.destroy();
        WXCircleViewPager wXCircleViewPager = wXSlider.mViewPager;
        if (wXCircleViewPager != null) {
            WXSlider wXSlider2 = this;
            wXCircleViewPager.stopAutoScroll();
            wXSlider2.mViewPager.removeAllViews();
            wXSlider2.mViewPager.destory();
        }
    }

    @Override
    public void onActivityResume() {
        WXSlider wXSlider = this;
        super.onActivityResume();
        WXCircleViewPager wXCircleViewPager = wXSlider.mViewPager;
        if (wXCircleViewPager != null && wXCircleViewPager.isAutoScroll()) {
            this.mViewPager.startAutoScroll();
        }
    }

    @Override
    public void onActivityStop() {
        WXSlider wXSlider = wXCircleViewPager;
        super.onActivityStop();
        WXCircleViewPager wXCircleViewPager = wXSlider.mViewPager;
        if (wXCircleViewPager != null) {
            wXCircleViewPager.pauseAutoScroll();
        }
    }

    public void addIndicator(WXIndicator object) {
        FrameLayout frameLayout = (FrameLayout)this.getHostView();
        if (frameLayout == null) {
            return;
        }
        this.mIndicator = object;
        if ((object = (WXCircleIndicator)((WXComponent)object).getHostView()) != null) {
            Object object2 = object;
            ((WXBaseCircleIndicator)object2).setCircleViewPager(this.mViewPager);
            frameLayout.addView((View)object2);
        }
    }

    @Override
    protected boolean setProperty(String object, Object object2) {
        String string2 = object;
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 1565939262: {
                if (!((String)object).equals("offsetXAccuracy")) break;
                n = 7;
                break;
            }
            case 1438608771: {
                if (!((String)object).equals("autoPlay")) break;
                n = 6;
                break;
            }
            case 996926241: {
                if (!((String)object).equals("showIndicators")) break;
                n = 5;
                break;
            }
            case 570418373: {
                if (!((String)object).equals("interval")) break;
                n = 4;
                break;
            }
            case 111972721: {
                if (!((String)object).equals("value")) break;
                n = 3;
                break;
            }
            case 100346066: {
                if (!((String)object).equals(INDEX)) break;
                n = 2;
                break;
            }
            case 66669991: {
                if (!((String)object).equals("scrollable")) break;
                n = 1;
                break;
            }
            case -1768064947: {
                if (!((String)object).equals("keepIndex")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return super.setProperty((String)object, object2);
            }
            case 7: {
                object = WXUtils.getFloat(object2, Float.valueOf(0.1f));
                if (((Float)object).floatValue() != 0.0f) {
                    this.setOffsetXAccuracy(((Float)object).floatValue());
                }
                return true;
            }
            case 6: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setAutoPlay((String)object);
                }
                return true;
            }
            case 5: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setShowIndicators((String)object);
                }
                return true;
            }
            case 4: {
                object = WXUtils.getInteger(object2, null);
                if (object != null) {
                    this.setInterval((Integer)object);
                }
                return true;
            }
            case 3: {
                object = WXUtils.getString(object2, null);
                if (object != null) {
                    this.setValue((String)object);
                }
                return true;
            }
            case 2: {
                object = WXUtils.getInteger(object2, null);
                if (object != null) {
                    this.setIndex((Integer)object);
                }
                return true;
            }
            case 1: {
                this.setScrollable(WXUtils.getBoolean(object2, Boolean.TRUE));
                return true;
            }
            case 0: 
        }
        this.keepIndex = WXUtils.getBoolean(object2, Boolean.FALSE);
        return true;
    }

    @Deprecated
    @WXComponentProp(name="value")
    public void setValue(String string2) {
        if (string2 != null && this.getHostView() != null) {
            try {
                this.setIndex(Integer.parseInt(string2));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                WXLogUtils.e("", numberFormatException);
                return;
            }
        }
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals("false")) {
            WXSlider wXSlider = this;
            wXSlider.mViewPager.stopAutoScroll();
            wXSlider.mViewPager.startAutoScroll();
        } else {
            this.mViewPager.stopAutoScroll();
        }
    }

    @WXComponentProp(name="showIndicators")
    public void setShowIndicators(String object) {
        this.mShowIndicators = !TextUtils.isEmpty((CharSequence)object) && !((String)object).equals("false");
        object = this.mIndicator;
        if (object == null) {
            return;
        }
        ((WXIndicator)object).setShowIndicators(this.mShowIndicators);
    }

    @WXComponentProp(name="interval")
    public void setInterval(int n) {
        WXCircleViewPager wXCircleViewPager = ((WXSlider)((Object)wXCircleViewPager)).mViewPager;
        if (wXCircleViewPager != null && n > 0) {
            wXCircleViewPager.setIntervalTime(n);
        }
    }

    @WXComponentProp(name="index")
    public void setIndex(int n) {
        Object object;
        if (((WXSlider)this).mViewPager != null && (object = ((WXSlider)this).mAdapter) != null) {
            if (n < ((WXCirclePageAdapter)((Object)object)).getRealCount() && n >= 0) {
                WXSlider wXSlider = this;
                n = wXSlider.getRealIndex(n);
                wXSlider.mViewPager.setCurrentItem(n);
                object = wXSlider.mIndicator;
                if (object != null && ((WXComponent)object).getHostView() != null && ((WXCircleIndicator)((WXSlider)this).mIndicator.getHostView()).getRealCurrentItem() != n) {
                    WXSlider wXSlider2 = this;
                    WXLogUtils.d("setIndex >>>> correction indicator to " + n);
                    ((WXCircleIndicator)wXSlider2.mIndicator.getHostView()).setRealCurrentItem(n);
                    ((WXCircleIndicator)wXSlider2.mIndicator.getHostView()).invalidate();
                    object = wXSlider2.mPageChangeListener;
                    if (object != null && (this = ((WXSlider)this).mAdapter) != null) {
                        object.onPageSelected(((WXCirclePageAdapter)((Object)this)).getFirst() + n);
                    }
                }
            } else {
                ((WXSlider)this).initIndex = n;
                return;
            }
        }
    }

    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean bl) {
        WXCircleViewPager wXCircleViewPager = this.mViewPager;
        if (wXCircleViewPager != null && this.mAdapter != null) {
            wXCircleViewPager.setScrollable(bl);
        }
    }

    @WXComponentProp(name="offsetXAccuracy")
    public void setOffsetXAccuracy(float f) {
        this.offsetXAccuracy = f;
    }

    protected class SliderPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private int lastPos = -1;

        protected SliderPageChangeListener() {
        }

        public void onPageScrolled(int n, float f, int n2) {
        }

        public void onPageSelected(int n) {
            WXCirclePageAdapter wXCirclePageAdapter;
            if (WXSlider.this.mAdapter.getRealPosition(n) == this.lastPos) {
                return;
            }
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("onPageSelected >>>>" + WXSlider.this.mAdapter.getRealPosition(n) + " lastPos: " + this.lastPos);
            }
            if ((wXCirclePageAdapter = WXSlider.this.mAdapter) != null && wXCirclePageAdapter.getRealCount() != 0) {
                SliderPageChangeListener sliderPageChangeListener = this;
                int n2 = sliderPageChangeListener.WXSlider.this.mAdapter.getRealPosition(n);
                if (sliderPageChangeListener.WXSlider.this.mChildren != null && n2 < WXSlider.this.mChildren.size()) {
                    if (((AbstractCollection)WXSlider.this.getEvents()).size() == 0) {
                        return;
                    }
                    String string2 = WXSlider.this.getRef();
                    if (((AbstractCollection)WXSlider.this.getEvents()).contains("change") && WXViewUtils.onScreenArea(WXSlider.this.getHostView())) {
                        HashMap<String, Integer> hashMap;
                        HashMap<String, Object> hashMap2;
                        WXSlider.this.params.put(WXSlider.INDEX, n2);
                        HashMap<String, Object> hashMap3 = hashMap2;
                        hashMap2 = new HashMap<String, Object>();
                        HashMap<String, Integer> hashMap4 = hashMap;
                        hashMap4();
                        hashMap.put(WXSlider.INDEX, n2);
                        hashMap2.put("attrs", hashMap4);
                        WXSDKManager.getInstance().fireEvent(WXSlider.this.getInstanceId(), string2, "change", WXSlider.this.params, hashMap3);
                    }
                    SliderPageChangeListener sliderPageChangeListener2 = this;
                    sliderPageChangeListener2.WXSlider.this.mViewPager.requestLayout();
                    ((FrameLayout)sliderPageChangeListener2.WXSlider.this.getHostView()).invalidate();
                    sliderPageChangeListener2.lastPos = sliderPageChangeListener2.WXSlider.this.mAdapter.getRealPosition(n);
                    return;
                }
                return;
            }
        }

        public void onPageScrollStateChanged(int n) {
            SliderPageChangeListener sliderPageChangeListener = (FrameLayout)sliderPageChangeListener.WXSlider.this.getHostView();
            if (sliderPageChangeListener != null) {
                sliderPageChangeListener.invalidate();
            }
        }
    }

    protected static class SliderOnScrollListener
    implements ViewPager.OnPageChangeListener {
        private float lastPositionOffset = 99.0f;
        private int selectedPosition;
        private WXSlider target;

        public SliderOnScrollListener(WXSlider wXSlider) {
            this.target = wXSlider;
            this.selectedPosition = wXSlider.mViewPager.superGetCurrentItem();
        }

        public void onPageScrolled(int n, float f, int n2) {
            float f2 = this.lastPositionOffset;
            if (f2 == 99.0f) {
                this.lastPositionOffset = f;
                return;
            }
            if (Math.abs(f - f2) >= this.target.offsetXAccuracy) {
                int n3 = this.selectedPosition;
                if (n == n3) {
                    HashMap<String, Object> hashMap;
                    HashMap<String, Object> hashMap2 = hashMap;
                    hashMap2(1);
                    hashMap.put("offsetXRatio", Float.valueOf(-f));
                    this.target.fireEvent("scroll", hashMap2);
                } else if (n < n3) {
                    HashMap<String, Object> hashMap;
                    HashMap<String, Object> hashMap3 = hashMap;
                    new HashMap<String, Object>(1).put("offsetXRatio", Float.valueOf(1.0f - f));
                    this.target.fireEvent("scroll", hashMap3);
                }
                this.lastPositionOffset = f;
            }
        }

        public void onPageSelected(int n) {
            this.selectedPosition = n;
        }

        public void onPageScrollStateChanged(int n) {
            if (n != 0) {
                if (n == 1) {
                    this.target.fireEvent("scrollstart");
                }
            } else {
                this.lastPositionOffset = 99.0f;
                this.target.fireEvent("scrollend");
            }
        }
    }

    private static class FlingGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_MIN_DISTANCE = WXViewUtils.dip2px(50.0f);
        private static final int SWIPE_MAX_OFF_PATH = WXViewUtils.dip2px(250.0f);
        private static final int SWIPE_THRESHOLD_VELOCITY = WXViewUtils.dip2px(200.0f);
        private WeakReference<WXCircleViewPager> pagerRef;

        FlingGestureListener(WXCircleViewPager wXCircleViewPager) {
            WeakReference<WXCircleViewPager> weakReference;
            Object object = weakReference;
            weakReference = new WeakReference<WXCircleViewPager>(wXCircleViewPager);
            v1.pagerRef = object;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            int n;
            block13: {
                int n2;
                float f3;
                WXCircleViewPager wXCircleViewPager = (WXCircleViewPager)((FlingGestureListener)((Object)wXCircleViewPager)).pagerRef.get();
                if (wXCircleViewPager == null) {
                    return false;
                }
                try {
                    float f4 = motionEvent.getY() - motionEvent2.getY();
                    if (Math.abs(f4) > (float)SWIPE_MAX_OFF_PATH) {
                        return false;
                    }
                    f3 = motionEvent.getX() - motionEvent2.getX();
                }
                catch (Exception exception) {
                    return false;
                }
                n = SWIPE_MIN_DISTANCE;
                if (f3 > (float)n2) {
                    if (!(Math.abs(f) > (float)SWIPE_THRESHOLD_VELOCITY)) break block13;
                    if (wXCircleViewPager.superGetCurrentItem() != 1) break block13;
                    wXCircleViewPager.setCurrentItem(0, false);
                    return true;
                }
            }
            float f5 = motionEvent2.getX() - motionEvent.getX();
            if (!(f5 > (float)n)) return false;
            if (!(Math.abs(f) > (float)SWIPE_THRESHOLD_VELOCITY)) return false;
            if (wXCircleViewPager.superGetCurrentItem() != 0) return false;
            wXCircleViewPager.setCurrentItem(1, false);
            return true;
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
            return new WXSlider(wXSDKInstance, wXVContainer, basicComponentData);
        }
    }
}

