/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.Layout;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.layout.measurefunc.TextContentBoxMeasurement;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.widget.TextWidget;
import com.taobao.weex.ui.view.WXTextView;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXLogUtils;

@Component(lazyload=false)
public class WXText
extends WXComponent<WXTextView>
implements FlatComponent<TextWidget> {
    private TextWidget mTextWidget;
    private BroadcastReceiver mTypefaceObserver;
    private String mFontFamily;

    @Deprecated
    public WXText(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, String string2, boolean bl, BasicComponentData basicComponentData) {
        this(wXSDKInstance, wXVContainer, basicComponentData);
    }

    public WXText(WXSDKInstance object, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        TextContentBoxMeasurement textContentBoxMeasurement;
        WXText wXText = this;
        super((WXSDKInstance)object, wXVContainer, basicComponentData);
        object = textContentBoxMeasurement;
        textContentBoxMeasurement = new TextContentBoxMeasurement(this);
        wXText.setContentBoxMeasurement((ContentBoxMeasurement)object);
    }

    private void registerTypefaceObserver(String string2) {
        if (WXEnvironment.getApplication() == null) {
            WXLogUtils.w("WXText", "ApplicationContent is null on register typeface observer");
            return;
        }
        this.mFontFamily = string2;
        if (this.mTypefaceObserver != null) {
            return;
        }
        this.mTypefaceObserver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                object = intent.getStringExtra("fontFamily");
                if (!WXText.this.mFontFamily.equals(object)) {
                    return;
                }
                if ((object = TypefaceUtil.getFontDO((String)object)) != null && ((FontDO)object).getTypeface() != null && WXText.this.getHostView() != null) {
                    intent = ((WXTextView)WXText.this.getHostView()).getTextLayout();
                    if (intent != null) {
                        intent.getPaint().setTypeface(((FontDO)object).getTypeface());
                    } else {
                        WXLogUtils.d("WXText", "Layout not created");
                    }
                    WXBridgeManager.getInstance().markDirty(WXText.this.getInstanceId(), WXText.this.getRef(), true);
                    WXText.this.forceRelayout();
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).registerReceiver(this.mTypefaceObserver, new IntentFilter("type_face_available"));
    }

    private void forceRelayout() {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ContentBoxMeasurement contentBoxMeasurement = contentBoxMeasurement.WXText.this.contentBoxMeasurement;
                if (contentBoxMeasurement instanceof TextContentBoxMeasurement) {
                    ((TextContentBoxMeasurement)contentBoxMeasurement).forceRelayout();
                }
            }
        });
    }

    @Override
    public boolean promoteToView(boolean bl) {
        if (this.getInstance().getFlatUIContext() != null) {
            return this.getInstance().getFlatUIContext().promoteToView(this, bl, WXText.class);
        }
        return false;
    }

    @Override
    @NonNull
    public TextWidget getOrCreateFlatWidget() {
        if (this.mTextWidget == null) {
            this.mTextWidget = new TextWidget(this.getInstance().getFlatUIContext());
        }
        return this.mTextWidget;
    }

    @Override
    public boolean isVirtualComponent() {
        return this.promoteToView(true) ^ true;
    }

    @Override
    protected WXTextView initComponentHostView(@NonNull Context context) {
        WXTextView wXTextView = new WXTextView(context);
        wXTextView.holdComponent(this);
        return wXTextView;
    }

    @Override
    public void updateExtra(Object object) {
        super.updateExtra(object);
        if (object instanceof Layout) {
            Layout layout2 = (Layout)object;
            if (!this.promoteToView(true)) {
                this.getOrCreateFlatWidget().updateTextDrawable(layout2);
            } else if (this.getHostView() != null && !object.equals(((WXTextView)this.getHostView()).getTextLayout())) {
                WXText wXText = this;
                ((WXTextView)wXText.getHostView()).setTextLayout(layout2);
                ((WXTextView)wXText.getHostView()).invalidate();
            }
        }
    }

    @Override
    protected void setAriaLabel(String string2) {
        if ((this = (WXTextView)((WXComponent)this).getHostView()) != null) {
            ((WXTextView)this).setAriaLabel(string2);
        }
    }

    @Override
    public void refreshData(WXComponent wXComponent) {
        super.refreshData(wXComponent);
        if (wXComponent instanceof WXText) {
            this.updateExtra(wXComponent.getExtra());
        }
    }

    @Override
    protected boolean setProperty(String string2, Object object) {
        String string3 = string2;
        string3.hashCode();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 365601008: {
                if (!string2.equals("fontSize")) break;
                n = 10;
                break;
            }
            case 261414991: {
                if (!string2.equals("textOverflow")) break;
                n = 9;
                break;
            }
            case 111972721: {
                if (!string2.equals("value")) break;
                n = 8;
                break;
            }
            case 102977279: {
                if (!string2.equals("lines")) break;
                n = 7;
                break;
            }
            case 94842723: {
                if (!string2.equals("color")) break;
                n = 6;
                break;
            }
            case -515807685: {
                if (!string2.equals("lineHeight")) break;
                n = 5;
                break;
            }
            case -734428249: {
                if (!string2.equals("fontWeight")) break;
                n = 4;
                break;
            }
            case -879295043: {
                if (!string2.equals("textDecoration")) break;
                n = 3;
                break;
            }
            case -1065511464: {
                if (!string2.equals("textAlign")) break;
                n = 2;
                break;
            }
            case -1224696685: {
                if (!string2.equals("fontFamily")) break;
                n = 1;
                break;
            }
            case -1550943582: {
                if (!string2.equals("fontStyle")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return super.setProperty(string2, object);
            }
            case 1: {
                if (object != null) {
                    this.registerTypefaceObserver(object.toString());
                }
                return true;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
        }
        return true;
    }

    @Override
    protected Object convertEmptyProperty(String string2, Object object) {
        String string3 = string2;
        string3.hashCode();
        if (!string3.equals("color")) {
            if (!string2.equals("fontSize")) {
                return super.convertEmptyProperty(string2, object);
            }
            return this.getInstance().getDefaultFontSize();
        }
        return "black";
    }

    @Override
    protected void createViewImpl() {
        if (this.promoteToView(true)) {
            super.createViewImpl();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (WXEnvironment.getApplication() != null && this.mTypefaceObserver != null) {
            WXLogUtils.d("WXText", "Unregister the typeface observer");
            LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).unregisterReceiver(this.mTypefaceObserver);
            this.mTypefaceObserver = null;
        }
    }

    @Override
    protected void layoutDirectionDidChanged(boolean bl) {
        this.forceRelayout();
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
            return new WXText(wXSDKInstance, wXVContainer, basicComponentData);
        }
    }
}

