/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;

public class WXPagerSnapHelper
extends PagerSnapHelper {
    @Nullable
    private OrientationHelper mVerticalHelper;
    @Nullable
    private OrientationHelper mHorizontalHelper;

    @NonNull
    private OrientationHelper getVerticalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    @NonNull
    private OrientationHelper getHorizontalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }

    private int distanceToStart(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View view, OrientationHelper orientationHelper) {
        return orientationHelper.getDecoratedStart(view) - orientationHelper.getStartAfterPadding();
    }

    @Nullable
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View view) {
        int[] nArray = new int[2];
        if (layoutManager.canScrollHorizontally()) {
            WXPagerSnapHelper wXPagerSnapHelper = wXPagerSnapHelper2;
            OrientationHelper orientationHelper = wXPagerSnapHelper.getHorizontalHelper(layoutManager);
            nArray[0] = wXPagerSnapHelper.distanceToStart(layoutManager, view, orientationHelper);
        } else {
            nArray[0] = 0;
        }
        if (layoutManager.canScrollVertically()) {
            WXPagerSnapHelper wXPagerSnapHelper = wXPagerSnapHelper2;
            WXPagerSnapHelper wXPagerSnapHelper2 = wXPagerSnapHelper.getVerticalHelper(layoutManager);
            nArray[1] = wXPagerSnapHelper.distanceToStart(layoutManager, view, (OrientationHelper)wXPagerSnapHelper2);
        } else {
            nArray[1] = 0;
        }
        return nArray;
    }
}

