/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.flat;

import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.RestrictTo;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.FlatGUIContext;
import com.taobao.weex.ui.flat.widget.AndroidViewWidget;
import com.taobao.weex.ui.flat.widget.Widget;
import java.util.LinkedList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class WidgetContainer<T extends ViewGroup>
extends WXVContainer<T> {
    protected List<Widget> widgets;

    public WidgetContainer(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
    }

    private void addFlatChild(Widget widget, int n) {
        if (this.widgets == null) {
            LinkedList<Widget> linkedList;
            LinkedList<Widget> linkedList2 = linkedList;
            linkedList = new LinkedList<Widget>();
            this.widgets = linkedList2;
        }
        if (n >= this.widgets.size()) {
            this.widgets.add(widget);
        } else {
            this.widgets.add(n, widget);
        }
        this.mountFlatGUI();
    }

    protected abstract void mountFlatGUI();

    protected abstract void unmountFlatGUI();

    public boolean intendToBeFlatContainer() {
        return false;
    }

    @Override
    public void createChildViewAt(int n) {
        if (this.intendToBeFlatContainer()) {
            Pair<WXComponent, Integer> pair = this.rearrangeIndexAndGetChild(n);
            Object object = pair.first;
            if (object != null) {
                FlatComponent flatComponent;
                object = (WXComponent)object;
                FlatGUIContext flatGUIContext = this.getInstance().getFlatUIContext();
                Object object2 = flatGUIContext.getFlatComponentAncestor(this);
                if (object2 == null || flatGUIContext.getAndroidViewWidget(this) != null) {
                    object2 = this;
                }
                flatGUIContext.register((WXComponent)object, (WidgetContainer)object2);
                if (object instanceof FlatComponent && !(flatComponent = (FlatComponent)object).promoteToView(false)) {
                    object2 = flatComponent.getOrCreateFlatWidget();
                } else {
                    AndroidViewWidget androidViewWidget;
                    WidgetContainer widgetContainer = object2;
                    object2 = androidViewWidget;
                    Object object3 = object;
                    ((AndroidViewWidget)object2)(flatGUIContext);
                    flatGUIContext.register((WXComponent)object, (AndroidViewWidget)object2);
                    ((WXComponent)object3).createView();
                    androidViewWidget.setContentView((View)((WXComponent)object3).getHostView());
                    widgetContainer.addSubView((View)((WXComponent)object).getHostView(), -1);
                }
                flatGUIContext.register((Widget)object2, (WXComponent)object);
                this.addFlatChild((Widget)object2, (Integer)pair.second);
            }
        } else {
            super.createChildViewAt(n);
        }
    }
}

