/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.viewpager.widget.ViewPager;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXViewUtils;

public class WXBaseCircleIndicator
extends FrameLayout
implements WXGestureObservable {
    private final Paint mPaintPage;
    private final Paint mPaintFill;
    private WXGesture wxGesture;
    private WXCircleViewPager mCircleViewPager;
    private float radius;
    private float circlePadding;
    private int pageColor;
    private int fillColor;
    private int realCurrentItem;
    private ViewPager.OnPageChangeListener mListener;

    public WXBaseCircleIndicator(Context context) {
        Paint paint;
        Paint paint2;
        WXBaseCircleIndicator wXBaseCircleIndicator = wXBaseCircleIndicator2;
        super(context);
        WXBaseCircleIndicator wXBaseCircleIndicator2 = paint2;
        paint2 = new Paint();
        wXBaseCircleIndicator.mPaintPage = wXBaseCircleIndicator2;
        wXBaseCircleIndicator2 = paint;
        paint = new Paint();
        wXBaseCircleIndicator.mPaintFill = wXBaseCircleIndicator2;
        wXBaseCircleIndicator.pageColor = -3355444;
        wXBaseCircleIndicator.fillColor = -12303292;
        wXBaseCircleIndicator.init();
    }

    private void init() {
        WXBaseCircleIndicator wXBaseCircleIndicator = this;
        wXBaseCircleIndicator.radius = WXViewUtils.dip2px(5.0f);
        wXBaseCircleIndicator.circlePadding = WXViewUtils.dip2px(5.0f);
        wXBaseCircleIndicator.pageColor = -3355444;
        wXBaseCircleIndicator.fillColor = -12303292;
        Paint.Style style = Paint.Style.FILL;
        wXBaseCircleIndicator.mPaintFill.setStyle(style);
        wXBaseCircleIndicator.mPaintFill.setAntiAlias(true);
        wXBaseCircleIndicator.mPaintPage.setAntiAlias(true);
        wXBaseCircleIndicator.mPaintPage.setColor(this.pageColor);
        wXBaseCircleIndicator.mPaintFill.setStyle(style);
        wXBaseCircleIndicator.mPaintFill.setColor(this.fillColor);
        wXBaseCircleIndicator.setWillNotDraw(false);
    }

    public WXBaseCircleIndicator(Context context, AttributeSet attributeSet) {
        Paint paint;
        Paint paint2;
        WXBaseCircleIndicator wXBaseCircleIndicator = wXBaseCircleIndicator2;
        super(context, attributeSet);
        WXBaseCircleIndicator wXBaseCircleIndicator2 = paint2;
        paint2 = new Paint();
        wXBaseCircleIndicator.mPaintPage = wXBaseCircleIndicator2;
        wXBaseCircleIndicator2 = paint;
        paint = new Paint();
        wXBaseCircleIndicator.mPaintFill = wXBaseCircleIndicator2;
        wXBaseCircleIndicator.pageColor = -3355444;
        wXBaseCircleIndicator.fillColor = -12303292;
        wXBaseCircleIndicator.init();
    }

    static /* synthetic */ int access$002(WXBaseCircleIndicator wXBaseCircleIndicator, int n) {
        wXBaseCircleIndicator.realCurrentItem = n;
        return n;
    }

    public void setCircleViewPager(WXCircleViewPager wXCircleViewPager) {
        this.mCircleViewPager = wXCircleViewPager;
        if (wXCircleViewPager != null) {
            if (this.mListener == null) {
                ViewPager.SimpleOnPageChangeListener simpleOnPageChangeListener;
                wXCircleViewPager = simpleOnPageChangeListener;
                simpleOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

                    public void onPageSelected(int n) {
                        1 v0 = this;
                        WXBaseCircleIndicator wXBaseCircleIndicator = v0.WXBaseCircleIndicator.this;
                        WXBaseCircleIndicator.access$002(wXBaseCircleIndicator, wXBaseCircleIndicator.mCircleViewPager.getRealCurrentItem());
                        v0.WXBaseCircleIndicator.this.invalidate();
                    }
                };
                this.mListener = wXCircleViewPager;
            }
            WXBaseCircleIndicator wXBaseCircleIndicator = this;
            wXBaseCircleIndicator.mCircleViewPager.addOnPageChangeListener(this.mListener);
            this.realCurrentItem = wXBaseCircleIndicator.mCircleViewPager.getRealCurrentItem();
            if (this.realCurrentItem < 0) {
                this.realCurrentItem = 0;
            }
        }
        this.requestLayout();
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setFillColor(int n) {
        this.fillColor = n;
        this.mPaintFill.setColor(n);
    }

    public void setPageColor(int n) {
        this.pageColor = n;
        this.mPaintPage.setColor(n);
    }

    public int getRealCurrentItem() {
        return this.realCurrentItem;
    }

    public void setRealCurrentItem(int n) {
        this.realCurrentItem = n;
        this.invalidate();
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        WXBaseCircleIndicator wXBaseCircleIndicator = this;
        boolean bl = super.dispatchTouchEvent(motionEvent);
        WXGesture wXGesture = wXBaseCircleIndicator.wxGesture;
        if (wXGesture != null) {
            bl |= wXGesture.onTouch((View)this, motionEvent);
        }
        return bl;
    }

    protected void onDraw(Canvas canvas) {
        WXBaseCircleIndicator wXBaseCircleIndicator = this;
        super.onDraw(canvas);
        float f = (wXBaseCircleIndicator.circlePadding + this.radius) * 2.0f;
        float f2 = (float)(wXBaseCircleIndicator.getWidth() / 2) - f * (float)(this.getCount() - 1) / 2.0f;
        float f3 = wXBaseCircleIndicator.getHeight() / 2 + this.getPaddingTop();
        for (int i = 0; i < this.getCount(); ++i) {
            Paint paint;
            float f4;
            float f5 = f2 + f * (float)i;
            if (i != this.realCurrentItem) {
                WXBaseCircleIndicator wXBaseCircleIndicator2 = this;
                f4 = wXBaseCircleIndicator2.radius;
                paint = wXBaseCircleIndicator2.mPaintPage;
                canvas.drawCircle(f5, f3, f4, paint);
                continue;
            }
            WXBaseCircleIndicator wXBaseCircleIndicator3 = this;
            f4 = wXBaseCircleIndicator3.radius;
            paint = wXBaseCircleIndicator3.mPaintFill;
            canvas.drawCircle(f5, f3, f4, paint);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = n2;
        n = View.MeasureSpec.getSize((int)n);
        n2 = View.MeasureSpec.getMode((int)n4);
        int n5 = View.MeasureSpec.getSize((int)n4);
        if (n3 != 0x40000000) {
            n = (int)((float)this.getPaddingLeft() + this.radius * 2.0f * (float)this.getCount() + this.circlePadding * (float)(this.getCount() - 1) + (float)this.getPaddingRight()) + 1;
        }
        if (n2 != 0x40000000) {
            n5 = (int)((float)this.getPaddingTop() + this.radius * 2.0f + (float)this.getPaddingBottom()) + 1;
        }
        this.setMeasuredDimension(n, n5);
    }

    public int getCount() {
        WXCircleViewPager wXCircleViewPager = this.mCircleViewPager;
        if (wXCircleViewPager != null && wXCircleViewPager.getAdapter() != null) {
            return this.mCircleViewPager.getRealCount();
        }
        return 0;
    }
}

