/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.Canvas;
import android.text.Layout;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.PopupMenu;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.view.IRenderResult;
import com.taobao.weex.ui.view.IRenderStatus;
import com.taobao.weex.ui.view.IWXTextView;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class WXTextView
extends View
implements WXGestureObservable,
IWXTextView,
IRenderStatus<WXText>,
IRenderResult<WXText> {
    private WeakReference<WXText> mWeakReference;
    private WXGesture wxGesture;
    private Layout textLayout;
    private boolean mIsLabelSet = false;

    public WXTextView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        Layout layout2 = this.getTextLayout();
        if (layout2 != null) {
            Canvas canvas2 = canvas;
            canvas2.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            layout2.draw(canvas2);
        }
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        WXTextView wXTextView = this;
        boolean bl = super.onTouchEvent(motionEvent);
        WXGesture wXGesture = wXTextView.wxGesture;
        if (wXGesture != null) {
            bl |= wXGesture.onTouch(this, motionEvent);
        }
        return bl;
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    @Override
    public CharSequence getText() {
        WXTextView wXTextView = wXTextView.textLayout;
        return wXTextView != null ? wXTextView.getText() : null;
    }

    public Layout getTextLayout() {
        return this.textLayout;
    }

    public void setTextLayout(Layout layout2) {
        ((WXTextView)this).textLayout = layout2;
        if (layout2 != null && !((WXTextView)this).mIsLabelSet) {
            this.setContentDescription(layout2.getText());
        }
        if ((this = ((WXTextView)this).mWeakReference) != null && (this = (WXText)((Reference)this).get()) != null) {
            ((WXComponent)this).readyToRender();
        }
    }

    public void setAriaLabel(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mIsLabelSet = true;
            this.setContentDescription(string2);
        } else {
            this.mIsLabelSet = false;
            string2 = this.textLayout;
            if (string2 != null) {
                this.setContentDescription(string2.getText());
            }
        }
    }

    public void setTextColor(@ColorInt int n) {
        if ((this = this.getTextLayout()) != null) {
            this.getPaint().setColor(n);
        }
    }

    @Override
    public void holdComponent(WXText wXText) {
        WeakReference<WXText> weakReference;
        WXTextView wXTextView = weakReference2;
        WeakReference<WXText> weakReference2 = weakReference;
        weakReference = new WeakReference<WXText>(wXText);
        wXTextView.mWeakReference = weakReference2;
    }

    @Override
    @Nullable
    public WXText getComponent() {
        WeakReference<WXText> weakReference = ((WXTextView)((Object)weakReference)).mWeakReference;
        return weakReference != null ? (WXText)weakReference.get() : null;
    }

    public void enableCopy(boolean bl) {
        if (bl) {
            View.OnLongClickListener onLongClickListener;
            View.OnLongClickListener onLongClickListener2 = onLongClickListener;
            onLongClickListener = new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    PopupMenu popupMenu;
                    view = popupMenu;
                    1 v1 = this;
                    Object object = v1.WXTextView.this.getContext();
                    popupMenu = new PopupMenu(object, (View)v1.WXTextView.this);
                    object = "Copy";
                    try {
                        object = WXTextView.this.getContext().getResources().getString(0x1040001);
                    }
                    catch (Throwable throwable) {}
                    View view2 = view;
                    view2.getMenu().add((CharSequence)object);
                    view2.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){
                        final /* synthetic */ String val$title;
                        {
                            this.val$title = string2;
                        }

                        public boolean onMenuItemClick(MenuItem menuItem) {
                            if (string2.val$title.equals(menuItem.getTitle())) {
                                1 v0 = string2;
                                String string2 = v0.WXTextView.this.getText().toString();
                                menuItem = (ClipboardManager)v0.WXTextView.this.getContext().getSystemService("clipboard");
                                if (menuItem != null) {
                                    String string3 = string2;
                                    menuItem.setPrimaryClip(ClipData.newPlainText((CharSequence)string3, (CharSequence)string3));
                                }
                                return true;
                            }
                            return false;
                        }
                    });
                    view2.show();
                    return true;
                }
            };
            this.setOnLongClickListener(onLongClickListener2);
        } else {
            this.setOnLongClickListener(null);
        }
    }
}

