/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.ui.view.border.BorderCorner;
import com.taobao.weex.ui.view.border.BorderEdge;
import com.taobao.weex.ui.view.border.BorderStyle;
import com.taobao.weex.ui.view.border.BorderUtil;
import com.taobao.weex.ui.view.border.BottomLeftCorner;
import com.taobao.weex.ui.view.border.BottomRightCorner;
import com.taobao.weex.ui.view.border.TopLeftCorner;
import com.taobao.weex.ui.view.border.TopRightCorner;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.uniapp.dom.AbsCSSShorthand;
import io.dcloud.feature.uniapp.ui.shadow.UniBoxShadowData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class BorderDrawable
extends Drawable {
    public static final int BORDER_TOP_LEFT_RADIUS = 0;
    public static final int BORDER_TOP_RIGHT_RADIUS = 1;
    public static final int BORDER_BOTTOM_RIGHT_RADIUS = 2;
    public static final int BORDER_BOTTOM_LEFT_RADIUS = 3;
    public static final int BORDER_RADIUS_ALL = 5;
    static final int DEFAULT_BORDER_COLOR = -16777216;
    static final float DEFAULT_BORDER_WIDTH = 0.0f;
    private static final BorderStyle DEFAULT_BORDER_STYLE = BorderStyle.SOLID;
    private static final String TAG = "Border";
    private static BorderStyle[] sBorderStyle = BorderStyle.values();
    private final Paint mPaint;
    @Nullable
    private CSSShorthand<CSSShorthand.EDGE> mBorderWidth;
    @Nullable
    private CSSShorthand<CSSShorthand.CORNER> mBorderRadius;
    @Nullable
    private CSSShorthand<CSSShorthand.CORNER> mOverlappingBorderRadius;
    @Nullable
    private SparseIntArray mBorderColor;
    @Nullable
    private SparseIntArray mBorderStyle;
    @Nullable
    private Path mPathForBorderOutline;
    private boolean mNeedUpdatePath;
    private int mColor;
    private Shader mShader;
    private int mAlpha;
    private TopLeftCorner mTopLeftCorner;
    private TopRightCorner mTopRightCorner;
    private BottomRightCorner mBottomRightCorner;
    private BottomLeftCorner mBottomLeftCorner;
    private final BorderEdge mBorderEdge;
    private RectF mRectBounds;
    UniBoxShadowData mBoxShadowData;

    public BorderDrawable() {
        BorderEdge borderEdge;
        Paint paint;
        Object object = paint;
        paint = new Paint(1);
        v1.mPaint = object;
        v1.mNeedUpdatePath = false;
        v1.mColor = 0;
        v1.mShader = null;
        v1.mAlpha = 255;
        object = borderEdge;
        borderEdge = new BorderEdge();
        v1.mBorderEdge = object;
        v1.mBoxShadowData = null;
    }

    private void updateBorderOutline() {
        if (borderDrawable2.mNeedUpdatePath) {
            RectF rectF;
            Path path;
            borderDrawable2.mNeedUpdatePath = false;
            if (borderDrawable2.mPathForBorderOutline == null) {
                Path path2;
                path = path2;
                path2 = new Path();
                borderDrawable2.mPathForBorderOutline = path;
            }
            BorderDrawable borderDrawable = borderDrawable2;
            borderDrawable.mPathForBorderOutline.reset();
            path = rectF;
            rectF = new RectF(borderDrawable2.getBounds());
            BorderDrawable borderDrawable2 = borderDrawable.mPathForBorderOutline;
            borderDrawable.prepareBorderPath(0, 0, 0, 0, (RectF)path, (Path)borderDrawable2);
        }
    }

    private void prepareBorderPath(int n, int n2, int n3, int n4, @NonNull RectF rectF, @NonNull Path path) {
        Object object = this.mBoxShadowData;
        if (object != null) {
            int n5 = 0;
            int n6 = 0;
            if (((UniBoxShadowData)object).getNormalTop() > 0) {
                n5 = this.mBoxShadowData.getNormalTop() / 2;
            }
            if (this.mBoxShadowData.getNormalLeft() > 0) {
                n6 = this.mBoxShadowData.getNormalLeft() / 2;
            }
            float f = n6;
            rectF.inset(f, (float)n5);
        }
        if (this.mBorderRadius != null) {
            BorderDrawable borderDrawable = this;
            borderDrawable.prepareBorderRadius(rectF);
            if (borderDrawable.mOverlappingBorderRadius == null) {
                CSSShorthand cSSShorthand;
                object = cSSShorthand;
                cSSShorthand = new CSSShorthand();
                this.mOverlappingBorderRadius = object;
            }
            BorderDrawable borderDrawable2 = this;
            float f = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
            float f2 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
            float f3 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
            float f4 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
            float f5 = f3;
            float f6 = f2;
            float f7 = f;
            float f8 = f;
            f = n4;
            float f9 = f8 - f;
            float f10 = n;
            float f11 = f7 - f10;
            float f12 = n2;
            f2 = f6 - f12;
            f10 = f6 - f10;
            f12 = f3 - f12;
            f3 = n3;
            float f13 = f5 - f3;
            f = f4 - f;
            f3 = f4 - f3;
            float[] fArray = new float[8];
            float[] fArray2 = fArray;
            fArray[0] = f9;
            fArray[1] = f11;
            fArray[2] = f2;
            fArray[3] = f10;
            fArray[4] = f12;
            fArray[5] = f13;
            fArray[6] = f;
            fArray[7] = f3;
            path.addRoundRect(rectF, fArray2, Path.Direction.CW);
        } else {
            path.addRect(rectF, Path.Direction.CW);
        }
    }

    private void prepareBorderRadius(@NonNull RectF rectF) {
        if (this.mBorderRadius != null) {
            BorderDrawable borderDrawable = this;
            float f = borderDrawable.getScaleFactor(rectF);
            if (borderDrawable.mOverlappingBorderRadius == null) {
                CSSShorthand cSSShorthand;
                CSSShorthand cSSShorthand2 = cSSShorthand;
                cSSShorthand = new CSSShorthand();
                this.mOverlappingBorderRadius = cSSShorthand2;
            }
            if (!Float.isNaN(f) && f < 1.0f) {
                BorderDrawable borderDrawable2 = this;
                CSSShorthand.CORNER cORNER = CSSShorthand.CORNER.BORDER_TOP_LEFT;
                borderDrawable2.mOverlappingBorderRadius.set(cORNER, this.mBorderRadius.get(cORNER) * f);
                CSSShorthand.CORNER cORNER2 = CSSShorthand.CORNER.BORDER_TOP_RIGHT;
                borderDrawable2.mOverlappingBorderRadius.set(cORNER2, this.mBorderRadius.get(cORNER2) * f);
                CSSShorthand.CORNER cORNER3 = CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT;
                borderDrawable2.mOverlappingBorderRadius.set(cORNER3, this.mBorderRadius.get(cORNER3) * f);
                CSSShorthand.CORNER cORNER4 = CSSShorthand.CORNER.BORDER_BOTTOM_LEFT;
                borderDrawable2.mOverlappingBorderRadius.set(cORNER4, this.mBorderRadius.get(cORNER4) * f);
            } else {
                BorderDrawable borderDrawable3 = this;
                CSSShorthand.CORNER cORNER = CSSShorthand.CORNER.BORDER_TOP_LEFT;
                borderDrawable3.mOverlappingBorderRadius.set(cORNER, this.mBorderRadius.get(cORNER));
                CSSShorthand.CORNER cORNER5 = CSSShorthand.CORNER.BORDER_TOP_RIGHT;
                borderDrawable3.mOverlappingBorderRadius.set(cORNER5, this.mBorderRadius.get(cORNER5));
                CSSShorthand.CORNER cORNER6 = CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT;
                borderDrawable3.mOverlappingBorderRadius.set(cORNER6, this.mBorderRadius.get(cORNER6));
                CSSShorthand.CORNER cORNER7 = CSSShorthand.CORNER.BORDER_BOTTOM_LEFT;
                borderDrawable3.mOverlappingBorderRadius.set(cORNER7, this.mBorderRadius.get(cORNER7));
            }
        }
    }

    private float getScaleFactor(@NonNull RectF object) {
        ArrayList arrayList;
        RectF rectF = object;
        RectF rectF2 = object;
        RectF rectF3 = object;
        RectF rectF4 = object;
        BorderDrawable borderDrawable = this;
        object = CSSShorthand.CORNER.BORDER_TOP_LEFT;
        CSSShorthand.CORNER cORNER = CSSShorthand.CORNER.BORDER_TOP_RIGHT;
        float f = borderDrawable.mBorderRadius.get((Enum<AbsCSSShorthand.CSSProperty>)object) + this.mBorderRadius.get(cORNER);
        float f2 = borderDrawable.mBorderRadius.get(cORNER);
        cORNER = CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT;
        float f3 = f2 + this.mBorderRadius.get(cORNER);
        float f4 = borderDrawable.mBorderRadius.get(cORNER);
        cORNER = CSSShorthand.CORNER.BORDER_BOTTOM_LEFT;
        float f5 = f4 + this.mBorderRadius.get(cORNER);
        float f6 = borderDrawable.mBorderRadius.get(cORNER) + this.mBorderRadius.get((Enum<AbsCSSShorthand.CSSProperty>)object);
        object = arrayList;
        arrayList = new ArrayList(4);
        this.updateFactor((List<Float>)object, rectF4.width(), f);
        this.updateFactor((List<Float>)object, rectF3.height(), f3);
        this.updateFactor((List<Float>)object, rectF2.width(), f5);
        this.updateFactor((List<Float>)object, rectF.height(), f6);
        return object.isEmpty() ? Float.NaN : ((Float)Collections.min(object)).floatValue();
    }

    private void updateFactor(@NonNull List<Float> list, float f, float f2) {
        if (f2 != 0.0f) {
            list.add(Float.valueOf(f / f2));
        }
    }

    private void drawBorders(Canvas canvas) {
        BorderCorner borderCorner;
        RectF rectF = this.mRectBounds;
        if (rectF == null) {
            RectF rectF2;
            rectF = rectF2;
            rectF2 = new RectF(this.getBounds());
            this.mRectBounds = rectF;
        } else {
            rectF.set(this.getBounds());
        }
        int n = 0;
        int n2 = 0;
        Object object = this.mBoxShadowData;
        if (object != null) {
            if (((UniBoxShadowData)object).getNormalTop() > 0) {
                n = this.mBoxShadowData.getNormalTop() / 2;
            }
            if (this.mBoxShadowData.getNormalLeft() > 0) {
                n2 = this.mBoxShadowData.getNormalLeft() / 2;
            }
            float f = n2;
            this.mRectBounds.inset(f, (float)n);
        }
        if ((object = this.mBorderWidth) == null) {
            return;
        }
        Object object2 = object;
        object = CSSShorthand.EDGE.LEFT;
        float f = ((AbsCSSShorthand)object2).get((Enum<? extends AbsCSSShorthand.CSSProperty>)object);
        CSSShorthand.EDGE eDGE = CSSShorthand.EDGE.TOP;
        float f2 = this.mBorderWidth.get(eDGE);
        CSSShorthand.EDGE eDGE2 = CSSShorthand.EDGE.BOTTOM;
        float f3 = this.mBorderWidth.get(eDGE2);
        CSSShorthand.EDGE eDGE3 = CSSShorthand.EDGE.RIGHT;
        float f4 = this.mBorderWidth.get(eDGE3);
        if (this.mTopLeftCorner == null) {
            TopLeftCorner topLeftCorner;
            borderCorner = topLeftCorner;
            topLeftCorner = new TopLeftCorner();
            this.mTopLeftCorner = borderCorner;
        }
        this.mTopLeftCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_TOP_LEFT), f, f2, this.mRectBounds);
        if (this.mTopRightCorner == null) {
            TopRightCorner topRightCorner;
            borderCorner = topRightCorner;
            topRightCorner = new TopRightCorner();
            this.mTopRightCorner = borderCorner;
        }
        this.mTopRightCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_TOP_RIGHT), f2, f4, this.mRectBounds);
        if (this.mBottomRightCorner == null) {
            BottomRightCorner bottomRightCorner;
            borderCorner = bottomRightCorner;
            bottomRightCorner = new BottomRightCorner();
            this.mBottomRightCorner = borderCorner;
        }
        this.mBottomRightCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT), f4, f3, this.mRectBounds);
        if (this.mBottomLeftCorner == null) {
            BottomLeftCorner bottomLeftCorner;
            borderCorner = bottomLeftCorner;
            bottomLeftCorner = new BottomLeftCorner();
            this.mBottomLeftCorner = borderCorner;
        }
        this.mBottomLeftCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT), f3, f, this.mRectBounds);
        if (!this.isDefAllDrawRoundRect(canvas, f, f2, f3, f4)) {
            float f5 = n2;
            canvas.translate(f5, (float)n);
            BorderEdge borderEdge = this.mBorderEdge.set(this.mTopLeftCorner, this.mTopRightCorner, f2, eDGE);
            this.drawOneSide(canvas, borderEdge);
            borderEdge = this.mBorderEdge.set(this.mTopRightCorner, this.mBottomRightCorner, f4, eDGE3);
            this.drawOneSide(canvas, borderEdge);
            borderEdge = this.mBorderEdge.set(this.mBottomRightCorner, this.mBottomLeftCorner, f3, eDGE2);
            this.drawOneSide(canvas, borderEdge);
            borderEdge = this.mBorderEdge.set(this.mBottomLeftCorner, this.mTopLeftCorner, f, (CSSShorthand.EDGE)object);
            this.drawOneSide(canvas, borderEdge);
        }
    }

    private boolean isDefAllDrawRoundRect(Canvas object, float f, float f2, float f3, float f4) {
        float f5;
        float f6 = this.mTopLeftCorner.getOuterCornerRadius();
        if (f5 > 0.0f && f6 == this.mTopRightCorner.getOuterCornerRadius() && f6 == this.mBottomLeftCorner.getOuterCornerRadius() && f6 == this.mBottomRightCorner.getOuterCornerRadius() && f > 0.0f && f == f2 && f == f3 && f == f4) {
            int n = WXViewUtils.multiplyColorAlpha(this.getBorderColor(CSSShorthand.EDGE.LEFT), this.mAlpha);
            BorderDrawable borderDrawable = this;
            CSSShorthand.EDGE eDGE = CSSShorthand.EDGE.TOP;
            int n2 = WXViewUtils.multiplyColorAlpha(borderDrawable.getBorderColor(eDGE), this.mAlpha);
            int n3 = WXViewUtils.multiplyColorAlpha(borderDrawable.getBorderColor(CSSShorthand.EDGE.BOTTOM), this.mAlpha);
            int n4 = WXViewUtils.multiplyColorAlpha(borderDrawable.getBorderColor(CSSShorthand.EDGE.RIGHT), this.mAlpha);
            if (n == n2 && n == n3 && n == n4) {
                RectF rectF;
                Canvas canvas = object;
                BorderDrawable borderDrawable2 = this;
                BorderDrawable borderDrawable3 = this;
                object = borderDrawable3.mTopLeftCorner;
                borderDrawable2.preparePaint(borderDrawable2.mBorderEdge.set((BorderCorner)object, borderDrawable3.mTopRightCorner, f2, eDGE).getEdge());
                borderDrawable2.mPaint.setStrokeWidth(f);
                object = rectF;
                object();
                float f7 = f / 2.0f;
                RectF rectF2 = this.mRectBounds;
                rectF.top = rectF2.top + f7;
                rectF.bottom = rectF2.bottom - f7;
                rectF.left = rectF2.left + f7;
                rectF.right = rectF2.right - f7;
                Paint paint = borderDrawable2.mPaint;
                float f8 = f6;
                canvas.drawRoundRect((RectF)object, f8, f8, paint);
                return true;
            }
        }
        return false;
    }

    private float getBorderRadius(CSSShorthand.CORNER cORNER) {
        CSSShorthand<CSSShorthand.CORNER> cSSShorthand = ((BorderDrawable)((Object)cSSShorthand)).mOverlappingBorderRadius;
        if (cSSShorthand != null) {
            return cSSShorthand.get(cORNER);
        }
        return 0.0f;
    }

    private void drawOneSide(Canvas canvas, @NonNull BorderEdge borderEdge) {
        if (0.0f != borderEdge.getBorderWidth()) {
            BorderDrawable borderDrawable = this;
            borderDrawable.preparePaint(borderEdge.getEdge());
            borderEdge.drawEdge(canvas, borderDrawable.mPaint);
        }
    }

    private void preparePaint(CSSShorthand.EDGE eDGE) {
        BorderDrawable borderDrawable = borderDrawable2;
        float f = borderDrawable2.mBorderWidth.get(eDGE);
        int n = WXViewUtils.multiplyColorAlpha(borderDrawable.getBorderColor(eDGE), borderDrawable2.mAlpha);
        BorderDrawable borderDrawable2 = sBorderStyle[borderDrawable2.getBorderStyle(eDGE)].getLineShader(f, n, eDGE);
        borderDrawable.mPaint.setShader((Shader)borderDrawable2);
        borderDrawable.mPaint.setColor(n);
        borderDrawable.mPaint.setStrokeCap(Paint.Cap.BUTT);
    }

    public void draw(@NonNull Canvas canvas) {
        BorderDrawable borderDrawable = this;
        canvas.save();
        borderDrawable.updateBorderOutline();
        borderDrawable.mPaint.setAlpha(255);
        if (borderDrawable.mPathForBorderOutline != null) {
            BorderDrawable borderDrawable2 = this;
            int n = WXViewUtils.multiplyColorAlpha(borderDrawable2.mColor, this.mAlpha);
            Shader shader = borderDrawable2.mShader;
            if (shader != null) {
                BorderDrawable borderDrawable3 = this;
                borderDrawable3.mPaint.setShader(shader);
                borderDrawable3.mPaint.setStyle(Paint.Style.FILL);
                Path path = borderDrawable3.mPathForBorderOutline;
                canvas.drawPath(path, borderDrawable3.mPaint);
                this.mPaint.setShader(null);
            } else if (n >>> 24 != 0) {
                BorderDrawable borderDrawable4 = this;
                borderDrawable4.mPaint.setColor(n);
                borderDrawable4.mPaint.setStyle(Paint.Style.FILL);
                Path path = borderDrawable4.mPathForBorderOutline;
                canvas.drawPath(path, borderDrawable4.mPaint);
                this.mPaint.setShader(null);
            }
        }
        BorderDrawable borderDrawable5 = this;
        BorderDrawable borderDrawable6 = this;
        borderDrawable6.mPaint.setStyle(Paint.Style.STROKE);
        borderDrawable6.mPaint.setStrokeJoin(Paint.Join.ROUND);
        borderDrawable5.drawBorders(canvas);
        borderDrawable5.mPaint.setShader(null);
        canvas.restore();
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.mNeedUpdatePath = true;
    }

    public void setAlpha(int n) {
        if (n != this.mAlpha) {
            this.mAlpha = n;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void updateBoxShadowData(UniBoxShadowData uniBoxShadowData) {
        this.mBoxShadowData = uniBoxShadowData;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return this.mShader != null ? -1 : WXViewUtils.getOpacityFromColor(WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    public void getOutline(@NonNull Outline outline) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.mPathForBorderOutline == null) {
                this.mNeedUpdatePath = true;
            }
            BorderDrawable borderDrawable = this;
            borderDrawable.updateBorderOutline();
            outline.setConvexPath(borderDrawable.mPathForBorderOutline);
        }
    }

    public void setBorderWidth(CSSShorthand.EDGE eDGE, float f) {
        if (this.mBorderWidth == null) {
            CSSShorthand cSSShorthand;
            CSSShorthand cSSShorthand2 = cSSShorthand;
            cSSShorthand = new CSSShorthand();
            this.mBorderWidth = cSSShorthand2;
        }
        if (this.mBorderWidth.get(eDGE) != f) {
            BorderDrawable borderDrawable = this;
            borderDrawable.mBorderWidth.set(eDGE, f);
            borderDrawable.mNeedUpdatePath = true;
            borderDrawable.invalidateSelf();
        }
    }

    float getBorderWidth(CSSShorthand.EDGE eDGE) {
        return this.mBorderWidth.get(eDGE);
    }

    public void setBorderRadius(CSSShorthand.CORNER cORNER, float f) {
        if (this.mBorderRadius == null) {
            CSSShorthand cSSShorthand;
            CSSShorthand cSSShorthand2 = cSSShorthand;
            cSSShorthand = new CSSShorthand();
            this.mBorderRadius = cSSShorthand2;
        }
        if (this.mBorderRadius.get(cORNER) != f || cORNER == CSSShorthand.CORNER.ALL && (f != this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) || f != this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) || f != this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) || f != this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT))) {
            BorderDrawable borderDrawable = this;
            borderDrawable.mBorderRadius.set(cORNER, f);
            borderDrawable.mNeedUpdatePath = true;
            borderDrawable.invalidateSelf();
        }
    }

    @NonNull
    public float[] getBorderRadius(RectF object) {
        BorderDrawable borderDrawable = this;
        borderDrawable.prepareBorderRadius((RectF)object);
        if (borderDrawable.mOverlappingBorderRadius == null) {
            CSSShorthand cSSShorthand;
            object = cSSShorthand;
            cSSShorthand = new CSSShorthand();
            this.mOverlappingBorderRadius = object;
        }
        BorderDrawable borderDrawable2 = this;
        float f = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
        float f2 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
        float f3 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
        float f4 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
        return new float[]{f, f, f2, f2, f3, f3, f4, f4};
    }

    @NonNull
    public float[] getBorderInnerRadius(RectF object) {
        BorderDrawable borderDrawable = object2;
        borderDrawable.prepareBorderRadius((RectF)object);
        if (borderDrawable.mOverlappingBorderRadius == null) {
            CSSShorthand cSSShorthand;
            object = cSSShorthand;
            cSSShorthand = new CSSShorthand();
            object2.mOverlappingBorderRadius = object;
        }
        BorderDrawable borderDrawable2 = object2;
        float f = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
        float f2 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
        float f3 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
        float f4 = borderDrawable2.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
        CSSShorthand<CSSShorthand.EDGE> cSSShorthand = borderDrawable2.mBorderWidth;
        if (cSSShorthand != null) {
            BorderDrawable borderDrawable3 = object2;
            BorderDrawable borderDrawable4 = object2;
            BorderDrawable borderDrawable5 = object2;
            Object object2 = CSSShorthand.EDGE.TOP;
            f = Math.max(f - cSSShorthand.get((Enum<AbsCSSShorthand.CSSProperty>)object2), 0.0f);
            f2 = Math.max(f2 - borderDrawable5.mBorderWidth.get((Enum<AbsCSSShorthand.CSSProperty>)object2), 0.0f);
            object2 = CSSShorthand.EDGE.BOTTOM;
            f3 = Math.max(f3 - borderDrawable4.mBorderWidth.get((Enum<AbsCSSShorthand.CSSProperty>)object2), 0.0f);
            f4 = Math.max(f4 - borderDrawable3.mBorderWidth.get((Enum<AbsCSSShorthand.CSSProperty>)object2), 0.0f);
        }
        return new float[]{f, f, f2, f2, f3, f3, f4, f4};
    }

    public void setBorderColor(CSSShorthand.EDGE eDGE, int n) {
        if (this.mBorderColor == null) {
            this.mBorderColor = new SparseIntArray(5);
            this.mBorderColor.put(CSSShorthand.EDGE.ALL.ordinal(), -16777216);
        }
        if (this.getBorderColor(eDGE) != n) {
            BorderDrawable borderDrawable = this;
            BorderUtil.updateSparseArray(borderDrawable.mBorderColor, eDGE.ordinal(), n);
            borderDrawable.invalidateSelf();
        }
    }

    int getBorderColor(CSSShorthand.EDGE eDGE) {
        return BorderUtil.fetchFromSparseArray(this.mBorderColor, eDGE.ordinal(), -16777216);
    }

    public void setBorderStyle(CSSShorthand.EDGE eDGE, @NonNull String string2) {
        block5: {
            if (this.mBorderStyle == null) {
                this.mBorderStyle = new SparseIntArray(5);
                this.mBorderStyle.put(CSSShorthand.EDGE.ALL.ordinal(), DEFAULT_BORDER_STYLE.ordinal());
            }
            BorderDrawable borderDrawable = this;
            CSSShorthand.EDGE eDGE2 = eDGE;
            int n = BorderStyle.valueOf(string2.toUpperCase(Locale.US)).ordinal();
            if (borderDrawable.getBorderStyle(eDGE2) == n) break block5;
            try {
                BorderDrawable borderDrawable2 = this;
                BorderUtil.updateSparseArray(borderDrawable2.mBorderStyle, eDGE.ordinal(), n);
                borderDrawable2.invalidateSelf();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WXLogUtils.e(TAG, WXLogUtils.getStackTrace(illegalArgumentException));
            }
        }
    }

    int getBorderStyle(CSSShorthand.EDGE eDGE) {
        return BorderUtil.fetchFromSparseArray(this.mBorderStyle, eDGE.ordinal(), BorderStyle.SOLID.ordinal());
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int n) {
        this.mColor = n;
        this.invalidateSelf();
    }

    public void setImage(Shader shader) {
        this.mShader = shader;
        this.invalidateSelf();
    }

    public boolean hasImage() {
        return this.mShader != null;
    }

    public boolean isRounded() {
        CSSShorthand<CSSShorthand.CORNER> cSSShorthand = this.mBorderRadius;
        return cSSShorthand != null && (cSSShorthand.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) != 0.0f || this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) != 0.0f || this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) != 0.0f || this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT) != 0.0f);
    }

    @NonNull
    public Path getContentPath(@NonNull RectF rectF) {
        Path path;
        Path path2 = path;
        path2();
        this.prepareBorderPath(0, 0, 0, 0, rectF, path2);
        return path;
    }
}

