/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview.adapter;

import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class WXRecyclerViewOnScrollListener
extends RecyclerView.OnScrollListener {
    protected LAYOUT_MANAGER_TYPE layoutManagerType;
    private int[] mLastPositions;
    private int[] mFirstPositions;
    private int mLastVisibleItemPosition;
    private int mFirstVisibleItemPosition;
    private int mCurrentScrollState = 0;
    private int mDy = 0;
    private WeakReference<IOnLoadMoreListener> listener;
    private boolean isLayoutRTL = false;

    public WXRecyclerViewOnScrollListener(IOnLoadMoreListener iOnLoadMoreListener) {
        WeakReference<IOnLoadMoreListener> weakReference;
        Object object = weakReference;
        weakReference = new WeakReference<IOnLoadMoreListener>(iOnLoadMoreListener);
        v1.listener = object;
    }

    private int findMax(int[] nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int findMin(int[] nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public void setLayoutRTL(boolean bl) {
        this.isLayoutRTL = bl;
    }

    public void onScrollStateChanged(RecyclerView object, int n) {
        block7: {
            WeakReference<IOnLoadMoreListener> weakReference;
            int n2;
            int n3;
            RecyclerView.LayoutManager layoutManager;
            block8: {
                View view;
                block9: {
                    super.onScrollStateChanged((RecyclerView)object, n);
                    this.mCurrentScrollState = n;
                    layoutManager = object.getLayoutManager();
                    int n4 = layoutManager.getChildCount();
                    int n5 = layoutManager.getItemCount();
                    if (n4 == 0) break block7;
                    n3 = (n5 - this.mLastVisibleItemPosition - 1) * object.getHeight() / n4;
                    if (n4 <= 0 || this.mCurrentScrollState != 0) break block7;
                    if (!object.isHorizontalScrollBarEnabled()) break block8;
                    view = object.getLayoutManager().getChildAt(n4 - 1);
                    int n6 = object.getLayoutManager().getPosition(view);
                    if (view == null || n6 != n5 - 1) break block7;
                    if (!this.isLayoutRTL) break block9;
                    if (layoutManager.getDecoratedLeft(view) < -50 || (object = this.listener) == null || ((Reference)object).get() == null) break block7;
                    ((IOnLoadMoreListener)this.listener.get()).onLoadMore(n3);
                    break block7;
                }
                if (layoutManager.getDecoratedRight(view) > object.getWidth() || (object = this.listener) == null || ((Reference)object).get() == null) break block7;
                ((IOnLoadMoreListener)this.listener.get()).onLoadMore(n3);
                break block7;
            }
            View view = layoutManager.getChildAt(this.mLastVisibleItemPosition);
            if (view != null) {
                int n7 = layoutManager.getDecoratedBottom(view);
                if (n7 + 50 < (n2 = object.getHeight())) {
                    return;
                }
                if (n7 > n2) {
                    return;
                }
            } else {
                n2 = this.mDy;
                if (n2 == 0 || n2 < 0) {
                    return;
                }
            }
            if ((weakReference = this.listener) != null && weakReference.get() != null) {
                ((IOnLoadMoreListener)this.listener.get()).onLoadMore(n3);
            }
            this.mDy = 0;
        }
    }

    public void onScrolled(RecyclerView recyclerView, int n, int n2) {
        super.onScrolled(recyclerView, n, n2);
        recyclerView = recyclerView.getLayoutManager();
        Object object = this.listener;
        if (object == null) {
            return;
        }
        if ((object = (IOnLoadMoreListener)((Reference)object).get()) != null) {
            object.onBeforeScroll(n, n2);
            this.mDy = n2;
            if (recyclerView instanceof LinearLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.LINEAR;
                LinearLayoutManager linearLayoutManager = (LinearLayoutManager)recyclerView;
                this.mLastVisibleItemPosition = linearLayoutManager.findLastVisibleItemPosition();
                object.notifyAppearStateChange(linearLayoutManager.findFirstVisibleItemPosition(), this.mLastVisibleItemPosition, n, n2);
            } else if (recyclerView instanceof GridLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.GRID;
                GridLayoutManager gridLayoutManager = (GridLayoutManager)recyclerView;
                this.mLastVisibleItemPosition = gridLayoutManager.findLastVisibleItemPosition();
                object.notifyAppearStateChange(gridLayoutManager.findFirstVisibleItemPosition(), this.mLastVisibleItemPosition, n, n2);
            } else if (recyclerView instanceof StaggeredGridLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.STAGGERED_GRID;
                recyclerView = (StaggeredGridLayoutManager)recyclerView;
                int n3 = recyclerView.getSpanCount();
                int[] nArray = this.mLastPositions;
                if (this.mLastPositions == null || n3 != nArray.length) {
                    this.mLastPositions = new int[n3];
                }
                nArray = this.mFirstPositions;
                if (this.mFirstPositions == null || n3 != nArray.length) {
                    this.mFirstPositions = new int[n3];
                }
                Object object2 = object;
                RecyclerView recyclerView2 = recyclerView;
                RecyclerView recyclerView3 = recyclerView2;
                recyclerView2.findFirstVisibleItemPositions(this.mFirstPositions);
                this.mFirstVisibleItemPosition = this.findMin(this.mFirstPositions);
                recyclerView3.findLastVisibleItemPositions(this.mLastPositions);
                int n4 = this.findMax(this.mLastPositions);
                try {
                    this.mLastVisibleItemPosition = n4;
                    object2.notifyAppearStateChange(this.mFirstVisibleItemPosition, n4, n, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    WXLogUtils.e(((Object)exception).toString());
                }
            } else {
                throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }
    }

    public static enum LAYOUT_MANAGER_TYPE {
        LINEAR,
        GRID,
        STAGGERED_GRID;

    }
}

