/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.circlebar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import androidx.core.view.ViewCompat;
import com.taobao.weex.ui.view.refresh.circlebar.MaterialProgressDrawable;

public class CircleProgressBar
extends ImageView {
    private static final int KEY_SHADOW_COLOR = 0x1E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.75f;
    private static final float SHADOW_RADIUS = 3.5f;
    private static final int SHADOW_ELEVATION = 4;
    public static final int DEFAULT_CIRCLE_BG_LIGHT = -328966;
    public static final int DEFAULT_CIRCLE_COLOR = -1048576;
    private static final int DEFAULT_CIRCLE_DIAMETER = 40;
    private static final int STROKE_WIDTH_LARGE = 3;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;
    private int mBackGroundColor;
    private int mProgressColor;
    private int mProgressStokeWidth;
    private int mArrowWidth;
    private int mArrowHeight;
    private int mProgress;
    private int mMax;
    private int mDiameter;
    private int mInnerRadius;
    private boolean mShowArrow;
    public MaterialProgressDrawable mProgressDrawable;
    private ShapeDrawable mBgCircle;
    private boolean mCircleBackgroundEnabled;
    private int[] mColors;
    private boolean isLayoutFinished;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler;

    public CircleProgressBar(Context context) {
        Handler handler;
        CircleProgressBar circleProgressBar = this;
        super(context);
        int[] nArray = new int[1];
        Object object = nArray;
        nArray[0] = -16777216;
        circleProgressBar.mColors = object;
        circleProgressBar.isLayoutFinished = false;
        object = handler;
        handler = new Handler(){

            public void handleMessage(Message object) {
                super.handleMessage((Message)object);
                if (((Message)object).what == 10010) {
                    if (CircleProgressBar.this.isLayoutFinished && (object = CircleProgressBar.this.mProgressDrawable) != null) {
                        ((MaterialProgressDrawable)((Object)object)).start();
                    } else {
                        Runnable runnable;
                        object = runnable;
                        runnable = new Runnable(){

                            @Override
                            public void run() {
                                CircleProgressBar.this.mHandler.sendEmptyMessage(10010);
                            }
                        };
                        this.postDelayed((Runnable)object, 100L);
                    }
                }
            }
        };
        circleProgressBar.mHandler = (Handler)object;
        circleProgressBar.init(context, null, 0);
    }

    public CircleProgressBar(Context context, AttributeSet attributeSet) {
        Handler handler;
        CircleProgressBar circleProgressBar = this;
        super(context, attributeSet);
        int[] nArray = new int[1];
        Object object = nArray;
        nArray[0] = -16777216;
        circleProgressBar.mColors = object;
        circleProgressBar.isLayoutFinished = false;
        object = handler;
        handler = new /* invalid duplicate definition of identical inner class */;
        circleProgressBar.mHandler = (Handler)object;
        circleProgressBar.init(context, attributeSet, 0);
    }

    public CircleProgressBar(Context context, AttributeSet attributeSet, int n) {
        Handler handler;
        CircleProgressBar circleProgressBar = this;
        super(context, attributeSet, n);
        int[] nArray = new int[1];
        Object object = nArray;
        nArray[0] = -16777216;
        circleProgressBar.mColors = object;
        circleProgressBar.isLayoutFinished = false;
        object = handler;
        handler = new /* invalid duplicate definition of identical inner class */;
        circleProgressBar.mHandler = (Handler)object;
        circleProgressBar.init(context, attributeSet, n);
    }

    private void init(Context object, AttributeSet attributeSet, int n) {
        MaterialProgressDrawable materialProgressDrawable;
        CircleProgressBar circleProgressBar = this;
        CircleProgressBar circleProgressBar2 = this;
        circleProgressBar2.mBackGroundColor = -328966;
        circleProgressBar2.mProgressColor = -1048576;
        circleProgressBar2.mColors = new int[]{-1048576};
        circleProgressBar2.mInnerRadius = -1;
        circleProgressBar.mProgressStokeWidth = (int)(circleProgressBar.getContext().getResources().getDisplayMetrics().density * 3.0f);
        circleProgressBar.mArrowWidth = -1;
        circleProgressBar.mArrowHeight = -1;
        circleProgressBar.mShowArrow = true;
        circleProgressBar.mCircleBackgroundEnabled = true;
        circleProgressBar.mProgress = 0;
        circleProgressBar.mMax = 100;
        object = materialProgressDrawable;
        circleProgressBar.mProgressDrawable = new MaterialProgressDrawable(this.getContext(), (View)this);
        super.setImageDrawable((Drawable)object);
    }

    private boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public void setProgressBackGroundColor(int n) {
        this.mBackGroundColor = n;
    }

    protected void onMeasure(int n, int n2) {
        CircleProgressBar circleProgressBar = this;
        super.onMeasure(n, n2);
        if (!circleProgressBar.elevationSupported()) {
            CircleProgressBar circleProgressBar2 = this;
            circleProgressBar2.setMeasuredDimension(circleProgressBar2.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    public int getProgressStokeWidth() {
        return this.mProgressStokeWidth;
    }

    public void setProgressStokeWidth(int n) {
        float f = this.getContext().getResources().getDisplayMetrics().density;
        this.mProgressStokeWidth = (int)((float)n * f);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        MaterialProgressDrawable materialProgressDrawable;
        super.onLayout(bl, n, n2, n3, n4);
        float f = this.getContext().getResources().getDisplayMetrics().density;
        this.mDiameter = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
        if (this.mDiameter <= 0) {
            this.mDiameter = (int)f * 40;
        }
        if (this.getBackground() == null && this.mCircleBackgroundEnabled) {
            float f2 = f;
            n = (int)(f2 * 1.75f);
            n2 = (int)(f2 * 0.0f);
            this.mShadowRadius = (int)(f2 * 3.5f);
            if (this.elevationSupported()) {
                OvalShape ovalShape;
                ShapeDrawable shapeDrawable;
                ShapeDrawable shapeDrawable2 = shapeDrawable;
                OvalShape ovalShape2 = ovalShape;
                ovalShape = new OvalShape();
                shapeDrawable = new ShapeDrawable((Shape)ovalShape2);
                this.mBgCircle = shapeDrawable2;
                ViewCompat.setElevation((View)this, (float)(f * 4.0f));
            } else {
                ShapeDrawable shapeDrawable;
                ShapeDrawable shapeDrawable3;
                OvalShadow ovalShadow;
                OvalShadow ovalShadow2 = ovalShadow;
                n3 = this.mShadowRadius;
                n4 = this.mDiameter - n3 * 2;
                ovalShadow = new OvalShadow(n3, n4);
                this.mBgCircle = shapeDrawable3 = shapeDrawable;
                ovalShadow2 = new ShapeDrawable((Shape)ovalShadow2).getPaint();
                ViewCompat.setLayerType((View)this, (int)1, (Paint)ovalShadow2);
                float f3 = this.mShadowRadius;
                float f4 = n2;
                float f5 = n;
                this.mBgCircle.getPaint().setShadowLayer(f3, f4, f5, 0x1E000000);
                int n5 = this.mShadowRadius;
                this.setPadding(n5, n5, n5, n5);
            }
            this.mBgCircle.getPaint().setColor(this.mBackGroundColor);
            this.setBackgroundDrawable((Drawable)this.mBgCircle);
        }
        if ((materialProgressDrawable = this.mProgressDrawable) == null) {
            return;
        }
        materialProgressDrawable.setBackgroundColor(this.mBackGroundColor);
        this.mProgressDrawable.setColorSchemeColors(this.mColors);
        if (this.isShowArrow()) {
            this.mProgressDrawable.setArrowScale(1.0f);
            this.mProgressDrawable.showArrow(true);
        }
        super.setImageDrawable(null);
        super.setImageDrawable((Drawable)this.mProgressDrawable);
        this.mProgressDrawable.setAlpha(255);
        if (this.getVisibility() == 0) {
            this.mProgressDrawable.setStartEndTrim(0.0f, 0.8f);
        }
        this.isLayoutFinished = true;
    }

    public boolean isShowArrow() {
        return this.mShowArrow;
    }

    public void setShowArrow(boolean bl) {
        this.mShowArrow = bl;
    }

    public void setAnimationListener(Animation.AnimationListener animationListener) {
        this.mListener = animationListener;
    }

    public void onAnimationStart() {
        CircleProgressBar circleProgressBar = this;
        super.onAnimationStart();
        Animation.AnimationListener animationListener = circleProgressBar.mListener;
        if (animationListener != null) {
            animationListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        CircleProgressBar circleProgressBar = this;
        super.onAnimationEnd();
        Animation.AnimationListener animationListener = circleProgressBar.mListener;
        if (animationListener != null) {
            animationListener.onAnimationEnd(this.getAnimation());
        }
    }

    public void setColorSchemeColors(int ... nArray) {
        object.mColors = nArray;
        Object object = object.mProgressDrawable;
        if (object != null) {
            ((MaterialProgressDrawable)((Object)object)).setColorSchemeColors(nArray);
        }
    }

    public void setBackgroundColorResource(int n) {
        if (circleProgressBar2.getBackground() instanceof ShapeDrawable) {
            CircleProgressBar circleProgressBar = circleProgressBar2;
            CircleProgressBar circleProgressBar2 = circleProgressBar.getResources();
            ((ShapeDrawable)circleProgressBar.getBackground()).getPaint().setColor(circleProgressBar2.getColor(n));
        }
    }

    public void setBackgroundColor(int n) {
        if (this.getBackground() instanceof ShapeDrawable) {
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(n);
        }
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int n) {
        this.mMax = n;
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setProgress(int n) {
        if (this.getMax() > 0) {
            this.mProgress = n;
        }
        this.invalidate();
    }

    public boolean circleBackgroundEnabled() {
        return this.mCircleBackgroundEnabled;
    }

    public void setCircleBackgroundEnabled(boolean bl) {
        this.mCircleBackgroundEnabled = bl;
    }

    protected void onAttachedToWindow() {
        CircleProgressBar circleProgressBar = object;
        super.onAttachedToWindow();
        MaterialProgressDrawable materialProgressDrawable = circleProgressBar.mProgressDrawable;
        if (materialProgressDrawable != null) {
            CircleProgressBar circleProgressBar2 = object;
            materialProgressDrawable.stop();
            Object object = circleProgressBar2.mProgressDrawable;
            boolean bl = circleProgressBar2.getVisibility() == 0;
            object.setVisible(bl, false);
        }
    }

    protected void onDetachedFromWindow() {
        CircleProgressBar circleProgressBar = this;
        super.onDetachedFromWindow();
        MaterialProgressDrawable materialProgressDrawable = circleProgressBar.mProgressDrawable;
        if (materialProgressDrawable != null) {
            materialProgressDrawable.stop();
            this.mProgressDrawable.setVisible(false, false);
        }
    }

    public void start() {
        this.mHandler.sendEmptyMessage(10010);
    }

    public void setStartEndTrim(float f, float f2) {
        Object object = object.mProgressDrawable;
        if (object != null) {
            ((MaterialProgressDrawable)((Object)object)).setStartEndTrim(f, f2);
        }
    }

    public void stop() {
        MaterialProgressDrawable materialProgressDrawable = this.mProgressDrawable;
        if (materialProgressDrawable != null) {
            materialProgressDrawable.stop();
        }
        this.mHandler.removeMessages(10010);
    }

    public void setProgressRotation(float f) {
        Object object = object.mProgressDrawable;
        if (object != null) {
            ((MaterialProgressDrawable)((Object)object)).setProgressRotation(f);
        }
    }

    public void destory() {
        this.mProgressDrawable.stop();
        this.mProgressDrawable = null;
    }

    private class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private int mShadowRadius;
        private Paint mShadowPaint = new Paint();
        private int mCircleDiameter;

        public OvalShadow(int n, int n2) {
            OvalShadow ovalShadow;
            RadialGradient radialGradient;
            object.mShadowRadius = n;
            object.mCircleDiameter = n2;
            object.CircleProgressBar.this = radialGradient;
            int n3 = object.mCircleDiameter;
            float f = n3 / 2;
            float f2 = n3 / 2;
            int[] nArray = new int[2];
            Object object = nArray;
            nArray[0] = 0x3D000000;
            nArray[1] = 0;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            ovalShadow.mRadialGradient = new RadialGradient(f, f2, (float)object.mShadowRadius, (int[])object, null, tileMode);
            ovalShadow.mShadowPaint.setShader((Shader)object.CircleProgressBar.this);
        }

        public void draw(Canvas canvas, Paint paint) {
            Canvas canvas2 = canvas;
            OvalShadow ovalShadow = this;
            int n = ovalShadow.CircleProgressBar.this.getWidth();
            float f = n / 2;
            float f2 = ovalShadow.CircleProgressBar.this.getHeight() / 2;
            float f3 = ovalShadow.mCircleDiameter / 2 + this.mShadowRadius;
            Paint paint2 = ovalShadow.mShadowPaint;
            canvas2.drawCircle(f, f2, f3, paint2);
            canvas2.drawCircle(f, f2, (float)(this.mCircleDiameter / 2), paint);
        }
    }
}

