/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.wson;

import androidx.collection.LruCache;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Wson {
    public static final boolean WriteMapNullValue = false;
    private static final byte NULL_TYPE = 48;
    private static final byte STRING_TYPE = 115;
    private static final byte BOOLEAN_TYPE_TRUE = 116;
    private static final byte BOOLEAN_TYPE_FALSE = 102;
    private static final byte NUMBER_INT_TYPE = 105;
    private static final byte NUMBER_LONG_TYPE = 108;
    private static final byte NUMBER_BIG_INTEGER_TYPE = 103;
    private static final byte NUMBER_BIG_DECIMAL_TYPE = 101;
    private static final byte NUMBER_DOUBLE_TYPE = 100;
    private static final byte NUMBER_FLOAT_TYPE = 70;
    private static final byte ARRAY_TYPE = 91;
    private static final byte MAP_TYPE = 123;
    private static final boolean IS_NATIVE_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final int GLOBAL_STRING_CACHE_SIZE = 2048;
    private static final ThreadLocal<char[]> localCharsBufferCache = new ThreadLocal();
    private static final String[] globalStringBytesCache = new String[2048];
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_PREFIX_IS = "is";
    private static LruCache<String, List<Method>> methodsCache = new LruCache(128);
    private static LruCache<String, List<Field>> fieldsCache = new LruCache(128);
    private static LruCache<String, Boolean> specialClass = new LruCache(16);

    public static final Object parse(byte[] byArray) {
        Parser parser;
        if (byArray == null) {
            return null;
        }
        Parser parser2 = parser;
        try {
            Object object = new Parser(byArray).parse();
            parser2.close();
            return object;
        }
        catch (Exception exception) {
            WXLogUtils.e("parseWson", exception);
            return null;
        }
    }

    public static final byte[] toWson(Object object) {
        Builder builder;
        if (object == null) {
            return null;
        }
        Builder builder2 = builder;
        builder2();
        byte[] byArray = builder.toWson(object);
        builder2.close();
        return byArray;
    }

    private static final List<Method> getBeanMethod(String string2, Class methodArray) {
        List list = (List)methodsCache.get((Object)string2);
        if (list == null) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList();
            for (Method method : methodArray.getMethods()) {
                String string3;
                if (method.getDeclaringClass() == Object.class || (method.getModifiers() & 8) != 0 || !(string3 = method.getName()).startsWith(METHOD_PREFIX_GET) && !string3.startsWith(METHOD_PREFIX_IS)) continue;
                if (method.getAnnotation(JSONField.class) == null) {
                    list.add(method);
                    continue;
                }
                throw new UnsupportedOperationException("getBeanMethod JSONField Annotation Not Handled, Use toJSON");
            }
            methodsCache.put((Object)string2, (Object)list);
        }
        return list;
    }

    private static final List<Field> getBeanFields(String string2, Class fieldArray) {
        List list = (List)fieldsCache.get((Object)string2);
        if (list == null) {
            ArrayList arrayList;
            fieldArray = fieldArray.getFields();
            list = arrayList;
            arrayList = new ArrayList(fieldArray.length);
            for (Field field : fieldArray) {
                if ((field.getModifiers() & 8) != 0) continue;
                if (field.getAnnotation(JSONField.class) == null) {
                    list.add(field);
                    continue;
                }
                throw new UnsupportedOperationException("getBeanMethod JSONField Annotation Not Handled, Use toJSON");
            }
            fieldsCache.put((Object)string2, (Object)list);
        }
        return list;
    }

    static /* synthetic */ List access$1000(String string2, Class clazz) {
        return Wson.getBeanMethod(string2, clazz);
    }

    static /* synthetic */ List access$1100(String string2, Class clazz) {
        return Wson.getBeanFields(string2, clazz);
    }

    private static final class Parser {
        private int position = 0;
        private byte[] buffer;
        private char[] charsBuffer;

        private Parser(byte[] byArray) {
            this.buffer = byArray;
            this.charsBuffer = (char[])localCharsBufferCache.get();
            if (this.charsBuffer != null) {
                localCharsBufferCache.set(null);
            } else {
                this.charsBuffer = new char[512];
            }
        }

        private final Object parse() {
            return this.readObject();
        }

        private final void close() {
            this.position = 0;
            this.buffer = null;
            if (this.charsBuffer != null) {
                localCharsBufferCache.set(this.charsBuffer);
            }
            this.charsBuffer = null;
        }

        private final Object readObject() {
            byte by = this.readType();
            if (by != 48) {
                if (by != 70) {
                    if (by != 91) {
                        if (by != 105) {
                            if (by != 108) {
                                if (by != 123) {
                                    if (by != 115) {
                                        if (by != 116) {
                                            switch (by) {
                                                default: {
                                                    throw new RuntimeException("wson unhandled type " + by + " " + this.position + " length " + this.buffer.length);
                                                }
                                                case 103: {
                                                    return new BigInteger(this.readUTF16String());
                                                }
                                                case 102: {
                                                    return Boolean.FALSE;
                                                }
                                                case 101: {
                                                    return new BigDecimal(this.readUTF16String());
                                                }
                                                case 100: 
                                            }
                                            return this.readDouble();
                                        }
                                        return Boolean.TRUE;
                                    }
                                    return this.readUTF16String();
                                }
                                return this.readMap();
                            }
                            return this.readLong();
                        }
                        return this.readVarInt();
                    }
                    return this.readArray();
                }
                return this.readFloat();
            }
            return null;
        }

        private final Object readMap() {
            JSONObject jSONObject;
            int n = this.readUInt();
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject();
            for (int i = 0; i < n; ++i) {
                Parser parser = this;
                String string2 = parser.readMapKeyUTF16();
                jSONObject2.put(string2, parser.readObject());
            }
            return jSONObject2;
        }

        private final Object readArray() {
            JSONArray jSONArray;
            int n = this.readUInt();
            JSONArray jSONArray2 = jSONArray;
            jSONArray = new JSONArray(n);
            for (int i = 0; i < n; ++i) {
                jSONArray2.add(this.readObject());
            }
            return jSONArray2;
        }

        private final byte readType() {
            int n = this.position;
            this.position = n + 1;
            return this.buffer[n];
        }

        private final String readMapKeyUTF16() {
            String string2;
            String string3;
            int n;
            block9: {
                int n2;
                int n3;
                int n4;
                Parser parser = this;
                n = parser.readUInt() / 2;
                if (parser.charsBuffer.length < n) {
                    this.charsBuffer = new char[n];
                }
                int n5 = 5381;
                if (IS_NATIVE_LITTLE_ENDIAN) {
                    for (n4 = 0; n4 < n; ++n4) {
                        Parser parser2 = this;
                        byte[] byArray = parser2.buffer;
                        n3 = parser2.position;
                        this.charsBuffer[n4] = n2 = (int)((char)((byArray[n3] & 0xFF) + (byArray[n3 + 1] << 8)));
                        n5 = (n5 << 5) + n5 + n2;
                        parser2.position = n3 + 2;
                    }
                } else {
                    for (n4 = 0; n4 < n; ++n4) {
                        Parser parser3 = this;
                        byte[] byArray = parser3.buffer;
                        n3 = parser3.position;
                        this.charsBuffer[n4] = n2 = (int)((char)((byArray[n3 + 1] & 0xFF) + (byArray[n3] << 8)));
                        n5 = (n5 << 5) + n5 + n2;
                        parser3.position = n3 + 2;
                    }
                }
                n5 = globalStringBytesCache.length - 1 & n5;
                string3 = globalStringBytesCache[n5];
                if (string3 != null && string3.length() == n) {
                    for (n2 = 0; n2 < n; ++n2) {
                        if (this.charsBuffer[n2] == string3.charAt(n2)) {
                            continue;
                        }
                        break block9;
                    }
                    return string3;
                }
            }
            string3 = string2;
            string2 = new String(this.charsBuffer, 0, n);
            if (n < 64) {
                globalStringBytesCache[n5] = string3;
            }
            return string3;
        }

        private final String readUTF16String() {
            Parser parser = this;
            int n = parser.readUInt() / 2;
            if (parser.charsBuffer.length < n) {
                this.charsBuffer = new char[n];
            }
            if (IS_NATIVE_LITTLE_ENDIAN) {
                for (int i = 0; i < n; ++i) {
                    char c;
                    Parser parser2 = this;
                    byte[] byArray = parser2.buffer;
                    int n2 = parser2.position;
                    this.charsBuffer[i] = c = (char)((byArray[n2] & 0xFF) + (byArray[n2 + 1] << 8));
                    parser2.position = n2 + 2;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    char c;
                    Parser parser3 = this;
                    byte[] byArray = parser3.buffer;
                    int n3 = parser3.position;
                    this.charsBuffer[i] = c = (char)((byArray[n3 + 1] & 0xFF) + (byArray[n3] << 8));
                    parser3.position = n3 + 2;
                }
            }
            return new String(this.charsBuffer, 0, n);
        }

        private final int readVarInt() {
            int n = this.readUInt();
            return (n << 31 >> 31 ^ n) >> 1 ^ n & Integer.MIN_VALUE;
        }

        private final int readUInt() {
            int n;
            byte by;
            int n2 = 0;
            int n3 = 0;
            while (((by = this.buffer[n = this.position]) & 0x80) != 0) {
                n2 |= (by & 0x7F) << n3;
                this.position = n + 1;
                if ((n3 += 7) <= 35) continue;
                throw new IllegalArgumentException("Variable length quantity is too long");
            }
            this.position = n + 1;
            return n2 | by << n3;
        }

        private final long readLong() {
            byte[] byArray = this.buffer;
            int n = this.position;
            this.position = n + 8;
            return ((long)this.buffer[n + 7] & 0xFFL) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + ((long)byArray[n] << 56);
        }

        private final Object readDouble() {
            double d;
            double d2 = Double.longBitsToDouble(this.readLong());
            if (d > 2.147483647E9) {
                long l;
                double d3 = d2;
                long l2 = (long)d3;
                if (d3 - (double)l < Double.MIN_NORMAL) {
                    return l2;
                }
            }
            return d2;
        }

        private Object readFloat() {
            Parser parser = object;
            Object object = parser.buffer;
            int n = parser.position;
            int n2 = (object[n + 3] & 0xFF) + ((object[n + 2] & 0xFF) << 8) + ((object[n + 1] & 0xFF) << 16) + ((object[n] & 0xFF) << 24);
            parser.position = n + 4;
            return Float.valueOf(Float.intBitsToFloat(n2));
        }
    }

    private static final class Builder {
        private static final ThreadLocal<byte[]> bufLocal = new ThreadLocal();
        private static final ThreadLocal<ArrayList> refsLocal = new ThreadLocal();
        private byte[] buffer;
        private int position;
        private ArrayList refs;

        private Builder() {
            ThreadLocal<Object> threadLocal = bufLocal;
            ((Builder)((Object)arrayList2)).buffer = threadLocal.get();
            if (((Builder)((Object)arrayList2)).buffer != null) {
                threadLocal.set(null);
            } else {
                ((Builder)((Object)arrayList2)).buffer = new byte[1024];
            }
            threadLocal = refsLocal;
            ((Builder)((Object)arrayList2)).refs = threadLocal.get();
            if (((Builder)((Object)arrayList2)).refs != null) {
                threadLocal.set(null);
            } else {
                ArrayList arrayList;
                Builder builder = arrayList2;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList(16);
                builder.refs = arrayList2;
            }
        }

        private final byte[] toWson(Object object) {
            Builder builder = this;
            builder.writeObject(object);
            int n = builder.position;
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, 0, byArray, 0, n);
            return byArray;
        }

        private final void close() {
            byte[] byArray = this.buffer;
            if (this.buffer.length <= 16384) {
                bufLocal.set(byArray);
            }
            if (this.refs.isEmpty()) {
                refsLocal.set(this.refs);
            } else {
                this.refs.clear();
            }
            Builder builder = this;
            builder.refs = null;
            builder.buffer = null;
            builder.position = 0;
        }

        private final void writeObject(Object iterator) {
            block26: {
                block24: {
                    block25: {
                        block23: {
                            if (iterator instanceof CharSequence) {
                                this.ensureCapacity(2);
                                this.writeByte((byte)115);
                                this.writeUTF16String((CharSequence)((Object)iterator));
                                return;
                            }
                            if (iterator instanceof Map) {
                                if (this.refs.contains(iterator)) {
                                    this.ensureCapacity(2);
                                    this.writeByte((byte)48);
                                    return;
                                }
                                this.refs.add(iterator);
                                this.writeMap((Map)((Object)iterator));
                                ArrayList arrayList = this.refs;
                                arrayList.remove(arrayList.size() - 1);
                                return;
                            }
                            if (iterator instanceof List) {
                                if (this.refs.contains(iterator)) {
                                    this.ensureCapacity(2);
                                    this.writeByte((byte)48);
                                    return;
                                }
                                this.refs.add(iterator);
                                this.ensureCapacity(8);
                                List list = (List)((Object)iterator);
                                this.writeByte((byte)91);
                                this.writeUInt(list.size());
                                iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    this.writeObject(iterator.next());
                                }
                                ArrayList arrayList = this.refs;
                                arrayList.remove(arrayList.size() - 1);
                                return;
                            }
                            if (iterator instanceof Number) {
                                this.writeNumber((Number)((Object)iterator));
                                return;
                            }
                            if (iterator instanceof Boolean) {
                                this.ensureCapacity(2);
                                if (((Boolean)((Object)iterator)).booleanValue()) {
                                    this.writeByte((byte)116);
                                } else {
                                    this.writeByte((byte)102);
                                }
                                return;
                            }
                            if (iterator == null) {
                                this.ensureCapacity(2);
                                this.writeByte((byte)48);
                                return;
                            }
                            if (iterator.getClass().isArray()) {
                                if (this.refs.contains(iterator)) {
                                    this.ensureCapacity(2);
                                    this.writeByte((byte)48);
                                    return;
                                }
                                this.refs.add(iterator);
                                this.ensureCapacity(8);
                                int n = Array.getLength(iterator);
                                this.writeByte((byte)91);
                                this.writeUInt(n);
                                for (int i = 0; i < n; ++i) {
                                    this.writeObject(Array.get(iterator, i));
                                }
                                ArrayList arrayList = this.refs;
                                arrayList.remove(arrayList.size() - 1);
                                return;
                            }
                            if (!(iterator instanceof Date)) break block23;
                            this.ensureCapacity(10);
                            double d = ((Date)((Object)iterator)).getTime();
                            this.writeByte((byte)100);
                            this.writeDouble(d);
                            break block24;
                        }
                        if (!(iterator instanceof Calendar)) break block25;
                        this.ensureCapacity(10);
                        double d = ((Calendar)((Object)iterator)).getTime().getTime();
                        this.writeByte((byte)100);
                        this.writeDouble(d);
                        break block24;
                    }
                    if (!(iterator instanceof Collection)) break block26;
                    if (this.refs.contains(iterator)) {
                        this.ensureCapacity(2);
                        this.writeByte((byte)48);
                        return;
                    }
                    this.refs.add(iterator);
                    this.ensureCapacity(8);
                    Collection collection = (Collection)((Object)iterator);
                    this.writeByte((byte)91);
                    this.writeUInt(collection.size());
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        this.writeObject(iterator.next());
                    }
                    ArrayList arrayList = this.refs;
                    arrayList.remove(arrayList.size() - 1);
                }
                return;
            }
            if (this.refs.contains(iterator)) {
                this.ensureCapacity(2);
                this.writeByte((byte)48);
            } else {
                this.refs.add(iterator);
                if (iterator.getClass().isEnum()) {
                    this.writeObject(JSON.toJSONString(iterator));
                } else {
                    this.writeAdapterObject(iterator);
                }
                ArrayList arrayList = this.refs;
                arrayList.remove(arrayList.size() - 1);
            }
        }

        private final void writeNumber(Number number) {
            this.ensureCapacity(12);
            if (number instanceof Integer) {
                this.writeByte((byte)105);
                this.writeVarInt(number.intValue());
                return;
            }
            if (number instanceof Float) {
                this.writeByte((byte)70);
                this.writeFloat(number.floatValue());
                return;
            }
            if (number instanceof Double) {
                this.writeByte((byte)100);
                this.writeDouble(number.doubleValue());
                return;
            }
            if (number instanceof Long) {
                this.writeByte((byte)108);
                this.writeLong(number.longValue());
                return;
            }
            if (!(number instanceof Short) && !(number instanceof Byte)) {
                if (number instanceof BigInteger) {
                    this.writeByte((byte)103);
                    this.writeUTF16String(number.toString());
                    return;
                }
                if (number instanceof BigDecimal) {
                    double d;
                    String string2 = number.toString();
                    if (string2.equals(Double.toString(d = number.doubleValue()))) {
                        Builder builder = this;
                        builder.writeByte((byte)100);
                        builder.writeDouble(d);
                    } else {
                        Builder builder = this;
                        builder.writeByte((byte)101);
                        builder.writeUTF16String(string2);
                    }
                    return;
                }
                this.writeByte((byte)115);
                this.writeUTF16String(number.toString());
                return;
            }
            this.writeByte((byte)105);
            this.writeVarInt(number.intValue());
        }

        private final void writeMap(Map object) {
            Object object2 = object.entrySet();
            int n = 0;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getValue() != null) continue;
                ++n;
            }
            Builder builder = this;
            builder.ensureCapacity(8);
            builder.writeByte((byte)123);
            this.writeUInt(object.size() - n);
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (Map.Entry)object.next();
                if (object2.getValue() == null) continue;
                this.writeMapKeyUTF16(object2.getKey().toString());
                this.writeObject(object2.getValue());
            }
        }

        private final void writeByte(byte by) {
            Builder builder = object;
            Object object = builder.buffer;
            int n = builder.position;
            object[n] = by;
            builder.position = n + 1;
        }

        private final void writeAdapterObject(Object object) {
            if (specialClass.get((Object)object.getClass().getName()) != null) {
                this.writeObject(JSON.toJSON((Object)object));
                return;
            }
            try {
                Builder builder = this;
                builder.writeMap(builder.toMap(object));
            }
            catch (Exception exception) {
                specialClass.put((Object)object.getClass().getName(), (Object)Boolean.TRUE);
                this.writeObject(JSON.toJSON((Object)object));
            }
        }

        /*
         * Exception decompiling
         */
        private final Map toMap(Object var1_2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 10[TRYBLOCK] [10 : 133->141)] java.lang.Exception
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final void writeMapKeyUTF16(String string2) {
            this.writeUTF16String(string2);
        }

        private final void writeUTF16String(CharSequence charSequence) {
            Builder builder = this;
            int n = charSequence.length();
            int n2 = n * 2;
            builder.ensureCapacity(n2 + 8);
            builder.writeUInt(n2);
            if (IS_NATIVE_LITTLE_ENDIAN) {
                for (n2 = 0; n2 < n; ++n2) {
                    Builder builder2 = this;
                    int n3 = charSequence.charAt(n2);
                    byte[] byArray = builder2.buffer;
                    int n4 = builder2.position;
                    int n5 = n3;
                    byArray[n4] = (byte)n3;
                    n3 = n4 + 1;
                    byArray[n3] = (byte)(n5 >>> 8);
                    builder2.position = n4 + 2;
                }
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    Builder builder3 = this;
                    int n6 = charSequence.charAt(n2);
                    byte[] byArray = builder3.buffer;
                    int n7 = builder3.position;
                    int n8 = n6;
                    int n9 = n6;
                    n6 = n7 + 1;
                    byArray[n6] = (byte)n9;
                    byArray[n7] = (byte)(n8 >>> 8);
                    builder3.position = n7 + 2;
                }
            }
        }

        private final void writeDouble(double d) {
            this.writeLong(Double.doubleToLongBits(d));
        }

        private final void writeFloat(float f) {
            Builder builder = this;
            int n = Float.floatToIntBits(f);
            byte[] byArray = builder.buffer;
            int n2 = builder.position;
            int n3 = n;
            int n4 = n;
            int n5 = n;
            int n6 = n;
            n = n2 + 3;
            byArray[n] = (byte)n6;
            n = n2 + 2;
            byArray[n] = (byte)(n5 >>> 8);
            n = n2 + 1;
            byArray[n] = (byte)(n4 >>> 16);
            byArray[n2] = (byte)(n3 >>> 24);
            builder.position = n2 + 4;
        }

        private final void writeLong(long l) {
            Builder builder = object;
            Object object = builder.buffer;
            int n = builder.position;
            object[n + 7] = (byte)l;
            int n2 = n + 6;
            object[n2] = (byte)(l >>> 8);
            n2 = n + 5;
            object[n2] = (byte)(l >>> 16);
            n2 = n + 4;
            object[n2] = (byte)(l >>> 24);
            n2 = n + 3;
            object[n2] = (byte)(l >>> 32);
            n2 = n + 2;
            object[n2] = (byte)(l >>> 40);
            n2 = n + 1;
            object[n2] = (byte)(l >>> 48);
            object[n] = (byte)(l >>> 56);
            builder.position = n + 8;
        }

        private final void writeVarInt(int n) {
            this.writeUInt(n << 1 ^ n >> 31);
        }

        private final void writeUInt(int n) {
            while ((n & 0xFFFFFF80) != 0) {
                Builder builder = object;
                byte[] byArray = builder.buffer;
                int n2 = builder.position;
                byArray[n2] = (byte)(n & 0x7F | 0x80);
                builder.position = n2 + 1;
                n >>>= 7;
            }
            Builder builder = object;
            Object object = builder.buffer;
            int n3 = builder.position;
            object[n3] = (byte)(n & 0x7F);
            builder.position = n3 + 1;
        }

        private final void ensureCapacity(int n) {
            byte[] byArray = this.buffer;
            if ((n += this.position) - this.buffer.length > 0) {
                int n2 = byArray.length << 1;
                if (n2 < 16384) {
                    n2 = 16384;
                }
                if (n2 - n >= 0) {
                    n = n2;
                }
                this.buffer = Arrays.copyOf(byArray, n);
            }
        }
    }
}

