/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.dom;

import android.text.Layout;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.collection.ArrayMap;
import com.taobao.weex.dom.binding.ELUtils;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbsStyle
implements Map<String, Object>,
Cloneable {
    private static final long serialVersionUID = 611132641365274134L;
    public static final int UNSET = -1;
    @NonNull
    protected Map<String, Object> mStyles;
    @Nullable
    protected Map<String, Map<String, Object>> mPesudoStyleMap;
    @Nullable
    protected Map<String, Object> mPesudoResetStyleMap;
    protected ArrayMap<String, Object> mBindingStyle;

    public AbsStyle() {
        ArrayMap arrayMap;
        AbsStyle absStyle = arrayMap;
        arrayMap = new ArrayMap();
        v1.mStyles = absStyle;
    }

    public AbsStyle(Map<String, Object> map) {
        AbsStyle absStyle = this;
        absStyle.mStyles = map;
        absStyle.processPesudoClasses(map);
    }

    public AbsStyle(Map<String, Object> map, boolean bl) {
        AbsStyle absStyle = this;
        absStyle();
        absStyle.putAll(map, bl);
    }

    public static WXTextDecoration getTextDecoration(Map<String, Object> object) {
        WXTextDecoration wXTextDecoration;
        if (object != null && (object = object.get("textDecoration")) != null) {
            object = object.toString();
            ((String)object).hashCode();
            int n = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 3387192: {
                    if (!((String)object).equals("none")) break;
                    n = 2;
                    break;
                }
                case -1026963764: {
                    if (!((String)object).equals("underline")) break;
                    n = 1;
                    break;
                }
                case -1171789332: {
                    if (!((String)object).equals("line-through")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    wXTextDecoration = WXTextDecoration.INVALID;
                    break;
                }
                case 2: {
                    wXTextDecoration = WXTextDecoration.NONE;
                    break;
                }
                case 1: {
                    wXTextDecoration = WXTextDecoration.UNDERLINE;
                    break;
                }
                case 0: {
                    wXTextDecoration = WXTextDecoration.LINETHROUGH;
                    break;
                }
            }
        } else {
            wXTextDecoration = WXTextDecoration.NONE;
        }
        return wXTextDecoration;
    }

    public static String getTextColor(Map<String, Object> object) {
        if (object == null) {
            return "";
        }
        return (object = object.get("color")) == null ? "" : object.toString();
    }

    public static int getFontWeight(Map<String, Object> object) {
        int n = 0;
        if (object != null && (object = object.get("fontWeight")) != null) {
            object = object.toString();
            ((String)object).hashCode();
            int n2 = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 3029637: {
                    if (!((String)object).equals("bold")) break;
                    n2 = 4;
                    break;
                }
                case 56313: {
                    if (!((String)object).equals("900")) break;
                    n2 = 3;
                    break;
                }
                case 55352: {
                    if (!((String)object).equals("800")) break;
                    n2 = 2;
                    break;
                }
                case 54391: {
                    if (!((String)object).equals("700")) break;
                    n2 = 1;
                    break;
                }
                case 53430: {
                    if (!((String)object).equals("600")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n = 1;
                }
            }
        }
        return n;
    }

    public static int getFontStyle(Map<String, Object> object) {
        int n = 0;
        if (object == null) {
            return n;
        }
        if ((object = object.get("fontStyle")) == null) {
            return n;
        }
        if (object.toString().equals("italic")) {
            n = 2;
        }
        return n;
    }

    public static int getFontSize(Map<String, Object> map, int n, float f) {
        if (map == null) {
            return (int)WXViewUtils.getRealPxByWidth((float)n, f);
        }
        int n2 = WXUtils.getInt(map.get("fontSize"));
        if (n2 > 0) {
            n = n2;
        }
        return (int)WXViewUtils.getRealPxByWidth((float)n, f);
    }

    public static String getFontFamily(Map<String, Object> object) {
        String string2 = null;
        if (object != null && (object = object.get("fontFamily")) != null) {
            string2 = object.toString();
        }
        return string2;
    }

    public static Layout.Alignment getTextAlignment(Map<String, Object> map) {
        return AbsStyle.getTextAlignment(map, false);
    }

    public static Layout.Alignment getTextAlignment(Map<String, Object> object, boolean bl) {
        Layout.Alignment alignment = bl ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL;
        if (TextUtils.equals((CharSequence)"left", (CharSequence)(object = (String)object.get("textAlign")))) {
            alignment = Layout.Alignment.ALIGN_NORMAL;
        } else if (TextUtils.equals((CharSequence)"center", (CharSequence)object)) {
            alignment = Layout.Alignment.ALIGN_CENTER;
        } else if (TextUtils.equals((CharSequence)"right", (CharSequence)object)) {
            alignment = Layout.Alignment.ALIGN_OPPOSITE;
        }
        return alignment;
    }

    public static TextUtils.TruncateAt getTextOverflow(Map<String, Object> truncateAt) {
        TextUtils.TruncateAt truncateAt2 = truncateAt;
        truncateAt = null;
        if (TextUtils.equals((CharSequence)"ellipsis", (CharSequence)((String)truncateAt2.get("textOverflow")))) {
            truncateAt = TextUtils.TruncateAt.END;
        }
        return truncateAt;
    }

    public static int getLines(Map<String, Object> map) {
        return WXUtils.getInt(map.get("lines"));
    }

    public static int getLineHeight(Map<String, Object> map, float f) {
        if (map == null) {
            return -1;
        }
        int n = WXUtils.getInt(map.get("lineHeight"));
        if (n <= 0) {
            return -1;
        }
        return (int)WXViewUtils.getRealPxByWidth((float)n, f);
    }

    private void initPesudoMapsIfNeed(Map<? extends String, ?> map) {
        ArrayMap arrayMap;
        if (this.mPesudoStyleMap == null) {
            ArrayMap arrayMap2;
            arrayMap = arrayMap2;
            arrayMap2 = new ArrayMap();
            this.mPesudoStyleMap = arrayMap;
        }
        if (this.mPesudoResetStyleMap == null) {
            ArrayMap arrayMap3;
            arrayMap = arrayMap3;
            arrayMap3 = new ArrayMap();
            this.mPesudoResetStyleMap = arrayMap;
        }
        if (this.mPesudoResetStyleMap.isEmpty()) {
            this.mPesudoResetStyleMap.putAll(map);
        }
    }

    private Map<String, Object> parseBindingStylesStatements(Map map) {
        if (map != null && map.size() != 0) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Map<String, Map<String, Object>> map2 = (String)entry.getKey();
                if (!this.addBindingStyleIfStatement((String)((Object)map2), entry.getValue())) continue;
                map2 = this.mPesudoStyleMap;
                if (map2 != null) {
                    map2.remove(entry.getKey());
                }
                if ((map2 = this.mPesudoResetStyleMap) != null) {
                    map2.remove(entry.getKey());
                }
                iterator.remove();
            }
            return map;
        }
        return map;
    }

    private boolean addBindingStyleIfStatement(String string2, Object object) {
        if (ELUtils.isBinding(object)) {
            if (((AbsStyle)object2).mBindingStyle == null) {
                ArrayMap arrayMap;
                ArrayMap arrayMap2 = arrayMap;
                arrayMap = new ArrayMap();
                ((AbsStyle)object2).mBindingStyle = arrayMap2;
            }
            AbsStyle absStyle = object2;
            Object object2 = ELUtils.bindingBlock(object);
            absStyle.mBindingStyle.put((Object)string2, object2);
            return true;
        }
        return false;
    }

    @Nullable
    public String getBlur() {
        if (this.get("filter") == null) {
            return null;
        }
        return this.get("filter").toString().trim();
    }

    public float getBorderRadius() {
        float f = WXUtils.getFloat(this.get("borderRadius"));
        if (WXUtils.isUndefined(f)) {
            return Float.NaN;
        }
        return f;
    }

    public String getBorderColor() {
        return (this = ((AbsStyle)this).get("borderColor")) == null ? null : this.toString();
    }

    public String getBorderStyle() {
        return (this = ((AbsStyle)this).get("borderStyle")) == null ? null : this.toString();
    }

    public boolean isSticky() {
        if ((this = ((AbsStyle)this).get("position")) == null) {
            return false;
        }
        return this.toString().equals("sticky");
    }

    public boolean isFixed() {
        if ((this = ((AbsStyle)this).get("position")) == null) {
            return false;
        }
        return this.toString().equals("fixed");
    }

    public float getLeft() {
        float f = WXUtils.getFloat(this.get("left"));
        if (WXUtils.isUndefined(f)) {
            return Float.NaN;
        }
        return f;
    }

    public float getRight() {
        float f = WXUtils.getFloat(this.get("right"));
        if (WXUtils.isUndefined(f)) {
            return Float.NaN;
        }
        return f;
    }

    public float getTop() {
        float f = WXUtils.getFloat(this.get("top"));
        if (WXUtils.isUndefined(f)) {
            return Float.NaN;
        }
        return f;
    }

    public float getBottom() {
        float f = WXUtils.getFloat(this.get("bottom"));
        if (WXUtils.isUndefined(f)) {
            return Float.NaN;
        }
        return f;
    }

    public String getBackgroundColor() {
        return (this = ((AbsStyle)this).get("backgroundColor")) == null ? "" : this.toString();
    }

    public int getTimeFontSize(int n) {
        int n2 = WXUtils.getInt(this.get("timeFontSize"));
        if (n2 > 0) {
            n = n2;
        }
        return n;
    }

    public float getOpacity() {
        Object object = ((AbsStyle)object).get("opacity");
        float f = 1.0f;
        if (object == null) {
            return f;
        }
        return WXUtils.getFloat(object);
    }

    public String getOverflow() {
        return (this = ((AbsStyle)this).get("overflow")) == null ? "visible" : this.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this.mStyles.equals(object);
    }

    @Override
    public int hashCode() {
        return this.mStyles.hashCode();
    }

    @Override
    public void clear() {
        this.mStyles.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.mStyles.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.mStyles.containsValue(object);
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.mStyles.entrySet();
    }

    @Override
    public Object get(Object object) {
        return this.mStyles.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.mStyles.isEmpty();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.mStyles.keySet();
    }

    @Override
    public Object put(String string2, Object object) {
        if (this.addBindingStyleIfStatement(string2, object)) {
            return null;
        }
        return this.mStyles.put(string2, object);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.mStyles.putAll(map);
    }

    public void putAll(Map<? extends String, ?> map, boolean bl) {
        this.mStyles.putAll(map);
        if (!bl) {
            this.processPesudoClasses(map);
        }
    }

    public void updateStyle(Map<? extends String, ?> map, boolean bl) {
        AbsStyle absStyle = this;
        absStyle.parseBindingStylesStatements(map);
        absStyle.putAll(map, bl);
    }

    public Map<String, Object> getPesudoResetStyles() {
        if (this.mPesudoResetStyleMap == null) {
            ArrayMap arrayMap;
            ArrayMap arrayMap2 = arrayMap;
            arrayMap = new ArrayMap();
            this.mPesudoResetStyleMap = arrayMap2;
        }
        return this.mPesudoResetStyleMap;
    }

    public Map<String, Map<String, Object>> getPesudoStyles() {
        if (this.mPesudoStyleMap == null) {
            ArrayMap arrayMap;
            ArrayMap arrayMap2 = arrayMap;
            arrayMap = new ArrayMap();
            this.mPesudoStyleMap = arrayMap2;
        }
        return this.mPesudoStyleMap;
    }

    <T extends String, V> void processPesudoClasses(Map<T, V> map) {
        Map map2 = null;
        for (Map.Entry<T, V> entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            int n = string2.indexOf(":");
            if (n <= 0) continue;
            this.initPesudoMapsIfNeed(map);
            String string3 = string2.substring(n);
            if (string3.equals(":enabled")) {
                string2 = string2.substring(0, n);
                if (map2 == null) {
                    ArrayMap arrayMap;
                    map2 = arrayMap;
                    arrayMap = new ArrayMap();
                }
                map2.put(string2, entry.getValue());
                this.mPesudoResetStyleMap.put(string2, entry.getValue());
                continue;
            }
            ArrayMap arrayMap = this.mPesudoStyleMap.get(string3 = string3.replace(":enabled", ""));
            if (arrayMap == null) {
                ArrayMap arrayMap2;
                arrayMap = arrayMap2;
                arrayMap2 = new ArrayMap();
                this.mPesudoStyleMap.put(string3, (Map<String, Object>)arrayMap);
            }
            Map.Entry<T, V> entry2 = entry;
            entry = string2.substring(0, n);
            arrayMap.put(entry, entry2.getValue());
        }
        if (map2 != null && !map2.isEmpty()) {
            this.mStyles.putAll(map2);
        }
    }

    @Override
    public Object remove(Object object) {
        return this.mStyles.remove(object);
    }

    @Override
    public int size() {
        return this.mStyles.size();
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        return this.mStyles.values();
    }

    public void parseStatements() {
        Map<String, Object> map = this.mStyles;
        if (map != null) {
            this.mStyles = this.parseBindingStylesStatements(map);
        }
    }

    public ArrayMap<String, Object> getBindingStyle() {
        return this.mBindingStyle;
    }

    public abstract AbsStyle clone();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String toString() {
        return this.mStyles.toString();
    }
}

