/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.widget.refresh;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.dcloud.android.v4.view.ViewCompat;

public class DCWeexCircleImageView
extends ImageView {
    private static final int KEY_SHADOW_COLOR = 0x5E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.0f;
    private static final float SHADOW_RADIUS = 2.5f;
    private static final int SHADOW_ELEVATION = 4;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;

    public DCWeexCircleImageView(Context context, int n, float f) {
        ShapeDrawable shapeDrawable;
        DCWeexCircleImageView dCWeexCircleImageView = this;
        super(context);
        float f2 = dCWeexCircleImageView.getContext().getResources().getDisplayMetrics().density;
        int n2 = (int)(f * f2 * 2.0f);
        int n3 = (int)(f2 * 1.0f);
        int n4 = (int)(f2 * 0.0f);
        dCWeexCircleImageView.mShadowRadius = (int)(f2 * 2.5f);
        if (dCWeexCircleImageView.elevationSupported()) {
            ShapeDrawable shapeDrawable2;
            shapeDrawable = shapeDrawable2;
            shapeDrawable2 = new ShapeDrawable((Shape)new OvalShape());
            ViewCompat.setElevation((View)this, (float)(f2 * 4.0f));
        } else {
            ShapeDrawable shapeDrawable3;
            OvalShadow ovalShadow;
            DCWeexCircleImageView dCWeexCircleImageView2 = this;
            OvalShadow ovalShadow2 = ovalShadow;
            DCWeexCircleImageView dCWeexCircleImageView3 = this;
            ovalShadow = dCWeexCircleImageView3.new OvalShadow(dCWeexCircleImageView3.mShadowRadius, n2);
            ShapeDrawable shapeDrawable4 = shapeDrawable3;
            ViewCompat.setLayerType((View)dCWeexCircleImageView2, (int)1, (Paint)new ShapeDrawable((Shape)ovalShadow2).getPaint());
            float f3 = this.mShadowRadius;
            float f4 = n4;
            float f5 = n3;
            shapeDrawable4.getPaint().setShadowLayer(f3, f4, f5, 0x5E000000);
            int n5 = dCWeexCircleImageView2.mShadowRadius;
            dCWeexCircleImageView2.setPadding(n5, n5, n5, n5);
            shapeDrawable = shapeDrawable4;
        }
        ShapeDrawable shapeDrawable5 = shapeDrawable;
        shapeDrawable5.getPaint().setColor(n);
        this.setBackgroundDrawable((Drawable)shapeDrawable5);
    }

    private boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    static /* synthetic */ int access$002(DCWeexCircleImageView dCWeexCircleImageView, int n) {
        dCWeexCircleImageView.mShadowRadius = n;
        return n;
    }

    protected void onMeasure(int n, int n2) {
        DCWeexCircleImageView dCWeexCircleImageView = this;
        super.onMeasure(n, n2);
        if (!dCWeexCircleImageView.elevationSupported()) {
            DCWeexCircleImageView dCWeexCircleImageView2 = this;
            dCWeexCircleImageView2.setMeasuredDimension(dCWeexCircleImageView2.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    public void setAnimationListener(Animation.AnimationListener animationListener) {
        this.mListener = animationListener;
    }

    public void onAnimationStart() {
        DCWeexCircleImageView dCWeexCircleImageView = this;
        super.onAnimationStart();
        Animation.AnimationListener animationListener = dCWeexCircleImageView.mListener;
        if (animationListener != null) {
            animationListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        DCWeexCircleImageView dCWeexCircleImageView = this;
        super.onAnimationEnd();
        Animation.AnimationListener animationListener = dCWeexCircleImageView.mListener;
        if (animationListener != null) {
            animationListener.onAnimationEnd(this.getAnimation());
        }
    }

    public void setBackgroundColorRes(int n) {
        DCWeexCircleImageView dCWeexCircleImageView = this;
        dCWeexCircleImageView.setBackgroundColor(dCWeexCircleImageView.getContext().getResources().getColor(n));
    }

    public void setBackgroundColor(int n) {
        if (this.getBackground() instanceof ShapeDrawable) {
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(n);
        }
    }

    private class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private Paint mShadowPaint = new Paint();
        private int mCircleDiameter;

        public OvalShadow(int n, int n2) {
            RadialGradient radialGradient;
            DCWeexCircleImageView.access$002(DCWeexCircleImageView.this, n);
            this.mCircleDiameter = n2;
            RadialGradient radialGradient2 = radialGradient;
            int n3 = this.mCircleDiameter;
            float f = n3 / 2;
            float f2 = n3 / 2;
            float f3 = DCWeexCircleImageView.this.mShadowRadius;
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = 0x3D000000;
            nArray[1] = 0;
            DCWeexCircleImageView.this = Shader.TileMode.CLAMP;
            this.mRadialGradient = new RadialGradient(f, f2, f3, nArray2, null, (Shader.TileMode)DCWeexCircleImageView.this);
            this.mShadowPaint.setShader((Shader)radialGradient2);
        }

        public void draw(Canvas canvas, Paint paint) {
            Canvas canvas2 = canvas;
            OvalShadow ovalShadow = this;
            int n = ovalShadow.DCWeexCircleImageView.this.getWidth();
            float f = n / 2;
            float f2 = ovalShadow.DCWeexCircleImageView.this.getHeight() / 2;
            float f3 = ovalShadow.mCircleDiameter / 2 + DCWeexCircleImageView.this.mShadowRadius;
            Paint paint2 = ovalShadow.mShadowPaint;
            canvas2.drawCircle(f, f2, f3, paint2);
            canvas2.drawCircle(f, f2, (float)(this.mCircleDiameter / 2), paint);
        }
    }
}

