/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.aztec.AztecDetectorResult;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.GridSampler;
import com.dcloud.zxing2.common.detector.MathUtils;
import com.dcloud.zxing2.common.detector.WhiteRectangleDetector;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;

public final class Detector {
    private static final int[] EXPECTED_CORNER_BITS = new int[]{3808, 476, 2107, 1799};
    private final BitMatrix image;
    private boolean compact;
    private int nbLayers;
    private int nbDataBlocks;
    private int nbCenterLayers;
    private int shift;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    private void extractParameters(ResultPoint[] resultPointArray) throws NotFoundException {
        if (this.isValid(resultPointArray[0]) && this.isValid(resultPointArray[1]) && this.isValid(resultPointArray[2]) && this.isValid(resultPointArray[3])) {
            int[] nArray;
            int n5 = this.nbCenterLayers * 2;
            ResultPoint resultPoint = resultPointArray[0];
            int n6 = this.sampleLine(resultPoint, resultPointArray[1], n5);
            ResultPoint resultPoint2 = resultPointArray[1];
            int n7 = this.sampleLine(resultPoint2, resultPointArray[2], n5);
            ResultPoint resultPoint3 = resultPointArray[2];
            int n8 = this.sampleLine(resultPoint3, resultPointArray[3], n5);
            ResultPoint resultPoint4 = resultPointArray[3];
            int n9 = this.sampleLine(resultPoint4, resultPointArray[0], n5);
            int[] nArray2 = nArray = new int[4];
            int[] nArray3 = nArray;
            nArray2[0] = n6;
            nArray3[1] = n7;
            nArray2[2] = n8;
            nArray3[3] = n9;
            this.shift = Detector.getRotation(nArray, n5);
            long l5 = 0L;
            for (n5 = 0; n5 < 4; ++n5) {
                n8 = nArray[(this.shift + n5) % 4];
                l5 = this.compact ? (l5 << 7) + (long)(n8 >> 1 & 0x7F) : (l5 << 10) + (long)((n8 >> 2 & 0x3E0) + (n8 >> 1 & 0x1F));
            }
            n5 = Detector.getCorrectedParameterData(l5, this.compact);
            if (this.compact) {
                this.nbLayers = (n5 >> 6) + 1;
                this.nbDataBlocks = (n5 & 0x3F) + 1;
                return;
            }
            this.nbLayers = (n5 >> 11) + 1;
            this.nbDataBlocks = (n5 & 0x7FF) + 1;
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int getRotation(int[] nArray, int n5) throws NotFoundException {
        int n6 = 0;
        int n7 = nArray.length;
        for (int i5 = 0; i5 < n7; ++i5) {
            int n8 = n6;
            n6 = nArray[i5];
            n6 = (n6 >> n5 - 2 << 1) + (n6 & 1);
            n6 = (n8 << 3) + n6;
        }
        int n9 = ((n6 & 1) << 11) + (n6 >> 1);
        for (n5 = 0; n5 < 4; ++n5) {
            if (Integer.bitCount(n9 ^ EXPECTED_CORNER_BITS[n5]) > 2) continue;
            return n5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    /*
     * WARNING - void declaration
     */
    private static int getCorrectedParameterData(long l5, boolean bl) throws NotFoundException {
        int n5;
        void var2_5;
        int n6;
        if (bl) {
            int n7 = 7;
            n6 = 2;
        } else {
            int n8 = 10;
            n6 = 4;
        }
        void v02 = var2_5;
        void var2_6 = v02 - n6;
        int[] nArray = new int[v02];
        for (void var5_9 = (v36840) - true; var5_9 >= 0; --var5_9) {
            nArray[var5_9] = (int)l5 & 0xF;
            l5 >>= 4;
        }
        try {
            new ReedSolomonDecoder(GenericGF.AZTEC_PARAM).decode(nArray, (int)var2_6);
            n5 = 0;
        }
        catch (ReedSolomonException reedSolomonException) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (int i5 = 0; i5 < n6; ++i5) {
            n5 = (n5 << 4) + nArray[i5];
        }
        return n5;
    }

    private ResultPoint[] getBullsEyeCorners(Point object) throws NotFoundException {
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        boolean bl = true;
        this.nbCenterLayers = 1;
        Point point = object;
        Object object2 = object;
        Object object3 = object;
        boolean bl2 = bl;
        while (this.nbCenterLayers < 9) {
            double d6;
            Detector detector = this;
            Point point2 = this.getFirstDifferent((Point)object, bl2, 1, -1);
            Point point3 = this.getFirstDifferent((Point)object3, bl2, 1, 1);
            Point point4 = this.getFirstDifferent((Point)object2, bl2, -1, 1);
            Point point5 = detector.getFirstDifferent(point, bl2, -1, -1);
            if (detector.nbCenterLayers > 2 && ((d6 = (double)(Detector.distance(point5, point2) * (float)this.nbCenterLayers / (Detector.distance(point, (Point)object) * (float)(this.nbCenterLayers + 2)))) < 0.75 || d6 > 1.25 || !this.isWhiteOrBlackRectangle(point2, point3, point4, point5))) break;
            boolean bl3 = bl2 ^ true;
            ++this.nbCenterLayers;
            point = point5;
            object2 = point4;
            object3 = point3;
            bl2 = bl3;
            object = point2;
        }
        if (!(bl2 = this.nbCenterLayers) && !bl2) {
            throw NotFoundException.getNotFoundInstance();
        }
        bl2 = bl2;
        this.compact = bl2;
        ResultPoint resultPoint5 = resultPoint4;
        resultPoint4 = new ResultPoint((float)((Point)object).getX() + 0.5f, (float)((Point)object).getY() - 0.5f);
        object = resultPoint3;
        resultPoint3 = new ResultPoint((float)((Point)object3).getX() + 0.5f, (float)((Point)object3).getY() + 0.5f);
        object3 = resultPoint2;
        resultPoint2 = new ResultPoint((float)((Point)object2).getX() - 0.5f, (float)((Point)object2).getY() + 0.5f);
        object2 = resultPoint;
        resultPoint = new ResultPoint((float)point.getX() - 0.5f, (float)point.getY() - 0.5f);
        int n5 = this.nbCenterLayers;
        float f5 = n5 * 2 - 3;
        return Detector.expandSquare(new ResultPoint[]{resultPoint5, object, object3, object2}, f5, n5 * 2);
    }

    private Point getMatrixCenter() {
        Object object;
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint[] resultPointArray = new WhiteRectangleDetector(((Detector)object).image).detect();
        ResultPoint[] resultPointArray2 = resultPointArray;
        ResultPoint[] resultPointArray3 = resultPointArray;
        ResultPoint[] resultPointArray4 = resultPointArray;
        ResultPoint resultPoint3 = resultPointArray[0];
        ResultPoint resultPoint4 = resultPointArray2[1];
        ResultPoint resultPoint5 = resultPointArray3[2];
        try {
            resultPoint2 = resultPointArray4[3];
        }
        catch (NotFoundException notFoundException) {
            Detector detector = object;
            int n5 = detector.image.getWidth() / 2;
            int n6 = detector.image.getHeight() / 2;
            int n7 = n5 + 7;
            int n8 = n6 - 7;
            resultPoint = detector.getFirstDifferent(new Point(n7, n8), false, 1, -1).toResultPoint();
            resultPoint5 = detector.getFirstDifferent(new Point(n7, n6 += 7), false, 1, 1).toResultPoint();
            resultPoint4 = detector.getFirstDifferent(new Point(n5 -= 7, n6), false, -1, 1).toResultPoint();
            resultPoint2 = detector.getFirstDifferent(new Point(n5, n8), false, -1, -1).toResultPoint();
            ResultPoint resultPoint6 = resultPoint5;
            resultPoint5 = resultPoint4;
            resultPoint4 = resultPoint6;
            resultPoint3 = resultPoint;
        }
        ResultPoint resultPoint7 = resultPoint3;
        int n9 = MathUtils.round((resultPoint7.getX() + resultPoint2.getX() + resultPoint4.getX() + resultPoint5.getX()) / 4.0f);
        int n10 = MathUtils.round((resultPoint7.getY() + resultPoint2.getY() + resultPoint4.getY() + resultPoint5.getY()) / 4.0f);
        ResultPoint[] resultPointArray5 = new WhiteRectangleDetector(((Detector)object).image, 15, n9, n10).detect();
        ResultPoint[] resultPointArray6 = resultPointArray5;
        ResultPoint[] resultPointArray7 = resultPointArray5;
        ResultPoint[] resultPointArray8 = resultPointArray5;
        resultPoint5 = resultPointArray5[0];
        resultPoint2 = resultPointArray6[1];
        resultPoint = resultPointArray7[2];
        try {
            object = resultPointArray8[3];
        }
        catch (NotFoundException notFoundException) {
            Detector detector = object;
            int n11 = n9 + 7;
            int n12 = n10 - 7;
            resultPoint2 = detector.getFirstDifferent(new Point(n11, n12), false, 1, -1).toResultPoint();
            int n13 = n11;
            n11 = n10 + 7;
            ResultPoint resultPoint8 = detector.getFirstDifferent(new Point(n13, n11), false, 1, 1).toResultPoint();
            resultPoint = detector.getFirstDifferent(new Point(n9 -= 7, n11), false, -1, 1).toResultPoint();
            object = detector.getFirstDifferent(new Point(n9, n12), false, -1, -1).toResultPoint();
            ResultPoint resultPoint9 = resultPoint2;
            resultPoint2 = resultPoint8;
            resultPoint5 = resultPoint9;
        }
        ResultPoint resultPoint10 = resultPoint5;
        n9 = MathUtils.round((resultPoint10.getX() + ((ResultPoint)object).getX() + resultPoint2.getX() + resultPoint.getX()) / 4.0f);
        int n14 = MathUtils.round((resultPoint10.getY() + ((ResultPoint)object).getY() + resultPoint2.getY() + resultPoint.getY()) / 4.0f);
        return new Point(n9, n14);
    }

    private ResultPoint[] getMatrixCornerPoints(ResultPoint[] resultPointArray) {
        return Detector.expandSquare(resultPointArray, this.nbCenterLayers * 2, this.getDimension());
    }

    private BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        ResultPoint resultPoint5 = resultPoint4;
        ResultPoint resultPoint6 = resultPoint3;
        ResultPoint resultPoint7 = resultPoint2;
        ResultPoint resultPoint8 = resultPoint;
        int n5 = this.getDimension();
        float f5 = (float)n5 / 2.0f;
        int n6 = this.nbCenterLayers;
        float f6 = f5 - (float)n6;
        float f7 = f5 + (float)n6;
        float f8 = resultPoint8.getX();
        float f9 = resultPoint8.getY();
        float f10 = resultPoint7.getX();
        float f11 = resultPoint7.getY();
        float f12 = resultPoint6.getX();
        float f13 = resultPoint6.getY();
        float f14 = resultPoint5.getX();
        float f15 = resultPoint5.getY();
        int n7 = n5;
        float f16 = f6;
        float f17 = f7;
        return GridSampler.getInstance().sampleGrid(bitMatrix, n7, n7, f16, f16, f7, f6, f17, f17, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15);
    }

    private int sampleLine(ResultPoint resultPoint, ResultPoint resultPoint2, int n5) {
        int n6 = 0;
        float f5 = Detector.distance(resultPoint, resultPoint2);
        float f6 = f5 / (float)n5;
        ResultPoint resultPoint3 = resultPoint;
        float f7 = resultPoint3.getX();
        float f8 = resultPoint3.getY();
        float f9 = f6 * (resultPoint2.getX() - resultPoint.getX()) / f5;
        float f10 = f6 * (resultPoint2.getY() - resultPoint.getY()) / f5;
        for (int i5 = 0; i5 < n5; ++i5) {
            float f11 = i5;
            int n7 = MathUtils.round(f7 + f11 * f9);
            if (!this.image.get(n7, MathUtils.round(f8 + f11 * f10))) continue;
            n6 |= 1 << n5 - i5 - 1;
        }
        return n6;
    }

    private boolean isWhiteOrBlackRectangle(Point point, Point point2, Point point3, Point point4) {
        Point point5;
        Point point6;
        Point point7;
        Point point8;
        Point point9 = point8;
        point8 = new Point(point.getX() - 3, point.getY() + 3);
        point = point7;
        point7 = new Point(point2.getX() - 3, point2.getY() - 3);
        point2 = point6;
        point6 = new Point(point3.getX() + 3, point3.getY() - 3);
        point3 = point5;
        point3(point4.getX() + 3, point4.getY() + 3);
        int n5 = this.getColor(point5, point9);
        if (n5 == 0) {
            return false;
        }
        if (this.getColor(point9, point) != n5) {
            return false;
        }
        if (this.getColor(point, point2) != n5) {
            return false;
        }
        return this.getColor(point2, point3) == n5;
    }

    private int getColor(Point point, Point point2) {
        float f5;
        Point point3 = point;
        Point point4 = point2;
        float f6 = Detector.distance(point, point2);
        float f7 = (float)(point4.getX() - point.getX()) / f6;
        float f8 = (float)(point4.getY() - point.getY()) / f6;
        int n5 = 0;
        float f9 = point3.getX();
        float f10 = point3.getY();
        Point point5 = point;
        int n6 = point5.getX();
        n6 = this.image.get(n6, point5.getY()) ? 1 : 0;
        int n7 = 0;
        while ((float)n7 < f6) {
            int n8 = MathUtils.round(f9 += f7);
            if (this.image.get(n8, MathUtils.round(f10 += f8)) != n6) {
                ++n5;
            }
            ++n7;
        }
        float f11 = (float)n5 / f6;
        if (f5 > 0.1f && f11 < 0.9f) {
            return 0;
        }
        if ((f11 <= 0.1f ? 1 : 0) == n6) {
            return 1;
        }
        return -1;
    }

    private Point getFirstDifferent(Point point, boolean bl, int n5, int n6) {
        Point point2 = point;
        int n7 = point2.getX() + n5;
        int n8 = point2.getY() + n6;
        while (this.isValid(n7, n8) && this.image.get(n7, n8) == bl) {
            n7 += n5;
            n8 += n6;
        }
        n7 -= n5;
        n8 -= n6;
        while (this.isValid(n7, n8) && this.image.get(n7, n8) == bl) {
            n7 += n5;
        }
        n7 -= n5;
        while (this.isValid(n7, n8) && this.image.get(n7, n8) == bl) {
            n8 += n6;
        }
        int n9 = n8 - n6;
        return new Point(n7, n9);
    }

    private static ResultPoint[] expandSquare(ResultPoint[] resultPointArray, float f5, float f6) {
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        f5 = f6 / (f5 * 2.0f);
        f6 = resultPointArray[0].getX() - resultPointArray[2].getX();
        float f7 = resultPointArray[0].getY() - resultPointArray[2].getY();
        float f8 = (resultPointArray[0].getX() + resultPointArray[2].getX()) / 2.0f;
        float f9 = (resultPointArray[0].getY() + resultPointArray[2].getY()) / 2.0f;
        ResultPoint resultPoint5 = resultPoint4;
        float f10 = f7;
        f6 = f5 * f6;
        f7 = f8 + f6;
        float f11 = f5 * f10;
        resultPoint4 = new ResultPoint(f7, f9 + f11);
        ResultPoint resultPoint6 = resultPoint3;
        f6 = f8 - f6;
        resultPoint3 = new ResultPoint(f6, f9 - f11);
        f6 = resultPointArray[1].getX() - resultPointArray[3].getX();
        f8 = resultPointArray[1].getY() - resultPointArray[3].getY();
        f9 = (resultPointArray[1].getX() + resultPointArray[3].getX()) / 2.0f;
        float f12 = (resultPointArray[1].getY() + resultPointArray[3].getY()) / 2.0f;
        ResultPoint resultPoint7 = resultPoint2;
        float f13 = f5;
        f5 *= f6;
        f6 = f9 + f5;
        f8 = f13 * f8;
        resultPoint2 = new ResultPoint(f6, f12 + f8);
        ResultPoint resultPoint8 = resultPoint;
        float f14 = f12;
        f12 = f9 - f5;
        resultPoint = new ResultPoint(f12, f14 - f8);
        return new ResultPoint[]{resultPoint5, resultPoint7, resultPoint6, resultPoint8};
    }

    private boolean isValid(int n5, int n6) {
        return n5 >= 0 && n5 < this.image.getWidth() && n6 > 0 && n6 < this.image.getHeight();
    }

    private boolean isValid(ResultPoint resultPoint) {
        return this.isValid(MathUtils.round(resultPoint.getX()), MathUtils.round(resultPoint.getY()));
    }

    private static float distance(Point point, Point point2) {
        Point point3 = point2;
        int n5 = point.getY();
        int n6 = point3.getX();
        int n7 = point3.getY();
        return MathUtils.distance(point.getX(), n5, n6, n7);
    }

    private static float distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        ResultPoint resultPoint3 = resultPoint2;
        float f5 = resultPoint.getY();
        float f6 = resultPoint3.getX();
        float f7 = resultPoint3.getY();
        return MathUtils.distance(resultPoint.getX(), f5, f6, f7);
    }

    private int getDimension() {
        if (this.compact) {
            return this.nbLayers * 4 + 11;
        }
        int n5 = this.nbLayers;
        if (n5 <= 4) {
            return n5 * 4 + 15;
        }
        return n5 * 4 + ((n5 - 4) / 8 + 1) * 2 + 15;
    }

    public AztecDetectorResult detect() throws NotFoundException {
        return this.detect(false);
    }

    public AztecDetectorResult detect(boolean bl) throws NotFoundException {
        ResultPoint[] resultPointArray;
        Detector detector = this;
        Object object = detector.getBullsEyeCorners(detector.getMatrixCenter());
        if (bl) {
            ResultPoint[] resultPointArray2 = object;
            ResultPoint[] resultPointArray3 = object;
            resultPointArray = resultPointArray2[0];
            resultPointArray2[0] = resultPointArray3[2];
            resultPointArray3[2] = resultPointArray;
        }
        ResultPoint[] resultPointArray4 = object;
        ResultPoint[] resultPointArray5 = object;
        Detector detector2 = this;
        detector2.extractParameters((ResultPoint[])object);
        resultPointArray = detector2.image;
        int n5 = detector2.shift;
        ResultPoint[] resultPointArray6 = object;
        ResultPoint[] resultPointArray7 = object;
        object = object[n5 % 4];
        ResultPoint resultPoint = resultPointArray7[(n5 + 1) % 4];
        ResultPoint resultPoint2 = resultPointArray6[(n5 + 2) % 4];
        ResultPoint resultPoint3 = resultPointArray5[(n5 + 3) % 4];
        object = this.sampleGrid((BitMatrix)resultPointArray, (ResultPoint)object, resultPoint, resultPoint2, resultPoint3);
        resultPointArray = this.getMatrixCornerPoints(resultPointArray4);
        Detector detector3 = this;
        boolean bl2 = detector3.compact;
        int n6 = detector3.nbDataBlocks;
        int n7 = detector3.nbLayers;
        return new AztecDetectorResult((BitMatrix)object, resultPointArray, bl2, n6, n7);
    }

    static final class Point {
        private final int x;
        private final int y;

        Point(int n5, int n6) {
            this.x = n5;
            this.y = n6;
        }

        ResultPoint toResultPoint() {
            return new ResultPoint(this.getX(), this.getY());
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }

        public String toString() {
            return "<" + this.x + ' ' + this.y + '>';
        }
    }
}

