/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.core;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.dcloud.android.downloader.core.DownloadResponse;
import com.dcloud.android.downloader.db.DownloadDBController;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import com.dcloud.android.downloader.exception.DownloadException;

public class DownloadResponseImpl
implements DownloadResponse {
    private static final String TAG = "DownloadResponseImpl";
    private final Handler handler;
    private final DownloadDBController downloadDBController;

    public DownloadResponseImpl(DownloadDBController downloadDBController) {
        Handler handler;
        this.downloadDBController = downloadDBController;
        downloadDBController = handler;
        handler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                super.handleMessage(message);
                DownloadInfo downloadInfo = (DownloadInfo)message.obj;
                switch (downloadInfo.getStatus()) {
                    default: {
                        break;
                    }
                    case 7: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onRemoved();
                        break;
                    }
                    case 6: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        DownloadInfo downloadInfo2 = downloadInfo;
                        downloadInfo.getDownloadListener().onDownloadFailed(downloadInfo2, downloadInfo2.getException());
                        break;
                    }
                    case 5: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onDownloadSuccess(downloadInfo);
                        break;
                    }
                    case 4: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onPaused();
                        break;
                    }
                    case 3: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onWaited();
                        break;
                    }
                    case 2: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        DownloadInfo downloadInfo3 = downloadInfo;
                        long l5 = downloadInfo3.getProgress();
                        long l6 = downloadInfo3.getSize();
                        downloadInfo.getDownloadListener().onDownloading(l5, l6);
                        break;
                    }
                    case 1: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onStart();
                    }
                }
            }
        };
        this.handler = downloadDBController;
    }

    @Override
    public void onStatusChanged(DownloadInfo downloadInfo) {
        if (downloadInfo.getStatus() != 7) {
            this.downloadDBController.createOrUpdate(downloadInfo);
            if (downloadInfo.getDownloadThreadInfos() != null) {
                for (DownloadThreadInfo downloadThreadInfo : downloadInfo.getDownloadThreadInfos()) {
                    this.downloadDBController.createOrUpdate(downloadThreadInfo);
                }
            }
        }
        this.handler.obtainMessage(downloadInfo.getId()).obj = downloadInfo;
        this.handler.obtainMessage(downloadInfo.getId()).sendToTarget();
        Log.d((String)TAG, (String)("progress:" + downloadInfo.getProgress() + ",size:" + downloadInfo.getSize()));
    }

    @Override
    public void handleException(DownloadException downloadException) {
    }
}

