/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.core;

import com.dcloud.android.downloader.config.Config;
import com.dcloud.android.downloader.core.DownloadResponse;
import com.dcloud.android.downloader.core.task.DownloadTask;
import com.dcloud.android.downloader.core.task.GetFileInfoTask;
import com.dcloud.android.downloader.core.thread.DownloadThread;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import com.dcloud.android.downloader.exception.DownloadException;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadTaskImpl
implements DownloadTask,
GetFileInfoTask.OnGetFileInfoListener,
DownloadThread.DownloadProgressListener {
    private final ExecutorService executorService;
    private final DownloadResponse downloadResponse;
    private final DownloadInfo downloadInfo;
    private final Config config;
    private final List<DownloadThread> downloadThreads;
    private final DownloadTaskListener downloadTaskListener;
    private long lastRefreshTime;
    private long progress;
    private volatile AtomicBoolean isComputerDownload;

    public DownloadTaskImpl(ExecutorService executorService, DownloadResponse downloadResponse, DownloadInfo downloadInfo, Config config, DownloadTaskListener downloadTaskListener) {
        DownloadTaskImpl downloadTaskImpl = this;
        this.lastRefreshTime = System.currentTimeMillis();
        this.isComputerDownload = new AtomicBoolean(false);
        this.executorService = executorService;
        this.downloadResponse = downloadResponse;
        this.downloadInfo = downloadInfo;
        this.config = config;
        downloadTaskImpl.downloadTaskListener = downloadTaskListener;
        downloadTaskImpl.downloadThreads = new ArrayList<DownloadThread>();
    }

    private void getFileInfo() {
        GetFileInfoTask getFileInfoTask;
        GetFileInfoTask getFileInfoTask2 = getFileInfoTask;
        DownloadTaskImpl downloadTaskImpl = this;
        DownloadResponse downloadResponse = downloadTaskImpl.downloadResponse;
        getFileInfoTask = new GetFileInfoTask(downloadResponse, downloadTaskImpl.downloadInfo, this);
        this.executorService.submit(getFileInfoTask2);
    }

    private void removeDownlaodFile() {
        File file;
        File file2 = file;
        if (new File(this.downloadInfo.getPath()).exists()) {
            file2.delete();
        }
    }

    private void computerDownloadProgress() {
        this.progress = 0L;
        for (DownloadThreadInfo downloadThreadInfo : this.downloadInfo.getDownloadThreadInfos()) {
            this.progress += downloadThreadInfo.getProgress();
        }
        this.downloadInfo.setProgress(this.progress);
    }

    @Override
    public void start() {
        if (this.downloadInfo.getSize() <= 0L) {
            this.getFileInfo();
        } else {
            Iterator<DownloadThreadInfo> iterator = this.downloadInfo.getDownloadThreadInfos().iterator();
            while (iterator.hasNext()) {
                DownloadThread downloadThread;
                DownloadTaskImpl downloadTaskImpl = this;
                Object object = iterator.next();
                DownloadThread downloadThread2 = downloadThread;
                DownloadThreadInfo downloadThreadInfo = object;
                DownloadTaskImpl downloadTaskImpl2 = this;
                object = downloadTaskImpl2.downloadResponse;
                Config config = downloadTaskImpl2.config;
                DownloadInfo downloadInfo = downloadTaskImpl2.downloadInfo;
                downloadThread = new DownloadThread(downloadThreadInfo, (DownloadResponse)object, config, downloadInfo, this);
                downloadTaskImpl.executorService.submit(downloadThread2);
                downloadTaskImpl.downloadThreads.add(downloadThread2);
            }
            DownloadTaskImpl downloadTaskImpl = this;
            downloadTaskImpl.downloadInfo.setStatus(2);
            downloadTaskImpl.downloadResponse.onStatusChanged(this.downloadInfo);
        }
    }

    @Override
    public void onSuccess(long l5, boolean bl) {
        ArrayList<DownloadThreadInfo> arrayList;
        this.downloadInfo.setSupportRanges(bl);
        this.downloadInfo.setSize(l5);
        this.removeDownlaodFile();
        ArrayList<DownloadThreadInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<DownloadThreadInfo>();
        if (bl) {
            long l6 = this.downloadInfo.getSize();
            int n5 = this.config.getEachDownloadThread();
            long l7 = l6 / (long)n5;
            for (int i5 = 0; i5 < n5; ++i5) {
                DownloadThread downloadThread;
                DownloadThreadInfo downloadThreadInfo;
                long l8 = l7 * (long)i5;
                long l9 = i5 == n5 - 1 ? l6 : l8 + l7 - 1L;
                DownloadThreadInfo downloadThreadInfo2 = downloadThreadInfo;
                arrayList2.add(new DownloadThreadInfo(i5, this.downloadInfo.getId(), this.downloadInfo.getDownloadUrl(), l8, l9));
                DownloadThread downloadThread2 = downloadThread;
                DownloadResponse downloadResponse = this.downloadResponse;
                DownloadInfo downloadInfo = this.downloadInfo;
                downloadThread = new DownloadThread(downloadThreadInfo2, downloadResponse, this.config, downloadInfo, this);
                this.executorService.submit(downloadThread2);
                this.downloadThreads.add(downloadThread2);
            }
        } else {
            DownloadThread downloadThread;
            DownloadThreadInfo downloadThreadInfo;
            Object object = downloadThreadInfo;
            Object object2 = this.downloadInfo.getDownloadUrl();
            long l10 = this.downloadInfo.getSize();
            arrayList2.add(new DownloadThreadInfo(0, this.downloadInfo.getId(), (String)object2, 0L, l10));
            object2 = downloadThread;
            DownloadThreadInfo downloadThreadInfo3 = object;
            object = this.downloadResponse;
            DownloadInfo downloadInfo = this.downloadInfo;
            downloadThread = new DownloadThread(downloadThreadInfo3, (DownloadResponse)object, this.config, downloadInfo, this);
            this.executorService.submit((Runnable)object2);
            this.downloadThreads.add((DownloadThread)object2);
        }
        this.downloadInfo.setDownloadThreadInfos(arrayList2);
        this.downloadInfo.setStatus(2);
        this.downloadResponse.onStatusChanged(this.downloadInfo);
    }

    @Override
    public void onFailed(DownloadException downloadException) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onProgress() {
        if (this.isComputerDownload.get()) return;
        DownloadTaskImpl downloadTaskImpl = this;
        synchronized (downloadTaskImpl) {
            Throwable throwable2;
            block5: {
                block6: {
                    long l5;
                    try {
                        if (downloadTaskImpl.isComputerDownload.get()) return;
                        this.isComputerDownload.set(true);
                        l5 = System.currentTimeMillis();
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    {
                        if (l5 - this.lastRefreshTime <= 1000L) break block6;
                    }
                    DownloadTaskImpl downloadTaskImpl2 = this;
                    downloadTaskImpl2.computerDownloadProgress();
                    downloadTaskImpl2.downloadResponse.onStatusChanged(this.downloadInfo);
                    this.lastRefreshTime = l5;
                }
                this.isComputerDownload.set(false);
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    @Override
    public void onDownloadSuccess() {
        DownloadTaskImpl downloadTaskImpl = this;
        downloadTaskImpl.computerDownloadProgress();
        if (downloadTaskImpl.downloadInfo.getProgress() == this.downloadInfo.getSize()) {
            DownloadTaskImpl downloadTaskImpl2 = this;
            downloadTaskImpl2.downloadInfo.setStatus(5);
            downloadTaskImpl2.downloadResponse.onStatusChanged(this.downloadInfo);
            DownloadTaskListener downloadTaskListener = downloadTaskImpl2.downloadTaskListener;
            if (downloadTaskListener != null) {
                downloadTaskListener.onDownloadSuccess(this.downloadInfo);
            }
        }
    }

    public static interface DownloadTaskListener {
        public void onDownloadSuccess(DownloadInfo var1);
    }
}

