/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.domain;

import android.content.Context;
import android.text.TextUtils;
import com.dcloud.android.annotation.IntDef;
import com.dcloud.android.downloader.callback.DownloadListener;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import com.dcloud.android.downloader.exception.DownloadException;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class DownloadInfo
implements Serializable {
    public static final int STATUS_NONE = 0;
    public static final int STATUS_PREPARE_DOWNLOAD = 1;
    public static final int STATUS_DOWNLOADING = 2;
    public static final int STATUS_WAIT = 3;
    public static final int STATUS_PAUSED = 4;
    public static final int STATUS_COMPLETED = 5;
    public static final int STATUS_ERROR = 6;
    public static final int STATUS_REMOVED = 7;
    private transient DownloadListener downloadListener;
    private DownloadException exception;
    private int id;
    private long createAt;
    private String uri;
    private String path;
    private long size;
    private long progress;
    private int status;
    private int supportRanges;
    private Context context;
    private List<DownloadThreadInfo> downloadThreadInfos;
    private Object tag;
    private String location;

    public DownloadInfo(Context context) {
        this.context = context;
    }

    public void setLocation(String string2) {
        this.location = string2;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDownloadUrl() {
        if (TextUtils.isEmpty((CharSequence)this.location)) {
            return this.getUri();
        }
        return this.location;
    }

    public void setTag(Object object) {
        this.tag = object;
    }

    public Object getTag() {
        return this.tag;
    }

    public DownloadException getException() {
        return this.exception;
    }

    public void setException(DownloadException downloadException) {
        this.exception = downloadException;
    }

    public long getCreateAt() {
        return this.createAt;
    }

    public Context getContext() {
        return this.context;
    }

    public void setCreateAt(long l5) {
        this.createAt = l5;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string2) {
        this.uri = string2;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string2) {
        this.path = string2;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l5) {
        this.size = l5;
    }

    public long getProgress() {
        return this.progress;
    }

    public void setProgress(long l5) {
        this.progress = l5;
    }

    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n5) {
        this.status = n5;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n5) {
        this.id = n5;
    }

    public int getSupportRanges() {
        return this.supportRanges;
    }

    public void setSupportRanges(int n5) {
        this.supportRanges = n5;
    }

    public boolean isSupportRanges() {
        return this.supportRanges == 0;
    }

    public void setSupportRanges(boolean bl) {
        this.supportRanges = bl ^ 1;
    }

    public List<DownloadThreadInfo> getDownloadThreadInfos() {
        return this.downloadThreadInfos;
    }

    public void setDownloadThreadInfos(List<DownloadThreadInfo> list) {
        this.downloadThreadInfos = list;
    }

    public boolean equals(Object object) {
        if (downloadInfo2 == object) {
            return true;
        }
        if (object != null && downloadInfo2.getClass() == object.getClass()) {
            DownloadInfo downloadInfo = downloadInfo2;
            DownloadInfo downloadInfo2 = (DownloadInfo)object;
            return downloadInfo.id == downloadInfo2.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isPause() {
        int n5 = this.status;
        return n5 == 4 || n5 == 6 || n5 == 7;
    }

    public static final class Builder {
        private static final String DEFAULT_ENCODE = "utf-8";
        private String id;
        private long createAt = -1L;
        private String url;
        private String path;

        public Builder setCreateAt(long l5) {
            this.createAt = l5;
            return this;
        }

        public Builder setUrl(String string2) {
            this.url = string2;
            return this;
        }

        public Builder setPath(String string2) {
            this.path = string2;
            return this;
        }

        public void setId(String string2) {
            this.id = string2;
        }

        public DownloadInfo build(Context context) {
            DownloadInfo downloadInfo;
            DownloadInfo downloadInfo2 = downloadInfo;
            downloadInfo = new DownloadInfo(context);
            if (!TextUtils.isEmpty((CharSequence)this.url)) {
                downloadInfo2.setUri(this.url);
                if (!TextUtils.isEmpty((CharSequence)this.path)) {
                    downloadInfo2.setPath(this.path);
                    if (this.createAt == -1L) {
                        this.setCreateAt(System.currentTimeMillis());
                    }
                    downloadInfo2.setId(this.url.hashCode());
                    if (TextUtils.isEmpty((CharSequence)this.id)) {
                        downloadInfo2.setId(this.url.hashCode());
                    }
                    return downloadInfo2;
                }
                throw new DownloadException(1, "path cannot be null.");
            }
            throw new DownloadException(0, "uri cannot be null.");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L})
    public static @interface DownloadStatus {
    }
}

