/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import com.dcloud.android.annotation.IntDef;
import com.dcloud.android.annotation.NonNull;
import com.dcloud.android.v4.view.animation.FastOutSlowInInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public class MaterialProgressDrawable
extends Drawable
implements Animatable {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final float FULL_ROTATION = 1080.0f;
    public static final int LARGE = 0;
    public static final int DEFAULT = 1;
    private static final int CIRCLE_DIAMETER = 40;
    private static final float CENTER_RADIUS = 8.75f;
    private static final float STROKE_WIDTH = 2.5f;
    private static final int CIRCLE_DIAMETER_LARGE = 56;
    private static final float CENTER_RADIUS_LARGE = 12.5f;
    private static final float STROKE_WIDTH_LARGE = 3.0f;
    private static final float COLOR_START_DELAY_OFFSET = 0.75f;
    private static final float END_TRIM_START_DELAY_OFFSET = 0.5f;
    private static final float START_TRIM_DURATION_OFFSET = 0.5f;
    private static final int ANIMATION_DURATION = 1332;
    private static final float NUM_POINTS = 5.0f;
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_HEIGHT = 5;
    private static final float ARROW_OFFSET_ANGLE = 5.0f;
    private static final int ARROW_WIDTH_LARGE = 12;
    private static final int ARROW_HEIGHT_LARGE = 6;
    private static final float MAX_PROGRESS_ARC = 0.8f;
    private final int[] COLORS;
    private final ArrayList<Animation> mAnimators;
    private final Ring mRing;
    private float mRotation;
    private Resources mResources;
    private View mParent;
    private Animation mAnimation;
    private float mRotationCount;
    private double mWidth;
    private double mHeight;
    boolean mFinishing;
    private final Drawable.Callback mCallback;

    public MaterialProgressDrawable(Context object, View object2) {
        Ring ring;
        Ring ring2;
        Drawable.Callback callback;
        MaterialProgressDrawable materialProgressDrawable = this;
        Context context = object;
        View view = object2;
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = -16777216;
        this.COLORS = nArray;
        this.mAnimators = new ArrayList();
        object2 = callback;
        this.mCallback = new Drawable.Callback(){

            public void invalidateDrawable(Drawable drawable) {
                MaterialProgressDrawable.this.invalidateSelf();
            }

            public void scheduleDrawable(Drawable drawable, Runnable runnable, long l5) {
                MaterialProgressDrawable.this.scheduleSelf(runnable, l5);
            }

            public void unscheduleDrawable(Drawable drawable, Runnable runnable) {
                MaterialProgressDrawable.this.unscheduleSelf(runnable);
            }
        };
        this.mParent = view;
        materialProgressDrawable.mResources = context.getResources();
        Ring ring3 = ring2 = ring;
        ring3((Drawable.Callback)object2);
        this.mRing = ring3;
        ring.setColors((int[])object);
        materialProgressDrawable.updateSizes(1);
        materialProgressDrawable.setupAnimators();
    }

    private void setSizeParameters(double d6, double d7, double d8, double d9, float f5, float f6) {
        Ring ring;
        Ring ring2 = ring = this.mRing;
        float f7 = this.mResources.getDisplayMetrics().density;
        double d10 = f7;
        this.mWidth = d6 * d10;
        this.mHeight = d7 * d10;
        ring.setStrokeWidth((float)d9 * f7);
        ring2.setCenterRadius(d8 * d10);
        ring2.setColorIndex(0);
        float f8 = f5 * f7;
        ring.setArrowDimensions(f8, f6 * f7);
        ring.setInsets((int)this.mWidth, (int)this.mHeight);
    }

    private float getRotation() {
        return this.mRotation;
    }

    private float getMinProgressArc(Ring ring) {
        return (float)Math.toRadians((double)ring.getStrokeWidth() / (ring.getCenterRadius() * (Math.PI * 2)));
    }

    private int evaluateColorChange(float f5, int n5, int n6) {
        int n7 = n5 >> 24 & 0xFF;
        int n8 = n7;
        int n9 = n5;
        n5 = n9 >> 16 & 0xFF;
        int n10 = n9 >> 8 & 0xFF;
        int n11 = n9 & 0xFF;
        int n12 = n6 >> 24 & 0xFF;
        int n13 = n8;
        int n14 = n6;
        n8 = n14 >> 16 & 0xFF;
        n6 = n14 >> 8 & 0xFF;
        int n15 = n14 & 0xFF;
        return n7 + (int)(f5 * (float)(n12 - n13)) << 24 | n5 + (int)(f5 * (float)(n8 - n5)) << 16 | n10 + (int)(f5 * (float)(n6 - n10)) << 8 | n11 + (int)(f5 * (float)(n15 - n11));
    }

    private void updateRingColor(float f5, Ring ring) {
        if (f5 > 0.75f) {
            Ring ring2 = ring;
            float f6 = (f5 - 0.75f) / 0.25f;
            int n5 = ring2.getStartingColor();
            int n6 = ring2.getNextColor();
            ring.setColor(this.evaluateColorChange(f6, n5, n6));
        }
    }

    private void applyFinishTranslation(float f5, Ring ring) {
        Ring ring2 = ring;
        Ring ring3 = ring;
        this.updateRingColor(f5, ring);
        float f6 = (float)(Math.floor(ring3.getStartingRotation() / 0.8f) + 1.0);
        float f7 = this.getMinProgressArc(ring3);
        ring2.setStartTrim(ring2.getStartingStartTrim() + (ring.getStartingEndTrim() - f7 - ring.getStartingStartTrim()) * f5);
        ring2.setEndTrim(ring2.getStartingEndTrim());
        ring2.setRotation(ring2.getStartingRotation() + (f6 - ring.getStartingRotation()) * f5);
    }

    private void setupAnimators() {
        final Ring ring = this.mRing;
        Animation animation = new Animation(){

            public void applyTransformation(float f5, Transformation object) {
                object = MaterialProgressDrawable.this;
                if (object.mFinishing) {
                    ((MaterialProgressDrawable)((Object)object)).applyFinishTranslation(f5, ring);
                } else {
                    1 v02 = this;
                    float f6 = ((MaterialProgressDrawable)((Object)object)).getMinProgressArc(ring);
                    float f7 = v02.ring.getStartingEndTrim();
                    float f8 = v02.ring.getStartingStartTrim();
                    float f9 = v02.ring.getStartingRotation();
                    v02.MaterialProgressDrawable.this.updateRingColor(f5, ring);
                    if (f5 <= 0.5f) {
                        float f10 = f8;
                        f8 = f5 / 0.5f;
                        f8 = f10 + (0.8f - f6) * MATERIAL_INTERPOLATOR.getInterpolation(f8);
                        ring.setStartTrim(f8);
                    }
                    if (f5 > 0.5f) {
                        f6 = f7 + (0.8f - f6) * MATERIAL_INTERPOLATOR.getInterpolation((f5 - 0.5f) / 0.5f);
                        ring.setEndTrim(f6);
                    }
                    float f11 = f5;
                    f5 = f9 + f5 * 0.25f;
                    ring.setRotation(f5);
                    float f12 = f11 * 216.0f + MaterialProgressDrawable.this.mRotationCount / 5.0f * 1080.0f;
                    MaterialProgressDrawable.this.setRotation(f12);
                }
            }
        };
        animation.setRepeatCount(-1);
        animation.setRepeatMode(1);
        animation.setInterpolator(LINEAR_INTERPOLATOR);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                MaterialProgressDrawable.access$402(MaterialProgressDrawable.this, 0.0f);
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
                2 v02 = this;
                v02.ring.storeOriginals();
                v02.ring.goToNextColor();
                Ring ring2 = v02.ring;
                ring2.setStartTrim(ring2.getEndTrim());
                MaterialProgressDrawable materialProgressDrawable = v02.MaterialProgressDrawable.this;
                if (materialProgressDrawable.mFinishing) {
                    materialProgressDrawable.mFinishing = false;
                    animation.setDuration(1332L);
                    ring.setShowArrow(false);
                } else {
                    MaterialProgressDrawable materialProgressDrawable2 = materialProgressDrawable;
                    MaterialProgressDrawable.access$402(materialProgressDrawable2, (materialProgressDrawable2.mRotationCount + 1.0f) % 5.0f);
                }
            }
        });
        this.mAnimation = animation;
    }

    static /* synthetic */ float access$402(MaterialProgressDrawable materialProgressDrawable, float f5) {
        materialProgressDrawable.mRotationCount = f5;
        return f5;
    }

    public void updateSizes(@ProgressDrawableSize int n5) {
        if (n5 == 0) {
            this.setSizeParameters(56.0, 56.0, 12.5, 3.0, 12.0f, 6.0f);
        } else {
            this.setSizeParameters(40.0, 40.0, 8.75, 2.5, 10.0f, 5.0f);
        }
    }

    public void showArrow(boolean bl) {
        this.mRing.setShowArrow(bl);
    }

    public void setArrowScale(float f5) {
        this.mRing.setArrowScale(f5);
    }

    public void setStartEndTrim(float f5, float f6) {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mRing.setStartTrim(f5);
        materialProgressDrawable.mRing.setEndTrim(f6);
    }

    public void setProgressRotation(float f5) {
        this.mRing.setRotation(f5);
    }

    public void setBackgroundColor(int n5) {
        this.mRing.setBackgroundColor(n5);
    }

    public void setColorSchemeColors(int ... nArray) {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mRing.setColors(nArray);
        materialProgressDrawable.mRing.setColorIndex(0);
    }

    public int getIntrinsicHeight() {
        return (int)this.mHeight;
    }

    public int getIntrinsicWidth() {
        return (int)this.mWidth;
    }

    public void draw(Canvas canvas) {
        Canvas canvas2 = canvas;
        Rect rect = this.getBounds();
        int n5 = canvas.save();
        float f5 = this.mRotation;
        float f6 = rect.exactCenterX();
        float f7 = rect.exactCenterY();
        canvas2.rotate(f5, f6, f7);
        this.mRing.draw(canvas, rect);
        canvas2.restoreToCount(n5);
    }

    public void setAlpha(int n5) {
        this.mRing.setAlpha(n5);
    }

    public int getAlpha() {
        return this.mRing.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mRing.setColorFilter(colorFilter);
    }

    void setRotation(float f5) {
        this.mRotation = f5;
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isRunning() {
        ArrayList<Animation> arrayList = ((MaterialProgressDrawable)((Object)arrayList)).mAnimators;
        int n5 = arrayList.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            Animation animation = (Animation)arrayList.get(i5);
            if (!animation.hasStarted() || animation.hasEnded()) continue;
            return true;
        }
        return false;
    }

    public void start() {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mAnimation.reset();
        materialProgressDrawable.mRing.storeOriginals();
        if (materialProgressDrawable.mRing.getEndTrim() != this.mRing.getStartTrim()) {
            MaterialProgressDrawable materialProgressDrawable2 = this;
            materialProgressDrawable2.mFinishing = true;
            materialProgressDrawable2.mAnimation.setDuration(666L);
            materialProgressDrawable2.mParent.startAnimation(this.mAnimation);
        } else {
            MaterialProgressDrawable materialProgressDrawable3 = this;
            materialProgressDrawable3.mRing.setColorIndex(0);
            materialProgressDrawable3.mRing.resetOriginals();
            materialProgressDrawable3.mAnimation.setDuration(1332L);
            materialProgressDrawable3.mParent.startAnimation(this.mAnimation);
        }
    }

    public void stop() {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mParent.clearAnimation();
        materialProgressDrawable.setRotation(0.0f);
        materialProgressDrawable.mRing.setShowArrow(false);
        materialProgressDrawable.mRing.setColorIndex(0);
        materialProgressDrawable.mRing.resetOriginals();
    }

    private static class Ring {
        private final RectF mTempBounds = new RectF();
        private final Paint mPaint;
        private final Paint mArrowPaint;
        private final Drawable.Callback mCallback;
        private float mStartTrim;
        private float mEndTrim;
        private float mRotation;
        private float mStrokeWidth;
        private float mStrokeInset;
        private int[] mColors;
        private int mColorIndex;
        private float mStartingStartTrim;
        private float mStartingEndTrim;
        private float mStartingRotation;
        private boolean mShowArrow;
        private Path mArrow;
        private float mArrowScale;
        private double mRingCenterRadius;
        private int mArrowWidth;
        private int mArrowHeight;
        private int mAlpha;
        private final Paint mCirclePaint;
        private int mBackgroundColor;
        private int mCurrentColor;

        public Ring(Drawable.Callback callback) {
            Paint paint;
            Paint paint2;
            Paint paint3 = paint2;
            this.mPaint = new Paint();
            Paint paint4 = paint;
            Paint paint5 = paint3;
            Ring ring = this;
            Paint paint6 = paint4;
            paint6();
            ring.mArrowPaint = paint6;
            ring.mStartTrim = 0.0f;
            ring.mEndTrim = 0.0f;
            ring.mRotation = 0.0f;
            ring.mStrokeWidth = 5.0f;
            ring.mStrokeInset = 2.5f;
            ring.mCirclePaint = new Paint(1);
            this.mCallback = callback;
            paint5.setStrokeCap(Paint.Cap.SQUARE);
            paint5.setAntiAlias(true);
            paint5.setStyle(Paint.Style.STROKE);
            paint.setStyle(Paint.Style.FILL);
            paint.setAntiAlias(true);
        }

        private void drawTriangle(Canvas canvas, float f5, float f6, Rect rect) {
            if (this.mShowArrow) {
                Path path = this.mArrow;
                if (path == null) {
                    Path path2;
                    this.mArrow = path = path2;
                    new Path().setFillType(Path.FillType.EVEN_ODD);
                } else {
                    path.reset();
                }
                Canvas canvas2 = canvas;
                Rect rect2 = rect;
                float f7 = f5;
                float f8 = f6;
                float f9 = (float)((int)this.mStrokeInset / 2) * this.mArrowScale;
                float f10 = (float)(this.mRingCenterRadius * Math.cos(0.0) + (double)rect.exactCenterX());
                f5 = (float)(this.mRingCenterRadius * Math.sin(0.0) + (double)rect.exactCenterY());
                this.mArrow.moveTo(0.0f, 0.0f);
                this.mArrow.lineTo((float)this.mArrowWidth * this.mArrowScale, 0.0f);
                f6 = this.mArrowScale;
                this.mArrow.lineTo((float)this.mArrowWidth * f6 / 2.0f, (float)this.mArrowHeight * f6);
                this.mArrow.offset(f10 - f9, f5);
                this.mArrow.close();
                this.mArrowPaint.setColor(this.mCurrentColor);
                f9 = f7 + f8 - 5.0f;
                f5 = rect2.exactCenterX();
                f6 = rect2.exactCenterY();
                canvas2.rotate(f9, f5, f6);
                canvas2.drawPath(this.mArrow, this.mArrowPaint);
            }
        }

        private int getNextColorIndex() {
            return (this.mColorIndex + 1) % this.mColors.length;
        }

        private void invalidateSelf() {
            this.mCallback.invalidateDrawable(null);
        }

        public void setBackgroundColor(int n5) {
            this.mBackgroundColor = n5;
        }

        public void setArrowDimensions(float f5, float f6) {
            this.mArrowWidth = (int)f5;
            this.mArrowHeight = (int)f6;
        }

        public void draw(Canvas canvas, Rect rect) {
            Ring ring = this;
            Canvas canvas2 = canvas;
            Ring ring2 = this;
            RectF rectF = ring2.mTempBounds;
            rectF.set(rect);
            float f5 = this.mStrokeInset;
            rectF.inset(f5, f5);
            float f6 = this.mRotation;
            float f7 = (ring2.mStartTrim + f6) * 360.0f;
            f6 = (ring2.mEndTrim + f6) * 360.0f - f7;
            ring2.mPaint.setColor(this.mCurrentColor);
            Paint paint = ring2.mPaint;
            canvas2.drawArc(rectF, f7, f6, false, paint);
            ring.drawTriangle(canvas2, f7, f6, rect);
            if (ring.mAlpha < 255) {
                Rect rect2 = rect;
                Ring ring3 = this;
                ring3.mCirclePaint.setColor(this.mBackgroundColor);
                ring3.mCirclePaint.setAlpha(255 - this.mAlpha);
                float f8 = rect2.exactCenterX();
                float f9 = rect2.exactCenterY();
                float f10 = rect2.width() / 2;
                rectF = this.mCirclePaint;
                canvas.drawCircle(f8, f9, f10, (Paint)rectF);
            }
        }

        public void setColors(@NonNull int[] nArray) {
            this.mColors = nArray;
            this.setColorIndex(0);
        }

        public void setColor(int n5) {
            this.mCurrentColor = n5;
        }

        public void setColorIndex(int n5) {
            this.mColorIndex = n5;
            this.mCurrentColor = this.mColors[n5];
        }

        public int getNextColor() {
            return this.mColors[this.getNextColorIndex()];
        }

        public void goToNextColor() {
            Ring ring = this;
            ring.setColorIndex(ring.getNextColorIndex());
        }

        public void setColorFilter(ColorFilter colorFilter) {
            Ring ring = this;
            ring.mPaint.setColorFilter(colorFilter);
            ring.invalidateSelf();
        }

        public void setAlpha(int n5) {
            this.mAlpha = n5;
        }

        public int getAlpha() {
            return this.mAlpha;
        }

        public void setStrokeWidth(float f5) {
            Ring ring = this;
            ring.mStrokeWidth = f5;
            ring.mPaint.setStrokeWidth(f5);
            ring.invalidateSelf();
        }

        public float getStrokeWidth() {
            return this.mStrokeWidth;
        }

        public void setStartTrim(float f5) {
            this.mStartTrim = f5;
            this.invalidateSelf();
        }

        public float getStartTrim() {
            return this.mStartTrim;
        }

        public float getStartingStartTrim() {
            return this.mStartingStartTrim;
        }

        public float getStartingEndTrim() {
            return this.mStartingEndTrim;
        }

        public int getStartingColor() {
            return this.mColors[this.mColorIndex];
        }

        public void setEndTrim(float f5) {
            this.mEndTrim = f5;
            this.invalidateSelf();
        }

        public float getEndTrim() {
            return this.mEndTrim;
        }

        public void setRotation(float f5) {
            this.mRotation = f5;
            this.invalidateSelf();
        }

        public float getRotation() {
            return this.mRotation;
        }

        public void setInsets(int n5, int n6) {
            float f5 = Math.min(n5, n6);
            double d6 = this.mRingCenterRadius;
            f5 = !(d6 <= 0.0) && !(f5 < 0.0f) ? (float)((double)(f5 / 2.0f) - d6) : (float)Math.ceil(this.mStrokeWidth / 2.0f);
            this.mStrokeInset = f5;
        }

        public float getInsets() {
            return this.mStrokeInset;
        }

        public void setCenterRadius(double d6) {
            this.mRingCenterRadius = d6;
        }

        public double getCenterRadius() {
            return this.mRingCenterRadius;
        }

        public void setShowArrow(boolean bl) {
            if (this.mShowArrow != bl) {
                this.mShowArrow = bl;
                this.invalidateSelf();
            }
        }

        public void setArrowScale(float f5) {
            if (f5 != this.mArrowScale) {
                this.mArrowScale = f5;
                this.invalidateSelf();
            }
        }

        public float getStartingRotation() {
            return this.mStartingRotation;
        }

        public void storeOriginals() {
            Ring ring = this;
            ring.mStartingStartTrim = ring.mStartTrim;
            ring.mStartingEndTrim = ring.mEndTrim;
            ring.mStartingRotation = ring.mRotation;
        }

        public void resetOriginals() {
            Ring ring = this;
            ring.mStartingStartTrim = 0.0f;
            ring.mStartingEndTrim = 0.0f;
            ring.mStartingRotation = 0.0f;
            ring.setStartTrim(0.0f);
            ring.setEndTrim(0.0f);
            ring.setRotation(0.0f);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @IntDef(value={0L, 1L})
    public static @interface ProgressDrawableSize {
    }
}

