/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget;

import android.content.Context;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import android.widget.Scroller;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import org.json.JSONObject;

public class SlideLayout
extends AbsoluteLayout {
    private static final int SNAP_VELOCITY = 1000;
    private static final int SCROLL_DURATION = 150;
    private static String LEFT = "left";
    private static String RIGHT = "right";
    private static String BEFORE_SLIDE = "beforeSlide";
    private static String AFTER_SLIDE = "afterSlide";
    private boolean mInterceptEventEnable = true;
    private boolean mIsHandledTouchEvent = false;
    private int mTouchSlop;
    private float mLastMotionX = -1.0f;
    private VelocityTracker mVelocityTracker;
    private boolean mCanDoSlideTransverseEvent = false;
    private int mSlideTransverseLeftMaxWitch = 0;
    private int mSlideTransverseRightMaxWitch = 0;
    private int mSlideLeftPosition = -1;
    private int mSlideRightPosition = -1;
    boolean isRightSlide = false;
    boolean isLeftSlide = false;
    boolean isSlideOpen = false;
    private Scroller mScroller = new Scroller(this.getContext());
    private float mFirstX = 0.0f;
    private OnStateChangeListener mChangeListener;

    public SlideLayout(Context context) {
        super(context);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    private void setState(final String string2, final String string3) {
        if (this.mChangeListener != null) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    1 v02 = string22;
                    String string22 = v02.string3;
                    string22.SlideLayout.this.mChangeListener.onStateChanged(string22, v02.string2);
                }
            };
            this.postDelayed(runnable2, 150L);
        }
    }

    private void smoothScrollTo(int n5, int n6) {
        SlideLayout slideLayout = this;
        slideLayout.enableChildrenCache();
        int n7 = Math.abs(n5) * 2;
        slideLayout.mScroller.startScroll(this.getScrollX(), 0, n5, 0, n7);
        slideLayout.invalidate();
    }

    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mChangeListener = onStateChangeListener;
    }

    public void setWidth(int n5) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.width = n5;
            this.requestLayout();
        }
    }

    public void setHeight(int n5) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.height = n5;
            this.requestLayout();
        }
    }

    public void initSlideInfo(JSONObject object, float f5, int n5) {
        JSONObject jSONObject = JSONUtil.getJSONObject(object, "slideoffset");
        if (jSONObject != null) {
            Object object2 = JSONUtil.getJSONObject(object, "position");
            if (object2 != null) {
                JSONObject jSONObject2 = object2;
                object2 = jSONObject2.optString(LEFT);
                String string2 = jSONObject2.optString(RIGHT);
                if (!TextUtils.isEmpty((CharSequence)object2)) {
                    int n6 = n5;
                    this.mSlideLeftPosition = PdrUtil.convertToScreenInt((String)object2, n6, n6 / 2, f5);
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    int n7 = n5;
                    this.mSlideRightPosition = PdrUtil.convertToScreenInt(string2, n7, n7 / 2, f5);
                }
            }
            this.mInterceptEventEnable = object.optBoolean("preventTouchEvent", true);
            object = JSONUtil.getString(jSONObject, LEFT);
            if (!TextUtils.isEmpty((CharSequence)object)) {
                boolean bl = this.mSlideLeftPosition > 0;
                int n8 = n5;
                this.isLeftSlide = bl;
                this.mSlideTransverseLeftMaxWitch = PdrUtil.convertToScreenInt((String)object, n8, n8 / 2, f5);
            }
            if (!TextUtils.isEmpty((CharSequence)(object = JSONUtil.getString(jSONObject, RIGHT)))) {
                boolean bl = this.mSlideRightPosition > 0;
                int n9 = n5;
                this.isRightSlide = bl;
                this.mSlideTransverseRightMaxWitch = PdrUtil.convertToScreenInt((String)object, n9, n9 / 2, f5);
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n5 = motionEvent.getAction();
        if (!this.mInterceptEventEnable) {
            return false;
        }
        if (!this.isLeftSlide && !this.isRightSlide) {
            return false;
        }
        if (n5 != 3 && n5 != 1) {
            if (n5 != 0 && this.mIsHandledTouchEvent) {
                return true;
            }
            if (n5 != 0) {
                if (n5 == 2 && (int)Math.abs(motionEvent.getX() - this.mFirstX) > this.mTouchSlop) {
                    SlideLayout slideLayout = this;
                    slideLayout.enableChildrenCache();
                    slideLayout.mIsHandledTouchEvent = true;
                    slideLayout.mCanDoSlideTransverseEvent = true;
                    slideLayout.requestDisallowInterceptTouchEvent(true);
                }
            } else {
                SlideLayout slideLayout = this;
                this.mLastMotionX = motionEvent.getX();
                slideLayout.mFirstX = motionEvent.getX();
                slideLayout.mIsHandledTouchEvent = false;
                slideLayout.mCanDoSlideTransverseEvent = false;
            }
            return this.mIsHandledTouchEvent;
        }
        SlideLayout slideLayout = this;
        slideLayout.mIsHandledTouchEvent = false;
        slideLayout.clearChildrenCache();
        return slideLayout.mIsHandledTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mCanDoSlideTransverseEvent && this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        switch (motionEvent.getAction()) {
            default: {
                break;
            }
            case 2: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.addMovement(motionEvent);
                }
                float f5 = motionEvent.getX();
                if (!this.mCanDoSlideTransverseEvent) break;
                int n5 = (int)(this.mLastMotionX - f5);
                this.mLastMotionX = f5;
                int n6 = this.getScrollX();
                int n7 = this.getChildAt(this.getChildCount() - 1).getRight() - n6 - this.getWidth();
                if (n6 == 0) {
                    if (this.isRightSlide && n5 > 0) {
                        this.scrollBy(n5, 0);
                        break;
                    }
                    if (!this.isLeftSlide || n5 >= 0) break;
                    this.scrollBy(n5, 0);
                    break;
                }
                if (n6 > 0 && n7 < 0 && this.isRightSlide) {
                    if (Math.abs(n6 = n5 + n6) > this.mSlideRightPosition) break;
                    if (n6 < 0) {
                        this.scrollBy(0, 0);
                        break;
                    }
                    if (Math.abs(n6) >= this.mSlideTransverseRightMaxWitch) {
                        this.scrollBy((int)((double)n5 / 1.5), 0);
                        break;
                    }
                    this.scrollBy(n5, 0);
                    break;
                }
                if (n6 >= 0 || n7 <= 0 || !this.isLeftSlide || Math.abs(n6 = n5 + n6) > this.mSlideLeftPosition) break;
                if (n6 > 0) {
                    this.scrollBy(0, 0);
                    break;
                }
                if (Math.abs(n6) >= this.mSlideTransverseLeftMaxWitch) {
                    this.scrollBy((int)((double)n5 / 1.5), 0);
                    break;
                }
                this.scrollBy(n5, 0);
                break;
            }
            case 1: 
            case 3: {
                VelocityTracker velocityTracker;
                if (this.mIsHandledTouchEvent) {
                    this.mIsHandledTouchEvent = false;
                    if (this.mCanDoSlideTransverseEvent) {
                        this.requestDisallowInterceptTouchEvent(false);
                        VelocityTracker velocityTracker2 = this.mVelocityTracker;
                        velocityTracker2.computeCurrentVelocity(1000);
                        int n8 = (int)velocityTracker2.getXVelocity();
                        int n9 = this.getScrollX();
                        if (n8 > 1000) {
                            if (n9 < 0 && this.isLeftSlide && this.mSlideLeftPosition >= (n8 = this.mSlideTransverseLeftMaxWitch)) {
                                this.smoothScrollTo(-(n8 - Math.abs(n9)), 0);
                                this.isSlideOpen = true;
                                String string2 = AFTER_SLIDE;
                                this.setState(LEFT, string2);
                            } else if (n9 > 0 && this.isRightSlide) {
                                this.smoothScrollTo(-n9, 0);
                                this.isSlideOpen = false;
                                String string3 = BEFORE_SLIDE;
                                this.setState(RIGHT, string3);
                            } else {
                                this.upSlideTo(n9);
                            }
                        } else if (n8 < -1000) {
                            if (n9 < 0 && this.isLeftSlide) {
                                this.smoothScrollTo(-n9, 0);
                                this.isSlideOpen = false;
                                String string4 = BEFORE_SLIDE;
                                this.setState(LEFT, string4);
                            } else if (n9 > 0 && this.isRightSlide && this.mSlideRightPosition >= (n8 = this.mSlideTransverseRightMaxWitch)) {
                                this.smoothScrollTo(n8 - Math.abs(n9), 0);
                                this.isSlideOpen = true;
                                String string5 = AFTER_SLIDE;
                                this.setState(RIGHT, string5);
                            } else {
                                this.upSlideTo(n9);
                            }
                        } else {
                            this.upSlideTo(n9);
                        }
                        velocityTracker = this.mVelocityTracker;
                        if (velocityTracker != null) {
                            velocityTracker.recycle();
                            this.mVelocityTracker = null;
                        }
                    }
                }
                if ((velocityTracker = this.mVelocityTracker) == null) break;
                velocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 0: {
                this.mIsHandledTouchEvent = false;
                if (this.mScroller.isFinished()) break;
                this.mScroller.abortAnimation();
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void upSlideTo(int n5) {
        int n6;
        if (n5 < 0) {
            n6 = this.mSlideTransverseLeftMaxWitch;
            if (Math.abs(n5) >= n6 / 2 && this.mSlideLeftPosition >= n6) {
                SlideLayout slideLayout = this;
                slideLayout.smoothScrollTo(-(n6 - Math.abs(n5)), 0);
                slideLayout.isSlideOpen = true;
                slideLayout.setState(LEFT, AFTER_SLIDE);
                return;
            }
        }
        if (n5 > 0) {
            n6 = this.mSlideTransverseRightMaxWitch;
            if (Math.abs(n5) >= n6 / 2 && this.mSlideRightPosition >= n6) {
                SlideLayout slideLayout = this;
                slideLayout.smoothScrollTo(n6 - Math.abs(n5), 0);
                slideLayout.isSlideOpen = true;
                slideLayout.setState(RIGHT, AFTER_SLIDE);
                return;
            }
        }
        if (n5 > 0) {
            SlideLayout slideLayout = this;
            slideLayout.smoothScrollTo(-n5, 0);
            slideLayout.setState(RIGHT, BEFORE_SLIDE);
        } else {
            SlideLayout slideLayout = this;
            slideLayout.smoothScrollTo(-n5, 0);
            slideLayout.setState(LEFT, BEFORE_SLIDE);
        }
        this.isSlideOpen = false;
    }

    public void setOffset(String string2, String string3, float f5) {
        int n5 = PdrUtil.convertToScreenInt(string3, this.getWidth(), 0, f5);
        int n6 = this.getScrollX();
        if (string2.equals(LEFT)) {
            if (n5 == 0) {
                if (n6 != 0) {
                    SlideLayout slideLayout = this;
                    slideLayout.smoothScrollTo(-n6, 0);
                    slideLayout.setState(LEFT, BEFORE_SLIDE);
                }
            } else {
                Runnable runnable;
                int n7 = this.mSlideLeftPosition;
                if (n5 > n7) {
                    n5 = n7;
                }
                int n8 = n5 - Math.abs(n6);
                this.smoothScrollTo(-n8, 0);
                Runnable runnable2 = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        SlideLayout slideLayout = SlideLayout.this;
                        slideLayout.upSlideTo(slideLayout.getScrollX());
                    }
                };
                long l5 = n8 * 2 + 200;
                this.postDelayed(runnable2, l5);
            }
        } else if (n5 == 0) {
            if (n6 != 0) {
                SlideLayout slideLayout = this;
                slideLayout.smoothScrollTo(-n6, 0);
                slideLayout.setState(RIGHT, BEFORE_SLIDE);
            }
        } else {
            Runnable runnable;
            int n9 = this.mSlideRightPosition;
            if (n5 > n9) {
                n5 = n9;
            }
            int n10 = n5 - Math.abs(n6);
            this.smoothScrollTo(n10, 0);
            Runnable runnable3 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    SlideLayout slideLayout = SlideLayout.this;
                    slideLayout.upSlideTo(slideLayout.getScrollX());
                }
            };
            long l6 = n10 * 2 + 200;
            this.postDelayed(runnable3, l6);
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            SlideLayout slideLayout = this;
            slideLayout.scrollTo(slideLayout.mScroller.getCurrX(), this.mScroller.getCurrY());
            slideLayout.postInvalidate();
        } else {
            this.clearChildrenCache();
        }
        super.computeScroll();
    }

    void enableChildrenCache() {
        int n5 = this.getChildCount();
        for (int i5 = 0; i5 < n5; ++i5) {
            this.getChildAt(i5).setDrawingCacheEnabled(true);
        }
    }

    void clearChildrenCache() {
        int n5 = this.getChildCount();
        for (int i5 = 0; i5 < n5; ++i5) {
            this.getChildAt(i5).setDrawingCacheEnabled(false);
        }
    }

    public void setInterceptTouchEventEnabled(boolean bl) {
        this.mIsHandledTouchEvent = bl;
    }

    public void reset() {
        int n5 = this.getScrollX();
        if (n5 == 0) {
            return;
        }
        this.smoothScrollTo(-n5, 0);
        if (n5 < 0) {
            this.setState(LEFT, BEFORE_SLIDE);
        } else {
            this.setState(RIGHT, BEFORE_SLIDE);
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChanged(String var1, String var2);
    }
}

