/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2;

import com.dcloud.zxing2.LuminanceSource;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private static final int THUMBNAIL_SCALE_FACTOR = 2;
    private final byte[] yuvData;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public PlanarYUVLuminanceSource(byte[] byArray, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        super(n9, n10);
        if (n7 + n9 <= n5 && n8 + n10 <= n6) {
            PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
            planarYUVLuminanceSource.yuvData = byArray;
            planarYUVLuminanceSource.dataWidth = n5;
            planarYUVLuminanceSource.dataHeight = n6;
            planarYUVLuminanceSource.left = n7;
            planarYUVLuminanceSource.top = n8;
            if (bl) {
                this.reverseHorizontal(n9, n10);
            }
            return;
        }
        throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
    }

    private void reverseHorizontal(int n5, int n6) {
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        byte[] byArray = planarYUVLuminanceSource.yuvData;
        int n7 = 0;
        int n8 = planarYUVLuminanceSource.top * this.dataWidth + this.left;
        while (n7 < n6) {
            int n9 = n8 + n5 / 2;
            int n10 = n8 + n5 - 1;
            int n11 = n8;
            while (n11 < n9) {
                byte[] byArray2 = byArray;
                byte[] byArray3 = byArray;
                byte by = byArray2[n11];
                byArray2[n11] = byArray3[n10];
                byArray3[n10] = by;
                ++n11;
                --n10;
            }
            ++n7;
            n8 += this.dataWidth;
        }
    }

    @Override
    public byte[] getRow(int n5, byte[] byArray) {
        if (n5 >= 0 && n5 < this.getHeight()) {
            int n6 = this.getWidth();
            if (byArray == null || byArray.length < n6) {
                byArray = new byte[n6];
            }
            int n7 = (n5 + this.top) * this.dataWidth + this.left;
            System.arraycopy(this.yuvData, n7, byArray, 0, n6);
            return byArray;
        }
        throw new IllegalArgumentException("Requested row is outside the image: " + n5);
    }

    @Override
    public byte[] getMatrix() {
        int n5 = this.getWidth();
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        int n6 = planarYUVLuminanceSource.getHeight();
        int n7 = planarYUVLuminanceSource.dataWidth;
        if (n5 == n7 && n6 == this.dataHeight) {
            return this.yuvData;
        }
        int n8 = n7;
        int n9 = n5 * n6;
        byte[] byArray = new byte[n9];
        n7 = this.top * n7 + this.left;
        if (n5 == n8) {
            System.arraycopy(this.yuvData, n7, byArray, 0, n9);
            return byArray;
        }
        byte[] byArray2 = this.yuvData;
        for (int i5 = 0; i5 < n6; ++i5) {
            System.arraycopy(byArray2, n7, byArray, i5 * n5, n5);
            n7 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n5, int n6, int n7, int n8) {
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        byte[] byArray = planarYUVLuminanceSource.yuvData;
        int n9 = planarYUVLuminanceSource.dataWidth;
        int n10 = planarYUVLuminanceSource.dataHeight;
        PlanarYUVLuminanceSource planarYUVLuminanceSource2 = this;
        int n11 = planarYUVLuminanceSource2.left + n5;
        n5 = planarYUVLuminanceSource2.top + n6;
        return new PlanarYUVLuminanceSource(byArray, n9, n10, n11, n5, n7, n8, false);
    }

    public int[] renderThumbnail() {
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        int n5 = planarYUVLuminanceSource.getWidth() / 2;
        int n6 = this.getHeight() / 2;
        int[] nArray = new int[n5 * n6];
        byte[] byArray = planarYUVLuminanceSource.yuvData;
        int n7 = planarYUVLuminanceSource.top * this.dataWidth + this.left;
        for (int i5 = 0; i5 < n6; ++i5) {
            int n8 = i5 * n5;
            for (int i6 = 0; i6 < n5; ++i6) {
                int n9 = n8 + i6;
                nArray[n9] = (byArray[n7 + i6 * 2] & 0xFF) * 65793 | 0xFF000000;
            }
            n7 += this.dataWidth * 2;
        }
        return nArray;
    }

    public int getThumbnailWidth() {
        return this.getWidth() / 2;
    }

    public int getThumbnailHeight() {
        return this.getHeight() / 2;
    }
}

