/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

import com.dcloud.zxing2.Binarizer;
import com.dcloud.zxing2.LuminanceSource;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int BLOCK_SIZE_POWER = 3;
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_SIZE_MASK = 7;
    private static final int MINIMUM_DIMENSION = 40;
    private static final int MIN_DYNAMIC_RANGE = 24;
    private BitMatrix matrix;

    public HybridBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    private static void calculateThresholdForBlock(byte[] byArray, int n5, int n6, int n7, int n8, int[][] nArray, BitMatrix bitMatrix) {
        for (int i5 = 0; i5 < n6; ++i5) {
            int n9 = i5 << 3;
            int n10 = n8 - 8;
            if (n9 > n10) {
                n9 = n10;
            }
            for (n10 = 0; n10 < n5; ++n10) {
                int n11 = n10 << 3;
                int n12 = n7 - 8;
                if (n11 > n12) {
                    n11 = n12;
                }
                n12 = HybridBinarizer.cap(n10, 2, n5 - 3);
                int n13 = HybridBinarizer.cap(i5, 2, n6 - 3);
                int n14 = 0;
                for (int i6 = -2; i6 <= 2; ++i6) {
                    int[] nArray2 = nArray[n13 + i6];
                    n14 += nArray2[n12 - 2] + nArray2[n12 - 1] + nArray2[n12] + nArray2[n12 + 1] + nArray2[n12 + 2];
                }
                n12 = n14 / 25;
                HybridBinarizer.thresholdBlock(byArray, n11, n9, n12, n7, bitMatrix);
            }
        }
    }

    private static int cap(int n5, int n6, int n7) {
        if (n5 < n6) {
            n5 = n6;
        } else if (n5 > n7) {
            n5 = n7;
        }
        return n5;
    }

    private static void thresholdBlock(byte[] byArray, int n5, int n6, int n7, int n8, BitMatrix bitMatrix) {
        int n9 = 0;
        int n10 = n6 * n8 + n5;
        while (n9 < 8) {
            for (int i5 = 0; i5 < 8; ++i5) {
                if ((byArray[n10 + i5] & 0xFF) > n7) continue;
                int n11 = n5 + i5;
                bitMatrix.set(n11, n6 + n9);
            }
            ++n9;
            n10 += n8;
        }
    }

    private static int[][] calculateBlackPoints(byte[] byArray, int n5, int n6, int n7, int n8) {
        int[][] nArray = new int[n6][n5];
        for (int i5 = 0; i5 < n6; ++i5) {
            int n9 = i5 << 3;
            int n10 = n8 - 8;
            if (n9 > n10) {
                n9 = n10;
            }
            for (n10 = 0; n10 < n5; ++n10) {
                int n11 = n10 << 3;
                int n12 = n7 - 8;
                if (n11 > n12) {
                    n11 = n12;
                }
                n12 = 0;
                int n13 = 255;
                int n14 = 0;
                int n15 = 0;
                n11 = n9 * n7 + n11;
                while (n15 < 8) {
                    int n16;
                    for (n16 = 0; n16 < 8; ++n16) {
                        int n17 = byArray[n11 + n16] & 0xFF;
                        n12 += n17;
                        if (n17 < n13) {
                            n13 = n17;
                        }
                        if (n17 <= n14) continue;
                        n14 = n17;
                    }
                    if (n14 - n13 > 24) {
                        block4: while (true) {
                            int n18 = n11;
                            n11 = n15 + 1;
                            n15 = n18 + n7;
                            int n19 = n11;
                            n11 = n15;
                            n15 = n19;
                            if (n15 >= 8) break;
                            n16 = 0;
                            while (true) {
                                if (n16 >= 8) continue block4;
                                n12 += byArray[n11 + n16] & 0xFF;
                                ++n16;
                            }
                            break;
                        }
                    }
                    ++n15;
                    n11 += n7;
                }
                n11 = n12 >> 6;
                if (n14 - n13 <= 24) {
                    int[] nArray2;
                    n11 = n13 / 2;
                    if (i5 > 0 && n10 > 0 && n13 < (n12 = ((nArray2 = nArray[i5 - 1])[n10] + nArray[i5][n13 = n10 - 1] * 2 + nArray2[n13]) / 4)) {
                        n11 = n12;
                    }
                }
                nArray[i5][n10] = n11;
            }
        }
        return nArray;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        Object object = this.matrix;
        if (object != null) {
            return object;
        }
        object = this.getLuminanceSource();
        int n5 = ((LuminanceSource)object).getWidth();
        int n6 = ((LuminanceSource)object).getHeight();
        if (n5 >= 40 && n6 >= 40) {
            BitMatrix bitMatrix;
            int n7 = n5;
            object = ((LuminanceSource)object).getMatrix();
            int n8 = n7 >> 3;
            if ((n7 & 7) != 0) {
                ++n8;
            }
            int n9 = n6;
            int n10 = n9 >> 3;
            if ((n9 & 7) != 0) {
                ++n10;
            }
            Object object2 = object;
            object = HybridBinarizer.calculateBlackPoints((byte[])object2, n8, n10, n5, n6);
            BitMatrix bitMatrix2 = bitMatrix;
            bitMatrix = new BitMatrix(n5, n6);
            HybridBinarizer.calculateThresholdForBlock((byte[])object2, n8, n10, n5, n6, (int[][])object, bitMatrix2);
            this.matrix = bitMatrix2;
        } else {
            this.matrix = super.getBlackMatrix();
        }
        return this.matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new HybridBinarizer(luminanceSource);
    }
}

