/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.reedsolomon;

import com.dcloud.zxing2.common.reedsolomon.GenericGF;

final class GenericGFPoly {
    private final GenericGF field;
    private final int[] coefficients;

    GenericGFPoly(GenericGF genericGF, int[] nArray) {
        if (nArray.length != 0) {
            ((GenericGFPoly)object).field = genericGF;
            int n5 = nArray.length;
            if (n5 > 1 && nArray[0] == 0) {
                int n6;
                for (n6 = 1; n6 < n5 && nArray[n6] == 0; ++n6) {
                }
                if (n6 == n5) {
                    GenericGFPoly genericGFPoly = object;
                    int[] nArray2 = new int[1];
                    Object object = nArray2;
                    nArray2[0] = 0;
                    genericGFPoly.coefficients = (int[])object;
                } else {
                    int[] nArray3 = new int[n5 - n6];
                    ((GenericGFPoly)object).coefficients = nArray3;
                    int n7 = nArray3.length;
                    System.arraycopy(nArray, n6, nArray3, 0, n7);
                }
            } else {
                ((GenericGFPoly)object).coefficients = nArray;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n5) {
        return this.coefficients[this.coefficients.length - 1 - n5];
    }

    int evaluateAt(int n5) {
        if (n5 == 0) {
            return this.getCoefficient(0);
        }
        int[] nArray = this.coefficients;
        int n6 = this.coefficients.length;
        if (n5 == 1) {
            int n7 = 0;
            n5 = nArray.length;
            for (n6 = 0; n6 < n5; ++n6) {
                n7 = GenericGF.addOrSubtract(n7, nArray[n6]);
            }
            return n7;
        }
        int n8 = nArray[0];
        for (int i5 = 1; i5 < n6; ++i5) {
            n8 = GenericGF.addOrSubtract(this.field.multiply(n5, n8), this.coefficients[i5]);
        }
        return n8;
    }

    GenericGFPoly addOrSubtract(GenericGFPoly object) {
        if (this.field.equals(((GenericGFPoly)object).field)) {
            if (this.isZero()) {
                return object;
            }
            if (((GenericGFPoly)object).isZero()) {
                return this;
            }
            object = this.coefficients;
            Object object2 = ((GenericGFPoly)object).coefficients;
            if (((Object)object).length <= ((int[])object2).length) {
                int[] nArray = object2;
                object2 = object;
                object = nArray;
            }
            Object object3 = object;
            int[] nArray = new int[((Object)object3).length];
            int n5 = ((Object)object3).length - ((int[])object2).length;
            System.arraycopy(object3, 0, nArray, 0, n5);
            for (int i5 = n5; i5 < ((Object)object).length; ++i5) {
                nArray[i5] = GenericGF.addOrSubtract(object2[i5 - n5], (int)object[i5]);
            }
            return new GenericGFPoly(this.field, nArray);
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    GenericGFPoly multiply(GenericGFPoly object) {
        if (this.field.equals(((GenericGFPoly)object).field)) {
            if (!this.isZero() && !((GenericGFPoly)object).isZero()) {
                int[] nArray = this.coefficients;
                int n5 = this.coefficients.length;
                object = ((GenericGFPoly)object).coefficients;
                int n6 = ((GenericGFPoly)object).coefficients.length;
                int[] nArray2 = new int[n5 + n6 - 1];
                for (int i5 = 0; i5 < n5; ++i5) {
                    int n7 = nArray[i5];
                    for (int i6 = 0; i6 < n6; ++i6) {
                        int n8 = i5 + i6;
                        nArray2[n8] = GenericGF.addOrSubtract(nArray2[n8], this.field.multiply(n7, (int)object[i6]));
                    }
                }
                return new GenericGFPoly(this.field, nArray2);
            }
            return this.field.getZero();
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    GenericGFPoly multiply(int n5) {
        if (n5 == 0) {
            return this.field.getZero();
        }
        if (n5 == 1) {
            return this;
        }
        int n6 = this.coefficients.length;
        int[] nArray = new int[n6];
        for (int i5 = 0; i5 < n6; ++i5) {
            nArray[i5] = this.field.multiply(this.coefficients[i5], n5);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly multiplyByMonomial(int n5, int n6) {
        if (n5 >= 0) {
            if (n6 == 0) {
                return this.field.getZero();
            }
            int n7 = this.coefficients.length;
            int[] nArray = new int[n7 + n5];
            for (int i5 = 0; i5 < n7; ++i5) {
                nArray[i5] = this.field.multiply(this.coefficients[i5], n6);
            }
            return new GenericGFPoly(this.field, nArray);
        }
        throw new IllegalArgumentException();
    }

    GenericGFPoly[] divide(GenericGFPoly genericGFPoly) {
        if (this.field.equals(genericGFPoly.field)) {
            if (!genericGFPoly.isZero()) {
                GenericGFPoly genericGFPoly2 = genericGFPoly;
                GenericGFPoly genericGFPoly3 = this.field.getZero();
                int n5 = genericGFPoly2.getCoefficient(genericGFPoly2.getDegree());
                n5 = this.field.inverse(n5);
                GenericGFPoly genericGFPoly4 = this;
                while (genericGFPoly4.getDegree() >= genericGFPoly.getDegree() && !genericGFPoly4.isZero()) {
                    int n6 = genericGFPoly4.getDegree() - genericGFPoly.getDegree();
                    GenericGFPoly genericGFPoly5 = genericGFPoly4;
                    int n7 = this.field.multiply(genericGFPoly5.getCoefficient(genericGFPoly5.getDegree()), n5);
                    GenericGFPoly genericGFPoly6 = genericGFPoly.multiplyByMonomial(n6, n7);
                    genericGFPoly3 = genericGFPoly3.addOrSubtract(this.field.buildMonomial(n6, n7));
                    genericGFPoly4 = genericGFPoly4.addOrSubtract(genericGFPoly6);
                }
                return new GenericGFPoly[]{genericGFPoly3, genericGFPoly4};
            }
            throw new IllegalArgumentException("Divide by 0");
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.getDegree() * 8);
        for (int i5 = this.getDegree(); i5 >= 0; --i5) {
            int n5 = this.getCoefficient(i5);
            if (n5 == 0) continue;
            if (n5 < 0) {
                stringBuilder2.append(" - ");
                n5 = -n5;
            } else if (stringBuilder2.length() > 0) {
                stringBuilder2.append(" + ");
            }
            if (i5 == 0 || n5 != 1) {
                if ((n5 = this.field.log(n5)) == 0) {
                    stringBuilder2.append('1');
                } else if (n5 == 1) {
                    stringBuilder2.append('a');
                } else {
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder3.append("a^");
                    stringBuilder3.append(n5);
                }
            }
            if (i5 == 0) continue;
            if (i5 == 1) {
                stringBuilder2.append('x');
                continue;
            }
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.append("x^");
            stringBuilder4.append(i5);
        }
        return stringBuilder2.toString();
    }
}

