/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.reedsolomon;

import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.GenericGFPoly;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;

public final class ReedSolomonDecoder {
    private final GenericGF field;

    public ReedSolomonDecoder(GenericGF genericGF) {
        this.field = genericGF;
    }

    private GenericGFPoly[] runEuclideanAlgorithm(GenericGFPoly genericGFPoly, GenericGFPoly genericGFPoly2, int n5) throws ReedSolomonException {
        if (genericGFPoly.getDegree() < genericGFPoly2.getDegree()) {
            GenericGFPoly genericGFPoly3 = genericGFPoly2;
            genericGFPoly2 = genericGFPoly;
            genericGFPoly = genericGFPoly3;
        }
        ReedSolomonDecoder reedSolomonDecoder = this;
        GenericGFPoly genericGFPoly4 = reedSolomonDecoder.field.getZero();
        GenericGFPoly genericGFPoly5 = reedSolomonDecoder.field.getOne();
        GenericGFPoly genericGFPoly6 = genericGFPoly2;
        GenericGFPoly genericGFPoly7 = genericGFPoly5;
        genericGFPoly5 = genericGFPoly4;
        genericGFPoly2 = genericGFPoly;
        genericGFPoly4 = genericGFPoly7;
        genericGFPoly = genericGFPoly6;
        while (genericGFPoly.getDegree() >= n5 / 2) {
            if (!genericGFPoly.isZero()) {
                GenericGFPoly genericGFPoly8 = genericGFPoly;
                GenericGFPoly genericGFPoly9 = this.field.getZero();
                int n6 = genericGFPoly8.getCoefficient(genericGFPoly8.getDegree());
                n6 = this.field.inverse(n6);
                while (genericGFPoly2.getDegree() >= genericGFPoly.getDegree() && !genericGFPoly2.isZero()) {
                    ReedSolomonDecoder reedSolomonDecoder2 = this;
                    int n7 = genericGFPoly2.getDegree() - genericGFPoly.getDegree();
                    GenericGFPoly genericGFPoly10 = genericGFPoly2;
                    int n8 = reedSolomonDecoder2.field.multiply(genericGFPoly10.getCoefficient(genericGFPoly10.getDegree()), n6);
                    GenericGFPoly genericGFPoly11 = genericGFPoly9.addOrSubtract(reedSolomonDecoder2.field.buildMonomial(n7, n8));
                    genericGFPoly2 = genericGFPoly2.addOrSubtract(genericGFPoly.multiplyByMonomial(n7, n8));
                    genericGFPoly9 = genericGFPoly11;
                }
                genericGFPoly5 = genericGFPoly9.multiply(genericGFPoly4).addOrSubtract(genericGFPoly5);
                if (genericGFPoly2.getDegree() < genericGFPoly.getDegree()) {
                    GenericGFPoly genericGFPoly12 = genericGFPoly2;
                    GenericGFPoly genericGFPoly13 = genericGFPoly5;
                    genericGFPoly5 = genericGFPoly4;
                    genericGFPoly2 = genericGFPoly;
                    genericGFPoly4 = genericGFPoly13;
                    genericGFPoly = genericGFPoly12;
                    continue;
                }
                throw new IllegalStateException("Division algorithm failed to reduce polynomial?");
            }
            throw new ReedSolomonException("r_{i-1} was zero");
        }
        int n9 = genericGFPoly4.getCoefficient(0);
        if (n9 != 0) {
            GenericGFPoly genericGFPoly14 = genericGFPoly;
            int n10 = this.field.inverse(n9);
            genericGFPoly = genericGFPoly4.multiply(n10);
            GenericGFPoly genericGFPoly15 = genericGFPoly14.multiply(n10);
            return new GenericGFPoly[]{genericGFPoly, genericGFPoly15};
        }
        throw new ReedSolomonException("sigmaTilde(0) was zero");
    }

    private int[] findErrorLocations(GenericGFPoly genericGFPoly) throws ReedSolomonException {
        int n5 = genericGFPoly.getDegree();
        if (n5 == 1) {
            int n6 = genericGFPoly.getCoefficient(1);
            return new int[]{n6};
        }
        int[] nArray = new int[n5];
        int n7 = 0;
        for (int i5 = 1; i5 < this.field.getSize() && n7 < n5; ++i5) {
            if (genericGFPoly.evaluateAt(i5) != 0) continue;
            nArray[n7] = this.field.inverse(i5);
            ++n7;
        }
        if (n7 == n5) {
            return nArray;
        }
        throw new ReedSolomonException("Error locator degree does not match number of roots");
    }

    private int[] findErrorMagnitudes(GenericGFPoly genericGFPoly, int[] nArray) {
        int n5 = nArray.length;
        int[] nArray2 = new int[n5];
        for (int i5 = 0; i5 < n5; ++i5) {
            int n6 = this.field.inverse(nArray[i5]);
            int n7 = 1;
            for (int i6 = 0; i6 < n5; ++i6) {
                if (i5 == i6) continue;
                int n8 = this.field.multiply(nArray[i6], n6);
                n8 = (n8 & 1) == 0 ? (n8 |= 1) : (n8 &= 0xFFFFFFFE);
                n7 = this.field.multiply(n7, n8);
            }
            nArray2[i5] = this.field.multiply(genericGFPoly.evaluateAt(n6), this.field.inverse(n7));
            if (this.field.getGeneratorBase() == 0) continue;
            nArray2[i5] = this.field.multiply(nArray2[i5], n6);
        }
        return nArray2;
    }

    public void decode(int[] nArray, int n5) throws ReedSolomonException {
        GenericGFPoly genericGFPoly;
        GenericGFPoly genericGFPoly2;
        Object object = genericGFPoly2;
        genericGFPoly2 = new GenericGFPoly(this.field, nArray);
        int[] nArray2 = new int[n5];
        int n6 = 1;
        for (int i5 = 0; i5 < n5; ++i5) {
            int n7;
            GenericGF genericGF = this.field;
            nArray2[n5 - 1 - i5] = n7 = ((GenericGFPoly)object).evaluateAt(genericGF.exp(i5 + genericGF.getGeneratorBase()));
            if (n7 == 0) continue;
            n6 = 0;
        }
        if (n6 != 0) {
            return;
        }
        ReedSolomonDecoder reedSolomonDecoder = this;
        object = genericGFPoly;
        genericGFPoly = new GenericGFPoly(this.field, nArray2);
        GenericGFPoly[] genericGFPolyArray = reedSolomonDecoder.runEuclideanAlgorithm(reedSolomonDecoder.field.buildMonomial(n5, 1), (GenericGFPoly)object, n5);
        Object object2 = genericGFPolyArray[0];
        object = genericGFPolyArray[1];
        object2 = reedSolomonDecoder.findErrorLocations((GenericGFPoly)object2);
        object = reedSolomonDecoder.findErrorMagnitudes((GenericGFPoly)object, (int[])object2);
        for (int i6 = 0; i6 < ((Object)object2).length; ++i6) {
            n6 = nArray.length - 1 - this.field.log((int)object2[i6]);
            if (n6 >= 0) {
                nArray[n6] = GenericGF.addOrSubtract(nArray[n6], (int)object[i6]);
                continue;
            }
            throw new ReedSolomonException("Bad error location");
        }
    }
}

